/*
 * Decompiled with CFR 0.152.
 */
package github.nighter.smartspawner.language;

import github.nighter.smartspawner.SmartSpawner;
import github.nighter.smartspawner.language.ColorUtil;
import github.nighter.smartspawner.language.LRUCache;
import github.nighter.smartspawner.language.LocaleData;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import lombok.Generated;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.EntityType;
import org.bukkit.plugin.java.JavaPlugin;

public class LanguageManager {
    private final JavaPlugin plugin;
    private String defaultLocale;
    private final Map<String, LocaleData> localeMap = new HashMap<String, LocaleData>();
    private final Set<String> activeLocales = new HashSet<String>();
    private final Set<LanguageFileType> activeFileTypes = new HashSet<LanguageFileType>();
    private LocaleData cachedDefaultLocaleData;
    private static final Map<String, String> EMPTY_PLACEHOLDERS = Collections.emptyMap();
    private final LRUCache<String, String> formattedStringCache;
    private final LRUCache<String, String[]> loreCache;
    private final LRUCache<String, List<String>> loreListCache;
    private final LRUCache<String, String> guiItemNameCache;
    private final LRUCache<String, String[]> guiItemLoreCache;
    private final LRUCache<String, List<String>> guiItemLoreListCache;
    private final LRUCache<String, String> entityNameCache;
    private final LRUCache<String, String> smallCapsCache;
    private final LRUCache<String, String> materialNameCache;
    private final AtomicInteger cacheHits = new AtomicInteger(0);
    private final AtomicInteger cacheMisses = new AtomicInteger(0);
    private static final int DEFAULT_STRING_CACHE_SIZE = 1000;
    private static final int DEFAULT_LORE_CACHE_SIZE = 250;
    private static final int DEFAULT_LORE_LIST_CACHE_SIZE = 250;

    public LanguageManager(JavaPlugin plugin) {
        this.plugin = plugin;
        this.defaultLocale = plugin.getConfig().getString("language", "en_US");
        this.activeFileTypes.addAll(Arrays.asList(LanguageFileType.values()));
        this.formattedStringCache = new LRUCache(1000);
        this.loreCache = new LRUCache(250);
        this.loreListCache = new LRUCache(250);
        this.guiItemNameCache = new LRUCache(1000);
        this.guiItemLoreCache = new LRUCache(250);
        this.guiItemLoreListCache = new LRUCache(250);
        this.entityNameCache = new LRUCache(250);
        this.smallCapsCache = new LRUCache(500);
        this.materialNameCache = new LRUCache(250);
        this.loadLanguages();
        this.saveDefaultFiles();
        this.cacheDefaultLocaleData();
    }

    public LanguageManager(SmartSpawner plugin, LanguageFileType ... fileTypes) {
        this.plugin = plugin;
        this.defaultLocale = plugin.getConfig().getString("language", "en_US");
        this.activeFileTypes.addAll(Arrays.asList(fileTypes));
        this.formattedStringCache = new LRUCache(1000);
        this.loreCache = new LRUCache(250);
        this.loreListCache = new LRUCache(250);
        this.guiItemNameCache = new LRUCache(1000);
        this.guiItemLoreCache = new LRUCache(250);
        this.guiItemLoreListCache = new LRUCache(250);
        this.entityNameCache = new LRUCache(250);
        this.smallCapsCache = new LRUCache(500);
        this.materialNameCache = new LRUCache(250);
        this.loadLanguages(fileTypes);
        this.saveDefaultFiles();
        this.cacheDefaultLocaleData();
    }

    private void saveDefaultFiles() {
        this.saveResource("language/vi_VN/messages.yml");
        this.saveResource("language/vi_VN/gui.yml");
        this.saveResource("language/vi_VN/formatting.yml");
        this.saveResource("language/vi_VN/items.yml");
        this.saveResource("language/DonutSMP/messages.yml");
        this.saveResource("language/DonutSMP/gui.yml");
        this.saveResource("language/DonutSMP/formatting.yml");
        this.saveResource("language/it_IT/messages.yml");
        this.saveResource("language/it_IT/gui.yml");
        this.saveResource("language/it_IT/formatting.yml");
        this.saveResource("language/it_IT/items.yml");
        this.saveResource("language/tr_TR/messages.yml");
        this.saveResource("language/tr_TR/gui.yml");
        this.saveResource("language/tr_TR/formatting.yml");
        this.saveResource("language/tr_TR/items.yml");
    }

    private void saveResource(String resourcePath) {
        File resourceFile = new File(this.plugin.getDataFolder(), resourcePath);
        if (!resourceFile.exists()) {
            resourceFile.getParentFile().mkdirs();
            this.plugin.saveResource(resourcePath, false);
        }
    }

    public void loadLanguages() {
        this.loadLanguages(this.activeFileTypes.toArray(new LanguageFileType[0]));
    }

    public void loadLanguages(LanguageFileType ... fileTypes) {
        File langDir = new File(this.plugin.getDataFolder(), "language");
        if (!langDir.exists() && !langDir.mkdirs()) {
            this.plugin.getLogger().severe("Failed to create language directory!");
            return;
        }
        this.localeMap.remove(this.defaultLocale);
        this.loadLocale(this.defaultLocale, fileTypes);
        this.activeLocales.add(this.defaultLocale);
    }

    private void cacheDefaultLocaleData() {
        this.cachedDefaultLocaleData = this.localeMap.get(this.defaultLocale);
        if (this.cachedDefaultLocaleData == null) {
            this.plugin.getLogger().severe("Failed to cache default locale data for " + this.defaultLocale);
            this.cachedDefaultLocaleData = new LocaleData(new YamlConfiguration(), new YamlConfiguration(), new YamlConfiguration(), new YamlConfiguration());
            this.localeMap.put(this.defaultLocale, this.cachedDefaultLocaleData);
        }
    }

    public void reloadLanguages() {
        this.clearCache();
        String previousDefaultLocale = this.defaultLocale;
        this.defaultLocale = this.plugin.getConfig().getString("language", "en_US");
        for (String locale : this.activeLocales) {
            this.localeMap.remove(locale);
            for (LanguageFileType fileType : this.activeFileTypes) {
                YamlConfiguration config = this.loadOrCreateFile(locale, fileType.getFileName(), true);
                this.updateLocaleData(locale, fileType, config);
            }
        }
        if (!this.activeLocales.contains(this.defaultLocale)) {
            this.loadLocale(this.defaultLocale, this.activeFileTypes.toArray(new LanguageFileType[0]));
            this.activeLocales.add(this.defaultLocale);
        }
        this.cacheDefaultLocaleData();
        this.plugin.getLogger().info("Successfully reloaded language files for language " + this.defaultLocale);
    }

    private void updateLocaleData(String locale, LanguageFileType fileType, YamlConfiguration config) {
        LocaleData existingData = this.localeMap.getOrDefault(locale, new LocaleData(new YamlConfiguration(), new YamlConfiguration(), new YamlConfiguration(), new YamlConfiguration()));
        switch (fileType.ordinal()) {
            case 0: {
                this.localeMap.put(locale, new LocaleData(config, existingData.gui(), existingData.formatting(), existingData.items()));
                break;
            }
            case 1: {
                this.localeMap.put(locale, new LocaleData(existingData.messages(), config, existingData.formatting(), existingData.items()));
                break;
            }
            case 2: {
                this.localeMap.put(locale, new LocaleData(existingData.messages(), existingData.gui(), config, existingData.items()));
                break;
            }
            case 3: {
                this.localeMap.put(locale, new LocaleData(existingData.messages(), existingData.gui(), existingData.formatting(), config));
            }
        }
    }

    private YamlConfiguration loadOrCreateFile(String locale, String fileName, boolean forceReload) {
        InputStream inputStream;
        boolean defaultResourceExists;
        File file = new File(this.plugin.getDataFolder(), "language/" + locale + "/" + fileName);
        YamlConfiguration defaultConfig = new YamlConfiguration();
        YamlConfiguration userConfig = new YamlConfiguration();
        boolean bl = defaultResourceExists = this.plugin.getResource("language/" + this.defaultLocale + "/" + fileName) != null;
        if (defaultResourceExists) {
            try {
                inputStream = this.plugin.getResource("language/" + this.defaultLocale + "/" + fileName);
                try {
                    if (inputStream != null) {
                        defaultConfig.loadFromString(new String(inputStream.readAllBytes()));
                    }
                }
                finally {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
            }
            catch (Exception e) {
                this.plugin.getLogger().log(Level.SEVERE, "Failed to load default " + fileName, e);
            }
        }
        if (!file.exists() && defaultResourceExists) {
            try {
                inputStream = this.plugin.getResource("language/" + this.defaultLocale + "/" + fileName);
                try {
                    if (inputStream != null) {
                        file.getParentFile().mkdirs();
                        Files.copy(inputStream, file.toPath(), new CopyOption[0]);
                    }
                }
                finally {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
            }
            catch (IOException e) {
                this.plugin.getLogger().log(Level.SEVERE, "Failed to create " + fileName + " for locale " + locale, e);
                return new YamlConfiguration();
            }
        }
        if (file.exists()) {
            try {
                if (forceReload) {
                    userConfig = new YamlConfiguration();
                }
                if (forceReload) {
                    userConfig = YamlConfiguration.loadConfiguration((File)file);
                } else {
                    userConfig.load(file);
                }
            }
            catch (Exception e) {
                this.plugin.getLogger().log(Level.WARNING, "Failed to load " + fileName + " for locale " + locale + ". Using defaults.", e);
                return defaultConfig;
            }
            boolean updated = false;
            for (String key : defaultConfig.getKeys(false)) {
                if (userConfig.contains(key)) continue;
                userConfig.set(key, defaultConfig.get(key));
                updated = true;
            }
            if (updated) {
                try {
                    userConfig.save(file);
                    this.plugin.getLogger().info("Updated " + fileName + " for locale " + locale);
                }
                catch (IOException e) {
                    this.plugin.getLogger().log(Level.WARNING, "Failed to save updated " + fileName + " for locale " + locale, e);
                }
            }
            return userConfig;
        }
        return new YamlConfiguration();
    }

    private YamlConfiguration loadOrCreateFile(String locale, String fileName) {
        return this.loadOrCreateFile(locale, fileName, false);
    }

    private void loadLocale(String locale, LanguageFileType ... fileTypes) {
        File localeDir = new File(this.plugin.getDataFolder(), "language/" + locale);
        if (!localeDir.exists() && !localeDir.mkdirs()) {
            this.plugin.getLogger().severe("Failed to create locale directory for " + locale);
            return;
        }
        YamlConfiguration messages = null;
        YamlConfiguration gui = null;
        YamlConfiguration formatting = null;
        YamlConfiguration items = null;
        block6: for (LanguageFileType fileType : fileTypes) {
            switch (fileType.ordinal()) {
                case 0: {
                    messages = this.loadOrCreateFile(locale, fileType.getFileName());
                    continue block6;
                }
                case 1: {
                    gui = this.loadOrCreateFile(locale, fileType.getFileName());
                    continue block6;
                }
                case 2: {
                    formatting = this.loadOrCreateFile(locale, fileType.getFileName());
                    continue block6;
                }
                case 3: {
                    items = this.loadOrCreateFile(locale, fileType.getFileName());
                }
            }
        }
        if (messages == null) {
            messages = new YamlConfiguration();
        }
        if (gui == null) {
            gui = new YamlConfiguration();
        }
        if (formatting == null) {
            formatting = new YamlConfiguration();
        }
        if (items == null) {
            items = new YamlConfiguration();
        }
        this.localeMap.put(locale, new LocaleData(messages, gui, formatting, items));
    }

    public String getMessage(String key, Map<String, String> placeholders) {
        if (!this.isMessageEnabled(key)) {
            return null;
        }
        Object message = this.cachedDefaultLocaleData.messages().getString(key + ".message");
        if (message == null) {
            return "Missing message: " + key;
        }
        String prefix = this.getPrefix();
        message = prefix + (String)message;
        return this.applyPlaceholdersAndColors((String)message, placeholders);
    }

    public String getMessageWithoutPrefix(String key, Map<String, String> placeholders) {
        if (!this.isMessageEnabled(key)) {
            return null;
        }
        String message = this.cachedDefaultLocaleData.messages().getString(key + ".message");
        if (message == null) {
            return "Missing message: " + key;
        }
        return this.applyPlaceholdersAndColors(message, placeholders);
    }

    public String getMessageForConsole(String key, Map<String, String> placeholders) {
        if (!this.isMessageEnabled(key)) {
            return null;
        }
        String message = this.cachedDefaultLocaleData.messages().getString(key + ".message");
        if (message == null) {
            return "Missing message: " + key;
        }
        return this.applyOnlyPlaceholders(message, placeholders);
    }

    public String getTitle(String key, Map<String, String> placeholders) {
        if (!this.isMessageEnabled(key)) {
            return null;
        }
        return this.getRawMessage(key + ".title", placeholders);
    }

    public String getSubtitle(String key, Map<String, String> placeholders) {
        if (!this.isMessageEnabled(key)) {
            return null;
        }
        return this.getRawMessage(key + ".subtitle", placeholders);
    }

    public String getActionBar(String key, Map<String, String> placeholders) {
        if (!this.isMessageEnabled(key)) {
            return null;
        }
        return this.getRawMessage(key + ".action_bar", placeholders);
    }

    public String getSound(String key) {
        if (!this.isMessageEnabled(key)) {
            return null;
        }
        return this.cachedDefaultLocaleData.messages().getString(key + ".sound");
    }

    private String getPrefix() {
        return this.cachedDefaultLocaleData.messages().getString("prefix", "&7[Server] &r");
    }

    String getRawMessage(String path, Map<String, String> placeholders) {
        String message = this.cachedDefaultLocaleData.messages().getString(path);
        if (message == null) {
            return null;
        }
        return this.applyPlaceholdersAndColors(message, placeholders);
    }

    private boolean isMessageEnabled(String key) {
        return this.cachedDefaultLocaleData.messages().getBoolean(key + ".enabled", true);
    }

    public boolean keyExists(String key) {
        return this.cachedDefaultLocaleData.messages().contains(key);
    }

    public String getGuiTitle(String key) {
        return this.getGuiTitle(key, EMPTY_PLACEHOLDERS);
    }

    public String getGuiTitle(String key, Map<String, String> placeholders) {
        if (!this.activeFileTypes.contains((Object)LanguageFileType.GUI)) {
            return null;
        }
        String title = this.cachedDefaultLocaleData.gui().getString(key);
        if (title == null) {
            return "Missing GUI title: " + key;
        }
        return this.applyPlaceholdersAndColors(title, placeholders);
    }

    public String getGuiItemName(String key) {
        return this.getGuiItemName(key, EMPTY_PLACEHOLDERS);
    }

    public String getGuiItemName(String key, Map<String, String> placeholders) {
        if (!this.activeFileTypes.contains((Object)LanguageFileType.GUI)) {
            return null;
        }
        String cacheKey = key + "|" + this.generateCacheKey("", placeholders);
        String cachedName = this.guiItemNameCache.get(cacheKey);
        if (cachedName != null) {
            this.cacheHits.incrementAndGet();
            return cachedName;
        }
        this.cacheMisses.incrementAndGet();
        String name = this.cachedDefaultLocaleData.gui().getString(key);
        if (name == null) {
            return "Missing item name: " + key;
        }
        String result = this.applyPlaceholdersAndColors(name, placeholders);
        this.guiItemNameCache.put(cacheKey, result);
        return result;
    }

    public String[] getGuiItemLore(String key) {
        return this.getGuiItemLore(key, EMPTY_PLACEHOLDERS);
    }

    public String[] getGuiItemLore(String key, Map<String, String> placeholders) {
        if (!this.activeFileTypes.contains((Object)LanguageFileType.GUI)) {
            return new String[0];
        }
        String cacheKey = key + "|" + this.generateCacheKey("", placeholders);
        String[] cachedLore = this.guiItemLoreCache.get(cacheKey);
        if (cachedLore != null) {
            this.cacheHits.incrementAndGet();
            return cachedLore;
        }
        this.cacheMisses.incrementAndGet();
        List loreList = this.cachedDefaultLocaleData.gui().getStringList(key);
        String[] result = (String[])loreList.stream().map(line -> this.applyPlaceholdersAndColors((String)line, placeholders)).toArray(String[]::new);
        this.guiItemLoreCache.put(cacheKey, result);
        return result;
    }

    public List<String> getGuiItemLoreAsList(String key) {
        return this.getGuiItemLoreAsList(key, EMPTY_PLACEHOLDERS);
    }

    public List<String> getGuiItemLoreAsList(String key, Map<String, String> placeholders) {
        if (!this.activeFileTypes.contains((Object)LanguageFileType.GUI)) {
            return Collections.emptyList();
        }
        String cacheKey = key + "|" + this.generateCacheKey("", placeholders);
        List<String> cachedLore = this.guiItemLoreListCache.get(cacheKey);
        if (cachedLore != null) {
            this.cacheHits.incrementAndGet();
            return cachedLore;
        }
        this.cacheMisses.incrementAndGet();
        List loreList = this.cachedDefaultLocaleData.gui().getStringList(key);
        List<String> result = loreList.stream().map(line -> this.applyPlaceholdersAndColors((String)line, placeholders)).toList();
        this.guiItemLoreListCache.put(cacheKey, result);
        return result;
    }

    public List<String> getGuiItemLoreWithMultilinePlaceholders(String key, Map<String, String> placeholders) {
        if (!this.activeFileTypes.contains((Object)LanguageFileType.GUI)) {
            return Collections.emptyList();
        }
        ArrayList<String> result = new ArrayList<String>();
        List loreList = this.cachedDefaultLocaleData.gui().getStringList(key);
        for (String line : loreList) {
            boolean containsMultilinePlaceholder = false;
            for (Map.Entry<String, String> entry : placeholders.entrySet()) {
                String placeholder = "%" + entry.getKey() + "%";
                if (!line.contains(placeholder) || !entry.getValue().contains("\n")) continue;
                containsMultilinePlaceholder = true;
                break;
            }
            if (containsMultilinePlaceholder) {
                String value;
                String placeholder;
                String processedLine = line;
                for (Map.Entry<String, String> entry : placeholders.entrySet()) {
                    placeholder = "%" + entry.getKey() + "%";
                    value = entry.getValue();
                    if (value.contains("\n")) continue;
                    processedLine = processedLine.replace(placeholder, value);
                }
                for (Map.Entry<String, String> entry : placeholders.entrySet()) {
                    placeholder = "%" + entry.getKey() + "%";
                    value = entry.getValue();
                    if (!processedLine.contains(placeholder) || !value.contains("\n")) continue;
                    String[] valueLines = value.split("\n");
                    String firstLine = processedLine.replace(placeholder, valueLines[0]);
                    result.add(ColorUtil.translateHexColorCodes(firstLine));
                    String lineStart = processedLine.substring(0, processedLine.indexOf(placeholder));
                    for (int i = 1; i < valueLines.length; ++i) {
                        result.add(ColorUtil.translateHexColorCodes(lineStart + valueLines[i]));
                    }
                }
                continue;
            }
            result.add(this.applyPlaceholdersAndColors(line, placeholders));
        }
        return result;
    }

    public String getVanillaItemName(Material material) {
        if (material == null) {
            return "Unknown Item";
        }
        String cacheKey = "material|" + material.name();
        String cachedName = this.materialNameCache.get(cacheKey);
        if (cachedName != null) {
            this.cacheHits.incrementAndGet();
            return cachedName;
        }
        this.cacheMisses.incrementAndGet();
        String key = "item." + material.name() + ".name";
        String name = null;
        if (this.activeFileTypes.contains((Object)LanguageFileType.ITEMS)) {
            name = this.cachedDefaultLocaleData.items().getString(key);
        }
        name = name == null ? this.formatEnumName(material.name()) : this.applyPlaceholdersAndColors(name, null);
        this.materialNameCache.put(cacheKey, name);
        return name;
    }

    public String[] getVanillaItemLore(Material material) {
        if (material == null) {
            return new String[0];
        }
        String key = "item." + material.name() + ".lore";
        return this.getItemLore(key);
    }

    public String getItemName(String key) {
        return this.getItemName(key, EMPTY_PLACEHOLDERS);
    }

    public String getItemName(String key, Map<String, String> placeholders) {
        if (!this.activeFileTypes.contains((Object)LanguageFileType.ITEMS)) {
            return key;
        }
        String name = this.cachedDefaultLocaleData.items().getString(key);
        if (name == null) {
            return key;
        }
        return this.applyPlaceholdersAndColors(name, placeholders);
    }

    public String[] getItemLore(String key) {
        return this.getItemLore(key, EMPTY_PLACEHOLDERS);
    }

    public String[] getItemLore(String key, Map<String, String> placeholders) {
        if (!this.activeFileTypes.contains((Object)LanguageFileType.ITEMS)) {
            return new String[0];
        }
        String cacheKey = key + "|" + this.generateCacheKey("", placeholders);
        String[] cachedLore = this.loreCache.get(cacheKey);
        if (cachedLore != null) {
            this.cacheHits.incrementAndGet();
            return cachedLore;
        }
        this.cacheMisses.incrementAndGet();
        List loreList = this.cachedDefaultLocaleData.items().getStringList(key);
        String[] result = (String[])loreList.stream().map(line -> this.applyPlaceholdersAndColors((String)line, placeholders)).toArray(String[]::new);
        this.loreCache.put(cacheKey, result);
        return result;
    }

    public List<String> getItemLoreWithMultilinePlaceholders(String key, Map<String, String> placeholders) {
        if (!this.activeFileTypes.contains((Object)LanguageFileType.ITEMS)) {
            return Collections.emptyList();
        }
        ArrayList<String> result = new ArrayList<String>();
        List loreList = this.cachedDefaultLocaleData.items().getStringList(key);
        for (String line : loreList) {
            boolean containsMultilinePlaceholder = false;
            for (Map.Entry<String, String> entry : placeholders.entrySet()) {
                String placeholder = "%" + entry.getKey() + "%";
                if (!line.contains(placeholder) || !entry.getValue().contains("\n")) continue;
                containsMultilinePlaceholder = true;
                break;
            }
            if (containsMultilinePlaceholder) {
                String value;
                String placeholder;
                String processedLine = line;
                for (Map.Entry<String, String> entry : placeholders.entrySet()) {
                    placeholder = "%" + entry.getKey() + "%";
                    value = entry.getValue();
                    if (value.contains("\n")) continue;
                    processedLine = processedLine.replace(placeholder, value);
                }
                for (Map.Entry<String, String> entry : placeholders.entrySet()) {
                    placeholder = "%" + entry.getKey() + "%";
                    value = entry.getValue();
                    if (!processedLine.contains(placeholder) || !value.contains("\n")) continue;
                    String[] valueLines = value.split("\n");
                    String firstLine = processedLine.replace(placeholder, valueLines[0]);
                    result.add(ColorUtil.translateHexColorCodes(firstLine));
                    String lineStart = processedLine.substring(0, processedLine.indexOf(placeholder));
                    for (int i = 1; i < valueLines.length; ++i) {
                        result.add(ColorUtil.translateHexColorCodes(lineStart + valueLines[i]));
                    }
                }
                continue;
            }
            result.add(this.applyPlaceholdersAndColors(line, placeholders));
        }
        return result;
    }

    public String formatNumber(double number) {
        double value;
        String format;
        if (!this.activeFileTypes.contains((Object)LanguageFileType.FORMATTING)) {
            if (number >= 1.0E12) {
                double value2 = (double)Math.round(number / 1.0E12 * 10.0) / 10.0;
                return this.formatDecimal(value2) + "T";
            }
            if (number >= 1.0E9) {
                double value3 = (double)Math.round(number / 1.0E9 * 10.0) / 10.0;
                return this.formatDecimal(value3) + "B";
            }
            if (number >= 1000000.0) {
                double value4 = (double)Math.round(number / 1000000.0 * 10.0) / 10.0;
                return this.formatDecimal(value4) + "M";
            }
            if (number >= 1000.0) {
                double value5 = (double)Math.round(number / 1000.0 * 10.0) / 10.0;
                return this.formatDecimal(value5) + "K";
            }
            double value6 = (double)Math.round(number * 10.0) / 10.0;
            return this.formatDecimal(value6);
        }
        if (number >= 1.0E12) {
            format = this.cachedDefaultLocaleData.formatting().getString("format_number.trillion", "%s%T");
            value = (double)Math.round(number / 1.0E12 * 10.0) / 10.0;
        } else if (number >= 1.0E9) {
            format = this.cachedDefaultLocaleData.formatting().getString("format_number.billion", "%s%B");
            value = (double)Math.round(number / 1.0E9 * 10.0) / 10.0;
        } else if (number >= 1000000.0) {
            format = this.cachedDefaultLocaleData.formatting().getString("format_number.million", "%s%M");
            value = (double)Math.round(number / 1000000.0 * 10.0) / 10.0;
        } else if (number >= 1000.0) {
            format = this.cachedDefaultLocaleData.formatting().getString("format_number.thousand", "%s%K");
            value = (double)Math.round(number / 1000.0 * 10.0) / 10.0;
        } else {
            format = this.cachedDefaultLocaleData.formatting().getString("format_number.default", "%s%");
            value = (double)Math.round(number * 10.0) / 10.0;
        }
        return format.replace("%s%", this.formatDecimal(value));
    }

    private String formatDecimal(double value) {
        if (value == Math.floor(value)) {
            return String.valueOf((int)value);
        }
        return String.valueOf(value);
    }

    public String getFormattedMobName(EntityType type) {
        String formattedName;
        if (type == null || type == EntityType.UNKNOWN) {
            return "Unknown";
        }
        String mobNameKey = type.name();
        String cacheKey = "mob_name|" + mobNameKey;
        String cachedName = this.entityNameCache.get(cacheKey);
        if (cachedName != null) {
            this.cacheHits.incrementAndGet();
            return cachedName;
        }
        this.cacheMisses.incrementAndGet();
        if (this.activeFileTypes.contains((Object)LanguageFileType.FORMATTING) && (formattedName = this.cachedDefaultLocaleData.formatting().getString("mob_names." + mobNameKey)) != null) {
            String result = this.applyPlaceholdersAndColors(formattedName, null);
            this.entityNameCache.put(cacheKey, result);
            return result;
        }
        String result = this.formatEnumName(mobNameKey);
        this.entityNameCache.put(cacheKey, result);
        return result;
    }

    public String formatEnumName(String enumName) {
        String[] words = enumName.split("_");
        StringBuilder result = new StringBuilder();
        for (String word : words) {
            if (word.length() <= 0) continue;
            result.append(word.charAt(0)).append(word.substring(1).toLowerCase()).append(" ");
        }
        return result.toString().trim();
    }

    public String getSmallCaps(String text) {
        if (text == null || text.isEmpty()) {
            return "";
        }
        String cacheKey = "smallcaps|" + text;
        String cachedText = this.smallCapsCache.get(cacheKey);
        if (cachedText != null) {
            this.cacheHits.incrementAndGet();
            return cachedText;
        }
        this.cacheMisses.incrementAndGet();
        StringBuilder result = new StringBuilder();
        for (char c : text.toCharArray()) {
            if (Character.isLetter(c)) {
                char lowercaseChar = Character.toLowerCase(c);
                char smallCapsChar = this.getSmallCapsChar(lowercaseChar);
                result.append(smallCapsChar);
                continue;
            }
            result.append(c);
        }
        String smallCapsText = result.toString();
        this.smallCapsCache.put(cacheKey, smallCapsText);
        return smallCapsText;
    }

    private char getSmallCapsChar(char c) {
        return switch (c) {
            case 'a' -> '\u1d00';
            case 'b' -> '\u0299';
            case 'c' -> '\u1d04';
            case 'd' -> '\u1d05';
            case 'e' -> '\u1d07';
            case 'f' -> '\ua730';
            case 'g' -> '\u0262';
            case 'h' -> '\u029c';
            case 'i' -> '\u026a';
            case 'j' -> '\u1d0a';
            case 'k' -> '\u1d0b';
            case 'l' -> '\u029f';
            case 'm' -> '\u1d0d';
            case 'n' -> '\u0274';
            case 'o' -> '\u1d0f';
            case 'p' -> '\u1d18';
            case 'q' -> '\u01eb';
            case 'r' -> '\u0280';
            case 's' -> '\ua731';
            case 't' -> '\u1d1b';
            case 'u' -> '\u1d1c';
            case 'v' -> '\u1d20';
            case 'w' -> '\u1d21';
            case 'x' -> 'x';
            case 'y' -> '\u028f';
            case 'z' -> '\u1d22';
            default -> c;
        };
    }

    public String applyPlaceholdersAndColors(String text, Map<String, String> placeholders) {
        if (text == null) {
            return null;
        }
        String cacheKey = this.generateCacheKey(text, placeholders);
        String cachedResult = this.formattedStringCache.get(cacheKey);
        if (cachedResult != null) {
            this.cacheHits.incrementAndGet();
            return cachedResult;
        }
        this.cacheMisses.incrementAndGet();
        String result = text;
        if (placeholders != null && !placeholders.isEmpty()) {
            for (Map.Entry<String, String> entry : placeholders.entrySet()) {
                result = result.replace("%" + entry.getKey() + "%", entry.getValue());
            }
        }
        result = ColorUtil.translateHexColorCodes(result);
        this.formattedStringCache.put(cacheKey, result);
        return result;
    }

    public String getColorCode(String path) {
        if (!this.activeFileTypes.contains((Object)LanguageFileType.GUI)) {
            return ChatColor.WHITE.toString();
        }
        String colorStr = this.cachedDefaultLocaleData.gui().getString(path);
        if (colorStr == null) {
            return ChatColor.WHITE.toString();
        }
        return this.applyPlaceholdersAndColors(colorStr, EMPTY_PLACEHOLDERS);
    }

    public String applyOnlyPlaceholders(String text, Map<String, String> placeholders) {
        if (text == null) {
            return null;
        }
        String cacheKey = this.generateCacheKey(text, placeholders);
        String cachedResult = this.formattedStringCache.get(cacheKey);
        if (cachedResult != null) {
            this.cacheHits.incrementAndGet();
            return cachedResult;
        }
        this.cacheMisses.incrementAndGet();
        String result = text;
        if (placeholders != null && !placeholders.isEmpty()) {
            for (Map.Entry<String, String> entry : placeholders.entrySet()) {
                result = result.replace("%" + entry.getKey() + "%", entry.getValue());
            }
        }
        this.formattedStringCache.put(cacheKey, result);
        return result;
    }

    public String getHologramText() {
        if (this.plugin.getConfig().contains("hologram.text")) {
            List lines = this.plugin.getConfig().getStringList("hologram.text");
            if (!lines.isEmpty()) {
                return String.join((CharSequence)"\n", lines);
            }
            return this.plugin.getConfig().getString("hologram.text");
        }
        return "&e%entity% Spawner &7[&f%stack_size%x&7]\n&7XP: &a%current_exp%&7/&a%max_exp%\n&7Items: &a%used_slots%&7/&a%max_slots%";
    }

    public void clearCache() {
        this.formattedStringCache.clear();
        this.loreCache.clear();
        this.loreListCache.clear();
        this.guiItemNameCache.clear();
        this.guiItemLoreCache.clear();
        this.guiItemLoreListCache.clear();
        this.entityNameCache.clear();
        this.smallCapsCache.clear();
        this.materialNameCache.clear();
    }

    private String generateCacheKey(String text, Map<String, String> placeholders) {
        if (placeholders == null || placeholders.isEmpty()) {
            return text;
        }
        StringBuilder keyBuilder = new StringBuilder(text);
        ArrayList<String> keys = new ArrayList<String>(placeholders.keySet());
        Collections.sort(keys);
        for (String key : keys) {
            keyBuilder.append('|').append(key).append('=').append(placeholders.get(key));
        }
        return keyBuilder.toString();
    }

    public Map<String, Object> getCacheStats() {
        HashMap<String, Object> stats = new HashMap<String, Object>();
        stats.put("string_cache_size", this.formattedStringCache.size());
        stats.put("string_cache_capacity", this.formattedStringCache.capacity());
        stats.put("lore_cache_size", this.loreCache.size());
        stats.put("lore_cache_capacity", this.loreCache.capacity());
        stats.put("lore_list_cache_size", this.loreListCache.size());
        stats.put("lore_list_cache_capacity", this.loreListCache.capacity());
        stats.put("gui_name_cache_size", this.guiItemNameCache.size());
        stats.put("gui_name_cache_capacity", this.guiItemNameCache.capacity());
        stats.put("gui_lore_cache_size", this.guiItemLoreCache.size());
        stats.put("gui_lore_cache_capacity", this.guiItemLoreCache.capacity());
        stats.put("gui_lore_list_cache_size", this.guiItemLoreListCache.size());
        stats.put("gui_lore_list_cache_capacity", this.guiItemLoreListCache.capacity());
        stats.put("entity_name_cache_size", this.entityNameCache.size());
        stats.put("entity_name_cache_capacity", this.entityNameCache.capacity());
        stats.put("small_caps_cache_size", this.smallCapsCache.size());
        stats.put("small_caps_cache_capacity", this.smallCapsCache.capacity());
        stats.put("material_name_cache_size", this.materialNameCache.size());
        stats.put("material_name_cache_capacity", this.materialNameCache.capacity());
        stats.put("cache_hits", this.cacheHits.get());
        stats.put("cache_misses", this.cacheMisses.get());
        stats.put("hit_ratio", this.cacheHits.get() > 0 ? (double)this.cacheHits.get() / (double)(this.cacheHits.get() + this.cacheMisses.get()) : 0.0);
        return stats;
    }

    @Generated
    public String getDefaultLocale() {
        return this.defaultLocale;
    }

    public static enum LanguageFileType {
        MESSAGES("messages.yml"),
        GUI("gui.yml"),
        FORMATTING("formatting.yml"),
        ITEMS("items.yml");

        private final String fileName;

        private LanguageFileType(String fileName) {
            this.fileName = fileName;
        }

        @Generated
        public String getFileName() {
            return this.fileName;
        }
    }
}

