/*
 * Decompiled with CFR 0.152.
 */
package github.nighter.smartspawner.migration;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import github.nighter.smartspawner.SmartSpawner;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class SpawnerDataConverter {
    private final SmartSpawner plugin;
    private final FileConfiguration oldConfig;
    private final FileConfiguration newConfig;
    private static final Gson gson = new Gson();

    public SpawnerDataConverter(SmartSpawner plugin, FileConfiguration oldConfig, FileConfiguration newConfig) {
        this.plugin = plugin;
        this.oldConfig = oldConfig;
        this.newConfig = newConfig;
    }

    public void convertData() {
        ConfigurationSection spawnersSection = this.oldConfig.getConfigurationSection("spawners");
        if (spawnersSection == null) {
            return;
        }
        for (String spawnerId : spawnersSection.getKeys(false)) {
            try {
                this.convertSpawner(spawnerId);
            }
            catch (Exception e) {
                this.plugin.getLogger().severe("Failed to convert spawner " + spawnerId);
                e.printStackTrace();
            }
        }
    }

    private void convertSpawner(String spawnerId) {
        String oldPath = "spawners." + spawnerId;
        try {
            String worldName = this.oldConfig.getString(oldPath + ".world");
            int x = this.oldConfig.getInt(oldPath + ".x");
            int y = this.oldConfig.getInt(oldPath + ".y");
            int z = this.oldConfig.getInt(oldPath + ".z");
            String settings = String.format("%d,%b,%d,%b,%d,%d,%d,%d,%d,%d,%d,%b", this.oldConfig.getInt(oldPath + ".spawnerExp"), this.oldConfig.getBoolean(oldPath + ".spawnerActive"), this.oldConfig.getInt(oldPath + ".spawnerRange"), this.oldConfig.getBoolean(oldPath + ".spawnerStop"), this.oldConfig.getInt(oldPath + ".spawnDelay"), this.oldConfig.getInt(oldPath + ".maxSpawnerLootSlots"), this.oldConfig.getInt(oldPath + ".maxStoredExp"), this.oldConfig.getInt(oldPath + ".minMobs"), this.oldConfig.getInt(oldPath + ".maxMobs"), this.oldConfig.getInt(oldPath + ".stackSize"), this.oldConfig.getLong(oldPath + ".lastSpawnTime"), this.oldConfig.getBoolean(oldPath + ".allowEquipmentItems"));
            ArrayList<Object> newInventoryFormat = new ArrayList<Object>();
            ConfigurationSection invSection = this.oldConfig.getConfigurationSection(oldPath + ".virtualInventory");
            if (invSection != null) {
                List serializedItems = invSection.getStringList("items");
                HashMap<String, Map> durabilityItems = new HashMap<String, Map>();
                HashMap<String, Integer> regularItems = new HashMap<String, Integer>();
                for (String string : serializedItems) {
                    try {
                        ItemStack item;
                        String[] parts = string.split(":", 2);
                        if (parts.length != 2 || (item = SpawnerDataConverter.itemStackFromJson(parts[1])) == null) continue;
                        if (item.getType() == Material.TIPPED_ARROW) {
                            ItemMeta meta = item.getItemMeta();
                            if (meta instanceof PotionMeta && ((PotionMeta)meta).hasCustomEffects()) {
                                PotionEffect effect = (PotionEffect)((PotionMeta)meta).getCustomEffects().get(0);
                                String itemKey = String.format("TIPPED_ARROW#%s;%d;%d", effect.getType().getName(), effect.getDuration(), effect.getAmplifier());
                                regularItems.merge(itemKey, item.getAmount(), Integer::sum);
                                continue;
                            }
                            regularItems.merge("ARROW", item.getAmount(), Integer::sum);
                            continue;
                        }
                        if (this.isDestructibleItem(item.getType())) {
                            String itemType = item.getType().name();
                            durabilityItems.computeIfAbsent(itemType, k -> new TreeMap()).merge(Integer.valueOf(item.getDurability()), item.getAmount(), Integer::sum);
                            continue;
                        }
                        regularItems.merge(item.getType().name(), item.getAmount(), Integer::sum);
                    }
                    catch (Exception e) {
                        this.plugin.getLogger().warning("Failed to convert item in spawner " + spawnerId + ": " + e.getMessage());
                    }
                }
                for (Map.Entry entry : regularItems.entrySet()) {
                    newInventoryFormat.add((String)entry.getKey() + ":" + String.valueOf(entry.getValue()));
                }
                for (Map.Entry entry : durabilityItems.entrySet()) {
                    StringBuilder itemString = new StringBuilder((String)entry.getKey());
                    if (!((Map)entry.getValue()).isEmpty()) {
                        itemString.append(";");
                        boolean first = true;
                        for (Map.Entry durabilityEntry : ((Map)entry.getValue()).entrySet()) {
                            if (!first) {
                                itemString.append(",");
                            }
                            itemString.append(durabilityEntry.getKey()).append(":").append(durabilityEntry.getValue());
                            first = false;
                        }
                    }
                    newInventoryFormat.add(itemString.toString());
                }
            }
            String spawnerPath = "spawners." + spawnerId;
            this.newConfig.set(spawnerPath + ".location", (Object)String.format("%s,%d,%d,%d", worldName, x, y, z));
            this.newConfig.set(spawnerPath + ".entityType", (Object)this.oldConfig.getString(oldPath + ".entityType"));
            this.newConfig.set(spawnerPath + ".settings", (Object)settings);
            this.newConfig.set(spawnerPath + ".inventory", newInventoryFormat);
        }
        catch (Exception e) {
            this.plugin.getLogger().severe("Failed to convert spawner " + spawnerId + ": " + e.getMessage());
            throw e;
        }
    }

    private boolean isDestructibleItem(Material material) {
        String name = material.name();
        return name.endsWith("_SWORD") || name.endsWith("_PICKAXE") || name.endsWith("_AXE") || name.endsWith("_SPADE") || name.endsWith("_HOE") || name.equals("BOW") || name.equals("FISHING_ROD") || name.equals("FLINT_AND_STEEL") || name.equals("SHEARS") || name.equals("SHIELD") || name.equals("ELYTRA") || name.equals("TRIDENT") || name.equals("CROSSBOW") || name.startsWith("LEATHER_") || name.startsWith("CHAINMAIL_") || name.startsWith("IRON_") || name.startsWith("GOLDEN_") || name.startsWith("DIAMOND_") || name.startsWith("NETHERITE_");
    }

    public static ItemStack itemStackFromJson(String data) {
        JsonObject json = (JsonObject)gson.fromJson(data, JsonObject.class);
        ItemStack item = new ItemStack(Material.valueOf((String)json.get("type").getAsString()), json.get("amount").getAsInt(), (short)json.get("durability").getAsInt());
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            if (json.has("displayName")) {
                meta.setDisplayName(json.get("displayName").getAsString());
            }
            if (json.has("lore")) {
                ArrayList<String> lore = new ArrayList<String>();
                JsonArray loreArray = json.getAsJsonArray("lore");
                Iterator iterator = loreArray.iterator();
                while (iterator.hasNext()) {
                    JsonElement element = (JsonElement)iterator.next();
                    lore.add(element.getAsString());
                }
                meta.setLore(lore);
            }
            if (json.has("enchantments")) {
                JsonObject enchants = json.getAsJsonObject("enchantments");
                for (Map.Entry entry : enchants.entrySet()) {
                    Enchantment enchantment = Enchantment.getByName((String)((String)entry.getKey()));
                    if (enchantment == null) continue;
                    meta.addEnchant(enchantment, ((JsonElement)entry.getValue()).getAsInt(), true);
                }
            }
            if (meta instanceof PotionMeta && json.has("potionData")) {
                PotionMeta potionMeta = (PotionMeta)meta;
                JsonObject potionData = json.getAsJsonObject("potionData");
                if (potionData.has("customEffects")) {
                    JsonArray customEffects = potionData.getAsJsonArray("customEffects");
                    for (JsonElement element : customEffects) {
                        JsonObject effectObj = element.getAsJsonObject();
                        PotionEffectType type = PotionEffectType.getByName((String)effectObj.get("type").getAsString());
                        if (type == null) continue;
                        PotionEffect effect = new PotionEffect(type, effectObj.get("duration").getAsInt(), effectObj.get("amplifier").getAsInt(), effectObj.get("ambient").getAsBoolean(), effectObj.get("particles").getAsBoolean(), effectObj.get("icon").getAsBoolean());
                        potionMeta.addCustomEffect(effect, true);
                    }
                }
            }
            item.setItemMeta(meta);
        }
        return item;
    }
}

