/*
 * Decompiled with CFR 0.152.
 */
package github.nighter.smartspawner.migration;

import github.nighter.smartspawner.SmartSpawner;
import github.nighter.smartspawner.migration.SpawnerDataConverter;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class SpawnerDataMigration {
    private final SmartSpawner plugin;
    private final File dataFolder;
    private static final String DATA_FILE = "spawners_data.yml";
    private static final String BACKUP_FILE = "spawners_data_backup.yml";
    private static final String MIGRATION_FLAG = "data_version";
    private final int CURRENT_VERSION;

    public SpawnerDataMigration(SmartSpawner plugin) {
        this.plugin = plugin;
        this.dataFolder = plugin.getDataFolder();
        this.CURRENT_VERSION = plugin.getDATA_VERSION();
    }

    public boolean checkAndMigrateData() {
        File dataFile = new File(this.dataFolder, DATA_FILE);
        if (!dataFile.exists()) {
            this.plugin.getLogger().info("Data file does not exist. No migration needed.");
            return false;
        }
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)dataFile);
        try {
            boolean needsMigration = false;
            if (!config.contains(MIGRATION_FLAG)) {
                config.set(MIGRATION_FLAG, (Object)this.CURRENT_VERSION);
                try {
                    config.save(dataFile);
                }
                catch (IOException e) {
                    this.plugin.getLogger().warning("Could not save data_version flag: " + e.getMessage());
                }
            }
            if (config.contains("spawners")) {
                for (String spawnerId : config.getConfigurationSection("spawners").getKeys(false)) {
                    String spawnerPath = "spawners." + spawnerId;
                    if (config.contains(spawnerPath + ".location") && config.contains(spawnerPath + ".settings") && config.contains(spawnerPath + ".inventory")) continue;
                    needsMigration = true;
                    break;
                }
            }
            if (!needsMigration) {
                return false;
            }
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("Error validating current data format: " + e.getMessage());
            boolean needsMigration = true;
        }
        this.plugin.getLogger().info("Starting data migration process...");
        try {
            if (!this.createBackup(dataFile)) {
                this.plugin.getLogger().severe("Failed to create backup. Migration aborted.");
                return false;
            }
            boolean success = this.migrateData((FileConfiguration)config, dataFile);
            if (success) {
                return true;
            }
            this.restoreFromBackup(dataFile);
            return false;
        }
        catch (Exception e) {
            this.plugin.getLogger().severe("Error during data migration: " + e.getMessage());
            e.printStackTrace();
            this.restoreFromBackup(dataFile);
            return false;
        }
    }

    private boolean createBackup(File sourceFile) {
        try {
            File backupFile = new File(this.dataFolder, BACKUP_FILE);
            Files.copy(sourceFile.toPath(), backupFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
            this.plugin.getLogger().info("Backup created successfully at: " + backupFile.getPath());
            return true;
        }
        catch (IOException e) {
            this.plugin.getLogger().severe("Failed to create backup: " + e.getMessage());
            e.printStackTrace();
            return false;
        }
    }

    private void restoreFromBackup(File dataFile) {
        try {
            File backupFile = new File(this.dataFolder, BACKUP_FILE);
            if (backupFile.exists()) {
                Files.copy(backupFile.toPath(), dataFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
                this.plugin.getLogger().info("Data restored from backup.");
            }
        }
        catch (IOException e) {
            this.plugin.getLogger().severe("Failed to restore from backup: " + e.getMessage());
            e.printStackTrace();
        }
    }

    private boolean migrateData(FileConfiguration oldConfig, File dataFile) {
        try {
            YamlConfiguration newConfig = new YamlConfiguration();
            newConfig.set(MIGRATION_FLAG, (Object)this.CURRENT_VERSION);
            SpawnerDataConverter converter = new SpawnerDataConverter(this.plugin, oldConfig, (FileConfiguration)newConfig);
            converter.convertData();
            newConfig.save(dataFile);
            return true;
        }
        catch (Exception e) {
            this.plugin.getLogger().severe("Failed to migrate data: " + e.getMessage());
            e.printStackTrace();
            return false;
        }
    }
}

