/*
 * Decompiled with CFR 0.152.
 */
package github.nighter.smartspawner.nms;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bukkit.Bukkit;
import org.bukkit.plugin.java.JavaPlugin;

public class VersionInitializer {
    private final Logger logger;
    private final String serverVersion;
    private final String basePackage = "github.nighter.smartspawner";
    private final String[][] components = new String[][]{{"Particles", "ParticleInitializer"}, {"Textures", "TextureInitializer"}, {"Spawners", "SpawnerInitializer"}};

    public VersionInitializer(JavaPlugin plugin) {
        this.logger = plugin.getLogger();
        this.serverVersion = Bukkit.getServer().getBukkitVersion();
    }

    public void initialize() {
        String versionPath = this.determineVersionPath();
        if (versionPath == null) {
            throw new IllegalStateException("Unsupported server version: " + this.serverVersion);
        }
        this.initializeComponentsForVersion(versionPath);
    }

    private String determineVersionPath() {
        HashMap<String, String> supportedVersions = new HashMap<String, String>();
        supportedVersions.put("1.20", "v1_20");
        supportedVersions.put("1.21", "v1_21");
        for (Map.Entry entry : supportedVersions.entrySet()) {
            if (!this.serverVersion.contains((CharSequence)entry.getKey())) continue;
            return (String)entry.getValue();
        }
        return null;
    }

    private void initializeComponentsForVersion(String versionPath) {
        for (String[] component : this.components) {
            this.initializeComponent(component[0], component[1], versionPath);
        }
    }

    private void initializeComponent(String componentName, String initializerClass, String versionPath) {
        try {
            String className = String.format("%s.%s.%s", "github.nighter.smartspawner", versionPath, initializerClass);
            Class<?> clazz = Class.forName(className);
            Method initMethod = clazz.getMethod("init", new Class[0]);
            initMethod.invoke(null, new Object[0]);
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.fine(String.format("Successfully initialized %s for version %s", componentName, this.serverVersion));
            }
        }
        catch (Exception e) {
            this.logger.severe(String.format("Failed to initialize %s for version %s: %s", componentName, this.serverVersion, e.getMessage()));
            if (this.logger.isLoggable(Level.FINE)) {
                e.printStackTrace();
            }
            throw new RuntimeException("Failed to initialize " + componentName, e);
        }
    }
}

