/*
 * Decompiled with CFR 0.152.
 */
package github.nighter.smartspawner.spawner.gui.main;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.bukkit.inventory.ItemStack;

public class ItemCache {
    private final AtomicInteger cacheHits = new AtomicInteger(0);
    private final AtomicInteger cacheMisses = new AtomicInteger(0);
    private final Cache<String, ItemStack> itemCache;

    public ItemCache() {
        this(500, 60);
    }

    public ItemCache(int maxSize, int expirySeconds) {
        this.itemCache = CacheBuilder.newBuilder().maximumSize((long)maxSize).expireAfterWrite((long)expirySeconds, TimeUnit.SECONDS).build();
    }

    public void put(String key, ItemStack item) {
        if (key == null || item == null) {
            return;
        }
        this.itemCache.put((Object)key, (Object)item.clone());
    }

    public ItemStack getIfPresent(String key) {
        if (key == null) {
            return null;
        }
        ItemStack item = (ItemStack)this.itemCache.getIfPresent((Object)key);
        if (item != null) {
            this.cacheHits.incrementAndGet();
            return item.clone();
        }
        this.cacheMisses.incrementAndGet();
        return null;
    }

    public void clear() {
        this.itemCache.invalidateAll();
    }

    public int getHitCount() {
        return this.cacheHits.get();
    }

    public int getMissCount() {
        return this.cacheMisses.get();
    }

    public long getSize() {
        return this.itemCache.size();
    }

    public double getHitRate() {
        int hits = this.cacheHits.get();
        int total = hits + this.cacheMisses.get();
        return total > 0 ? (double)hits / (double)total * 100.0 : 0.0;
    }
}

