/*
 * Decompiled with CFR 0.152.
 */
package github.nighter.smartspawner.spawner.gui.main;

import github.nighter.smartspawner.SmartSpawner;
import github.nighter.smartspawner.holders.SpawnerMenuHolder;
import github.nighter.smartspawner.language.LanguageManager;
import github.nighter.smartspawner.language.MessageService;
import github.nighter.smartspawner.nms.ParticleWrapper;
import github.nighter.smartspawner.spawner.gui.main.SpawnerMenuUI;
import github.nighter.smartspawner.spawner.gui.stacker.SpawnerStackerUI;
import github.nighter.smartspawner.spawner.gui.storage.SpawnerStorageUI;
import github.nighter.smartspawner.spawner.gui.synchronization.SpawnerGuiViewManager;
import github.nighter.smartspawner.spawner.properties.SpawnerData;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;

public class SpawnerMenuAction
implements Listener {
    private static final Set<Material> SPAWNER_INFO_MATERIALS = EnumSet.of(Material.PLAYER_HEAD, new Material[]{Material.SPAWNER, Material.ZOMBIE_HEAD, Material.SKELETON_SKULL, Material.WITHER_SKELETON_SKULL, Material.CREEPER_HEAD, Material.PIGLIN_HEAD});
    private final SmartSpawner plugin;
    private final SpawnerMenuUI spawnerMenuUI;
    private final SpawnerStackerUI spawnerStackerUI;
    private final SpawnerStorageUI spawnerStorageUI;
    private final SpawnerGuiViewManager spawnerGuiViewManager;
    private final LanguageManager languageManager;
    private final MessageService messageService;
    private final Map<UUID, Long> sellCooldowns = new ConcurrentHashMap<UUID, Long>();
    private final Map<UUID, Long> lastInfoClickTime = new ConcurrentHashMap<UUID, Long>();
    private boolean cooldownEnabled = true;
    private long cooldownDurationMs = 3000L;
    private long lastConfigReloadTime = 0L;
    private static final long CONFIG_CACHE_TTL = 60000L;

    public SpawnerMenuAction(SmartSpawner plugin) {
        this.plugin = plugin;
        this.spawnerMenuUI = plugin.getSpawnerMenuUI();
        this.spawnerStackerUI = plugin.getSpawnerStackerUI();
        this.spawnerStorageUI = plugin.getSpawnerStorageUI();
        this.spawnerGuiViewManager = plugin.getSpawnerGuiViewManager();
        this.languageManager = plugin.getLanguageManager();
        this.messageService = plugin.getMessageService();
        this.updateCooldownSettings();
    }

    @EventHandler
    public void onMenuClick(InventoryClickEvent event) {
        HumanEntity humanEntity = event.getWhoClicked();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player player = (Player)humanEntity;
        InventoryHolder inventoryHolder = event.getInventory().getHolder();
        if (!(inventoryHolder instanceof SpawnerMenuHolder)) {
            return;
        }
        SpawnerMenuHolder holder = (SpawnerMenuHolder)inventoryHolder;
        event.setCancelled(true);
        SpawnerData spawner = holder.getSpawnerData();
        if (event.getClickedInventory() == null || !(event.getClickedInventory().getHolder() instanceof SpawnerMenuHolder)) {
            return;
        }
        ItemStack clickedItem = event.getCurrentItem();
        if (clickedItem == null || clickedItem.getType() == Material.AIR) {
            return;
        }
        Material itemType = clickedItem.getType();
        if (itemType == Material.CHEST) {
            this.handleChestClick(player, spawner);
        } else if (SPAWNER_INFO_MATERIALS.contains(itemType)) {
            this.handleSpawnerInfoClick(player, spawner, event.getClick());
        } else if (itemType == Material.EXPERIENCE_BOTTLE) {
            this.handleExpBottleClick(player, spawner, false);
        }
    }

    public void handleChestClick(Player player, SpawnerData spawner) {
        String title = this.languageManager.getGuiTitle("gui_title_storage");
        Inventory pageInventory = this.spawnerStorageUI.createInventory(spawner, title, 1, -1);
        player.playSound(player.getLocation(), Sound.BLOCK_CHEST_OPEN, 1.0f, 1.0f);
        player.closeInventory();
        player.openInventory(pageInventory);
    }

    private void handleSpawnerInfoClick(Player player, SpawnerData spawner, ClickType clickType) {
        boolean hasShopIntegration;
        if (this.isClickTooFrequent(player)) {
            return;
        }
        boolean bl = hasShopIntegration = this.plugin.hasShopIntegration() && player.hasPermission("smartspawner.sellall");
        if (hasShopIntegration) {
            if (clickType == ClickType.LEFT) {
                boolean hasExp = this.handleExpBottleClick(player, spawner, true);
                boolean soldItems = this.handleSellAllItems(player, spawner);
                if (soldItems && spawner.getIsAtCapacity().booleanValue()) {
                    spawner.setIsAtCapacity(false);
                }
            } else if (clickType == ClickType.RIGHT) {
                if (!player.hasPermission("smartspawner.stack")) {
                    this.messageService.sendMessage(player, "no_permission");
                    return;
                }
                this.spawnerStackerUI.openStackerGui(player, spawner);
                player.playSound(player.getLocation(), Sound.UI_BUTTON_CLICK, 1.0f, 1.0f);
            }
        } else {
            if (!player.hasPermission("smartspawner.stack")) {
                this.messageService.sendMessage(player, "no_permission");
                return;
            }
            this.spawnerStackerUI.openStackerGui(player, spawner);
            player.playSound(player.getLocation(), Sound.UI_BUTTON_CLICK, 1.0f, 1.0f);
        }
    }

    private boolean isClickTooFrequent(Player player) {
        long now = System.currentTimeMillis();
        long last = this.lastInfoClickTime.getOrDefault(player.getUniqueId(), 0L);
        this.lastInfoClickTime.put(player.getUniqueId(), now);
        return now - last < 300L;
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        this.lastInfoClickTime.remove(event.getPlayer().getUniqueId());
        this.sellCooldowns.remove(event.getPlayer().getUniqueId());
    }

    private boolean handleSellAllItems(Player player, SpawnerData spawner) {
        if (!this.plugin.hasShopIntegration()) {
            return false;
        }
        if (!player.hasPermission("smartspawner.sellall")) {
            this.messageService.sendMessage(player, "no_permission");
            return false;
        }
        this.checkConfigReload();
        if (!this.cooldownEnabled) {
            return this.plugin.getShopIntegration().sellAllItems(player, spawner);
        }
        long remainingTime = this.getRemainingCooldownTime(player);
        if (remainingTime > 0L) {
            this.sendCooldownMessage(player, remainingTime);
            return false;
        }
        this.updateCooldown(player);
        if (Math.random() < 0.1) {
            this.clearOldCooldowns();
        }
        return this.plugin.getShopIntegration().sellAllItems(player, spawner);
    }

    private void checkConfigReload() {
        long now = System.currentTimeMillis();
        if (now - this.lastConfigReloadTime > 60000L) {
            this.updateCooldownSettings();
            this.lastConfigReloadTime = now;
        }
    }

    public void updateCooldownSettings() {
        this.cooldownEnabled = this.plugin.getConfig().getBoolean("sell_cooldown.enabled", true);
        long durationTicks = this.plugin.getTimeFromConfig("sell_cooldown.duration", "3s");
        this.cooldownDurationMs = durationTicks * 50L;
    }

    private long getRemainingCooldownTime(Player player) {
        if (!this.cooldownEnabled || this.cooldownDurationMs <= 0L) {
            return 0L;
        }
        long lastSellTime = this.sellCooldowns.getOrDefault(player.getUniqueId(), 0L);
        long currentTime = System.currentTimeMillis();
        long elapsed = currentTime - lastSellTime;
        return elapsed >= this.cooldownDurationMs ? 0L : this.cooldownDurationMs - elapsed;
    }

    private void sendCooldownMessage(Player player, long remainingTimeMs) {
        int remainingSeconds = (int)Math.ceil((double)remainingTimeMs / 1000.0);
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("seconds", String.valueOf(remainingSeconds));
        placeholders.put("time", this.formatRemainingTime(remainingTimeMs));
        this.messageService.sendMessage(player, "shop.sell_cooldown", placeholders);
    }

    private String formatRemainingTime(long milliseconds) {
        if (milliseconds < 1000L) {
            return milliseconds + "ms";
        }
        if (milliseconds < 60000L) {
            return String.format("%.1fs", (double)milliseconds / 1000.0);
        }
        long minutes = TimeUnit.MILLISECONDS.toMinutes(milliseconds);
        long seconds = TimeUnit.MILLISECONDS.toSeconds(milliseconds) - TimeUnit.MINUTES.toSeconds(minutes);
        return String.format("%dm %ds", minutes, seconds);
    }

    private void updateCooldown(Player player) {
        this.sellCooldowns.put(player.getUniqueId(), System.currentTimeMillis());
    }

    private void clearOldCooldowns() {
        if (!this.cooldownEnabled || this.cooldownDurationMs <= 0L) {
            this.sellCooldowns.clear();
            return;
        }
        long currentTime = System.currentTimeMillis();
        long expirationThreshold = this.cooldownDurationMs * 2L;
        this.sellCooldowns.entrySet().removeIf(entry -> currentTime - (Long)entry.getValue() > expirationThreshold);
    }

    public boolean isSellCooldownActive(Player player) {
        return this.getRemainingCooldownTime(player) > 0L;
    }

    public void updateSellCooldown(Player player) {
        this.updateCooldown(player);
    }

    public String getRemainingCooldownTimeFormatted(Player player) {
        long remaining = this.getRemainingCooldownTime(player);
        return remaining > 0L ? this.formatRemainingTime(remaining) : null;
    }

    public boolean handleExpBottleClick(Player player, SpawnerData spawner, boolean isSell) {
        if (this.isClickTooFrequent(player) && !isSell) {
            return false;
        }
        int exp = spawner.getSpawnerExp();
        if (exp <= 0 && !isSell) {
            this.messageService.sendMessage(player, "no_exp");
            return false;
        }
        int initialExp = exp;
        int expUsedForMending = 0;
        if (this.plugin.getConfig().getBoolean("spawner_properties.default.allow_exp_mending")) {
            expUsedForMending = this.applyMendingFromExp(player, exp);
            exp -= expUsedForMending;
        }
        if (exp > 0) {
            player.giveExp(exp);
            player.playSound(player.getLocation(), Sound.ENTITY_EXPERIENCE_ORB_PICKUP, 1.0f, 1.0f);
        }
        spawner.setSpawnerExp(0);
        this.spawnerMenuUI.openSpawnerMenu(player, spawner, true);
        this.spawnerGuiViewManager.updateSpawnerMenuViewers(spawner);
        if (spawner.getSpawnerExp() < spawner.getMaxStoredExp() && spawner.getIsAtCapacity().booleanValue()) {
            spawner.setIsAtCapacity(false);
        }
        this.sendExpCollectionMessage(player, initialExp, expUsedForMending);
        return true;
    }

    private int applyMendingFromExp(Player player, int availableExp) {
        if (availableExp <= 0) {
            return 0;
        }
        int expUsed = 0;
        PlayerInventory inventory = player.getInventory();
        List<ItemStack> itemsToCheck = Arrays.asList(inventory.getItemInMainHand(), inventory.getItemInOffHand(), inventory.getHelmet(), inventory.getChestplate(), inventory.getLeggings(), inventory.getBoots());
        for (ItemStack item : itemsToCheck) {
            int damage;
            int durabilityToRepair;
            int expNeeded;
            Damageable damageable;
            ItemMeta itemMeta;
            if (availableExp <= 0) break;
            if (item == null || item.getType() == Material.AIR || !item.getEnchantments().containsKey(Enchantment.MENDING) || !((itemMeta = item.getItemMeta()) instanceof Damageable) || (damageable = (Damageable)itemMeta).getDamage() <= 0 || (expNeeded = ((durabilityToRepair = Math.min(damage = damageable.getDamage(), availableExp * 2)) + 1) / 2) <= 0) continue;
            int actualExpUsed = Math.min(expNeeded, availableExp);
            int actualRepair = actualExpUsed * 2;
            int newDamage = Math.max(0, damage - actualRepair);
            Damageable meta = (Damageable)item.getItemMeta();
            meta.setDamage(newDamage);
            item.setItemMeta((ItemMeta)meta);
            availableExp -= actualExpUsed;
            expUsed += actualExpUsed;
            player.playSound(player.getLocation(), Sound.BLOCK_ANVIL_USE, 0.5f, 1.0f);
            player.spawnParticle(ParticleWrapper.VILLAGER_HAPPY, player.getLocation().add(0.0, 1.0, 0.0), 5);
        }
        return expUsed;
    }

    private void sendExpCollectionMessage(Player player, int totalExp, int mendingExp) {
        HashMap<String, String> placeholders = new HashMap<String, String>();
        if (mendingExp > 0) {
            int remainingExp = totalExp - mendingExp;
            placeholders.put("exp_mending", this.languageManager.formatNumber(mendingExp));
            placeholders.put("exp", this.languageManager.formatNumber(remainingExp));
            this.messageService.sendMessage(player, "exp_collected_with_mending", placeholders);
        } else if (totalExp > 0) {
            placeholders.put("exp", this.plugin.getLanguageManager().formatNumber(totalExp));
            this.messageService.sendMessage(player, "exp_collected", placeholders);
        }
    }
}

