/*
 * Decompiled with CFR 0.152.
 */
package github.nighter.smartspawner.spawner.gui.main;

import github.nighter.smartspawner.SmartSpawner;
import github.nighter.smartspawner.language.LanguageManager;
import github.nighter.smartspawner.language.MessageService;
import github.nighter.smartspawner.spawner.properties.SpawnerData;
import java.util.HashMap;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.geysermc.cumulus.form.Form;
import org.geysermc.cumulus.form.SimpleForm;
import org.geysermc.cumulus.util.FormImage;
import org.geysermc.floodgate.api.FloodgateApi;

public class SpawnerMenuFormUI {
    private final SmartSpawner plugin;
    private final LanguageManager languageManager;
    private final MessageService messageService;

    public SpawnerMenuFormUI(SmartSpawner plugin) {
        this.plugin = plugin;
        this.languageManager = plugin.getLanguageManager();
        this.messageService = plugin.getMessageService();
    }

    public void openSpawnerForm(Player player, SpawnerData spawner) {
        String entityName = this.languageManager.getFormattedMobName(spawner.getEntityType());
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("entity", entityName);
        placeholders.put("amount", String.valueOf(spawner.getStackSize()));
        String title = spawner.getStackSize() > 1 ? this.languageManager.getGuiTitle("gui_title_main.stacked_spawner", placeholders) : this.languageManager.getGuiTitle("gui_title_main.single_spawner", placeholders);
        String lootButtonText = "Open Storage";
        String infoButtonText = "Open Stack Menu";
        String expButtonText = "Collect Experience";
        SimpleForm form = (SimpleForm)((SimpleForm.Builder)((SimpleForm.Builder)((SimpleForm.Builder)SimpleForm.builder().title(title)).content(this.createInfoContent(player, spawner)).button(lootButtonText, FormImage.Type.URL, "https://img.icons8.com/?size=100&id=e78DnJp8bhmX&format=png&color=000000").button(infoButtonText, FormImage.Type.URL, "https://static.wikia.nocookie.net/minecraft_gamepedia/images/c/cf/Spawner_with_fire.png/revision/latest?cb=20190925003048").button(expButtonText, FormImage.Type.URL, "https://static.wikia.nocookie.net/minecraft_gamepedia/images/1/10/Bottle_o%27_Enchanting.gif/revision/latest?cb=20200428012753").closedOrInvalidResultHandler(() -> {})).validResultHandler(response -> {
            int buttonId = response.clickedButtonId();
            this.plugin.getServer().getScheduler().runTask((Plugin)this.plugin, () -> {
                switch (buttonId) {
                    case 0: {
                        this.handleLootStorage(player, spawner);
                        break;
                    }
                    case 1: {
                        this.handleSpawnerInfo(player, spawner);
                        break;
                    }
                    case 2: {
                        this.handleExpCollection(player, spawner);
                    }
                }
            });
        })).build();
        FloodgateApi.getInstance().getPlayer(player.getUniqueId()).sendForm((Form)form);
    }

    private String createInfoContent(Player player, SpawnerData spawner) {
        StringBuilder content = new StringBuilder();
        String entityName = this.languageManager.getFormattedMobName(spawner.getEntityType());
        content.append("\u00a7l\u00a7b\u00bb\u00bb\u00bb Spawner Information \u00ab\u00ab\u00ab\u00a7r\n\n");
        content.append("\u00a78\u25aa \u00a7b Entity: \u00a7f").append(entityName).append("\n");
        content.append("\u00a78\u25aa \u00a7b Stack Size: \u00a7f").append(spawner.getStackSize()).append("\n");
        content.append("\u00a78\u25aa \u00a7b Range: \u00a7f").append(spawner.getSpawnerRange()).append(" \u00a77blocks\n");
        content.append("\u00a78\u25aa \u00a7b Delay: \u00a7f").append(spawner.getSpawnDelay() / 20L).append(" \u00a77seconds\n");
        content.append("\u00a78\u25aa \u00a7b Mob Rate: \u00a7f").append(spawner.getMinMobs()).append(" \u00a77- \u00a7f").append(spawner.getMaxMobs()).append("\n\n");
        int currentItems = spawner.getVirtualInventory().getUsedSlots();
        int maxSlots = spawner.getMaxSpawnerLootSlots();
        content.append("\u00a7l\u00a76\u00bb\u00bb\u00bb Storage \u00ab\u00ab\u00ab\u00a7r\n\n");
        content.append("\u00a78\u25aa \u00a76 Slots: \u00a7f").append(currentItems).append("\u00a77/\u00a7f").append(maxSlots).append("\n");
        content.append("\u00a78\u25aa \u00a76 Status: \u00a7f").append(this.getStorageStatus(currentItems, maxSlots)).append("\n\n");
        long currentExp = spawner.getSpawnerExp().intValue();
        long maxExp = spawner.getMaxStoredExp();
        String formattedExp = this.languageManager.formatNumber(currentExp);
        String formattedMaxExp = this.languageManager.formatNumber(maxExp);
        content.append("\u00a7l\u00a7a\u00bb\u00bb\u00bb Experience \u00ab\u00ab\u00ab\u00a7r\n\n");
        content.append("\u00a78\u25aa \u00a7a Current: \u00a7e").append(formattedExp).append("\u00a77/\u00a7e").append(formattedMaxExp).append(" \u00a77XP\n");
        content.append("\u00a78\u25aa \u00a7a Status: \u00a7e").append(this.getExpStatus(currentExp, maxExp)).append("\n\n");
        return content.toString();
    }

    private String getStorageStatus(int current, int max) {
        double ratio = (double)current / (double)max;
        if (ratio >= 0.9) {
            return "\u00a7cNearly Full";
        }
        if (ratio >= 0.7) {
            return "\u00a76Filling Up";
        }
        if (ratio >= 0.4) {
            return "\u00a7eHalf Full";
        }
        if (ratio > 0.0) {
            return "\u00a7aPlenty of Space";
        }
        return "\u00a7aEmpty";
    }

    private String getExpStatus(long current, long max) {
        double ratio = (double)current / (double)max;
        if (ratio >= 0.9) {
            return "\u00a7cAlmost Full";
        }
        if (ratio >= 0.7) {
            return "\u00a76Large Amount";
        }
        if (ratio >= 0.4) {
            return "\u00a7eMedium Amount";
        }
        if (ratio > 0.0) {
            return "\u00a7aSmall Amount";
        }
        return "\u00a7aEmpty";
    }

    private void handleLootStorage(Player player, SpawnerData spawner) {
        this.plugin.getSpawnerMenuAction().handleChestClick(player, spawner);
    }

    private void handleSpawnerInfo(Player player, SpawnerData spawner) {
        if (!player.hasPermission("smartspawner.stack")) {
            this.messageService.sendMessage(player, "no_permission");
            return;
        }
        this.plugin.getSpawnerStackerUI().openStackerGui(player, spawner);
    }

    private void handleExpCollection(Player player, SpawnerData spawner) {
        this.plugin.getSpawnerMenuAction().handleExpBottleClick(player, spawner, false);
    }

    private int calculatePercentage(long current, long maximum) {
        return maximum > 0L ? (int)((double)current / (double)maximum * 100.0) : 0;
    }

    public static boolean isBedrockPlayer(Player player) {
        try {
            return FloodgateApi.getInstance().isFloodgatePlayer(player.getUniqueId());
        }
        catch (Exception e) {
            return false;
        }
    }
}

