/*
 * Decompiled with CFR 0.152.
 */
package github.nighter.smartspawner.spawner.gui.storage;

import github.nighter.smartspawner.SmartSpawner;
import github.nighter.smartspawner.holders.FilterConfigHolder;
import github.nighter.smartspawner.language.LanguageManager;
import github.nighter.smartspawner.spawner.gui.storage.SpawnerStorageUI;
import github.nighter.smartspawner.spawner.loot.LootItem;
import github.nighter.smartspawner.spawner.properties.SpawnerData;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

public class FilterConfigUI
implements Listener {
    private static final int INVENTORY_SIZE = 27;
    private static final Set<Integer> DIVIDER_SLOTS = Set.of(Integer.valueOf(4), Integer.valueOf(13), Integer.valueOf(22));
    private final SmartSpawner plugin;
    private final LanguageManager languageManager;
    private final SpawnerStorageUI storageUI;
    private final Map<String, ItemStack> staticButtons;
    private final Map<UUID, Long> lastItemClickTime = new ConcurrentHashMap<UUID, Long>();

    public FilterConfigUI(SmartSpawner plugin) {
        this.plugin = plugin;
        this.languageManager = plugin.getLanguageManager();
        this.storageUI = plugin.getSpawnerStorageUI();
        this.staticButtons = new HashMap<String, ItemStack>();
        this.initializeStaticButtons();
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    private void initializeStaticButtons() {
        this.staticButtons.put("divider", this.createButton(Material.PURPLE_STAINED_GLASS_PANE, this.languageManager.getGuiItemName("filter_divider.name"), this.languageManager.getGuiItemLoreAsList("filter_divider.lore")));
    }

    private ItemStack createButton(Material material, String name, List<String> lore) {
        ItemStack item = new ItemStack(material);
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            meta.setDisplayName(name);
            if (!lore.isEmpty()) {
                meta.setLore(lore);
            }
            item.setItemMeta(meta);
        }
        return item;
    }

    private boolean isClickTooFrequent(Player player) {
        long now = System.currentTimeMillis();
        long last = this.lastItemClickTime.getOrDefault(player.getUniqueId(), 0L);
        this.lastItemClickTime.put(player.getUniqueId(), now);
        return now - last < 200L;
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        UUID playerId = event.getPlayer().getUniqueId();
        this.lastItemClickTime.remove(playerId);
    }

    public void openFilterConfigGUI(Player player, SpawnerData spawner) {
        String title = this.languageManager.getGuiTitle("gui_title_filter_config");
        Inventory filterInventory = Bukkit.createInventory((InventoryHolder)new FilterConfigHolder(spawner), (int)27, (String)title);
        this.setupFilterInventory(filterInventory, spawner);
        player.playSound(player.getLocation(), Sound.UI_BUTTON_CLICK, 1.0f, 1.0f);
        player.openInventory(filterInventory);
    }

    private void setupFilterInventory(Inventory inventory, SpawnerData spawner) {
        inventory.clear();
        List<LootItem> allLootItems = spawner.getLootConfig().getAllItems();
        Set<Material> filteredItems = spawner.getFilteredItems();
        ItemStack divider = this.staticButtons.get("divider");
        for (Integer slot : DIVIDER_SLOTS) {
            inventory.setItem(slot.intValue(), divider);
        }
        ArrayList<ItemStack> allowedItems = new ArrayList<ItemStack>();
        ArrayList<ItemStack> blockedItems = new ArrayList<ItemStack>();
        for (LootItem lootItem : allLootItems) {
            ItemStack displayItem = lootItem.createItemStack(new Random());
            if (displayItem == null) continue;
            Material itemType = displayItem.getType();
            if (filteredItems.contains(itemType)) {
                displayItem = this.addFilterMarkerToItem(displayItem, true);
                blockedItems.add(displayItem);
                continue;
            }
            displayItem = this.addFilterMarkerToItem(displayItem, false);
            allowedItems.add(displayItem);
        }
        this.placeItemsInSection(inventory, allowedItems, 0, 4);
        this.placeItemsInSection(inventory, blockedItems, 5, 4);
    }

    private ItemStack addFilterMarkerToItem(ItemStack item, boolean isFiltered) {
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            String itemName = this.languageManager.getVanillaItemName(item.getType());
            HashMap<String, String> placeholders = new HashMap<String, String>();
            placeholders.put("item_name", itemName);
            placeholders.put("\u026a\u1d1b\u1d07\u1d0d_\u0274\u1d00\u1d0d\u1d07", this.languageManager.getSmallCaps(itemName));
            String nameKey = isFiltered ? "filter_item_blocked.name" : "filter_item_allowed.name";
            meta.setDisplayName(this.languageManager.getGuiItemName(nameKey, placeholders));
            String loreKey = isFiltered ? "filter_item_blocked.lore" : "filter_item_allowed.lore";
            meta.setLore(this.languageManager.getGuiItemLoreAsList(loreKey, placeholders));
            item.setItemMeta(meta);
        }
        return item;
    }

    private void placeItemsInSection(Inventory inventory, List<ItemStack> items, int startColumn, int columnsSpan) {
        int index = 0;
        for (ItemStack item : items) {
            int row = index / columnsSpan;
            int column = startColumn + index % columnsSpan;
            int slot = row * 9 + column;
            if (slot < 27 && !DIVIDER_SLOTS.contains(slot)) {
                inventory.setItem(slot, item);
            }
            ++index;
        }
    }

    @EventHandler
    public void onFilterInventoryClick(InventoryClickEvent event) {
        InventoryHolder inventoryHolder = event.getInventory().getHolder();
        if (!(inventoryHolder instanceof FilterConfigHolder)) {
            return;
        }
        FilterConfigHolder holder = (FilterConfigHolder)inventoryHolder;
        event.setCancelled(true);
        HumanEntity humanEntity = event.getWhoClicked();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player player = (Player)humanEntity;
        if (this.isClickTooFrequent(player)) {
            return;
        }
        SpawnerData spawner = holder.getSpawnerData();
        int slot = event.getRawSlot();
        if (DIVIDER_SLOTS.contains(slot)) {
            this.returnToStorage(player, spawner);
            return;
        }
        ItemStack clickedItem = event.getCurrentItem();
        if (clickedItem == null || clickedItem.getType() == Material.AIR) {
            return;
        }
        boolean wasUpdated = this.toggleItemFilter(player, spawner, clickedItem);
        if (wasUpdated) {
            this.setupFilterInventory(event.getInventory(), spawner);
        }
    }

    private void returnToStorage(Player player, SpawnerData spawner) {
        player.playSound(player.getLocation(), Sound.UI_BUTTON_CLICK, 0.8f, 1.0f);
        player.closeInventory();
        String title = this.languageManager.getGuiTitle("gui_title_storage");
        Inventory pageInventory = this.storageUI.createInventory(spawner, title, 1, -1);
        player.openInventory(pageInventory);
    }

    private boolean toggleItemFilter(Player player, SpawnerData spawner, ItemStack clickedItem) {
        Material itemType = clickedItem.getType();
        boolean wasFiltered = spawner.toggleItemFilter(itemType);
        Sound sound = wasFiltered ? Sound.BLOCK_NOTE_BLOCK_PLING : Sound.UI_BUTTON_CLICK;
        player.playSound(player.getLocation(), sound, 0.5f, 1.0f);
        return true;
    }
}

