/*
 * Decompiled with CFR 0.152.
 */
package github.nighter.smartspawner.spawner.gui.storage;

import github.nighter.smartspawner.SmartSpawner;
import github.nighter.smartspawner.holders.StoragePageHolder;
import github.nighter.smartspawner.language.LanguageManager;
import github.nighter.smartspawner.language.MessageService;
import github.nighter.smartspawner.spawner.gui.main.SpawnerMenuAction;
import github.nighter.smartspawner.spawner.gui.main.SpawnerMenuUI;
import github.nighter.smartspawner.spawner.gui.storage.FilterConfigUI;
import github.nighter.smartspawner.spawner.gui.storage.SpawnerStorageUI;
import github.nighter.smartspawner.spawner.gui.storage.utils.ItemClickHandler;
import github.nighter.smartspawner.spawner.gui.storage.utils.ItemMoveHelper;
import github.nighter.smartspawner.spawner.gui.storage.utils.ItemMoveResult;
import github.nighter.smartspawner.spawner.gui.synchronization.SpawnerGuiViewManager;
import github.nighter.smartspawner.spawner.properties.SpawnerData;
import github.nighter.smartspawner.spawner.properties.VirtualInventory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;

public class SpawnerStorageAction
implements Listener {
    private final SmartSpawner plugin;
    private final LanguageManager languageManager;
    private final SpawnerMenuUI spawnerMenuUI;
    private final SpawnerGuiViewManager spawnerGuiViewManager;
    private final SpawnerMenuAction spawnerMenuAction;
    private final MessageService messageService;
    private final FilterConfigUI filterConfigUI;
    private static final int INVENTORY_SIZE = 54;
    private static final int STORAGE_SLOTS = 45;
    private static final Set<Integer> CONTROL_SLOTS = Set.of(Integer.valueOf(45), Integer.valueOf(46), Integer.valueOf(48), Integer.valueOf(49), Integer.valueOf(50), Integer.valueOf(52), Integer.valueOf(53));
    private final Map<ClickType, ItemClickHandler> clickHandlers;
    private final Map<UUID, Inventory> openStorageInventories = new HashMap<UUID, Inventory>();
    private final Map<UUID, Long> lastItemClickTime = new ConcurrentHashMap<UUID, Long>();

    public SpawnerStorageAction(SmartSpawner plugin) {
        this.plugin = plugin;
        this.languageManager = plugin.getLanguageManager();
        this.clickHandlers = this.initializeClickHandlers();
        this.spawnerMenuUI = plugin.getSpawnerMenuUI();
        this.spawnerGuiViewManager = plugin.getSpawnerGuiViewManager();
        this.spawnerMenuAction = plugin.getSpawnerMenuAction();
        this.messageService = plugin.getMessageService();
        this.filterConfigUI = plugin.getFilterConfigUI();
    }

    private Map<ClickType, ItemClickHandler> initializeClickHandlers() {
        EnumMap<ClickType, ItemClickHandler> handlers = new EnumMap<ClickType, ItemClickHandler>(ClickType.class);
        handlers.put(ClickType.RIGHT, (player, inv, slot, item, spawner) -> this.takeSingleItem(player, inv, slot, item, spawner, true));
        handlers.put(ClickType.LEFT, (player, inv, slot, item, spawner) -> this.takeSingleItem(player, inv, slot, item, spawner, false));
        return Collections.unmodifiableMap(handlers);
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onInventoryClick(InventoryClickEvent event) {
        ItemStack clickedItem;
        Player player;
        HumanEntity humanEntity;
        block9: {
            block8: {
                humanEntity = event.getWhoClicked();
                if (!(humanEntity instanceof Player)) break block8;
                player = (Player)humanEntity;
                humanEntity = event.getInventory().getHolder();
                if (humanEntity instanceof StoragePageHolder) break block9;
            }
            return;
        }
        StoragePageHolder holder = (StoragePageHolder)humanEntity;
        SpawnerData spawner = holder.getSpawnerData();
        int slot = event.getRawSlot();
        if ((event.getAction() == InventoryAction.DROP_ONE_SLOT || event.getAction() == InventoryAction.DROP_ALL_SLOT) && slot >= 0 && slot < 45 && (clickedItem = event.getCurrentItem()) != null && clickedItem.getType() != Material.AIR) {
            event.setCancelled(true);
            boolean dropStack = event.getAction() == InventoryAction.DROP_ALL_SLOT;
            this.handleItemDrop(player, spawner, event.getInventory(), slot, clickedItem, dropStack);
            return;
        }
        event.setCancelled(true);
        if (slot < 0 || slot >= 54) {
            return;
        }
        if (CONTROL_SLOTS.contains(slot)) {
            this.handleControlSlotClick(player, slot, holder, spawner, event.getInventory());
            return;
        }
        clickedItem = event.getCurrentItem();
        if (clickedItem == null || clickedItem.getType() == Material.AIR) {
            return;
        }
        ItemClickHandler handler = this.clickHandlers.get(event.getClick());
        if (handler != null) {
            handler.handle(player, event.getInventory(), slot, clickedItem, spawner);
        }
    }

    @EventHandler
    public void onInventoryDrag(InventoryDragEvent event) {
        if (event.getInventory().getHolder() instanceof StoragePageHolder) {
            event.setCancelled(true);
        }
    }

    private void handleItemDrop(Player player, SpawnerData spawner, Inventory inventory, int slot, ItemStack item, boolean dropStack) {
        int amountToDrop = dropStack ? item.getAmount() : 1;
        ItemStack droppedItem = item.clone();
        droppedItem.setAmount(Math.min(amountToDrop, item.getAmount()));
        VirtualInventory virtualInv = spawner.getVirtualInventory();
        ArrayList<ItemStack> itemsToRemove = new ArrayList<ItemStack>();
        itemsToRemove.add(droppedItem);
        virtualInv.removeItems(itemsToRemove);
        int remaining = item.getAmount() - amountToDrop;
        if (remaining <= 0) {
            inventory.setItem(slot, null);
        } else {
            ItemStack remainingItem = item.clone();
            remainingItem.setAmount(remaining);
            inventory.setItem(slot, remainingItem);
        }
        Location dropLocation = player.getLocation().clone();
        double yaw = Math.toRadians(player.getLocation().getYaw());
        dropLocation.add(-Math.sin(yaw) * 1.8, 0.1, Math.cos(yaw) * 1.8);
        player.getWorld().dropItem(dropLocation, droppedItem);
        player.playSound(player.getLocation(), Sound.ENTITY_ITEM_PICKUP, 0.5f, 1.2f);
        spawner.updateHologramData();
        StoragePageHolder holder = (StoragePageHolder)inventory.getHolder();
        if (holder != null) {
            this.spawnerGuiViewManager.updateSpawnerMenuViewers(spawner);
            if (spawner.getMaxSpawnerLootSlots() > holder.getOldUsedSlots() && spawner.getIsAtCapacity().booleanValue()) {
                spawner.setIsAtCapacity(false);
            }
        }
    }

    private void handleControlSlotClick(Player player, int slot, StoragePageHolder holder, SpawnerData spawner, Inventory inventory) {
        switch (slot) {
            case 45: {
                this.handleDiscardAllItems(player, spawner, inventory);
                break;
            }
            case 46: {
                this.openFilterConfig(player, spawner);
                break;
            }
            case 48: {
                if (holder.getCurrentPage() <= 1) break;
                this.updatePageContent(player, spawner, holder.getCurrentPage() - 1, inventory, false);
                break;
            }
            case 49: {
                this.handleTakeAllItems(player, inventory);
                break;
            }
            case 50: {
                if (holder.getCurrentPage() >= holder.getTotalPages()) break;
                this.updatePageContent(player, spawner, holder.getCurrentPage() + 1, inventory, false);
                break;
            }
            case 52: {
                if (!this.plugin.hasShopIntegration()) break;
                this.handleSellAllItems(player, spawner, holder);
                break;
            }
            case 53: {
                this.openMainMenu(player, spawner);
            }
        }
    }

    private void openFilterConfig(Player player, SpawnerData spawner) {
        if (this.isClickTooFrequent(player)) {
            return;
        }
        this.filterConfigUI.openFilterConfigGUI(player, spawner);
    }

    private void takeSingleItem(Player player, Inventory sourceInv, int slot, ItemStack item, SpawnerData spawner, boolean singleItem) {
        VirtualInventory virtualInv;
        PlayerInventory playerInv;
        ItemMoveResult result = ItemMoveHelper.moveItems(item, singleItem ? 1 : item.getAmount(), playerInv = player.getInventory(), virtualInv = spawner.getVirtualInventory());
        if (result.getAmountMoved() > 0) {
            SpawnerStorageAction.updateInventorySlot(sourceInv, slot, item, result.getAmountMoved());
            virtualInv.removeItems(result.getMovedItems());
            player.updateInventory();
            spawner.updateHologramData();
            StoragePageHolder holder = (StoragePageHolder)sourceInv.getHolder();
            if (holder != null) {
                this.spawnerGuiViewManager.updateSpawnerMenuViewers(spawner);
                if (spawner.getMaxSpawnerLootSlots() > holder.getOldUsedSlots() && spawner.getIsAtCapacity().booleanValue()) {
                    spawner.setIsAtCapacity(false);
                }
            }
        } else {
            this.messageService.sendMessage(player, "inventory_full");
        }
    }

    private static void updateInventorySlot(Inventory sourceInv, int slot, ItemStack item, int amountMoved) {
        if (amountMoved >= item.getAmount()) {
            sourceInv.setItem(slot, null);
            return;
        }
        ItemStack remaining = item.clone();
        remaining.setAmount(item.getAmount() - amountMoved);
        sourceInv.setItem(slot, remaining);
    }

    private void updatePageContent(Player player, SpawnerData spawner, int newPage, Inventory inventory, boolean refresh) {
        SpawnerStorageUI lootManager = this.plugin.getSpawnerStorageUI();
        StoragePageHolder holder = (StoragePageHolder)inventory.getHolder();
        int totalPages = this.calculateTotalPages(spawner);
        assert (holder != null);
        holder.setTotalPages(totalPages);
        holder.setCurrentPage(newPage);
        holder.updateOldUsedSlots();
        lootManager.updateDisplay(inventory, spawner, newPage, totalPages);
        this.updateInventoryTitle(player, inventory, spawner, newPage, totalPages);
        Sound sound = refresh ? Sound.ITEM_ARMOR_EQUIP_DIAMOND : Sound.UI_BUTTON_CLICK;
        float pitch = refresh ? 1.2f : 1.0f;
        player.playSound(player.getLocation(), sound, 1.0f, pitch);
    }

    private int calculateTotalPages(SpawnerData spawner) {
        int usedSlots = spawner.getVirtualInventory().getUsedSlots();
        return Math.max(1, (int)Math.ceil((double)usedSlots / 45.0));
    }

    private void updateInventoryTitle(Player player, Inventory inventory, SpawnerData spawner, int page, int totalPages) {
        String baseTitle = this.languageManager.getGuiTitle("gui_title_storage");
        String newTitle = baseTitle + " - [" + page + "/" + totalPages + "]";
        try {
            player.getOpenInventory().setTitle(newTitle);
        }
        catch (Exception e) {
            this.openLootPage(player, spawner, page, false);
        }
    }

    private void handleSellAllItems(Player player, SpawnerData spawner, StoragePageHolder holder) {
        if (!this.plugin.hasShopIntegration()) {
            return;
        }
        if (this.isClickTooFrequent(player)) {
            return;
        }
        player.playSound(player.getLocation(), Sound.UI_BUTTON_CLICK, 1.0f, 1.0f);
        if (!player.hasPermission("smartspawner.sellall")) {
            this.messageService.sendMessage(player, "no_permission");
            return;
        }
        if (this.spawnerMenuAction.isSellCooldownActive(player)) {
            HashMap<String, String> placeholders = new HashMap<String, String>();
            placeholders.put("time", this.spawnerMenuAction.getRemainingCooldownTimeFormatted(player));
            this.messageService.sendMessage(player, "shop.sell_cooldown", placeholders);
            return;
        }
        this.spawnerMenuAction.updateSellCooldown(player);
        boolean success = this.plugin.getShopIntegration().sellAllItems(player, spawner);
        if (success && spawner.getIsAtCapacity().booleanValue()) {
            spawner.setIsAtCapacity(false);
        }
    }

    private boolean isClickTooFrequent(Player player) {
        long now = System.currentTimeMillis();
        long last = this.lastItemClickTime.getOrDefault(player.getUniqueId(), 0L);
        this.lastItemClickTime.put(player.getUniqueId(), now);
        return now - last < 300L;
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        UUID playerId = event.getPlayer().getUniqueId();
        this.lastItemClickTime.remove(playerId);
    }

    private void openMainMenu(Player player, SpawnerData spawner) {
        player.playSound(player.getLocation(), Sound.UI_BUTTON_CLICK, 1.0f, 1.0f);
        this.spawnerMenuUI.openSpawnerMenu(player, spawner, true);
    }

    private void handleDiscardAllItems(Player player, SpawnerData spawner, Inventory inventory) {
        if (this.isClickTooFrequent(player)) {
            return;
        }
        VirtualInventory virtualInv = spawner.getVirtualInventory();
        if (virtualInv.getUsedSlots() == 0) {
            this.messageService.sendMessage(player, "no_items_to_discard");
            return;
        }
        long totalItems = virtualInv.getTotalItems();
        Map<VirtualInventory.ItemSignature, Long> items = virtualInv.getConsolidatedItems();
        ArrayList<ItemStack> itemsToRemove = new ArrayList<ItemStack>();
        for (Map.Entry<VirtualInventory.ItemSignature, Long> entry : items.entrySet()) {
            int stackSize;
            ItemStack template = entry.getKey().getTemplate();
            for (long amount = entry.getValue().longValue(); amount > 0L; amount -= (long)stackSize) {
                ItemStack stack = template.clone();
                stackSize = (int)Math.min(amount, (long)template.getMaxStackSize());
                stack.setAmount(stackSize);
                itemsToRemove.add(stack);
            }
        }
        virtualInv.removeItems(itemsToRemove);
        StoragePageHolder holder = (StoragePageHolder)inventory.getHolder();
        int oldTotalPages = this.calculateTotalPages(spawner);
        spawner.updateHologramData();
        if (spawner.getIsAtCapacity().booleanValue()) {
            spawner.setIsAtCapacity(false);
        }
        int newTotalPages = this.calculateTotalPages(spawner);
        holder.setTotalPages(newTotalPages);
        holder.setCurrentPage(1);
        holder.updateOldUsedSlots();
        this.spawnerGuiViewManager.updateSpawnerMenuViewers(spawner);
        this.updatePageContent(player, spawner, 1, inventory, true);
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("amount", this.languageManager.formatNumber(totalItems));
        this.messageService.sendMessage(player, "discard_all_success", placeholders);
    }

    private void openLootPage(Player player, SpawnerData spawner, int page, boolean refresh) {
        SpawnerStorageUI lootManager = this.plugin.getSpawnerStorageUI();
        String title = this.languageManager.getGuiTitle("gui_title_storage");
        int totalPages = this.calculateTotalPages(spawner);
        page = Math.max(1, Math.min(page, totalPages));
        UUID playerId = player.getUniqueId();
        Inventory existingInventory = this.openStorageInventories.get(playerId);
        if (existingInventory != null && !refresh && existingInventory.getHolder() instanceof StoragePageHolder) {
            StoragePageHolder holder = (StoragePageHolder)existingInventory.getHolder();
            holder.setTotalPages(totalPages);
            holder.setCurrentPage(page);
            holder.updateOldUsedSlots();
            this.updatePageContent(player, spawner, page, existingInventory, false);
            return;
        }
        Inventory pageInventory = lootManager.createInventory(spawner, title, page, totalPages);
        this.openStorageInventories.put(playerId, pageInventory);
        Sound sound = refresh ? Sound.ITEM_ARMOR_EQUIP_DIAMOND : Sound.UI_BUTTON_CLICK;
        float pitch = refresh ? 1.2f : 1.0f;
        player.playSound(player.getLocation(), sound, 1.0f, pitch);
        player.openInventory(pageInventory);
    }

    public void handleTakeAllItems(Player player, Inventory sourceInventory) {
        if (this.isClickTooFrequent(player)) {
            return;
        }
        StoragePageHolder holder = (StoragePageHolder)sourceInventory.getHolder();
        SpawnerData spawner = holder.getSpawnerData();
        VirtualInventory virtualInv = spawner.getVirtualInventory();
        HashMap<Integer, ItemStack> sourceItems = new HashMap<Integer, ItemStack>();
        for (int i = 0; i < 45; ++i) {
            ItemStack item = sourceInventory.getItem(i);
            if (item == null || item.getType() == Material.AIR) continue;
            sourceItems.put(i, item.clone());
        }
        if (sourceItems.isEmpty()) {
            this.messageService.sendMessage(player, "no_items_to_take");
            return;
        }
        TransferResult result = this.transferItems(player, sourceInventory, sourceItems, virtualInv);
        this.sendTransferMessage(player, result);
        player.updateInventory();
        if (result.anyItemMoved) {
            int newTotalPages = this.calculateTotalPages(spawner);
            holder.setTotalPages(newTotalPages);
            this.spawnerGuiViewManager.updateSpawnerMenuViewers(spawner);
            if (spawner.getMaxSpawnerLootSlots() > holder.getOldUsedSlots() && spawner.getIsAtCapacity().booleanValue()) {
                spawner.setIsAtCapacity(false);
            }
        }
    }

    private TransferResult transferItems(Player player, Inventory sourceInventory, Map<Integer, ItemStack> sourceItems, VirtualInventory virtualInv) {
        boolean anyItemMoved = false;
        boolean inventoryFull = false;
        PlayerInventory playerInv = player.getInventory();
        int totalAmountMoved = 0;
        ArrayList<ItemStack> itemsToRemove = new ArrayList<ItemStack>();
        for (Map.Entry<Integer, ItemStack> entry : sourceItems.entrySet()) {
            int sourceSlot = entry.getKey();
            ItemStack itemToMove = entry.getValue();
            int amountToMove = itemToMove.getAmount();
            int amountMoved = 0;
            for (int i = 0; i < 36 && amountToMove > 0; ++i) {
                int spaceInStack;
                ItemStack targetItem = playerInv.getItem(i);
                if (targetItem == null || targetItem.getType() == Material.AIR) {
                    ItemStack newStack = itemToMove.clone();
                    newStack.setAmount(Math.min(amountToMove, itemToMove.getMaxStackSize()));
                    playerInv.setItem(i, newStack);
                    amountMoved += newStack.getAmount();
                    amountToMove -= newStack.getAmount();
                    anyItemMoved = true;
                    continue;
                }
                if (!targetItem.isSimilar(itemToMove) || (spaceInStack = targetItem.getMaxStackSize() - targetItem.getAmount()) <= 0) continue;
                int addAmount = Math.min(spaceInStack, amountToMove);
                targetItem.setAmount(targetItem.getAmount() + addAmount);
                amountMoved += addAmount;
                amountToMove -= addAmount;
                anyItemMoved = true;
            }
            if (amountMoved > 0) {
                totalAmountMoved += amountMoved;
                ItemStack movedItem = itemToMove.clone();
                movedItem.setAmount(amountMoved);
                itemsToRemove.add(movedItem);
                if (amountMoved == itemToMove.getAmount()) {
                    sourceInventory.setItem(sourceSlot, null);
                } else {
                    ItemStack remaining = itemToMove.clone();
                    remaining.setAmount(itemToMove.getAmount() - amountMoved);
                    sourceInventory.setItem(sourceSlot, remaining);
                    inventoryFull = true;
                }
            }
            if (!inventoryFull) continue;
            break;
        }
        if (!itemsToRemove.isEmpty()) {
            virtualInv.removeItems(itemsToRemove);
            StoragePageHolder holder = (StoragePageHolder)sourceInventory.getHolder();
            holder.getSpawnerData().updateHologramData();
            holder.updateOldUsedSlots();
        }
        return new TransferResult(anyItemMoved, inventoryFull, totalAmountMoved);
    }

    private void sendTransferMessage(Player player, TransferResult result) {
        if (!result.anyItemMoved) {
            this.messageService.sendMessage(player, "inventory_full");
        } else {
            HashMap<String, String> placeholders = new HashMap<String, String>();
            placeholders.put("amount", String.valueOf(result.totalMoved));
            this.messageService.sendMessage(player, "take_all_items", placeholders);
        }
    }

    @EventHandler
    public void onInventoryClose(InventoryCloseEvent event) {
        if (!(event.getInventory().getHolder() instanceof StoragePageHolder)) {
            return;
        }
        HumanEntity humanEntity = event.getPlayer();
        if (humanEntity instanceof Player) {
            Player player = (Player)humanEntity;
            UUID playerId = player.getUniqueId();
            this.openStorageInventories.remove(playerId);
        }
    }

    private record TransferResult(boolean anyItemMoved, boolean inventoryFull, int totalMoved) {
    }
}

