/*
 * Decompiled with CFR 0.152.
 */
package github.nighter.smartspawner.spawner.gui.storage;

import github.nighter.smartspawner.Scheduler;
import github.nighter.smartspawner.SmartSpawner;
import github.nighter.smartspawner.holders.StoragePageHolder;
import github.nighter.smartspawner.language.LanguageManager;
import github.nighter.smartspawner.spawner.properties.SpawnerData;
import github.nighter.smartspawner.spawner.properties.VirtualInventory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class SpawnerStorageUI {
    private static final int NAVIGATION_ROW = 5;
    private static final int INVENTORY_SIZE = 54;
    private final SmartSpawner plugin;
    private final LanguageManager languageManager;
    private final Map<String, ItemStack> staticButtons;
    private final Map<String, ItemStack> navigationButtonCache;
    private final Map<String, ItemStack> pageIndicatorCache;
    private static final int MAX_CACHE_SIZE = 100;
    private Scheduler.Task cleanupTask;

    public SpawnerStorageUI(SmartSpawner plugin) {
        this.plugin = plugin;
        this.languageManager = plugin.getLanguageManager();
        this.staticButtons = new HashMap<String, ItemStack>(4);
        this.navigationButtonCache = new ConcurrentHashMap<String, ItemStack>(16);
        this.pageIndicatorCache = new ConcurrentHashMap<String, ItemStack>(16);
        this.initializeStaticButtons();
        this.startCleanupTask();
    }

    private void initializeStaticButtons() {
        this.staticButtons.put("return", this.createButton(Material.RED_STAINED_GLASS_PANE, this.languageManager.getGuiItemName("return_button.name"), this.languageManager.getGuiItemLoreAsList("return_button.lore")));
        this.staticButtons.put("takeAll", this.createButton(Material.CHEST, this.languageManager.getGuiItemName("take_all_button.name"), this.languageManager.getGuiItemLoreAsList("take_all_button.lore")));
        this.staticButtons.put("discardAll", this.createButton(Material.CAULDRON, this.languageManager.getGuiItemName("discard_all_button.name"), this.languageManager.getGuiItemLoreAsList("discard_all_button.lore")));
        this.staticButtons.put("itemFilter", this.createButton(Material.HOPPER, this.languageManager.getGuiItemName("item_filter_button.name"), this.languageManager.getGuiItemLoreAsList("item_filter_button.lore")));
    }

    public Inventory createInventory(SpawnerData spawner, String title, int page, int totalPages) {
        if (totalPages == -1) {
            totalPages = this.calculateTotalPages(spawner);
        }
        page = Math.max(1, Math.min(page, totalPages));
        Inventory pageInv = Bukkit.createInventory((InventoryHolder)new StoragePageHolder(spawner, page, totalPages), (int)54, (String)(title + " - [" + page + "/" + totalPages + "]"));
        StoragePageHolder holder = (StoragePageHolder)pageInv.getHolder();
        holder.setInventory(pageInv);
        holder.updateOldUsedSlots();
        this.updateDisplay(pageInv, spawner, page, totalPages);
        return pageInv;
    }

    public void updateDisplay(Inventory inventory, SpawnerData spawner, int page, int totalPages) {
        int currentUsedSlots;
        if (totalPages == -1) {
            totalPages = this.calculateTotalPages(spawner);
        }
        HashMap<Integer, ItemStack> updates = new HashMap<Integer, ItemStack>();
        HashSet<Integer> slotsToEmpty = new HashSet<Integer>();
        for (int i = 0; i < 45; ++i) {
            slotsToEmpty.add(i);
        }
        this.addPageItems(updates, slotsToEmpty, spawner, page);
        this.addNavigationButtons(updates, spawner, page, totalPages);
        Iterator<Object> i = slotsToEmpty.iterator();
        while (i.hasNext()) {
            int n = (Integer)i.next();
            if (updates.containsKey(n)) continue;
            inventory.setItem(n, null);
        }
        for (Map.Entry entry : updates.entrySet()) {
            inventory.setItem(((Integer)entry.getKey()).intValue(), (ItemStack)entry.getValue());
        }
        if (this.plugin.getConfig().getBoolean("hologram.enabled", false)) {
            Scheduler.runLocationTask(spawner.getSpawnerLocation(), spawner::updateHologramData);
        }
        StoragePageHolder holder = (StoragePageHolder)inventory.getHolder();
        assert (holder != null);
        int n = holder.getOldUsedSlots();
        if (n != (currentUsedSlots = spawner.getVirtualInventory().getUsedSlots())) {
            int newTotalPages = this.calculateTotalPages(spawner);
            holder.setTotalPages(newTotalPages);
            holder.updateOldUsedSlots();
        }
    }

    private void addPageItems(Map<Integer, ItemStack> updates, Set<Integer> slotsToEmpty, SpawnerData spawner, int page) {
        VirtualInventory virtualInv = spawner.getVirtualInventory();
        Map<Integer, ItemStack> displayItems = virtualInv.getDisplayInventory();
        if (displayItems.isEmpty()) {
            return;
        }
        int startIndex = (page - 1) * 45;
        for (Map.Entry<Integer, ItemStack> entry : displayItems.entrySet()) {
            int globalIndex = entry.getKey();
            if (globalIndex < startIndex || globalIndex >= startIndex + 45) continue;
            int displaySlot = globalIndex - startIndex;
            updates.put(displaySlot, entry.getValue());
            slotsToEmpty.remove(displaySlot);
        }
    }

    private void addNavigationButtons(Map<Integer, ItemStack> updates, SpawnerData spawner, int page, int totalPages) {
        String cacheKey;
        if (totalPages == -1) {
            totalPages = this.calculateTotalPages(spawner);
        }
        int navRowBase = 45;
        if (page > 1) {
            cacheKey = "prev-" + (page - 1);
            ItemStack prevButton = this.navigationButtonCache.computeIfAbsent(cacheKey, k -> this.createNavigationButton("previous", page - 1));
            updates.put(navRowBase + 3, prevButton);
        }
        if (page < totalPages) {
            cacheKey = "next-" + (page + 1);
            ItemStack nextButton = this.navigationButtonCache.computeIfAbsent(cacheKey, k -> this.createNavigationButton("next", page + 1));
            updates.put(navRowBase + 5, nextButton);
        }
        updates.put(navRowBase + 4, this.staticButtons.get("takeAll"));
        updates.put(navRowBase, this.staticButtons.get("discardAll"));
        updates.put(navRowBase + 1, this.staticButtons.get("itemFilter"));
        updates.put(navRowBase + 8, this.staticButtons.get("return"));
        if (this.plugin.hasShopIntegration()) {
            String indicatorKey = this.getPageIndicatorKey(page, totalPages, spawner);
            int finalTotalPages = totalPages;
            ItemStack shopIndicator = this.pageIndicatorCache.computeIfAbsent(indicatorKey, k -> this.createShopPageIndicator(page, finalTotalPages, spawner));
            updates.put(navRowBase + 7, shopIndicator);
        }
    }

    private String getPageIndicatorKey(int page, int totalPages, SpawnerData spawner) {
        VirtualInventory virtualInv = spawner.getVirtualInventory();
        int usedSlots = virtualInv.getUsedSlots();
        int maxSlots = spawner.getMaxSpawnerLootSlots();
        return page + "-" + totalPages + "-" + usedSlots + "-" + maxSlots;
    }

    private int calculateTotalPages(SpawnerData spawner) {
        int usedSlots = spawner.getVirtualInventory().getUsedSlots();
        return Math.max(1, (int)Math.ceil((double)usedSlots / 45.0));
    }

    private ItemStack createButton(Material material, String name, List<String> lore) {
        ItemStack item = new ItemStack(material);
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            meta.setDisplayName(name);
            if (!lore.isEmpty()) {
                meta.setLore(lore);
            }
            item.setItemMeta(meta);
        }
        return item;
    }

    private ItemStack createNavigationButton(String type, int targetPage) {
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("target_page", String.valueOf(targetPage));
        String buttonKey = type.equals("previous") ? "navigation_button_previous" : "navigation_button_next";
        String buttonName = this.languageManager.getGuiItemName(buttonKey + ".name", placeholders);
        String[] buttonLore = this.languageManager.getGuiItemLore(buttonKey + ".lore", placeholders);
        return this.createButton(Material.SPECTRAL_ARROW, buttonName, Arrays.asList(buttonLore));
    }

    private ItemStack createShopPageIndicator(int currentPage, int totalPages, SpawnerData spawner) {
        VirtualInventory virtualInv = spawner.getVirtualInventory();
        int maxSlots = spawner.getMaxSpawnerLootSlots();
        int usedSlots = virtualInv.getUsedSlots();
        int percentStorage = maxSlots > 0 ? (int)((double)usedSlots / (double)maxSlots * 100.0) : 0;
        String formattedMaxSlots = this.languageManager.formatNumber(maxSlots);
        String formattedUsedSlots = this.languageManager.formatNumber(usedSlots);
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("current_page", String.valueOf(currentPage));
        placeholders.put("total_pages", String.valueOf(totalPages));
        placeholders.put("max_slots", formattedMaxSlots);
        placeholders.put("used_slots", formattedUsedSlots);
        placeholders.put("percent_storage", String.valueOf(percentStorage));
        String name = this.languageManager.getGuiItemName("shop_page_indicator.name", placeholders);
        List<String> lore = this.languageManager.getGuiItemLoreAsList("shop_page_indicator.lore", placeholders);
        return this.createButton(Material.GOLD_INGOT, name, lore);
    }

    private void startCleanupTask() {
        this.cleanupTask = Scheduler.runTaskTimer(this::cleanupCaches, 600L, 600L);
    }

    public void cancelTasks() {
        if (this.cleanupTask != null) {
            this.cleanupTask.cancel();
            this.cleanupTask = null;
        }
    }

    private void cleanupCaches() {
        int i;
        ArrayList<String> keysToRemove;
        int toRemove;
        if (this.navigationButtonCache.size() > 100) {
            toRemove = this.navigationButtonCache.size() - 50;
            keysToRemove = new ArrayList<String>(this.navigationButtonCache.keySet());
            for (i = 0; i < Math.min(toRemove, keysToRemove.size()); ++i) {
                this.navigationButtonCache.remove(keysToRemove.get(i));
            }
        }
        if (this.pageIndicatorCache.size() > 100) {
            toRemove = this.pageIndicatorCache.size() - 50;
            keysToRemove = new ArrayList<String>(this.pageIndicatorCache.keySet());
            for (i = 0; i < Math.min(toRemove, keysToRemove.size()); ++i) {
                this.pageIndicatorCache.remove(keysToRemove.get(i));
            }
        }
    }

    public void cleanup() {
        this.navigationButtonCache.clear();
        this.pageIndicatorCache.clear();
        this.cancelTasks();
        this.initializeStaticButtons();
    }
}

