/*
 * Decompiled with CFR 0.152.
 */
package github.nighter.smartspawner.spawner.gui.storage.utils;

import github.nighter.smartspawner.spawner.gui.storage.utils.BatchItemMoveResult;
import github.nighter.smartspawner.spawner.gui.storage.utils.ItemMoveResult;
import github.nighter.smartspawner.spawner.gui.storage.utils.ItemUpdate;
import github.nighter.smartspawner.spawner.properties.VirtualInventory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;

public class ItemMoveHelper {
    public static ItemMoveResult moveItems(ItemStack source, int amountToMove, PlayerInventory targetInv, VirtualInventory virtualInv) {
        ArrayList<ItemStack> movedItems = new ArrayList<ItemStack>();
        int amountMoved = 0;
        for (int i = 0; i < 36 && amountToMove > 0; ++i) {
            int spaceInStack;
            ItemStack current = targetInv.getItem(i);
            if (current == null || current.getType().isAir()) {
                ItemStack newStack = source.clone();
                newStack.setAmount(Math.min(amountToMove, source.getMaxStackSize()));
                targetInv.setItem(i, newStack);
                movedItems.add(newStack.clone());
                amountMoved += newStack.getAmount();
                amountToMove -= newStack.getAmount();
                break;
            }
            if (!current.isSimilar(source) || (spaceInStack = current.getMaxStackSize() - current.getAmount()) <= 0) continue;
            int addAmount = Math.min(spaceInStack, amountToMove);
            current.setAmount(current.getAmount() + addAmount);
            ItemStack moved = source.clone();
            moved.setAmount(addAmount);
            movedItems.add(moved);
            amountMoved += addAmount;
            if ((amountToMove -= addAmount) <= 0) break;
        }
        return new ItemMoveResult(amountMoved, movedItems);
    }

    public static BatchItemMoveResult moveBatchItems(Map<Integer, ItemStack> items, PlayerInventory targetInv, VirtualInventory virtualInv) {
        HashMap<Integer, ItemUpdate> slotUpdates = new HashMap<Integer, ItemUpdate>();
        ArrayList<ItemStack> movedItems = new ArrayList<ItemStack>();
        int totalMoved = 0;
        boolean inventoryFull = false;
        for (Map.Entry<Integer, ItemStack> entry : items.entrySet()) {
            ItemStack itemToMove = entry.getValue();
            int sourceSlot = entry.getKey();
            int amountToMove = itemToMove.getAmount();
            int amountMoved = 0;
            for (int i = 0; i < 36 && amountToMove > 0; ++i) {
                int spaceInStack;
                ItemStack targetItem = targetInv.getItem(i);
                if (targetItem == null || targetItem.getType().isAir()) {
                    ItemStack newStack = itemToMove.clone();
                    newStack.setAmount(Math.min(amountToMove, itemToMove.getMaxStackSize()));
                    targetInv.setItem(i, newStack);
                    amountToMove -= newStack.getAmount();
                    ItemStack moved = itemToMove.clone();
                    moved.setAmount(amountMoved += newStack.getAmount());
                    movedItems.add(moved);
                    continue;
                }
                if (!targetItem.isSimilar(itemToMove) || (spaceInStack = targetItem.getMaxStackSize() - targetItem.getAmount()) <= 0) continue;
                int addAmount = Math.min(spaceInStack, amountToMove);
                targetItem.setAmount(targetItem.getAmount() + addAmount);
                amountMoved += addAmount;
                amountToMove -= addAmount;
                ItemStack moved = itemToMove.clone();
                moved.setAmount(addAmount);
                movedItems.add(moved);
            }
            if (amountMoved > 0) {
                totalMoved += amountMoved;
                slotUpdates.put(sourceSlot, new ItemUpdate(itemToMove, amountMoved));
            }
            if (amountToMove <= 0) continue;
            inventoryFull = true;
            break;
        }
        return new BatchItemMoveResult(totalMoved, slotUpdates, movedItems, inventoryFull);
    }
}

