/*
 * Decompiled with CFR 0.152.
 */
package github.nighter.smartspawner.spawner.gui.synchronization;

import github.nighter.smartspawner.Scheduler;
import github.nighter.smartspawner.SmartSpawner;
import github.nighter.smartspawner.holders.SpawnerMenuHolder;
import github.nighter.smartspawner.holders.StoragePageHolder;
import github.nighter.smartspawner.language.LanguageManager;
import github.nighter.smartspawner.spawner.gui.main.SpawnerMenuUI;
import github.nighter.smartspawner.spawner.gui.storage.SpawnerStorageUI;
import github.nighter.smartspawner.spawner.gui.synchronization.ItemUpdater;
import github.nighter.smartspawner.spawner.properties.SpawnerData;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class SpawnerGuiViewManager
implements Listener {
    private static final long UPDATE_INTERVAL_TICKS = 10L;
    private static final long INITIAL_DELAY_TICKS = 10L;
    private static final int ITEMS_PER_PAGE = 45;
    private static final int CHEST_SLOT = 11;
    private static final int SPAWNER_INFO_SLOT = 13;
    private static final int EXP_SLOT = 15;
    private static final int UPDATE_CHEST = 1;
    private static final int UPDATE_INFO = 2;
    private static final int UPDATE_EXP = 4;
    private static final int UPDATE_ALL = 7;
    private final SmartSpawner plugin;
    private final LanguageManager languageManager;
    private final SpawnerStorageUI spawnerStorageUI;
    private final SpawnerMenuUI spawnerMenuUI;
    private final Map<UUID, SpawnerViewerInfo> playerToSpawnerMap;
    private final Map<String, Set<UUID>> spawnerToPlayersMap;
    private final Set<Class<? extends InventoryHolder>> validHolderTypes;
    private final Set<UUID> pendingUpdates = ConcurrentHashMap.newKeySet();
    private final Map<UUID, Integer> updateFlags = new ConcurrentHashMap<UUID, Integer>();
    private Scheduler.Task updateTask;
    private volatile boolean isTaskRunning;
    private String cachedTimerPrefix;
    private String cachedInactiveText;
    private String cachedFullText;

    public SpawnerGuiViewManager(SmartSpawner plugin) {
        this.plugin = plugin;
        this.languageManager = plugin.getLanguageManager();
        this.spawnerStorageUI = plugin.getSpawnerStorageUI();
        this.spawnerMenuUI = plugin.getSpawnerMenuUI();
        this.playerToSpawnerMap = new ConcurrentHashMap<UUID, SpawnerViewerInfo>();
        this.spawnerToPlayersMap = new ConcurrentHashMap<String, Set<UUID>>();
        this.isTaskRunning = false;
        this.validHolderTypes = Set.of(SpawnerMenuHolder.class, StoragePageHolder.class);
        this.initCachedStrings();
    }

    private void initCachedStrings() {
        this.cachedTimerPrefix = this.languageManager.getGuiItemName("spawner_info_item.lore_change");
        this.cachedInactiveText = this.languageManager.getGuiItemName("spawner_info_item.lore_inactive");
        this.cachedFullText = this.languageManager.getGuiItemName("spawner_info_item.lore_full");
    }

    private synchronized void startUpdateTask() {
        if (this.isTaskRunning) {
            return;
        }
        this.updateTask = Scheduler.runTaskTimer(this::updateGuiForSpawnerInfo, 10L, 10L);
        this.isTaskRunning = true;
    }

    public synchronized void stopUpdateTask() {
        if (!this.isTaskRunning) {
            return;
        }
        if (this.updateTask != null) {
            this.updateTask.cancel();
            this.updateTask = null;
        }
        this.isTaskRunning = false;
    }

    private boolean isValidGuiSession(Player player) {
        return player != null && player.isOnline();
    }

    private boolean isValidHolder(InventoryHolder holder) {
        return holder != null && this.validHolderTypes.contains(holder.getClass());
    }

    public void trackViewer(UUID playerId, SpawnerData spawner) {
        this.playerToSpawnerMap.put(playerId, new SpawnerViewerInfo(spawner));
        this.spawnerToPlayersMap.computeIfAbsent(spawner.getSpawnerId(), k -> ConcurrentHashMap.newKeySet()).add(playerId);
        if (!this.isTaskRunning) {
            this.startUpdateTask();
        }
    }

    public void untrackViewer(UUID playerId) {
        SpawnerData spawner;
        Set<UUID> viewers;
        SpawnerViewerInfo info = this.playerToSpawnerMap.remove(playerId);
        if (info != null && (viewers = this.spawnerToPlayersMap.get((spawner = info.spawnerData).getSpawnerId())) != null) {
            viewers.remove(playerId);
            if (viewers.isEmpty()) {
                this.spawnerToPlayersMap.remove(spawner.getSpawnerId());
            }
        }
        this.pendingUpdates.remove(playerId);
        this.updateFlags.remove(playerId);
        if (this.playerToSpawnerMap.isEmpty()) {
            this.stopUpdateTask();
        }
    }

    public Set<Player> getViewers(String spawnerId) {
        Set<UUID> viewerIds = this.spawnerToPlayersMap.get(spawnerId);
        if (viewerIds == null || viewerIds.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<Player> onlineViewers = new HashSet<Player>(viewerIds.size());
        for (UUID id : viewerIds) {
            Player player = Bukkit.getPlayer((UUID)id);
            if (player == null || !player.isOnline()) continue;
            onlineViewers.add(player);
        }
        return onlineViewers;
    }

    public boolean hasViewers(SpawnerData spawner) {
        Set<UUID> viewers = this.spawnerToPlayersMap.get(spawner.getSpawnerId());
        return viewers != null && !viewers.isEmpty();
    }

    public void clearAllTrackedGuis() {
        this.playerToSpawnerMap.clear();
        this.spawnerToPlayersMap.clear();
        this.pendingUpdates.clear();
        this.updateFlags.clear();
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onInventoryOpen(InventoryOpenEvent event) {
        HumanEntity humanEntity = event.getPlayer();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player player = (Player)humanEntity;
        InventoryHolder holder = event.getInventory().getHolder();
        if (!this.isValidHolder(holder)) {
            return;
        }
        UUID playerId = player.getUniqueId();
        SpawnerData spawnerData = null;
        if (holder instanceof SpawnerMenuHolder) {
            SpawnerMenuHolder spawnerHolder = (SpawnerMenuHolder)holder;
            spawnerData = spawnerHolder.getSpawnerData();
        } else if (holder instanceof StoragePageHolder) {
            StoragePageHolder storageHolder = (StoragePageHolder)holder;
            spawnerData = storageHolder.getSpawnerData();
        }
        if (spawnerData != null) {
            this.trackViewer(playerId, spawnerData);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onInventoryClose(InventoryCloseEvent event) {
        HumanEntity humanEntity = event.getPlayer();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player player = (Player)humanEntity;
        this.untrackViewer(player.getUniqueId());
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerQuit(PlayerQuitEvent event) {
        this.untrackViewer(event.getPlayer().getUniqueId());
    }

    private void updateGuiForSpawnerInfo() {
        if (this.playerToSpawnerMap.isEmpty()) {
            this.stopUpdateTask();
            return;
        }
        this.processPendingUpdates();
        for (Map.Entry<UUID, SpawnerViewerInfo> entry : this.playerToSpawnerMap.entrySet()) {
            UUID playerId = entry.getKey();
            SpawnerViewerInfo viewerInfo = entry.getValue();
            SpawnerData spawner = viewerInfo.spawnerData;
            Player player = Bukkit.getPlayer((UUID)playerId);
            if (!this.isValidGuiSession(player)) {
                this.untrackViewer(playerId);
                continue;
            }
            Location playerLocation = player.getLocation();
            if (playerLocation == null) continue;
            Scheduler.runLocationTask(playerLocation, () -> {
                if (!player.isOnline()) {
                    return;
                }
                Inventory openInventory = player.getOpenInventory().getTopInventory();
                if (openInventory == null) {
                    return;
                }
                InventoryHolder holder = openInventory.getHolder();
                if (holder instanceof SpawnerMenuHolder) {
                    if (!spawner.getIsAtCapacity().booleanValue()) {
                        this.updateSpawnerInfoItemTimer(openInventory, spawner);
                    }
                } else if (!(holder instanceof StoragePageHolder)) {
                    this.untrackViewer(playerId);
                }
            });
        }
    }

    private void processPendingUpdates() {
        if (this.pendingUpdates.isEmpty()) {
            return;
        }
        HashSet<UUID> currentUpdates = new HashSet<UUID>(this.pendingUpdates);
        this.pendingUpdates.clear();
        for (UUID playerId : currentUpdates) {
            Player player = Bukkit.getPlayer((UUID)playerId);
            if (!this.isValidGuiSession(player)) {
                this.untrackViewer(playerId);
                this.updateFlags.remove(playerId);
                continue;
            }
            SpawnerViewerInfo info = this.playerToSpawnerMap.get(playerId);
            if (info == null) {
                this.updateFlags.remove(playerId);
                continue;
            }
            int flags = this.updateFlags.getOrDefault(playerId, 7);
            this.updateFlags.remove(playerId);
            Location loc = player.getLocation();
            if (loc == null) continue;
            int finalFlags = flags;
            SpawnerData spawner = info.spawnerData;
            Scheduler.runLocationTask(loc, () -> {
                if (!player.isOnline()) {
                    return;
                }
                Inventory openInv = player.getOpenInventory().getTopInventory();
                if (openInv == null || !(openInv.getHolder() instanceof SpawnerMenuHolder)) {
                    return;
                }
                this.processInventoryUpdate(player, openInv, spawner, finalFlags);
            });
        }
    }

    private void processInventoryUpdate(Player player, Inventory inventory, SpawnerData spawner, int flags) {
        boolean needsUpdate = false;
        if ((flags & 1) != 0) {
            this.updateChestItem(inventory, spawner);
            needsUpdate = true;
        }
        if ((flags & 2) != 0) {
            this.updateSpawnerInfoItem(inventory, spawner, player);
            needsUpdate = true;
        }
        if ((flags & 4) != 0) {
            this.updateExpItem(inventory, spawner);
            needsUpdate = true;
        }
        if (needsUpdate) {
            player.updateInventory();
        }
    }

    public void updateSpawnerMenuViewers(SpawnerData spawner) {
        Player viewer;
        Set<UUID> viewers = this.spawnerToPlayersMap.get(spawner.getSpawnerId());
        if (viewers == null || viewers.isEmpty()) {
            return;
        }
        int viewerCount = viewers.size();
        if (viewerCount > 10) {
            this.plugin.debug(viewerCount + " spawner menu viewers to update for " + spawner.getSpawnerId() + " (batch update)");
        }
        int oldTotalPages = -1;
        int newTotalPages = -1;
        for (UUID viewerId : viewers) {
            Inventory openInv;
            viewer = Bukkit.getPlayer((UUID)viewerId);
            if (!this.isValidGuiSession(viewer)) {
                this.untrackViewer(viewerId);
                continue;
            }
            this.pendingUpdates.add(viewerId);
            this.updateFlags.put(viewerId, 7);
            if (viewerCount > 5 || (openInv = viewer.getOpenInventory().getTopInventory()) == null || !(openInv.getHolder() instanceof StoragePageHolder)) continue;
            if (oldTotalPages == -1) {
                StoragePageHolder holder = (StoragePageHolder)openInv.getHolder();
                oldTotalPages = this.calculateTotalPages(holder.getOldUsedSlots());
                newTotalPages = this.calculateTotalPages(spawner.getVirtualInventory().getUsedSlots());
            }
            this.processStorageUpdate(viewer, spawner, oldTotalPages, newTotalPages);
        }
        if (viewerCount > 5) {
            for (UUID viewerId : viewers) {
                Location loc;
                viewer = Bukkit.getPlayer((UUID)viewerId);
                if (!this.isValidGuiSession(viewer) || (loc = viewer.getLocation()) == null) continue;
                Scheduler.runLocationTask(loc, () -> {
                    if (!viewer.isOnline()) {
                        return;
                    }
                    Inventory openInv = viewer.getOpenInventory().getTopInventory();
                    if (openInv != null && openInv.getHolder() instanceof StoragePageHolder) {
                        StoragePageHolder holder = (StoragePageHolder)openInv.getHolder();
                        int oldPages = this.calculateTotalPages(holder.getOldUsedSlots());
                        int newPages = this.calculateTotalPages(spawner.getVirtualInventory().getUsedSlots());
                        this.processStorageUpdateDirect(viewer, openInv, spawner, holder, oldPages, newPages);
                    }
                });
            }
        }
    }

    public void processStorageUpdate(Player viewer, SpawnerData spawner, int oldTotalPages, int newTotalPages) {
        Location loc = viewer.getLocation();
        if (loc != null) {
            Scheduler.runLocationTask(loc, () -> {
                if (!viewer.isOnline()) {
                    return;
                }
                Inventory openInv = viewer.getOpenInventory().getTopInventory();
                if (openInv == null || !(openInv.getHolder() instanceof StoragePageHolder)) {
                    return;
                }
                StoragePageHolder holder = (StoragePageHolder)openInv.getHolder();
                this.processStorageUpdateDirect(viewer, openInv, spawner, holder, oldTotalPages, newTotalPages);
            });
        }
    }

    private void processStorageUpdateDirect(Player viewer, Inventory inventory, SpawnerData spawner, StoragePageHolder holder, int oldTotalPages, int newTotalPages) {
        boolean pagesChanged = oldTotalPages != newTotalPages;
        int currentPage = holder.getCurrentPage();
        boolean needsNewInventory = false;
        int targetPage = currentPage;
        if (currentPage > newTotalPages) {
            targetPage = newTotalPages;
            holder.setCurrentPage(targetPage);
            needsNewInventory = true;
        } else if (pagesChanged) {
            needsNewInventory = true;
        }
        if (needsNewInventory) {
            try {
                String newTitle = this.languageManager.getGuiTitle("gui_title_storage") + " - [" + targetPage + "/" + newTotalPages + "]";
                viewer.getOpenInventory().setTitle(newTitle);
                this.spawnerStorageUI.updateDisplay(inventory, spawner, targetPage, newTotalPages);
            }
            catch (Exception e) {
                Inventory newInv = this.spawnerStorageUI.createInventory(spawner, this.languageManager.getGuiTitle("gui_title_storage"), targetPage, newTotalPages);
                viewer.closeInventory();
                viewer.openInventory(newInv);
            }
        } else {
            this.spawnerStorageUI.updateDisplay(inventory, spawner, targetPage, newTotalPages);
            viewer.updateInventory();
        }
    }

    private int calculateTotalPages(int totalItems) {
        return totalItems <= 0 ? 1 : (int)Math.ceil((double)totalItems / 45.0);
    }

    public void updateSpawnerMenuGui(Player player, SpawnerData spawner, boolean forceUpdate) {
        this.pendingUpdates.add(player.getUniqueId());
        this.updateFlags.put(player.getUniqueId(), 7);
    }

    private void updateSpawnerInfoItem(Inventory inventory, SpawnerData spawner, Player player) {
        ItemStack currentSpawnerItem = inventory.getItem(13);
        if (currentSpawnerItem == null || !currentSpawnerItem.hasItemMeta()) {
            return;
        }
        ItemStack newSpawnerItem = this.spawnerMenuUI.createSpawnerInfoItem(player, spawner);
        if (!ItemUpdater.areItemsEqual(currentSpawnerItem, newSpawnerItem)) {
            this.preserveTimerInfo(currentSpawnerItem, newSpawnerItem);
            inventory.setItem(13, newSpawnerItem);
        }
    }

    private void preserveTimerInfo(ItemStack currentItem, ItemStack newItem) {
        if (this.cachedTimerPrefix == null || this.cachedTimerPrefix.isEmpty()) {
            return;
        }
        ItemMeta currentMeta = currentItem.getItemMeta();
        ItemMeta newMeta = newItem.getItemMeta();
        if (currentMeta != null && currentMeta.hasLore() && newMeta != null && newMeta.hasLore()) {
            String strippedLine;
            List currentLore = currentMeta.getLore();
            List newLore = newMeta.getLore();
            if (currentLore == null || newLore == null) {
                return;
            }
            String strippedPrefix = ChatColor.stripColor((String)this.cachedTimerPrefix);
            String timerLine = null;
            for (String line : currentLore) {
                strippedLine = ChatColor.stripColor((String)line);
                if (!strippedLine.startsWith(strippedPrefix)) continue;
                timerLine = line;
                break;
            }
            if (timerLine != null) {
                int insertIndex = -1;
                for (int i = 0; i < newLore.size(); ++i) {
                    strippedLine = ChatColor.stripColor((String)((String)newLore.get(i)));
                    if (!strippedLine.startsWith(strippedPrefix)) continue;
                    insertIndex = i;
                    break;
                }
                if (insertIndex >= 0) {
                    newLore.set(insertIndex, timerLine);
                    newMeta.setLore(newLore);
                    newItem.setItemMeta(newMeta);
                }
            }
        }
    }

    private void updateSpawnerInfoItemTimer(Inventory inventory, SpawnerData spawner) {
        ItemStack spawnerItem = inventory.getItem(13);
        if (spawnerItem == null || !spawnerItem.hasItemMeta()) {
            return;
        }
        if (this.cachedTimerPrefix == null || this.cachedTimerPrefix.trim().isEmpty()) {
            return;
        }
        long timeUntilNextSpawn = this.calculateTimeUntilNextSpawn(spawner);
        String timeDisplay = spawner.getIsAtCapacity() != false ? this.cachedFullText : (timeUntilNextSpawn == -1L ? this.cachedInactiveText : this.formatTime(timeUntilNextSpawn));
        String newLine = this.cachedTimerPrefix + timeDisplay;
        ItemMeta meta = spawnerItem.getItemMeta();
        if (meta == null || !meta.hasLore()) {
            return;
        }
        List lore = meta.getLore();
        if (lore == null) {
            return;
        }
        String strippedPrefix = ChatColor.stripColor((String)this.cachedTimerPrefix);
        int lineIndex = -1;
        for (int i = 0; i < lore.size(); ++i) {
            String strippedLine = ChatColor.stripColor((String)((String)lore.get(i)));
            if (!strippedLine.startsWith(strippedPrefix)) continue;
            lineIndex = i;
            break;
        }
        if (lineIndex >= 0) {
            if (!((String)lore.get(lineIndex)).equals(newLine)) {
                ItemUpdater.updateLoreLine(spawnerItem, lineIndex, newLine);
            }
        } else {
            lore.add(newLine);
            ItemUpdater.updateLore(spawnerItem, lore);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private long calculateTimeUntilNextSpawn(SpawnerData spawner) {
        if (spawner.getSpawnerActive() == false) return -1L;
        if (spawner.getSpawnerStop().booleanValue()) {
            return -1L;
        }
        long cachedDelay = spawner.getCachedSpawnDelay();
        if (cachedDelay == 0L) {
            cachedDelay = spawner.getSpawnDelay() * 50L;
            spawner.setCachedSpawnDelay(cachedDelay);
        }
        long currentTime = System.currentTimeMillis();
        long lastSpawnTime = spawner.getLastSpawnTime();
        long timeUntilNextSpawn = lastSpawnTime + cachedDelay - currentTime;
        if (timeUntilNextSpawn >= 0L) return timeUntilNextSpawn;
        try {
            if (!spawner.getLock().tryLock(100L, TimeUnit.MILLISECONDS)) return Math.max(0L, timeUntilNextSpawn);
            try {
                currentTime = System.currentTimeMillis();
                lastSpawnTime = spawner.getLastSpawnTime();
                timeUntilNextSpawn = lastSpawnTime + cachedDelay - currentTime;
                if (timeUntilNextSpawn >= 0L) return timeUntilNextSpawn;
                spawner.setLastSpawnTime(currentTime - cachedDelay);
                Location spawnerLocation = spawner.getSpawnerLocation();
                if (spawnerLocation != null) {
                    Scheduler.runLocationTask(spawnerLocation, () -> this.plugin.getRangeChecker().activateSpawner(spawner));
                }
                long l = 0L;
                return l;
            }
            finally {
                spawner.getLock().unlock();
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return Math.max(0L, timeUntilNextSpawn);
        }
    }

    private String formatTime(long milliseconds) {
        if (milliseconds <= 0L) {
            return "00:00";
        }
        long seconds = milliseconds / 1000L;
        long minutes = seconds / 60L;
        return String.format("%02d:%02d", minutes, seconds %= 60L);
    }

    private void updateChestItem(Inventory inventory, SpawnerData spawner) {
        ItemStack currentChestItem = inventory.getItem(11);
        if (currentChestItem == null || !currentChestItem.hasItemMeta()) {
            return;
        }
        ItemStack newChestItem = this.spawnerMenuUI.createLootStorageItem(spawner);
        if (!ItemUpdater.areItemsEqual(currentChestItem, newChestItem)) {
            inventory.setItem(11, newChestItem);
        }
    }

    private void updateExpItem(Inventory inventory, SpawnerData spawner) {
        ItemStack currentExpItem = inventory.getItem(15);
        if (currentExpItem == null || !currentExpItem.hasItemMeta()) {
            return;
        }
        ItemStack newExpItem = this.spawnerMenuUI.createExpItem(spawner);
        if (!ItemUpdater.areItemsEqual(currentExpItem, newExpItem)) {
            inventory.setItem(15, newExpItem);
        }
    }

    public void closeAllViewersInventory(SpawnerData spawner) {
        String spawnerId = spawner.getSpawnerId();
        Set<Player> viewers = this.getViewers(spawnerId);
        if (!viewers.isEmpty()) {
            for (Player viewer : viewers) {
                if (viewer == null || !viewer.isOnline()) continue;
                viewer.closeInventory();
            }
        }
        if (this.plugin.getSpawnerStackerHandler() != null) {
            this.plugin.getSpawnerStackerHandler().closeAllViewersInventory(spawnerId);
        }
    }

    public void cleanup() {
        this.stopUpdateTask();
        this.clearAllTrackedGuis();
    }

    private static class SpawnerViewerInfo {
        final SpawnerData spawnerData;
        final long lastUpdateTime;

        SpawnerViewerInfo(SpawnerData spawnerData) {
            this.spawnerData = spawnerData;
            this.lastUpdateTime = System.currentTimeMillis();
        }
    }
}

