/*
 * Decompiled with CFR 0.152.
 */
package github.nighter.smartspawner.spawner.interactions;

import github.nighter.smartspawner.Scheduler;
import github.nighter.smartspawner.SmartSpawner;
import github.nighter.smartspawner.hooks.protections.CheckOpenMenu;
import github.nighter.smartspawner.language.MessageService;
import github.nighter.smartspawner.nms.ParticleWrapper;
import github.nighter.smartspawner.spawner.gui.main.SpawnerMenuUI;
import github.nighter.smartspawner.spawner.interactions.stack.SpawnerStackHandler;
import github.nighter.smartspawner.spawner.interactions.type.SpawnEggHandler;
import github.nighter.smartspawner.spawner.properties.SpawnerData;
import github.nighter.smartspawner.spawner.properties.SpawnerManager;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.CreatureSpawner;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;
import org.geysermc.floodgate.api.FloodgateApi;

public class SpawnerClickManager
implements Listener {
    private static final long COOLDOWN_MS = 250L;
    private static final long CLEANUP_INTERVAL_TICKS = 6000L;
    private final SmartSpawner plugin;
    private final MessageService messageService;
    private final SpawnerManager spawnerManager;
    private final SpawnEggHandler spawnEggHandler;
    private final SpawnerStackHandler spawnerStackHandler;
    private final SpawnerMenuUI spawnerMenuUI;
    private final Map<UUID, Long> playerCooldowns = new ConcurrentHashMap<UUID, Long>();

    public SpawnerClickManager(SmartSpawner plugin) {
        this.plugin = plugin;
        this.messageService = plugin.getMessageService();
        this.spawnerManager = plugin.getSpawnerManager();
        this.spawnEggHandler = plugin.getSpawnEggHandler();
        this.spawnerStackHandler = plugin.getSpawnerStackHandler();
        this.spawnerMenuUI = plugin.getSpawnerMenuUI();
        this.initCleanupTask();
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onSpawnerClick(PlayerInteractEvent event) {
        if (!this.isValidSpawnerInteraction(event)) {
            return;
        }
        Player player = event.getPlayer();
        Block block = event.getClickedBlock();
        SpawnerData spawner = this.spawnerManager.getSpawnerByLocation(block.getLocation());
        if (spawner == null) {
            return;
        }
        if (!this.isInteractionAllowed(player)) {
            event.setCancelled(true);
            return;
        }
        ItemStack heldItem = player.getInventory().getItemInMainHand();
        Material itemType = heldItem.getType();
        if (this.shouldAllowNormalBlockPlacement(player, itemType)) {
            return;
        }
        if (this.isBedrockPlayerUsingTool(player, itemType)) {
            return;
        }
        event.setCancelled(true);
        if (!spawner.getSpawnerActive().booleanValue()) {
            this.handleInactiveSpawnerInteraction(player, block, spawner, heldItem, itemType);
        }
        this.handleSpawnerInteraction(player, block, heldItem, itemType, spawner);
    }

    private boolean isValidSpawnerInteraction(PlayerInteractEvent event) {
        return event.getAction() == Action.RIGHT_CLICK_BLOCK && event.getClickedBlock() != null && event.getClickedBlock().getType() == Material.SPAWNER;
    }

    private boolean isInteractionAllowed(Player player) {
        long currentTime = System.currentTimeMillis();
        Long lastInteraction = this.playerCooldowns.get(player.getUniqueId());
        if (lastInteraction != null && currentTime - lastInteraction < 250L) {
            return false;
        }
        this.playerCooldowns.put(player.getUniqueId(), currentTime);
        return true;
    }

    private boolean shouldAllowNormalBlockPlacement(Player player, Material itemType) {
        return player.isSneaking() && itemType.isBlock() && itemType != Material.SPAWNER;
    }

    private boolean isBedrockPlayerUsingTool(Player player, Material itemType) {
        if (!this.isBedrockPlayer(player)) {
            return false;
        }
        String itemName = itemType.name();
        boolean isTool = itemName.endsWith("_PICKAXE") || itemName.endsWith("_SHOVEL") || itemName.endsWith("_HOE") || itemName.endsWith("_AXE");
        return isTool;
    }

    private void handleSpawnerInteraction(Player player, Block block, ItemStack heldItem, Material itemType, SpawnerData spawner) {
        if (!CheckOpenMenu.CanPlayerOpenMenu(player, block.getLocation())) {
            this.messageService.sendMessage(player, "spawner_protected");
            return;
        }
        if (this.isSpawnEgg(itemType)) {
            this.spawnEggHandler.handleSpawnEggUse(player, (CreatureSpawner)block.getState(), spawner, heldItem);
            return;
        }
        if (itemType == Material.SPAWNER) {
            this.spawnerStackHandler.handleSpawnerStacking(player, block, spawner, heldItem);
            return;
        }
        this.openSpawnerMenu(player, spawner);
    }

    private void handleInactiveSpawnerInteraction(Player player, Block block, SpawnerData spawner, ItemStack heldItem, Material itemType) {
        if (!CheckOpenMenu.CanPlayerOpenMenu(player, block.getLocation())) {
            this.messageService.sendMessage(player, "spawner_protected");
            return;
        }
        if (this.isSpawnEgg(itemType)) {
            this.spawnEggHandler.handleSpawnEggUse(player, (CreatureSpawner)block.getState(), spawner, heldItem);
            return;
        }
        spawner.setSpawnerActive(true);
        this.spawnerManager.queueSpawnerForSaving(spawner.getSpawnerId());
        this.messageService.sendMessage(player, "spawner_activated");
        if (itemType == Material.SPAWNER) {
            this.spawnerStackHandler.handleSpawnerStacking(player, block, spawner, heldItem);
            return;
        }
        this.openSpawnerMenu(player, spawner);
    }

    private void openSpawnerMenu(Player player, SpawnerData spawner) {
        this.spawnerMenuUI.openSpawnerMenu(player, spawner, false);
    }

    private boolean isSpawnEgg(Material material) {
        return material.name().endsWith("_SPAWN_EGG");
    }

    private void spawnActivationParticles(Location location) {
        Scheduler.runLocationTask(location, () -> location.getWorld().spawnParticle(ParticleWrapper.SPELL_WITCH, location.clone().add(0.5, 0.5, 0.5), 50, 0.5, 0.5, 0.5, 0.0));
    }

    private boolean isBedrockPlayer(Player player) {
        try {
            FloodgateApi api = FloodgateApi.getInstance();
            return api != null && api.isFloodgatePlayer(player.getUniqueId());
        }
        catch (NoClassDefFoundError | NullPointerException e) {
            return false;
        }
    }

    private void initCleanupTask() {
        Scheduler.runTaskTimer(this::cleanupCooldowns, 6000L, 6000L);
    }

    public void cleanupCooldowns() {
        long expirationThreshold = System.currentTimeMillis() - 2500L;
        this.playerCooldowns.entrySet().removeIf(entry -> (Long)entry.getValue() < expirationThreshold);
    }

    public void cleanup() {
        this.playerCooldowns.clear();
    }
}

