/*
 * Decompiled with CFR 0.152.
 */
package github.nighter.smartspawner.spawner.interactions.place;

import github.nighter.smartspawner.Scheduler;
import github.nighter.smartspawner.SmartSpawner;
import github.nighter.smartspawner.api.events.SpawnerPlaceEvent;
import github.nighter.smartspawner.extras.HopperHandler;
import github.nighter.smartspawner.language.MessageService;
import github.nighter.smartspawner.nms.ParticleWrapper;
import github.nighter.smartspawner.spawner.properties.SpawnerData;
import github.nighter.smartspawner.spawner.properties.SpawnerManager;
import github.nighter.smartspawner.utils.SpawnerTypeChecker;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.CreatureSpawner;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BlockStateMeta;
import org.bukkit.inventory.meta.ItemMeta;

public class SpawnerPlaceListener
implements Listener {
    private static final double PARTICLE_OFFSET = 0.5;
    private final SmartSpawner plugin;
    private final MessageService messageService;
    private final SpawnerManager spawnerManager;
    private final HopperHandler hopperHandler;

    public SpawnerPlaceListener(SmartSpawner plugin) {
        this.plugin = plugin;
        this.messageService = plugin.getMessageService();
        this.spawnerManager = plugin.getSpawnerManager();
        this.hopperHandler = plugin.getHopperHandler();
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onBlockPlace(BlockPlaceEvent event) {
        Block block = event.getBlock();
        if (block.getType() != Material.SPAWNER) {
            return;
        }
        Player player = event.getPlayer();
        ItemStack item = event.getItemInHand();
        ItemMeta meta = item.getItemMeta();
        if (!(meta instanceof BlockStateMeta)) {
            event.setCancelled(true);
            this.plugin.debug("Invalid spawner item: " + String.valueOf(item.getType()));
            return;
        }
        BlockStateMeta blockMeta = (BlockStateMeta)meta;
        boolean isVanillaSpawner = SpawnerTypeChecker.isVanillaSpawner(item);
        EntityType storedEntityType = null;
        if (blockMeta.hasBlockState() && blockMeta.getBlockState() instanceof CreatureSpawner) {
            storedEntityType = ((CreatureSpawner)blockMeta.getBlockState()).getSpawnedType();
        }
        if (SpawnerPlaceEvent.getHandlerList().getRegisteredListeners().length != 0) {
            SpawnerPlaceEvent e = new SpawnerPlaceEvent(player, block.getLocation(), 1);
            Bukkit.getPluginManager().callEvent((Event)e);
            if (e.isCancelled()) {
                event.setCancelled(true);
                return;
            }
        }
        this.handleSpawnerSetup(block, player, storedEntityType, isVanillaSpawner);
    }

    private void handleSpawnerSetup(Block block, Player player, EntityType entityType, boolean isVanillaSpawner) {
        CreatureSpawner spawner = (CreatureSpawner)block.getState();
        if (isVanillaSpawner) {
            spawner.setSpawnedType(entityType);
            spawner.update(true, false);
            return;
        }
        Scheduler.runLocationTaskLater(block.getLocation(), () -> {
            if (block.getType() != Material.SPAWNER) {
                return;
            }
            CreatureSpawner delayedSpawner = (CreatureSpawner)block.getState();
            EntityType finalEntityType = this.getEntityType(entityType, delayedSpawner);
            delayedSpawner.setSpawnedType(finalEntityType);
            delayedSpawner.update(true, false);
            this.createSmartSpawner(block, player, finalEntityType);
            this.setupHopperIntegration(block);
        }, 2L);
    }

    private EntityType getEntityType(EntityType storedEntityType, CreatureSpawner placedSpawner) {
        EntityType entityType = storedEntityType;
        if (entityType == null || entityType == EntityType.UNKNOWN) {
            entityType = placedSpawner.getSpawnedType();
            placedSpawner.setSpawnedType(entityType);
            placedSpawner.update(true, false);
        }
        return entityType;
    }

    private void createSmartSpawner(Block block, Player player, EntityType entityType) {
        Object spawner;
        String spawnerId = UUID.randomUUID().toString().substring(0, 8);
        BlockState state = block.getState();
        if (state instanceof CreatureSpawner) {
            spawner = (CreatureSpawner)state;
            spawner.setSpawnedType(entityType);
            spawner.update(true, false);
        }
        spawner = new SpawnerData(spawnerId, block.getLocation(), entityType, this.plugin);
        ((SpawnerData)spawner).setSpawnerActive(true);
        this.spawnerManager.addSpawner(spawnerId, (SpawnerData)spawner);
        this.spawnerManager.queueSpawnerForSaving(spawnerId);
        if (this.plugin.getConfig().getBoolean("particle.spawner_generate_loot", true)) {
            this.showCreationParticles(block);
        }
        this.messageService.sendMessage(player, "spawner_activated");
    }

    private void showCreationParticles(Block block) {
        Scheduler.runLocationTask(block.getLocation(), () -> {
            Location particleLocation = block.getLocation().clone().add(0.5, 0.5, 0.5);
            block.getWorld().spawnParticle(ParticleWrapper.SPELL_WITCH, particleLocation, 50, 0.5, 0.5, 0.5, 0.0);
        });
    }

    private void setupHopperIntegration(Block block) {
        Scheduler.runLocationTask(block.getLocation(), () -> {
            Block blockBelow = block.getRelative(BlockFace.DOWN);
            if (blockBelow.getType() == Material.HOPPER && this.hopperHandler != null) {
                this.hopperHandler.startHopperTask(blockBelow.getLocation(), block.getLocation());
            }
        });
    }
}

