/*
 * Decompiled with CFR 0.152.
 */
package github.nighter.smartspawner.spawner.interactions.stack;

import github.nighter.smartspawner.Scheduler;
import github.nighter.smartspawner.SmartSpawner;
import github.nighter.smartspawner.api.events.SpawnerStackEvent;
import github.nighter.smartspawner.hooks.protections.CheckStackBlock;
import github.nighter.smartspawner.language.LanguageManager;
import github.nighter.smartspawner.language.MessageService;
import github.nighter.smartspawner.nms.ParticleWrapper;
import github.nighter.smartspawner.spawner.properties.SpawnerData;
import github.nighter.smartspawner.utils.SpawnerTypeChecker;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.CreatureSpawner;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BlockStateMeta;
import org.bukkit.inventory.meta.ItemMeta;

public class SpawnerStackHandler {
    private static final long STACK_COOLDOWN = 250L;
    private final SmartSpawner plugin;
    private final LanguageManager languageManager;
    private final MessageService messageService;
    private final Map<UUID, Long> lastStackTime;
    private final Map<Location, UUID> stackLocks;

    public SpawnerStackHandler(SmartSpawner plugin) {
        this.plugin = plugin;
        this.languageManager = plugin.getLanguageManager();
        this.messageService = plugin.getMessageService();
        this.lastStackTime = new ConcurrentHashMap<UUID, Long>();
        this.stackLocks = new ConcurrentHashMap<Location, UUID>();
        this.startCleanupTask();
    }

    private void startCleanupTask() {
        Scheduler.runTaskTimer(() -> {
            long now = System.currentTimeMillis();
            this.lastStackTime.entrySet().removeIf(entry -> now - (Long)entry.getValue() > 10000L);
            this.stackLocks.entrySet().removeIf(entry -> this.plugin.getServer().getPlayer((UUID)entry.getValue()) == null);
        }, 200L, 200L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleSpawnerStacking(Player player, Block block, SpawnerData spawnerData, ItemStack itemInHand) {
        if (this.isOnCooldown(player)) {
            return;
        }
        if (!this.acquireStackLock(player, block.getLocation())) {
            return;
        }
        try {
            this.handleSpawnerStack(player, spawnerData, itemInHand, player.isSneaking());
        }
        finally {
            this.releaseStackLock(block.getLocation());
            this.updateLastStackTime(player);
        }
    }

    private boolean isOnCooldown(Player player) {
        long lastTime = this.lastStackTime.getOrDefault(player.getUniqueId(), 0L);
        return System.currentTimeMillis() - lastTime < 250L;
    }

    private void updateLastStackTime(Player player) {
        this.lastStackTime.put(player.getUniqueId(), System.currentTimeMillis());
    }

    private boolean acquireStackLock(Player player, Location location) {
        return this.stackLocks.putIfAbsent(location, player.getUniqueId()) == null;
    }

    private void releaseStackLock(Location location) {
        this.stackLocks.remove(location);
    }

    public boolean handleSpawnerStack(Player player, SpawnerData targetSpawner, ItemStack itemInHand, boolean stackAll) {
        EntityType targetEntityType;
        if (itemInHand.getType() != Material.SPAWNER) {
            return false;
        }
        Location location = targetSpawner.getSpawnerLocation();
        if (!this.hasStackPermissions(player, location)) {
            return false;
        }
        if (SpawnerTypeChecker.isVanillaSpawner(itemInHand)) {
            this.messageService.sendMessage(player, "spawner_invalid");
            return false;
        }
        Optional<EntityType> handEntityTypeOpt = this.getEntityTypeFromItem(itemInHand);
        if (!handEntityTypeOpt.isPresent()) {
            this.messageService.sendMessage(player, "spawner_invalid");
            return false;
        }
        EntityType handEntityType = handEntityTypeOpt.get();
        if (handEntityType != (targetEntityType = targetSpawner.getEntityType())) {
            this.messageService.sendMessage(player, "spawner_different");
            return false;
        }
        int maxStackSize = targetSpawner.getMaxStackSize();
        int currentStack = targetSpawner.getStackSize();
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("max", String.valueOf(maxStackSize));
        if (currentStack >= maxStackSize) {
            this.messageService.sendMessage(player, "spawner_stack_full", placeholders);
            return false;
        }
        return this.processStackAddition(player, targetSpawner, itemInHand, stackAll, currentStack, maxStackSize);
    }

    private boolean hasStackPermissions(Player player, Location location) {
        if (!CheckStackBlock.CanPlayerPlaceBlock(player, location)) {
            this.messageService.sendMessage(player, "spawner_protected");
            return false;
        }
        if (!player.hasPermission("smartspawner.stack")) {
            this.messageService.sendMessage(player, "no_permission");
            return false;
        }
        return true;
    }

    public Optional<EntityType> getEntityTypeFromItem(ItemStack item) {
        CreatureSpawner handSpawner;
        EntityType entityType;
        BlockState blockState;
        BlockStateMeta blockMeta;
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return Optional.empty();
        }
        if (meta instanceof BlockStateMeta && (blockMeta = (BlockStateMeta)meta).hasBlockState() && (blockState = blockMeta.getBlockState()) instanceof CreatureSpawner && (entityType = (handSpawner = (CreatureSpawner)blockState).getSpawnedType()) != null) {
            return Optional.of(entityType);
        }
        return Optional.empty();
    }

    private boolean processStackAddition(Player player, SpawnerData targetSpawner, ItemStack itemInHand, boolean stackAll, int currentStack, int maxStackSize) {
        int itemAmount = itemInHand.getAmount();
        int spaceLeft = maxStackSize - currentStack;
        int amountToStack = stackAll ? Math.min(spaceLeft, itemAmount) : 1;
        int newStack = currentStack + amountToStack;
        if (SpawnerStackEvent.getHandlerList().getRegisteredListeners().length != 0) {
            SpawnerStackEvent e = new SpawnerStackEvent(player, targetSpawner.getSpawnerLocation(), currentStack, newStack);
            Bukkit.getPluginManager().callEvent((Event)e);
            if (e.isCancelled()) {
                return false;
            }
        }
        targetSpawner.setStackSize(newStack);
        if (targetSpawner.getIsAtCapacity().booleanValue()) {
            targetSpawner.setIsAtCapacity(false);
        }
        this.updatePlayerInventory(player, itemInHand, amountToStack);
        this.showStackAnimation(targetSpawner, newStack, player);
        return true;
    }

    private void updatePlayerInventory(Player player, ItemStack itemInHand, int amountUsed) {
        if (player.getGameMode() != GameMode.CREATIVE) {
            int remainingAmount = itemInHand.getAmount() - amountUsed;
            if (remainingAmount <= 0) {
                player.getInventory().setItemInMainHand(null);
            } else {
                itemInHand.setAmount(remainingAmount);
            }
        }
    }

    private void showStackAnimation(SpawnerData spawner, int newStack, Player player) {
        Location loc;
        World world;
        if (this.plugin.getConfig().getBoolean("particle.spawner_stack", true) && (world = (loc = spawner.getSpawnerLocation()).getWorld()) != null) {
            Scheduler.runLocationTask(loc, () -> world.spawnParticle(ParticleWrapper.VILLAGER_HAPPY, loc.clone().add(0.5, 0.5, 0.5), 10, 0.3, 0.3, 0.3, 0.0));
        }
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("amount", String.valueOf(newStack));
        this.messageService.sendMessage(player, "spawner_stack_success", placeholders);
    }
}

