/*
 * Decompiled with CFR 0.152.
 */
package github.nighter.smartspawner.spawner.loot;

import github.nighter.smartspawner.economy.ItemPriceManager;
import github.nighter.smartspawner.spawner.loot.EntityLootConfig;
import github.nighter.smartspawner.spawner.loot.LootItem;
import java.io.File;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.EntityType;
import org.bukkit.plugin.java.JavaPlugin;

public class EntityLootRegistry {
    private final JavaPlugin plugin;
    private FileConfiguration lootConfig;
    private final Map<String, EntityLootConfig> entityLootConfigs;
    private final ItemPriceManager priceManager;
    private final Map<Material, Double> cachedPrices;

    public EntityLootRegistry(JavaPlugin plugin, ItemPriceManager priceManager) {
        this.plugin = plugin;
        this.lootConfig = YamlConfiguration.loadConfiguration((File)new File(plugin.getDataFolder(), "mob_drops.yml"));
        this.entityLootConfigs = new ConcurrentHashMap<String, EntityLootConfig>();
        this.priceManager = priceManager;
        this.cachedPrices = new ConcurrentHashMap<Material, Double>();
        this.loadConfigurations();
    }

    private void loadConfigurations() {
        this.entityLootConfigs.clear();
        this.cachedPrices.clear();
        for (String entityName : this.lootConfig.getKeys(false)) {
            ConfigurationSection entitySection;
            if (entityName.startsWith("#") || entityName.equals("per_mob_drop") || (entitySection = this.lootConfig.getConfigurationSection(entityName)) == null) continue;
            int experience = entitySection.getInt("experience", 0);
            ArrayList<LootItem> items = new ArrayList<LootItem>();
            ConfigurationSection lootSection = entitySection.getConfigurationSection("loot");
            if (lootSection != null) {
                for (String itemKey : lootSection.getKeys(false)) {
                    ConfigurationSection itemSection = lootSection.getConfigurationSection(itemKey);
                    if (itemSection == null) continue;
                    try {
                        ConfigurationSection potionSection;
                        Material material = Material.valueOf((String)itemKey.toUpperCase());
                        String[] amounts = itemSection.getString("amount", "1-1").split("-");
                        int minAmount = Integer.parseInt(amounts[0]);
                        int maxAmount = Integer.parseInt(amounts.length > 1 ? amounts[1] : amounts[0]);
                        double chance = itemSection.getDouble("chance", 100.0);
                        double sellPrice = this.getSellPrice(material);
                        Integer minDurability = null;
                        Integer maxDurability = null;
                        if (itemSection.contains("durability")) {
                            String[] durabilities = itemSection.getString("durability").split("-");
                            minDurability = Integer.parseInt(durabilities[0]);
                            maxDurability = Integer.parseInt(durabilities.length > 1 ? durabilities[1] : durabilities[0]);
                        }
                        String potionEffectType = null;
                        Integer potionDuration = null;
                        Integer potionAmplifier = null;
                        if (material == Material.TIPPED_ARROW && itemSection.contains("potion_effect") && (potionSection = itemSection.getConfigurationSection("potion_effect")) != null) {
                            potionEffectType = potionSection.getString("effect");
                            int seconds = potionSection.getInt("duration", 5);
                            potionDuration = seconds * 20;
                            potionAmplifier = potionSection.getInt("level", 0);
                        }
                        items.add(new LootItem(material, minAmount, maxAmount, chance, minDurability, maxDurability, potionEffectType, potionDuration, potionAmplifier, sellPrice));
                    }
                    catch (IllegalArgumentException e) {
                        this.plugin.getLogger().warning("Invalid material name: " + itemKey + " in entity loot config for " + entityName);
                    }
                }
            }
            this.entityLootConfigs.put(entityName.toLowerCase(), new EntityLootConfig(experience, items));
        }
    }

    private double getSellPrice(Material material) {
        return this.cachedPrices.computeIfAbsent(material, this.priceManager::getPrice);
    }

    public EntityLootConfig getLootConfig(EntityType entityType) {
        if (entityType == null || entityType == EntityType.UNKNOWN) {
            return null;
        }
        return this.entityLootConfigs.get(entityType.name().toLowerCase());
    }

    public void reload() {
        this.entityLootConfigs.clear();
        this.cachedPrices.clear();
        this.lootConfig = YamlConfiguration.loadConfiguration((File)new File(this.plugin.getDataFolder(), "mob_drops.yml"));
        this.loadConfigurations();
    }
}

