/*
 * Decompiled with CFR 0.152.
 */
package github.nighter.smartspawner.spawner.loot;

import java.util.Random;
import lombok.Generated;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class LootItem {
    private final Material material;
    private final int minAmount;
    private final int maxAmount;
    private final double chance;
    private final Integer minDurability;
    private final Integer maxDurability;
    private final String potionEffectType;
    private final Integer potionDuration;
    private final Integer potionAmplifier;
    private final double sellPrice;

    public LootItem(Material material, int minAmount, int maxAmount, double chance, Integer minDurability, Integer maxDurability, String potionEffectType, Integer potionDuration, Integer potionAmplifier, double sellPrice) {
        this.material = material;
        this.minAmount = minAmount;
        this.maxAmount = maxAmount;
        this.chance = chance;
        this.minDurability = minDurability;
        this.maxDurability = maxDurability;
        this.potionEffectType = potionEffectType;
        this.potionDuration = potionDuration;
        this.potionAmplifier = potionAmplifier;
        this.sellPrice = sellPrice;
    }

    public ItemStack createItemStack(Random random) {
        PotionMeta meta;
        PotionEffectType effectType;
        ItemMeta meta2;
        ItemStack item = new ItemStack(this.material, 1);
        if (this.minDurability != null && this.maxDurability != null && (meta2 = item.getItemMeta()) instanceof Damageable) {
            int durability = random.nextInt(this.maxDurability - this.minDurability + 1) + this.minDurability;
            ((Damageable)meta2).setDamage(durability);
            item.setItemMeta(meta2);
        }
        if (this.material == Material.TIPPED_ARROW && this.potionEffectType != null && (effectType = PotionEffectType.getByName((String)this.potionEffectType)) != null && this.potionDuration != null && this.potionAmplifier != null && (meta = (PotionMeta)item.getItemMeta()) != null) {
            PotionEffect effect = new PotionEffect(effectType, this.potionDuration.intValue(), this.potionAmplifier.intValue(), true, true, true);
            meta.addCustomEffect(effect, true);
            item.setItemMeta((ItemMeta)meta);
        }
        return item;
    }

    public int generateAmount(Random random) {
        return random.nextInt(this.maxAmount - this.minAmount + 1) + this.minAmount;
    }

    public double calculateSellValue(int amount) {
        return this.sellPrice * (double)amount;
    }

    @Generated
    public Material getMaterial() {
        return this.material;
    }

    @Generated
    public int getMinAmount() {
        return this.minAmount;
    }

    @Generated
    public int getMaxAmount() {
        return this.maxAmount;
    }

    @Generated
    public double getChance() {
        return this.chance;
    }

    @Generated
    public Integer getMinDurability() {
        return this.minDurability;
    }

    @Generated
    public Integer getMaxDurability() {
        return this.maxDurability;
    }

    @Generated
    public String getPotionEffectType() {
        return this.potionEffectType;
    }

    @Generated
    public Integer getPotionDuration() {
        return this.potionDuration;
    }

    @Generated
    public Integer getPotionAmplifier() {
        return this.potionAmplifier;
    }

    @Generated
    public double getSellPrice() {
        return this.sellPrice;
    }
}

