/*
 * Decompiled with CFR 0.152.
 */
package github.nighter.smartspawner.spawner.lootgen;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.inventory.ItemStack;

public class LootResult {
    private final List<ItemStack> items;
    private final int experience;
    private final Map<String, Object> metadata;

    public LootResult(List<ItemStack> items, int experience) {
        this.items = new ArrayList<ItemStack>(items);
        this.experience = experience;
        this.metadata = new HashMap<String, Object>();
    }

    public LootResult(List<ItemStack> items, int experience, Map<String, Object> metadata) {
        this.items = new ArrayList<ItemStack>(items);
        this.experience = experience;
        this.metadata = new HashMap<String, Object>(metadata);
    }

    public List<ItemStack> getItems() {
        return new ArrayList<ItemStack>(this.items);
    }

    List<ItemStack> getRawItems() {
        return this.items;
    }

    public int getExperience() {
        return this.experience;
    }

    public Object getMetadata(String key) {
        return this.metadata.get(key);
    }

    public void setMetadata(String key, Object value) {
        this.metadata.put(key, value);
    }

    public boolean hasItems() {
        return !this.items.isEmpty();
    }

    public boolean hasExperience() {
        return this.experience > 0;
    }

    public int getTotalItems() {
        return this.items.stream().mapToInt(ItemStack::getAmount).sum();
    }

    public LootResult combine(LootResult other) {
        ArrayList<ItemStack> combinedItems = new ArrayList<ItemStack>(this.items);
        combinedItems.addAll(other.getItems());
        HashMap<String, Object> combinedMetadata = new HashMap<String, Object>(this.metadata);
        combinedMetadata.putAll(other.metadata);
        return new LootResult(combinedItems, this.experience + other.experience, combinedMetadata);
    }

    public static LootResult empty() {
        return new LootResult(Collections.emptyList(), 0);
    }

    public static LootResult combine(Collection<LootResult> results) {
        ArrayList<ItemStack> allItems = new ArrayList<ItemStack>();
        int totalExp = 0;
        HashMap<String, Object> combinedMetadata = new HashMap<String, Object>();
        for (LootResult result : results) {
            allItems.addAll(result.getItems());
            totalExp += result.getExperience();
            combinedMetadata.putAll(result.metadata);
        }
        return new LootResult(allItems, totalExp, combinedMetadata);
    }

    public String toString() {
        return String.format("LootResult{items=%d, experience=%d, metadata=%s}", this.items.size(), this.experience, this.metadata);
    }

    public void serialize(ConfigurationSection section) {
        section.set("experience", (Object)this.experience);
        ArrayList<Map> serializedItems = new ArrayList<Map>();
        for (ItemStack item : this.items) {
            serializedItems.add(item.serialize());
        }
        section.set("items", serializedItems);
        section.set("metadata", this.metadata);
    }

    public static LootResult deserialize(ConfigurationSection section) {
        int exp = section.getInt("experience", 0);
        ArrayList<ItemStack> deserializedItems = new ArrayList<ItemStack>();
        List itemsList = section.getList("items", new ArrayList());
        for (Object obj : itemsList) {
            if (!(obj instanceof Map)) continue;
            Map itemMap = (Map)obj;
            ItemStack item = ItemStack.deserialize((Map)itemMap);
            deserializedItems.add(item);
        }
        Map metadata = (Map)section.get("metadata", new HashMap());
        return new LootResult(deserializedItems, exp, metadata);
    }
}

