/*
 * Decompiled with CFR 0.152.
 */
package github.nighter.smartspawner.spawner.lootgen;

import github.nighter.smartspawner.Scheduler;
import github.nighter.smartspawner.SmartSpawner;
import github.nighter.smartspawner.nms.ParticleWrapper;
import github.nighter.smartspawner.spawner.gui.synchronization.SpawnerGuiViewManager;
import github.nighter.smartspawner.spawner.loot.LootItem;
import github.nighter.smartspawner.spawner.lootgen.LootResult;
import github.nighter.smartspawner.spawner.properties.SpawnerData;
import github.nighter.smartspawner.spawner.properties.SpawnerManager;
import github.nighter.smartspawner.spawner.properties.VirtualInventory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.EntityType;
import org.bukkit.inventory.ItemStack;

public class SpawnerLootGenerator {
    private final SmartSpawner plugin;
    private final SpawnerGuiViewManager spawnerGuiViewManager;
    private final SpawnerManager spawnerManager;
    private final Random random;

    public SpawnerLootGenerator(SmartSpawner plugin) {
        this.plugin = plugin;
        this.spawnerGuiViewManager = plugin.getSpawnerGuiViewManager();
        this.spawnerManager = plugin.getSpawnerManager();
        this.random = new Random();
    }

    public LootResult generateLoot(int minMobs, int maxMobs, SpawnerData spawner) {
        int mobCount = this.random.nextInt(maxMobs - minMobs + 1) + minMobs;
        int totalExperience = spawner.getEntityExperienceValue() * mobCount;
        List<LootItem> validItems = spawner.getValidLootItems();
        if (validItems.isEmpty()) {
            return new LootResult(Collections.emptyList(), totalExperience);
        }
        HashMap<ItemStack, Integer> consolidatedLoot = new HashMap<ItemStack, Integer>();
        for (LootItem lootItem : validItems) {
            ItemStack prototype;
            int successfulDrops = 0;
            for (int i = 0; i < mobCount; ++i) {
                if (!(this.random.nextDouble() * 100.0 <= lootItem.getChance())) continue;
                ++successfulDrops;
            }
            if (successfulDrops <= 0 || (prototype = lootItem.createItemStack(this.random)) == null) continue;
            int totalAmount = 0;
            for (int i = 0; i < successfulDrops; ++i) {
                totalAmount += lootItem.generateAmount(this.random);
            }
            if (totalAmount <= 0) continue;
            consolidatedLoot.merge(prototype, totalAmount, Integer::sum);
        }
        ArrayList<ItemStack> finalLoot = new ArrayList<ItemStack>(consolidatedLoot.size());
        for (Map.Entry entry : consolidatedLoot.entrySet()) {
            ItemStack extraStack;
            ItemStack item = ((ItemStack)entry.getKey()).clone();
            item.setAmount(Math.min((Integer)entry.getValue(), item.getMaxStackSize()));
            finalLoot.add(item);
            for (int remaining = (Integer)entry.getValue() - item.getMaxStackSize(); remaining > 0; remaining -= extraStack.getAmount()) {
                extraStack = item.clone();
                extraStack.setAmount(Math.min(remaining, item.getMaxStackSize()));
                finalLoot.add(extraStack);
            }
        }
        return new LootResult(finalLoot, totalExperience);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void spawnLootToSpawner(SpawnerData spawner) {
        boolean lockAcquired = spawner.getLock().tryLock();
        if (!lockAcquired) {
            return;
        }
        try {
            long currentTime = System.currentTimeMillis();
            long lastSpawnTime = spawner.getLastSpawnTime();
            long spawnDelay = spawner.getSpawnDelay();
            if (currentTime - lastSpawnTime < spawnDelay) {
                return;
            }
            AtomicInteger usedSlots = new AtomicInteger(spawner.getVirtualInventory().getUsedSlots());
            AtomicInteger maxSlots = new AtomicInteger(spawner.getMaxSpawnerLootSlots());
            if (usedSlots.get() >= maxSlots.get() && spawner.getSpawnerExp() >= spawner.getMaxStoredExp()) {
                if (!spawner.getIsAtCapacity().booleanValue()) {
                    spawner.setIsAtCapacity(true);
                }
                return;
            }
            spawner.setLastSpawnTime(currentTime);
            EntityType entityType = spawner.getEntityType();
            int minMobs = spawner.getMinMobs();
            int maxMobs = spawner.getMaxMobs();
            String spawnerId = spawner.getSpawnerId();
            Scheduler.runTaskAsync(() -> {
                LootResult loot = this.generateLoot(minMobs, maxMobs, spawner);
                if (loot.getItems().isEmpty() && loot.getExperience() == 0) {
                    return;
                }
                Scheduler.runLocationTask(spawner.getSpawnerLocation(), () -> {
                    boolean updateLockAcquired = spawner.getLock().tryLock();
                    if (!updateLockAcquired) {
                        return;
                    }
                    try {
                        boolean changed = false;
                        if (loot.getExperience() > 0 && spawner.getSpawnerExp() < spawner.getMaxStoredExp()) {
                            int currentExp = spawner.getSpawnerExp();
                            int maxExp = spawner.getMaxStoredExp();
                            int newExp = Math.min(currentExp + loot.getExperience(), maxExp);
                            if (newExp != currentExp) {
                                spawner.setSpawnerExp(newExp);
                                changed = true;
                            }
                        }
                        maxSlots.set(spawner.getMaxSpawnerLootSlots());
                        usedSlots.set(spawner.getVirtualInventory().getUsedSlots());
                        if (!loot.getItems().isEmpty() && usedSlots.get() < maxSlots.get()) {
                            List<ItemStack> itemsToAdd = new ArrayList<ItemStack>(loot.getItems());
                            int totalRequiredSlots = this.calculateRequiredSlots(itemsToAdd, spawner.getVirtualInventory());
                            if (totalRequiredSlots > maxSlots.get()) {
                                itemsToAdd = this.limitItemsToAvailableSlots(itemsToAdd, spawner);
                            }
                            if (!itemsToAdd.isEmpty()) {
                                spawner.getVirtualInventory().addItems(itemsToAdd);
                                changed = true;
                            }
                        }
                        if (!changed) {
                            return;
                        }
                        spawner.updateCapacityStatus();
                        this.handleGuiUpdates(spawner);
                        this.spawnerManager.markSpawnerModified(spawner.getSpawnerId());
                    }
                    finally {
                        spawner.getLock().unlock();
                    }
                });
            });
        }
        finally {
            spawner.getLock().unlock();
        }
    }

    private List<ItemStack> limitItemsToAvailableSlots(List<ItemStack> items, SpawnerData spawner) {
        VirtualInventory currentInventory = spawner.getVirtualInventory();
        int maxSlots = spawner.getMaxSpawnerLootSlots();
        if (currentInventory.getUsedSlots() >= maxSlots) {
            return Collections.emptyList();
        }
        HashMap<VirtualInventory.ItemSignature, Long> simulatedInventory = new HashMap<VirtualInventory.ItemSignature, Long>(currentInventory.getConsolidatedItems());
        ArrayList<ItemStack> acceptedItems = new ArrayList<ItemStack>();
        items.sort(Comparator.comparing(item -> item.getType().name()));
        for (ItemStack item2 : items) {
            long maxAddAmount;
            if (item2 == null || item2.getAmount() <= 0) continue;
            HashMap<VirtualInventory.ItemSignature, Long> tempSimulation = new HashMap<VirtualInventory.ItemSignature, Long>(simulatedInventory);
            VirtualInventory.ItemSignature sig = new VirtualInventory.ItemSignature(item2);
            tempSimulation.merge(sig, Long.valueOf(item2.getAmount()), Long::sum);
            int slotsNeeded = this.calculateSlots(tempSimulation);
            if (slotsNeeded <= maxSlots) {
                acceptedItems.add(item2);
                simulatedInventory = tempSimulation;
                continue;
            }
            int maxStackSize = item2.getMaxStackSize();
            long currentAmount = simulatedInventory.getOrDefault(sig, 0L);
            int remainingSlots = maxSlots - this.calculateSlots(simulatedInventory);
            if (remainingSlots <= 0 || (maxAddAmount = (long)(remainingSlots * maxStackSize) - currentAmount % (long)maxStackSize) <= 0L) break;
            ItemStack partialItem = item2.clone();
            partialItem.setAmount((int)Math.min(maxAddAmount, (long)item2.getAmount()));
            acceptedItems.add(partialItem);
            simulatedInventory.merge(sig, Long.valueOf(partialItem.getAmount()), Long::sum);
            break;
        }
        return acceptedItems;
    }

    private int calculateSlots(Map<VirtualInventory.ItemSignature, Long> items) {
        return items.entrySet().stream().mapToInt(entry -> {
            long amount = (Long)entry.getValue();
            int maxStackSize = ((VirtualInventory.ItemSignature)entry.getKey()).getTemplateRef().getMaxStackSize();
            return (int)((amount + (long)maxStackSize - 1L) / (long)maxStackSize);
        }).sum();
    }

    private int calculateRequiredSlots(List<ItemStack> items, VirtualInventory inventory) {
        HashMap<VirtualInventory.ItemSignature, Long> simulatedItems = new HashMap<VirtualInventory.ItemSignature, Long>();
        if (inventory != null) {
            simulatedItems.putAll(inventory.getConsolidatedItems());
        }
        for (ItemStack item : items) {
            if (item == null || item.getAmount() <= 0) continue;
            VirtualInventory.ItemSignature sig = new VirtualInventory.ItemSignature(item);
            simulatedItems.merge(sig, Long.valueOf(item.getAmount()), Long::sum);
        }
        return this.calculateSlots(simulatedItems);
    }

    private void handleGuiUpdates(SpawnerData spawner) {
        Location loc;
        World world;
        if (this.plugin.getConfig().getBoolean("particle.spawner_generate_loot", true) && (world = (loc = spawner.getSpawnerLocation()).getWorld()) != null) {
            Scheduler.runLocationTask(loc, () -> world.spawnParticle(ParticleWrapper.VILLAGER_HAPPY, loc.clone().add(0.5, 0.5, 0.5), 10, 0.3, 0.3, 0.3, 0.0));
        }
        this.spawnerGuiViewManager.updateSpawnerMenuViewers(spawner);
        if (this.plugin.getConfig().getBoolean("hologram.enabled", false)) {
            spawner.updateHologramData();
        }
    }
}

