/*
 * Decompiled with CFR 0.152.
 */
package github.nighter.smartspawner.spawner.properties;

import github.nighter.smartspawner.SmartSpawner;
import github.nighter.smartspawner.commands.hologram.SpawnerHologram;
import github.nighter.smartspawner.spawner.loot.EntityLootConfig;
import github.nighter.smartspawner.spawner.loot.EntityLootRegistry;
import github.nighter.smartspawner.spawner.loot.LootItem;
import github.nighter.smartspawner.spawner.properties.VirtualInventory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import lombok.Generated;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class SpawnerData {
    private static final Logger logger = Logger.getLogger("SmartSpawnerConfig");
    private final SmartSpawner plugin;
    private final EntityLootRegistry lootRegistry;
    private final String spawnerId;
    private final Location spawnerLocation;
    private final ReentrantLock lock = new ReentrantLock();
    private Integer spawnerExp;
    private Boolean spawnerActive;
    private Integer spawnerRange;
    private Boolean spawnerStop;
    private Boolean isAtCapacity;
    private Long lastSpawnTime;
    private long spawnDelay;
    private EntityType entityType;
    private EntityLootConfig lootConfig;
    private int maxStoragePages;
    private int maxSpawnerLootSlots;
    private int maxStoredExp;
    private int minMobs;
    private int maxMobs;
    private int stackSize;
    private int maxStackSize;
    private VirtualInventory virtualInventory;
    private final Set<Material> filteredItems = new HashSet<Material>();
    private SpawnerHologram hologram;
    private long cachedSpawnDelay = 0L;

    public SpawnerData(String id, Location location, EntityType type, SmartSpawner plugin) {
        this.plugin = plugin;
        this.spawnerId = id;
        this.spawnerLocation = location;
        this.entityType = type;
        this.spawnerExp = 0;
        this.spawnerActive = true;
        this.spawnerStop = true;
        this.isAtCapacity = false;
        this.stackSize = 1;
        this.maxStackSize = plugin.getConfig().getInt("spawner_properties.default.max_stack_size", 1000);
        this.maxStoragePages = plugin.getConfig().getInt("spawner_properties.default.max_storage_pages", 1);
        this.maxSpawnerLootSlots = 45;
        this.lootRegistry = plugin.getEntityLootRegistry();
        this.lootConfig = this.lootRegistry.getLootConfig(this.entityType);
        this.loadConfigValues();
        this.virtualInventory = new VirtualInventory(this.maxSpawnerLootSlots);
        if (plugin.getConfig().getBoolean("hologram.enabled", false)) {
            this.hologram = new SpawnerHologram(location);
            this.hologram.createHologram();
            this.updateHologramData();
        }
    }

    private void loadConfigValues() {
        int baseMaxStoredExp = this.plugin.getConfig().getInt("spawner_properties.default.max_stored_exp", 1000);
        int baseMinMobs = this.plugin.getConfig().getInt("spawner_properties.default.min_mobs", 1);
        int baseMaxMobs = this.plugin.getConfig().getInt("spawner_properties.default.max_mobs", 4);
        long baseSpawnerDelay = this.plugin.getTimeFromConfig("spawner_properties.default.delay", "25s");
        int maxStoragePages = this.plugin.getConfig().getInt("spawner_properties.default.max_storage_pages", 1);
        if (maxStoragePages <= 0) {
            logger.warning("Invalid max_storage_pages value. Setting to default: 1");
            maxStoragePages = 1;
        }
        this.maxSpawnerLootSlots = 45 * maxStoragePages * this.stackSize;
        if (this.maxSpawnerLootSlots < 0) {
            this.maxSpawnerLootSlots = 45;
        }
        this.maxStoredExp = baseMaxStoredExp * this.stackSize;
        if (this.maxStoredExp <= 0) {
            logger.warning("Invalid max_stored_exp value after scaling. Setting to base value: " + baseMaxStoredExp);
            this.maxStoredExp = baseMaxStoredExp;
        }
        this.minMobs = baseMinMobs * this.stackSize;
        if (this.minMobs <= 0) {
            logger.warning("Invalid min_mobs value after scaling. Setting to base value: " + baseMinMobs);
            this.minMobs = baseMinMobs;
        }
        this.maxMobs = baseMaxMobs * this.stackSize;
        if (this.maxMobs <= 0 || this.maxMobs <= this.minMobs) {
            logger.warning("Invalid max_mobs value after scaling. Setting to: " + (this.minMobs + this.stackSize));
            this.maxMobs = this.minMobs + this.stackSize;
        }
        this.spawnDelay = baseSpawnerDelay;
        if (this.spawnDelay <= 0L) {
            logger.warning("Invalid delay value. Setting to default: 20");
            this.spawnDelay = 400L;
        }
        this.spawnerRange = this.plugin.getConfig().getInt("spawner_properties.default.range");
        if (this.spawnerRange <= 0) {
            logger.warning("Invalid range value. Setting to default: 16");
            this.spawnerRange = 16;
        }
    }

    public void setStackSize(int stackSize) {
        this.lock.lock();
        try {
            this.updateStackSize(stackSize);
        }
        finally {
            this.lock.unlock();
        }
    }

    public void setStackSize(int stackSize, Player player) {
        this.lock.lock();
        try {
            this.updateStackSize(stackSize);
        }
        finally {
            this.lock.unlock();
        }
    }

    private void updateStackSize(int stackSize) {
        if (stackSize <= 0) {
            this.stackSize = 1;
            this.plugin.getLogger().warning("Invalid stack size. Setting to 1");
            return;
        }
        if (stackSize > this.maxStackSize) {
            this.stackSize = this.maxStackSize;
            this.plugin.getLogger().warning("Stack size exceeds maximum. Setting to " + this.stackSize);
            return;
        }
        Map<VirtualInventory.ItemSignature, Long> currentItems = this.virtualInventory.getConsolidatedItems();
        int newMaxSlots = 45 * this.maxStoragePages * stackSize;
        VirtualInventory newInventory = new VirtualInventory(newMaxSlots);
        ArrayList<ItemStack> itemsToTransfer = new ArrayList<ItemStack>();
        currentItems.forEach((signature, amount) -> {
            ItemStack template = signature.getTemplate();
            while (amount > 0L) {
                int batchSize = (int)Math.min(amount, Integer.MAX_VALUE);
                ItemStack batch = template.clone();
                batch.setAmount(batchSize);
                itemsToTransfer.add(batch);
                amount = amount - (long)batchSize;
            }
        });
        this.stackSize = stackSize;
        this.loadConfigValues();
        this.lastSpawnTime = System.currentTimeMillis() + this.spawnDelay;
        newInventory.addItems(itemsToTransfer);
        this.virtualInventory = newInventory;
        this.updateHologramData();
    }

    public void decreaseStackSizeByOne() {
        --this.stackSize;
        this.updateHologramData();
    }

    public void setSpawnerExp(int exp) {
        this.spawnerExp = Math.min(exp, this.maxStoredExp);
        this.updateHologramData();
    }

    public Map<Integer, ItemStack> getDisplayInventory() {
        return this.virtualInventory.getDisplayInventory();
    }

    public void updateHologramData() {
        if (this.hologram != null) {
            this.hologram.updateData(this.stackSize, this.entityType, this.spawnerExp, this.maxStoredExp, this.virtualInventory.getUsedSlots(), this.maxSpawnerLootSlots);
        }
    }

    public void reloadHologramData() {
        if (this.hologram != null) {
            this.hologram.remove();
            this.hologram = new SpawnerHologram(this.spawnerLocation);
            this.hologram.createHologram();
            this.hologram.updateData(this.stackSize, this.entityType, this.spawnerExp, this.maxStoredExp, this.virtualInventory.getUsedSlots(), this.maxSpawnerLootSlots);
        }
    }

    public void refreshHologram() {
        if (this.plugin.getConfig().getBoolean("hologram.enabled", false)) {
            if (this.hologram == null) {
                this.hologram = new SpawnerHologram(this.spawnerLocation);
                this.hologram.createHologram();
                this.updateHologramData();
            }
        } else if (this.hologram != null) {
            this.hologram.remove();
            this.hologram = null;
        }
    }

    public void removeHologram() {
        if (this.hologram != null) {
            this.hologram.remove();
            this.hologram = null;
        }
    }

    public boolean isCompletelyFull() {
        return this.virtualInventory.getUsedSlots() >= this.maxSpawnerLootSlots && this.spawnerExp >= this.maxStoredExp;
    }

    public boolean updateCapacityStatus() {
        boolean newStatus = this.isCompletelyFull();
        if (newStatus != this.isAtCapacity) {
            this.isAtCapacity = newStatus;
            return true;
        }
        return false;
    }

    public void setEntityType(EntityType newType) {
        this.entityType = newType;
        this.lootConfig = this.lootRegistry.getLootConfig(newType);
        this.updateHologramData();
    }

    public boolean toggleItemFilter(Material material) {
        boolean wasFiltered = this.filteredItems.contains(material);
        if (wasFiltered) {
            this.filteredItems.remove(material);
        } else {
            this.filteredItems.add(material);
        }
        return !wasFiltered;
    }

    public List<LootItem> getValidLootItems() {
        if (this.lootConfig == null) {
            return Collections.emptyList();
        }
        List<LootItem> allItems = this.lootConfig.getAllItems();
        return allItems.stream().filter(item -> {
            ItemStack example = item.createItemStack(new Random());
            return example != null && !this.filteredItems.contains(example.getType());
        }).collect(Collectors.toList());
    }

    public int getEntityExperienceValue() {
        return this.lootConfig != null ? this.lootConfig.getExperience() : 0;
    }

    public void reloadLootConfig() {
        this.lootConfig = this.lootRegistry.getLootConfig(this.entityType);
    }

    @Generated
    public String getSpawnerId() {
        return this.spawnerId;
    }

    @Generated
    public Location getSpawnerLocation() {
        return this.spawnerLocation;
    }

    @Generated
    public ReentrantLock getLock() {
        return this.lock;
    }

    @Generated
    public Integer getSpawnerExp() {
        return this.spawnerExp;
    }

    @Generated
    public Boolean getSpawnerActive() {
        return this.spawnerActive;
    }

    @Generated
    public void setSpawnerActive(Boolean spawnerActive) {
        this.spawnerActive = spawnerActive;
    }

    @Generated
    public Integer getSpawnerRange() {
        return this.spawnerRange;
    }

    @Generated
    public void setSpawnerRange(Integer spawnerRange) {
        this.spawnerRange = spawnerRange;
    }

    @Generated
    public Boolean getSpawnerStop() {
        return this.spawnerStop;
    }

    @Generated
    public void setSpawnerStop(Boolean spawnerStop) {
        this.spawnerStop = spawnerStop;
    }

    @Generated
    public Boolean getIsAtCapacity() {
        return this.isAtCapacity;
    }

    @Generated
    public void setIsAtCapacity(Boolean isAtCapacity) {
        this.isAtCapacity = isAtCapacity;
    }

    @Generated
    public Long getLastSpawnTime() {
        return this.lastSpawnTime;
    }

    @Generated
    public void setLastSpawnTime(Long lastSpawnTime) {
        this.lastSpawnTime = lastSpawnTime;
    }

    @Generated
    public long getSpawnDelay() {
        return this.spawnDelay;
    }

    @Generated
    public void setSpawnDelay(long spawnDelay) {
        this.spawnDelay = spawnDelay;
    }

    @Generated
    public EntityType getEntityType() {
        return this.entityType;
    }

    @Generated
    public EntityLootConfig getLootConfig() {
        return this.lootConfig;
    }

    @Generated
    public void setLootConfig(EntityLootConfig lootConfig) {
        this.lootConfig = lootConfig;
    }

    @Generated
    public int getMaxStoragePages() {
        return this.maxStoragePages;
    }

    @Generated
    public void setMaxStoragePages(int maxStoragePages) {
        this.maxStoragePages = maxStoragePages;
    }

    @Generated
    public int getMaxSpawnerLootSlots() {
        return this.maxSpawnerLootSlots;
    }

    @Generated
    public void setMaxSpawnerLootSlots(int maxSpawnerLootSlots) {
        this.maxSpawnerLootSlots = maxSpawnerLootSlots;
    }

    @Generated
    public int getMaxStoredExp() {
        return this.maxStoredExp;
    }

    @Generated
    public void setMaxStoredExp(int maxStoredExp) {
        this.maxStoredExp = maxStoredExp;
    }

    @Generated
    public int getMinMobs() {
        return this.minMobs;
    }

    @Generated
    public void setMinMobs(int minMobs) {
        this.minMobs = minMobs;
    }

    @Generated
    public int getMaxMobs() {
        return this.maxMobs;
    }

    @Generated
    public void setMaxMobs(int maxMobs) {
        this.maxMobs = maxMobs;
    }

    @Generated
    public int getStackSize() {
        return this.stackSize;
    }

    @Generated
    public int getMaxStackSize() {
        return this.maxStackSize;
    }

    @Generated
    public void setMaxStackSize(int maxStackSize) {
        this.maxStackSize = maxStackSize;
    }

    @Generated
    public VirtualInventory getVirtualInventory() {
        return this.virtualInventory;
    }

    @Generated
    public void setVirtualInventory(VirtualInventory virtualInventory) {
        this.virtualInventory = virtualInventory;
    }

    @Generated
    public Set<Material> getFilteredItems() {
        return this.filteredItems;
    }

    @Generated
    public long getCachedSpawnDelay() {
        return this.cachedSpawnDelay;
    }

    @Generated
    public void setCachedSpawnDelay(long cachedSpawnDelay) {
        this.cachedSpawnDelay = cachedSpawnDelay;
    }
}

