/*
 * Decompiled with CFR 0.152.
 */
package github.nighter.smartspawner.spawner.properties;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class VirtualInventory {
    private final Map<ItemSignature, Long> consolidatedItems;
    private final int maxSlots;
    private final Map<Integer, ItemStack> displayInventoryCache;
    private boolean displayCacheDirty;
    private int usedSlotsCache;
    private long totalItemsCache;
    private boolean metricsCacheDirty;
    private List<Map.Entry<ItemSignature, Long>> sortedEntriesCache;
    private static final Comparator<Map.Entry<ItemSignature, Long>> ITEM_COMPARATOR = Comparator.comparing(e -> ((ItemSignature)e.getKey()).getTemplateRef().getType().name());
    private static final int ITEM_CACHE_SIZE = 128;
    private static final Map<ItemStack, ItemSignature> signatureCache = Collections.synchronizedMap(new LinkedHashMap<ItemStack, ItemSignature>(128, 0.75f, true){

        @Override
        protected boolean removeEldestEntry(Map.Entry<ItemStack, ItemSignature> eldest) {
            return this.size() > 128;
        }
    });

    public VirtualInventory(int maxSlots) {
        this.maxSlots = maxSlots;
        this.consolidatedItems = new ConcurrentHashMap<ItemSignature, Long>();
        this.displayInventoryCache = new HashMap<Integer, ItemStack>(maxSlots);
        this.displayCacheDirty = true;
        this.metricsCacheDirty = true;
        this.usedSlotsCache = 0;
        this.totalItemsCache = 0L;
        this.sortedEntriesCache = null;
    }

    public static ItemSignature getSignature(ItemStack item) {
        ItemSignature cachedSig = signatureCache.get(item);
        if (cachedSig != null) {
            return cachedSig;
        }
        ItemSignature newSig = new ItemSignature(item);
        signatureCache.put(item.clone(), newSig);
        return newSig;
    }

    public void addItems(List<ItemStack> items) {
        if (items.isEmpty()) {
            return;
        }
        HashMap<ItemSignature, Long> itemBatch = new HashMap<ItemSignature, Long>(items.size());
        for (ItemStack itemStack : items) {
            if (itemStack == null || itemStack.getAmount() <= 0) continue;
            ItemSignature sig = VirtualInventory.getSignature(itemStack);
            itemBatch.merge(sig, Long.valueOf(itemStack.getAmount()), Long::sum);
        }
        if (!itemBatch.isEmpty()) {
            for (Map.Entry entry : itemBatch.entrySet()) {
                this.consolidatedItems.merge((ItemSignature)entry.getKey(), (Long)entry.getValue(), Long::sum);
            }
            this.displayCacheDirty = true;
            this.metricsCacheDirty = true;
            this.sortedEntriesCache = null;
        }
    }

    public boolean removeItems(List<ItemStack> items) {
        if (items.isEmpty()) {
            return true;
        }
        HashMap<ItemSignature, Long> toRemove = new HashMap<ItemSignature, Long>();
        for (ItemStack itemStack : items) {
            if (itemStack == null || itemStack.getAmount() <= 0) continue;
            ItemSignature sig = new ItemSignature(itemStack);
            toRemove.merge(sig, Long.valueOf(itemStack.getAmount()), Long::sum);
        }
        if (toRemove.isEmpty()) {
            return true;
        }
        for (Map.Entry entry : toRemove.entrySet()) {
            Long currentAmount = this.consolidatedItems.getOrDefault(entry.getKey(), 0L);
            if (currentAmount >= (Long)entry.getValue()) continue;
            return false;
        }
        boolean updated = false;
        for (Map.Entry entry : toRemove.entrySet()) {
            ItemSignature sig = (ItemSignature)entry.getKey();
            long amountToRemove = (Long)entry.getValue();
            this.consolidatedItems.computeIfPresent(sig, (key, current) -> {
                long newAmount = current - amountToRemove;
                return newAmount <= 0L ? null : Long.valueOf(newAmount);
            });
            updated = true;
        }
        if (updated) {
            this.displayCacheDirty = true;
            this.metricsCacheDirty = true;
            this.sortedEntriesCache = null;
        }
        return true;
    }

    public Map<Integer, ItemStack> getDisplayInventory() {
        if (!this.displayCacheDirty) {
            return Collections.unmodifiableMap(this.displayInventoryCache);
        }
        this.displayInventoryCache.clear();
        if (this.consolidatedItems.isEmpty()) {
            this.displayCacheDirty = false;
            this.usedSlotsCache = 0;
            return Collections.emptyMap();
        }
        if (this.sortedEntriesCache == null) {
            this.sortedEntriesCache = new ArrayList<Map.Entry<ItemSignature, Long>>(this.consolidatedItems.entrySet());
            this.sortedEntriesCache.sort(Comparator.comparing(e -> ((ItemSignature)e.getKey()).getMaterialName()));
        }
        int currentSlot = 0;
        for (Map.Entry<ItemSignature, Long> entry : this.sortedEntriesCache) {
            int stackSize;
            if (currentSlot >= this.maxSlots) break;
            ItemSignature sig = entry.getKey();
            ItemStack templateItem = sig.getTemplateRef();
            int maxStackSize = templateItem.getMaxStackSize();
            for (long totalAmount = entry.getValue().longValue(); totalAmount > 0L && currentSlot < this.maxSlots; totalAmount -= (long)stackSize, ++currentSlot) {
                stackSize = (int)Math.min(totalAmount, (long)maxStackSize);
                ItemStack displayItem = templateItem.clone();
                displayItem.setAmount(stackSize);
                this.displayInventoryCache.put(currentSlot, displayItem);
            }
        }
        this.displayCacheDirty = false;
        this.usedSlotsCache = this.displayInventoryCache.size();
        return Collections.unmodifiableMap(this.displayInventoryCache);
    }

    public int getMaxSlots() {
        return this.maxSlots;
    }

    public long getTotalItems() {
        if (this.metricsCacheDirty) {
            this.updateMetricsCache();
        }
        return this.totalItemsCache;
    }

    public Map<ItemSignature, Long> getConsolidatedItems() {
        return new HashMap<ItemSignature, Long>(this.consolidatedItems);
    }

    public int getUsedSlots() {
        if (this.displayCacheDirty) {
            if (this.consolidatedItems.isEmpty()) {
                return 0;
            }
            int estimatedSlots = 0;
            for (Map.Entry<ItemSignature, Long> entry : this.consolidatedItems.entrySet()) {
                int maxStackSize;
                long amount = entry.getValue();
                if ((estimatedSlots += (int)Math.ceil((double)amount / (double)(maxStackSize = entry.getKey().getTemplateRef().getMaxStackSize()))) < this.maxSlots) continue;
                return this.maxSlots;
            }
            return estimatedSlots;
        }
        return this.usedSlotsCache;
    }

    private void updateMetricsCache() {
        this.totalItemsCache = this.consolidatedItems.values().stream().mapToLong(Long::longValue).sum();
        this.metricsCacheDirty = false;
    }

    public boolean isDirty() {
        return this.displayCacheDirty;
    }

    public static class ItemSignature {
        private final ItemStack template;
        private final int hashCode;
        private final String materialName;

        public ItemSignature(ItemStack item) {
            this.template = item.clone();
            this.template.setAmount(1);
            this.materialName = item.getType().name();
            this.hashCode = this.calculateHashCode();
        }

        private int calculateHashCode() {
            int result = 31 * this.template.getType().ordinal();
            result = 31 * result + this.template.getDurability();
            if (this.template.hasItemMeta()) {
                ItemMeta meta = this.template.getItemMeta();
                result = 31 * result + (meta.hasDisplayName() ? meta.getDisplayName().hashCode() : 0);
                result = 31 * result + (meta.hasLore() ? meta.getLore().hashCode() : 0);
                result = 31 * result + (meta.hasEnchants() ? meta.getEnchants().hashCode() : 0);
            }
            return result;
        }

        public boolean equals(Object o) {
            boolean thatHasMeta;
            if (this == o) {
                return true;
            }
            if (!(o instanceof ItemSignature)) {
                return false;
            }
            ItemSignature that = (ItemSignature)o;
            if (this.template.getType() != that.template.getType() || this.template.getDurability() != that.template.getDurability()) {
                return false;
            }
            boolean thisHasMeta = this.template.hasItemMeta();
            if (thisHasMeta != (thatHasMeta = that.template.hasItemMeta())) {
                return false;
            }
            if (!thisHasMeta) {
                return true;
            }
            return this.template.isSimilar(that.template);
        }

        public int hashCode() {
            return this.hashCode;
        }

        public ItemStack getTemplate() {
            return this.template.clone();
        }

        public ItemStack getTemplateRef() {
            return this.template;
        }

        public String getMaterialName() {
            return this.materialName;
        }
    }
}

