/*
 * Decompiled with CFR 0.152.
 */
package github.nighter.smartspawner.spawner.utils;

import github.nighter.smartspawner.spawner.properties.VirtualInventory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class ItemStackSerializer {
    private static final List<String> ARMOR_MATERIALS = Arrays.asList("LEATHER", "CHAINMAIL", "IRON", "GOLDEN", "DIAMOND", "NETHERITE");
    private static final List<String> ARMOR_PIECES = Arrays.asList("_HELMET", "_CHESTPLATE", "_LEGGINGS", "_BOOTS");
    private static final List<String> TOOL_TYPES = Arrays.asList("_SWORD", "_PICKAXE", "_AXE", "_SHOVEL", "_HOE");

    public static List<String> serializeInventory(Map<VirtualInventory.ItemSignature, Long> items) {
        HashMap<Material, ItemGroup> groupedItems = new HashMap<Material, ItemGroup>();
        for (Map.Entry<VirtualInventory.ItemSignature, Long> entry : items.entrySet()) {
            ItemStack template = entry.getKey().getTemplate();
            Material material = template.getType();
            ItemGroup group = groupedItems.computeIfAbsent(material, ItemGroup::new);
            if (material == Material.TIPPED_ARROW) {
                PotionMeta meta = (PotionMeta)template.getItemMeta();
                if (meta == null || meta.getCustomEffects().isEmpty()) continue;
                group.addPotionArrow((PotionEffect)meta.getCustomEffects().get(0), entry.getValue().intValue());
                continue;
            }
            if (ItemStackSerializer.isDestructibleItem(material)) {
                group.addItem(template.getDurability(), entry.getValue().intValue());
                continue;
            }
            group.addItem((short)0, entry.getValue().intValue());
        }
        ArrayList<String> serializedItems = new ArrayList<String>();
        for (ItemGroup group : groupedItems.values()) {
            boolean first;
            if (group.getMaterial() == Material.TIPPED_ARROW) {
                StringBuilder sb = new StringBuilder("TIPPED_ARROW#");
                first = true;
                for (Map.Entry<String, Integer> entry : group.getPotionEffectCount().entrySet()) {
                    if (!first) {
                        sb.append(',');
                    }
                    sb.append(entry.getKey()).append(':').append(entry.getValue());
                    first = false;
                }
                serializedItems.add(sb.toString());
                continue;
            }
            if (ItemStackSerializer.isDestructibleItem(group.getMaterial())) {
                StringBuilder sb = new StringBuilder(group.getMaterial().name());
                sb.append(';');
                first = true;
                for (Map.Entry<Object, Integer> entry : group.getDurabilityCount().entrySet()) {
                    if (!first) {
                        sb.append(',');
                    }
                    sb.append(entry.getKey()).append(':').append(entry.getValue());
                    first = false;
                }
                serializedItems.add(sb.toString());
                continue;
            }
            int totalCount = group.getDurabilityCount().values().stream().mapToInt(Integer::intValue).sum();
            serializedItems.add(group.getMaterial().name() + ":" + totalCount);
        }
        return serializedItems;
    }

    public static Map<ItemStack, Integer> deserializeInventory(List<String> data) {
        HashMap<ItemStack, Integer> result = new HashMap<ItemStack, Integer>();
        for (String entry : data) {
            Material material;
            String[] parts;
            if (entry.startsWith("TIPPED_ARROW#")) {
                String[] effectEntries;
                for (String effectEntry : effectEntries = entry.substring("TIPPED_ARROW#".length()).split(",")) {
                    String[] parts2 = effectEntry.split(":");
                    String[] effectData = parts2[0].split(";");
                    int count = Integer.parseInt(parts2[1]);
                    ItemStack arrow = new ItemStack(Material.TIPPED_ARROW);
                    PotionMeta meta = (PotionMeta)arrow.getItemMeta();
                    if (meta != null) {
                        PotionEffect effect = new PotionEffect(PotionEffectType.getByName((String)effectData[0]), Integer.parseInt(effectData[1]), Integer.parseInt(effectData[2]));
                        meta.addCustomEffect(effect, true);
                        arrow.setItemMeta((ItemMeta)meta);
                    }
                    result.put(arrow, count);
                }
                continue;
            }
            if (entry.contains(";")) {
                parts = entry.split(";");
                material = Material.valueOf((String)parts[0]);
                for (String durabilityCount : parts[1].split(",")) {
                    String[] dc = durabilityCount.split(":");
                    short durability = Short.parseShort(dc[0]);
                    int count = Integer.parseInt(dc[1]);
                    ItemStack item = new ItemStack(material);
                    item.setDurability(durability);
                    result.put(item, count);
                }
                continue;
            }
            parts = entry.split(":");
            material = Material.valueOf((String)parts[0]);
            int count = Integer.parseInt(parts[1]);
            ItemStack item = new ItemStack(material);
            result.put(item, count);
        }
        return result;
    }

    public static boolean isDestructibleItem(Material material) {
        String name = material.name();
        for (String type : TOOL_TYPES) {
            if (!name.endsWith(type)) continue;
            return true;
        }
        for (String armorMaterial : ARMOR_MATERIALS) {
            for (String armorPiece : ARMOR_PIECES) {
                if (!name.equals(armorMaterial + armorPiece)) continue;
                return true;
            }
        }
        return name.equals("BOW") || name.equals("FISHING_ROD") || name.equals("FLINT_AND_STEEL") || name.equals("SHEARS") || name.equals("SHIELD") || name.equals("ELYTRA") || name.equals("TRIDENT") || name.equals("CROSSBOW") || name.equals("CARROT_ON_A_STICK") || name.equals("WARPED_FUNGUS_ON_A_STICK");
    }

    public static class ItemGroup {
        private final Material material;
        private final Map<Short, Integer> durabilityCount;
        private final Map<String, Integer> potionEffectCount;

        public ItemGroup(Material material) {
            this.material = material;
            this.durabilityCount = new HashMap<Short, Integer>();
            this.potionEffectCount = new HashMap<String, Integer>();
        }

        public void addItem(short durability, int count) {
            this.durabilityCount.merge(durability, count, Integer::sum);
        }

        public void addPotionArrow(PotionEffect effect, int count) {
            String effectKey = this.serializePotionEffect(effect);
            this.potionEffectCount.merge(effectKey, count, Integer::sum);
        }

        private String serializePotionEffect(PotionEffect effect) {
            return String.format("%s;%d;%d", effect.getType().getName(), effect.getDuration(), effect.getAmplifier());
        }

        @Generated
        public Material getMaterial() {
            return this.material;
        }

        @Generated
        public Map<Short, Integer> getDurabilityCount() {
            return this.durabilityCount;
        }

        @Generated
        public Map<String, Integer> getPotionEffectCount() {
            return this.potionEffectCount;
        }
    }
}

