/*
 * Decompiled with CFR 0.152.
 */
package github.nighter.smartspawner.updates;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import github.nighter.smartspawner.Scheduler;
import github.nighter.smartspawner.updates.Version;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.time.LocalDate;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.event.HoverEventSource;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class UpdateChecker
implements Listener {
    private final JavaPlugin plugin;
    private final String projectId = "9tQwxSFr";
    private boolean updateAvailable = false;
    private final String currentVersion;
    private String latestVersion = "";
    private String downloadUrl = "";
    private String directLink = "";
    private static final String CONSOLE_RESET = "\u001b[0m";
    private static final String CONSOLE_BRIGHT_GREEN = "\u001b[92m";
    private static final String CONSOLE_YELLOW = "\u001b[33m";
    private static final String CONSOLE_INDIGO = "\u001b[38;5;93m";
    private static final String CONSOLE_LAVENDER = "\u001b[38;5;183m";
    private static final String CONSOLE_BRIGHT_PURPLE = "\u001b[95m";
    private final Map<UUID, LocalDate> notifiedPlayers = new HashMap<UUID, LocalDate>();

    public UpdateChecker(JavaPlugin plugin) {
        this.plugin = plugin;
        this.currentVersion = plugin.getDescription().getVersion();
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
        ((CompletableFuture)this.checkForUpdates().thenAccept(hasUpdate -> {
            if (hasUpdate.booleanValue()) {
                this.displayConsoleUpdateMessage();
            }
        })).exceptionally(ex -> {
            plugin.getLogger().warning("Failed to check for updates: " + ex.getMessage());
            return null;
        });
    }

    private void displayConsoleUpdateMessage() {
        String modrinthLink = "https://modrinth.com/plugin/9tQwxSFr/version/" + this.latestVersion;
        String frameColor = CONSOLE_INDIGO;
        this.plugin.getLogger().info(frameColor + "\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u001b[0m");
        this.plugin.getLogger().info(frameColor + "\u001b[92m         \ud83d\udd2e \ua731\u1d0d\u1d00\u0280\u1d1b\ua731\u1d18\u1d00\u1d21\u0274\u1d07\u0280 \u1d1c\u1d18\u1d05\u1d00\u1d1b\u1d07 \u1d00\u1d20\u1d00\u026a\u029f\u1d00\u0299\u029f\u1d07 \ud83d\udd2e\u001b[0m");
        this.plugin.getLogger().info(frameColor + "\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u001b[0m");
        this.plugin.getLogger().info("");
        this.plugin.getLogger().info(frameColor + "\u001b[0m\ud83d\udce6 \u1d04\u1d1c\u0280\u0280\u1d07\u0274\u1d1b \u1d20\u1d07\u0280\ua731\u026a\u1d0f\u0274: \u001b[33m" + this.formatConsoleText(this.currentVersion, 31) + CONSOLE_RESET);
        this.plugin.getLogger().info(frameColor + "\u001b[0m\u2705 \u029f\u1d00\u1d1b\u1d07\ua731\u1d1b \u1d20\u1d07\u0280\ua731\u026a\u1d0f\u0274: \u001b[92m" + this.formatConsoleText(this.latestVersion, 32) + CONSOLE_RESET);
        this.plugin.getLogger().info("");
        this.plugin.getLogger().info(frameColor + "\u001b[0m\ud83d\udce5 \u1d05\u1d0f\u1d21\u0274\u029f\u1d0f\u1d00\u1d05 \u1d1b\u029c\u1d07 \u029f\u1d00\u1d1b\u1d07\ua731\u1d1b \u1d20\u1d07\u0280\ua731\u026a\u1d0f\u0274 \u1d00\u1d1b:\u001b[0m");
        this.plugin.getLogger().info(frameColor + " \u001b[38;5;183m" + this.formatConsoleText(modrinthLink, 51) + CONSOLE_RESET);
        this.plugin.getLogger().info("");
        this.plugin.getLogger().info(frameColor + "\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u001b[0m");
    }

    private String formatConsoleText(String text, int maxLength) {
        if (text.length() > maxLength) {
            return text.substring(0, maxLength - 3) + "...";
        }
        return text + " ".repeat(maxLength - text.length());
    }

    public CompletableFuture<Boolean> checkForUpdates() {
        return CompletableFuture.supplyAsync(() -> {
            try {
                Version current;
                Version latest;
                URL url = new URL("https://api.modrinth.com/v2/project/9tQwxSFr/version");
                HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                connection.setRequestMethod("GET");
                connection.setRequestProperty("User-Agent", "SmartSpawner-UpdateChecker/1.0");
                if (connection.getResponseCode() != 200) {
                    this.plugin.getLogger().warning("Failed to check for updates. HTTP Error: " + connection.getResponseCode());
                    return false;
                }
                BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));
                String response = reader.lines().collect(Collectors.joining("\n"));
                reader.close();
                JsonArray versions = JsonParser.parseString((String)response).getAsJsonArray();
                if (versions.isEmpty()) {
                    return false;
                }
                JsonObject latestVersionObj = null;
                for (JsonElement element : versions) {
                    JsonObject version = element.getAsJsonObject();
                    String versionType = version.get("version_type").getAsString();
                    if (!versionType.equals("release")) continue;
                    if (latestVersionObj == null) {
                        latestVersionObj = version;
                        continue;
                    }
                    String currentDate = latestVersionObj.get("date_published").getAsString();
                    String newDate = version.get("date_published").getAsString();
                    if (newDate.compareTo(currentDate) <= 0) continue;
                    latestVersionObj = version;
                }
                if (latestVersionObj == null) {
                    return false;
                }
                this.latestVersion = latestVersionObj.get("version_number").getAsString();
                String versionId = latestVersionObj.get("id").getAsString();
                this.downloadUrl = "https://modrinth.com/plugin/9tQwxSFr/version/" + this.latestVersion;
                JsonArray files = latestVersionObj.getAsJsonArray("files");
                if (!files.isEmpty()) {
                    JsonObject primaryFile = files.get(0).getAsJsonObject();
                    this.directLink = primaryFile.get("url").getAsString();
                }
                this.updateAvailable = (latest = new Version(this.latestVersion)).compareTo(current = new Version(this.currentVersion)) > 0;
                return this.updateAvailable;
            }
            catch (Exception e) {
                this.plugin.getLogger().warning("Error checking for updates: " + e.getMessage());
                e.printStackTrace();
                return false;
            }
        });
    }

    private void sendUpdateNotification(Player player) {
        if (!this.updateAvailable || !player.hasPermission("smartspawner.update.notify")) {
            return;
        }
        TextColor primaryPurple = TextColor.fromHexString((String)"#ab7afd");
        TextColor deepPurple = TextColor.fromHexString((String)"#7b68ee");
        TextColor indigo = TextColor.fromHexString((String)"#5B2C6F");
        TextColor brightGreen = TextColor.fromHexString((String)"#37eb9a");
        TextColor yellow = TextColor.fromHexString((String)"#f0c857");
        TextColor white = TextColor.fromHexString((String)"#e6e6fa");
        Component borderTop = Component.text((String)"\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501 \ua731\u1d0d\u1d00\u0280\u1d1b\ua731\u1d18\u1d00\u1d21\u0274\u1d07\u0280 \u1d1c\u1d18\u1d05\u1d00\u1d1b\u1d07 \u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501").color(deepPurple);
        Component borderBottom = Component.text((String)"\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501").color(deepPurple);
        Component updateMsg = Component.text((String)"\u27a4 \u0274\u1d07\u1d21 \u1d1c\u1d18\u1d05\u1d00\u1d1b\u1d07 \u1d00\u1d20\u1d00\u026a\u029f\u1d00\u0299\u029f\u1d07!").color(brightGreen);
        Component versionsComponent = ((TextComponent)((TextComponent)((TextComponent)Component.text((String)"\u2726 \u1d04\u1d1c\u0280\u0280\u1d07\u0274\u1d1b: ").color(white)).append(Component.text((String)this.currentVersion).color(yellow))).append(Component.text((String)"  \u2726 \u029f\u1d00\u1d1b\u1d07\ua731\u1d1b: ").color(white))).append(Component.text((String)this.latestVersion).color(brightGreen));
        Component downloadButton = ((TextComponent)((TextComponent)Component.text((String)"\u25b6 [\u1d04\u029f\u026a\u1d04\u1d0b \u1d1b\u1d0f \u1d05\u1d0f\u1d21\u0274\u029f\u1d0f\u1d00\u1d05 \u029f\u1d00\u1d1b\u1d07\ua731\u1d1b \u1d20\u1d07\u0280\ua731\u026a\u1d0f\u0274]").color(primaryPurple)).clickEvent(ClickEvent.openUrl((String)this.downloadUrl))).hoverEvent((HoverEventSource)HoverEvent.showText((Component)((TextComponent)Component.text((String)"\u1d05\u1d0f\u1d21\u0274\u029f\u1d0f\u1d00\u1d05 \u1d20\u1d07\u0280\ua731\u026a\u1d0f\u0274 ").color(white)).append(Component.text((String)this.latestVersion).color(brightGreen))));
        player.sendMessage(" ");
        player.sendMessage(borderTop);
        player.sendMessage(" ");
        player.sendMessage(updateMsg);
        player.sendMessage(versionsComponent);
        player.sendMessage(downloadButton);
        player.sendMessage(" ");
        player.sendMessage(borderBottom);
        player.playSound(player.getLocation(), Sound.ENTITY_PLAYER_LEVELUP, 0.8f, 1.2f);
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        if (player.hasPermission("smartspawner.update.notify")) {
            UUID playerId = player.getUniqueId();
            LocalDate today = LocalDate.now();
            this.notifiedPlayers.entrySet().removeIf(entry -> ((LocalDate)entry.getValue()).isBefore(today));
            if (this.notifiedPlayers.containsKey(playerId) && this.notifiedPlayers.get(playerId).isEqual(today)) {
                return;
            }
            if (this.updateAvailable) {
                Scheduler.runTaskLater(() -> {
                    this.sendUpdateNotification(player);
                    this.notifiedPlayers.put(playerId, today);
                }, 40L);
            } else {
                this.checkForUpdates().thenAccept(hasUpdate -> {
                    if (hasUpdate.booleanValue()) {
                        Scheduler.runTask(() -> {
                            this.sendUpdateNotification(player);
                            this.notifiedPlayers.put(playerId, today);
                        });
                    }
                });
            }
        }
    }
}

