/*
 * Decompiled with CFR 0.152.
 */
package github.nighter.smartspawner.commands;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import github.nighter.smartspawner.SmartSpawner;
import github.nighter.smartspawner.logging.SpawnerEventType;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.Commands;
import lombok.Generated;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.command.RemoteConsoleCommandSender;
import org.bukkit.entity.Player;
import org.jspecify.annotations.NullMarked;

@NullMarked
public abstract class BaseSubCommand {
    protected final SmartSpawner plugin;

    public abstract String getName();

    public abstract String getPermission();

    public abstract String getDescription();

    public abstract int execute(CommandContext<CommandSourceStack> var1);

    public LiteralArgumentBuilder<CommandSourceStack> build() {
        LiteralArgumentBuilder builder = Commands.literal((String)this.getName());
        builder.requires(source -> this.hasPermission(source.getSender()));
        builder.executes(context -> {
            this.logCommandExecution((CommandContext<CommandSourceStack>)context);
            return this.execute((CommandContext<CommandSourceStack>)context);
        });
        return builder;
    }

    protected boolean hasPermission(CommandSender sender) {
        if (sender instanceof ConsoleCommandSender || sender instanceof RemoteConsoleCommandSender) {
            return true;
        }
        return sender.hasPermission(this.getPermission()) || sender.isOp();
    }

    protected boolean isPlayer(CommandSender sender) {
        return sender instanceof Player;
    }

    protected Player getPlayer(CommandSender sender) {
        if (this.isPlayer(sender)) {
            return (Player)sender;
        }
        return null;
    }

    protected boolean isConsoleOrRcon(CommandSender sender) {
        return sender instanceof ConsoleCommandSender || sender instanceof RemoteConsoleCommandSender;
    }

    protected void logCommandExecution(CommandContext<CommandSourceStack> context) {
        if (this.plugin.getSpawnerActionLogger() == null) {
            return;
        }
        CommandSender sender = ((CommandSourceStack)context.getSource()).getSender();
        SpawnerEventType eventType = sender instanceof RemoteConsoleCommandSender ? SpawnerEventType.COMMAND_EXECUTE_RCON : (sender instanceof ConsoleCommandSender ? SpawnerEventType.COMMAND_EXECUTE_CONSOLE : SpawnerEventType.COMMAND_EXECUTE_PLAYER);
        this.plugin.getSpawnerActionLogger().log(eventType, builder -> {
            if (sender instanceof Player) {
                Player player = (Player)sender;
                builder.player(player.getName(), player.getUniqueId());
            } else {
                builder.metadata("sender", sender.getName());
            }
            builder.metadata("command", this.getName());
            builder.metadata("full_command", context.getInput());
        });
    }

    @Generated
    public BaseSubCommand(SmartSpawner plugin) {
        this.plugin = plugin;
    }
}

