/*
 * Decompiled with CFR 0.152.
 */
package github.nighter.smartspawner.commands.list.gui.management;

import github.nighter.smartspawner.SmartSpawner;
import github.nighter.smartspawner.commands.list.gui.management.SpawnerManagementHolder;
import github.nighter.smartspawner.language.LanguageManager;
import github.nighter.smartspawner.language.MessageService;
import github.nighter.smartspawner.spawner.properties.SpawnerData;
import github.nighter.smartspawner.spawner.properties.SpawnerManager;
import java.util.Arrays;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class SpawnerManagementGUI {
    private static final int INVENTORY_SIZE = 27;
    private static final int TELEPORT_SLOT = 10;
    private static final int OPEN_SPAWNER_SLOT = 12;
    private static final int STACK_SLOT = 14;
    private static final int REMOVE_SLOT = 16;
    private static final int BACK_SLOT = 26;
    private final SmartSpawner plugin;
    private final LanguageManager languageManager;
    private final MessageService messageService;
    private final SpawnerManager spawnerManager;

    public SpawnerManagementGUI(SmartSpawner plugin) {
        this.plugin = plugin;
        this.languageManager = plugin.getLanguageManager();
        this.messageService = plugin.getMessageService();
        this.spawnerManager = plugin.getSpawnerManager();
    }

    public void openManagementMenu(Player player, String spawnerId, String worldName, int listPage) {
        SpawnerData spawner = this.spawnerManager.getSpawnerById(spawnerId);
        if (spawner == null) {
            this.messageService.sendMessage(player, "spawner_not_found");
            return;
        }
        String title = this.languageManager.getGuiTitle("spawner_management.title");
        Inventory inv = Bukkit.createInventory((InventoryHolder)new SpawnerManagementHolder(spawnerId, worldName, listPage), (int)27, (String)title);
        player.playSound(player.getLocation(), Sound.UI_BUTTON_CLICK, 1.0f, 1.0f);
        this.createActionItem(inv, 10, "spawner_management.teleport", Material.ENDER_PEARL);
        this.createActionItem(inv, 12, "spawner_management.open_spawner", Material.ENDER_EYE);
        this.createActionItem(inv, 14, "spawner_management.stack", Material.SPAWNER);
        this.createActionItem(inv, 16, "spawner_management.remove", Material.BARRIER);
        this.createActionItem(inv, 26, "spawner_management.back", Material.RED_STAINED_GLASS_PANE);
        player.openInventory(inv);
    }

    private void createActionItem(Inventory inv, int slot, String langKey, Material material) {
        ItemStack item = new ItemStack(material);
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            meta.setDisplayName(this.languageManager.getGuiItemName(langKey + ".name"));
            List<String> lore = Arrays.asList(this.languageManager.getGuiItemLore(langKey + ".lore"));
            meta.setLore(lore);
            meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS, ItemFlag.HIDE_ATTRIBUTES, ItemFlag.HIDE_ADDITIONAL_TOOLTIP, ItemFlag.HIDE_UNBREAKABLE});
            item.setItemMeta(meta);
        }
        inv.setItem(slot, item);
    }
}

