/*
 * Decompiled with CFR 0.152.
 */
package github.nighter.smartspawner.hooks.economy.shops.providers.shopguiplus;

import github.nighter.smartspawner.Scheduler;
import github.nighter.smartspawner.SmartSpawner;
import net.brcdev.shopgui.ShopGuiPlusApi;
import net.brcdev.shopgui.event.ShopGUIPlusPostEnableEvent;
import net.brcdev.shopgui.event.ShopsPostLoadEvent;
import net.brcdev.shopgui.exception.api.ExternalSpawnerProviderNameConflictException;
import net.brcdev.shopgui.spawner.external.provider.ExternalSpawnerProvider;
import org.bukkit.Bukkit;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;

public class SpawnerHook
implements Listener {
    private final SmartSpawner plugin;

    public SpawnerHook(SmartSpawner plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onShopGUIPlusPostEnable(ShopGUIPlusPostEnableEvent event) {
        if (Bukkit.getPluginManager().getPlugin("ShopGUIPlus") != null) {
            try {
                ShopGuiPlusApi.registerSpawnerProvider((ExternalSpawnerProvider)this.plugin.getSpawnerProvider());
            }
            catch (ExternalSpawnerProviderNameConflictException e) {
                this.plugin.getLogger().warning("Failed to hook spawner into ShopGUI+: " + e.getMessage());
            }
            this.plugin.getLogger().info("Registered spawner provider in ShopGUI+!");
        }
    }

    @EventHandler
    public void onShopsPostLoad(ShopsPostLoadEvent event) {
        Scheduler.runTaskLater(() -> {
            this.plugin.getItemPriceManager().reloadShopIntegration();
            this.plugin.getEntityLootRegistry().loadConfigurations();
            this.plugin.getSpawnerManager().reloadSpawnerDrops();
        }, 100L);
    }

    public void unregister() {
        ShopGUIPlusPostEnableEvent.getHandlerList().unregister((Listener)this);
        ShopsPostLoadEvent.getHandlerList().unregister((Listener)this);
    }
}

