/*
 * Decompiled with CFR 0.152.
 */
package github.nighter.smartspawner.spawner.gui.storage;

import github.nighter.smartspawner.Scheduler;
import github.nighter.smartspawner.SmartSpawner;
import github.nighter.smartspawner.language.LanguageManager;
import github.nighter.smartspawner.spawner.gui.layout.GuiButton;
import github.nighter.smartspawner.spawner.gui.layout.GuiLayout;
import github.nighter.smartspawner.spawner.gui.layout.GuiLayoutConfig;
import github.nighter.smartspawner.spawner.gui.storage.StoragePageHolder;
import github.nighter.smartspawner.spawner.loot.LootItem;
import github.nighter.smartspawner.spawner.properties.SpawnerData;
import github.nighter.smartspawner.spawner.properties.VirtualInventory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class SpawnerStorageUI {
    private static final int INVENTORY_SIZE = 54;
    private final SmartSpawner plugin;
    private final LanguageManager languageManager;
    private GuiLayoutConfig layoutConfig;
    private final Map<String, ItemStack> staticButtons;
    private final Map<String, ItemStack> navigationButtonCache;
    private final Map<String, ItemStack> pageIndicatorCache;
    private static final int MAX_CACHE_SIZE = 100;
    private String cachedStorageTitleFormat = null;
    private Scheduler.Task cleanupTask;

    public SpawnerStorageUI(SmartSpawner plugin) {
        this.plugin = plugin;
        this.languageManager = plugin.getLanguageManager();
        this.layoutConfig = plugin.getGuiLayoutConfig();
        this.staticButtons = new HashMap<String, ItemStack>(8);
        this.navigationButtonCache = new ConcurrentHashMap<String, ItemStack>(16);
        this.pageIndicatorCache = new ConcurrentHashMap<String, ItemStack>(16);
        this.initializeStaticButtons();
        this.startCleanupTask();
    }

    public void reload() {
        this.layoutConfig = this.plugin.getGuiLayoutConfig();
        this.navigationButtonCache.clear();
        this.pageIndicatorCache.clear();
        this.staticButtons.clear();
        this.cachedStorageTitleFormat = null;
        this.initializeStaticButtons();
    }

    private void initializeStaticButtons() {
        GuiButton itemFilterButton;
        GuiButton dropPageButton;
        GuiButton sortItemsButton;
        GuiButton takeAllButton;
        GuiLayout layout = this.layoutConfig.getCurrentLayout();
        GuiButton returnButton = layout.getButton("return");
        if (returnButton != null) {
            this.staticButtons.put("return", this.createButton(returnButton.getMaterial(), this.languageManager.getGuiItemName("return_button.name"), this.languageManager.getGuiItemLoreAsList("return_button.lore")));
        }
        if ((takeAllButton = layout.getButton("take_all")) != null) {
            this.staticButtons.put("takeAll", this.createButton(takeAllButton.getMaterial(), this.languageManager.getGuiItemName("take_all_button.name"), this.languageManager.getGuiItemLoreAsList("take_all_button.lore")));
        }
        if ((sortItemsButton = layout.getButton("sort_items")) != null) {
            this.staticButtons.put("sortItems", this.createButton(sortItemsButton.getMaterial(), this.languageManager.getGuiItemName("sort_items_button.name"), this.languageManager.getGuiItemLoreAsList("sort_items_button.lore")));
        }
        if ((dropPageButton = layout.getButton("drop_page")) != null) {
            this.staticButtons.put("dropPage", this.createButton(dropPageButton.getMaterial(), this.languageManager.getGuiItemName("drop_page_button.name"), this.languageManager.getGuiItemLoreAsList("drop_page_button.lore")));
        }
        if ((itemFilterButton = layout.getButton("item_filter")) != null) {
            this.staticButtons.put("itemFilter", this.createButton(itemFilterButton.getMaterial(), this.languageManager.getGuiItemName("item_filter_button.name"), this.languageManager.getGuiItemLoreAsList("item_filter_button.lore")));
        }
    }

    private String getStorageTitle(int page, int totalPages) {
        if (this.cachedStorageTitleFormat == null) {
            this.cachedStorageTitleFormat = this.languageManager.getGuiTitle("gui_title_storage");
        }
        return this.languageManager.getGuiTitle("gui_title_storage", Map.of("current_page", String.valueOf(page), "total_pages", String.valueOf(totalPages)));
    }

    public Inventory createInventory(SpawnerData spawner, String title, int page, int totalPages) {
        if (totalPages == -1) {
            totalPages = this.calculateTotalPages(spawner);
        }
        page = Math.max(1, Math.min(page, totalPages));
        Inventory pageInv = Bukkit.createInventory((InventoryHolder)new StoragePageHolder(spawner, page, totalPages), (int)54, (String)this.getStorageTitle(page, totalPages));
        StoragePageHolder holder = (StoragePageHolder)pageInv.getHolder(false);
        holder.setInventory(pageInv);
        holder.updateOldUsedSlots();
        this.updateDisplay(pageInv, spawner, page, totalPages);
        return pageInv;
    }

    public void updateDisplay(Inventory inventory, SpawnerData spawner, int page, int totalPages) {
        int currentUsedSlots;
        if (totalPages == -1) {
            totalPages = this.calculateTotalPages(spawner);
        }
        HashMap<Integer, ItemStack> updates = new HashMap<Integer, ItemStack>();
        HashSet<Integer> slotsToEmpty = new HashSet<Integer>();
        for (int i = 0; i < 45; ++i) {
            slotsToEmpty.add(i);
        }
        this.addPageItems(updates, slotsToEmpty, spawner, page);
        this.addNavigationButtons(updates, spawner, page, totalPages);
        Iterator<Object> i = slotsToEmpty.iterator();
        while (i.hasNext()) {
            int n = (Integer)i.next();
            if (updates.containsKey(n)) continue;
            inventory.setItem(n, null);
        }
        for (Map.Entry entry : updates.entrySet()) {
            inventory.setItem(((Integer)entry.getKey()).intValue(), (ItemStack)entry.getValue());
        }
        if (this.plugin.getConfig().getBoolean("hologram.enabled", false)) {
            Scheduler.runLocationTask(spawner.getSpawnerLocation(), spawner::updateHologramData);
        }
        StoragePageHolder holder = (StoragePageHolder)inventory.getHolder(false);
        assert (holder != null);
        int n = holder.getOldUsedSlots();
        if (n != (currentUsedSlots = spawner.getVirtualInventory().getUsedSlots())) {
            int newTotalPages = this.calculateTotalPages(spawner);
            holder.setTotalPages(newTotalPages);
            holder.updateOldUsedSlots();
        }
    }

    private void addPageItems(Map<Integer, ItemStack> updates, Set<Integer> slotsToEmpty, SpawnerData spawner, int page) {
        VirtualInventory virtualInv = spawner.getVirtualInventory();
        Map<Integer, ItemStack> displayItems = virtualInv.getDisplayInventory();
        if (displayItems.isEmpty()) {
            return;
        }
        int startIndex = (page - 1) * 45;
        for (Map.Entry<Integer, ItemStack> entry : displayItems.entrySet()) {
            int globalIndex = entry.getKey();
            if (globalIndex < startIndex || globalIndex >= startIndex + 45) continue;
            int displaySlot = globalIndex - startIndex;
            updates.put(displaySlot, entry.getValue());
            slotsToEmpty.remove(displaySlot);
        }
    }

    private void addNavigationButtons(Map<Integer, ItemStack> updates, SpawnerData spawner, int page, int totalPages) {
        String cacheKey;
        if (totalPages == -1) {
            totalPages = this.calculateTotalPages(spawner);
        }
        GuiLayout layout = this.layoutConfig.getCurrentLayout();
        if (page > 1 && layout.hasButton("previous_page")) {
            GuiButton prevButton = layout.getButton("previous_page");
            cacheKey = "prev-" + (page - 1);
            ItemStack prevItem = this.navigationButtonCache.computeIfAbsent(cacheKey, k -> this.createNavigationButton("previous", page - 1, prevButton.getMaterial()));
            updates.put(prevButton.getSlot(), prevItem);
        }
        if (page < totalPages && layout.hasButton("next_page")) {
            GuiButton nextButton = layout.getButton("next_page");
            cacheKey = "next-" + (page + 1);
            ItemStack nextItem = this.navigationButtonCache.computeIfAbsent(cacheKey, k -> this.createNavigationButton("next", page + 1, nextButton.getMaterial()));
            updates.put(nextButton.getSlot(), nextItem);
        }
        if (layout.hasButton("take_all")) {
            GuiButton takeAllButton = layout.getButton("take_all");
            updates.put(takeAllButton.getSlot(), this.staticButtons.get("takeAll"));
        }
        if (layout.hasButton("sort_items")) {
            GuiButton sortItemsButton = layout.getButton("sort_items");
            ItemStack sortButton = this.createSortButton(spawner, sortItemsButton.getMaterial());
            updates.put(sortItemsButton.getSlot(), sortButton);
        }
        if (layout.hasButton("drop_page")) {
            GuiButton dropPageButton = layout.getButton("drop_page");
            updates.put(dropPageButton.getSlot(), this.staticButtons.get("dropPage"));
        }
        if (layout.hasButton("item_filter")) {
            GuiButton itemFilterButton = layout.getButton("item_filter");
            updates.put(itemFilterButton.getSlot(), this.staticButtons.get("itemFilter"));
        }
        if (layout.hasButton("return")) {
            GuiButton returnButton = layout.getButton("return");
            updates.put(returnButton.getSlot(), this.staticButtons.get("return"));
        }
        if (layout.hasButton("sell_all")) {
            GuiButton sellButton = layout.getButton("sell_all");
            ItemStack sellIndicator = this.createSellButton(spawner, sellButton.getMaterial());
            updates.put(sellButton.getSlot(), sellIndicator);
        }
    }

    private int calculateTotalPages(SpawnerData spawner) {
        int usedSlots = spawner.getVirtualInventory().getUsedSlots();
        return Math.max(1, (int)Math.ceil((double)usedSlots / 45.0));
    }

    private ItemStack createButton(Material material, String name, List<String> lore) {
        ItemStack item = new ItemStack(material);
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            meta.setDisplayName(name);
            if (!lore.isEmpty()) {
                meta.setLore(lore);
            }
            item.setItemMeta(meta);
        }
        return item;
    }

    private ItemStack createNavigationButton(String type, int targetPage, Material material) {
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("target_page", String.valueOf(targetPage));
        String buttonKey = type.equals("previous") ? "navigation_button_previous" : "navigation_button_next";
        String buttonName = this.languageManager.getGuiItemName(buttonKey + ".name", placeholders);
        String[] buttonLore = this.languageManager.getGuiItemLore(buttonKey + ".lore", placeholders);
        return this.createButton(material, buttonName, Arrays.asList(buttonLore));
    }

    private ItemStack createSellButton(SpawnerData spawner, Material material) {
        HashMap<String, String> placeholders = new HashMap<String, String>();
        if (spawner.isSellValueDirty()) {
            spawner.recalculateSellValue();
        }
        double totalSellPrice = spawner.getAccumulatedSellValue();
        placeholders.put("total_sell_price", this.languageManager.formatNumber(totalSellPrice));
        String name = this.languageManager.getGuiItemName("sell_button.name", placeholders);
        List<String> lore = this.languageManager.getGuiItemLoreAsList("sell_button.lore");
        return this.createButton(material, name, lore);
    }

    private ItemStack createSortButton(SpawnerData spawner, Material material) {
        HashMap<String, String> placeholders = new HashMap<String, String>();
        Material currentSort = spawner.getPreferredSortItem();
        String selectedItemFormat = this.languageManager.getGuiItemName("sort_items_button.selected_item");
        String unselectedItemFormat = this.languageManager.getGuiItemName("sort_items_button.unselected_item");
        String noneText = this.languageManager.getGuiItemName("sort_items_button.no_item");
        StringBuilder availableItems = new StringBuilder();
        if (spawner.getLootConfig() != null && spawner.getLootConfig().getAllItems() != null) {
            boolean first = true;
            List<LootItem> sortedLoot = spawner.getLootConfig().getAllItems().stream().sorted(Comparator.comparing(item -> item.getMaterial().name())).toList();
            for (LootItem lootItem : sortedLoot) {
                if (!first) {
                    availableItems.append("\n");
                }
                String itemName = this.languageManager.getVanillaItemName(lootItem.getMaterial());
                String format = currentSort == lootItem.getMaterial() ? selectedItemFormat : unselectedItemFormat;
                String formattedItem = format.replace("%item_name%", itemName);
                availableItems.append(formattedItem);
                first = false;
            }
        }
        if (availableItems.isEmpty()) {
            availableItems.append(noneText);
        }
        placeholders.put("available_items", availableItems.toString());
        String name = this.languageManager.getGuiItemName("sort_items_button.name", placeholders);
        List<String> lore = this.languageManager.getGuiItemLoreWithMultilinePlaceholders("sort_items_button.lore", placeholders);
        return this.createButton(material, name, lore);
    }

    private void startCleanupTask() {
        this.cleanupTask = Scheduler.runTaskTimer(this::cleanupCaches, 600L, 600L);
    }

    public void cancelTasks() {
        if (this.cleanupTask != null) {
            this.cleanupTask.cancel();
            this.cleanupTask = null;
        }
    }

    private void cleanupCaches() {
        int i;
        ArrayList<String> keysToRemove;
        int toRemove;
        if (this.navigationButtonCache.size() > 100) {
            toRemove = this.navigationButtonCache.size() - 50;
            keysToRemove = new ArrayList<String>(this.navigationButtonCache.keySet());
            for (i = 0; i < Math.min(toRemove, keysToRemove.size()); ++i) {
                this.navigationButtonCache.remove(keysToRemove.get(i));
            }
        }
        if (this.pageIndicatorCache.size() > 100) {
            toRemove = this.pageIndicatorCache.size() - 50;
            keysToRemove = new ArrayList<String>(this.pageIndicatorCache.keySet());
            for (i = 0; i < Math.min(toRemove, keysToRemove.size()); ++i) {
                this.pageIndicatorCache.remove(keysToRemove.get(i));
            }
        }
    }

    public void cleanup() {
        this.navigationButtonCache.clear();
        this.pageIndicatorCache.clear();
        this.cachedStorageTitleFormat = null;
        this.cancelTasks();
        this.initializeStaticButtons();
    }

    @Generated
    public GuiLayoutConfig getLayoutConfig() {
        return this.layoutConfig;
    }
}

