/*
 * Decompiled with CFR 0.152.
 */
package github.nighter.smartspawner.spawner.interactions.click;

import github.nighter.smartspawner.Scheduler;
import github.nighter.smartspawner.SmartSpawner;
import github.nighter.smartspawner.hooks.protections.CheckOpenMenu;
import github.nighter.smartspawner.language.MessageService;
import github.nighter.smartspawner.spawner.gui.main.SpawnerMenuFormUI;
import github.nighter.smartspawner.spawner.gui.main.SpawnerMenuUI;
import github.nighter.smartspawner.spawner.interactions.stack.SpawnerStackHandler;
import github.nighter.smartspawner.spawner.interactions.type.SpawnEggHandler;
import github.nighter.smartspawner.spawner.properties.SpawnerData;
import github.nighter.smartspawner.spawner.properties.SpawnerManager;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.CreatureSpawner;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;

public class SpawnerClickManager
implements Listener {
    private static final long COOLDOWN_MS = 250L;
    private static final long CLEANUP_INTERVAL_TICKS = 6000L;
    private final SmartSpawner plugin;
    private final MessageService messageService;
    private final SpawnerManager spawnerManager;
    private final SpawnEggHandler spawnEggHandler;
    private final SpawnerStackHandler spawnerStackHandler;
    private final SpawnerMenuUI spawnerMenuUI;
    private final SpawnerMenuFormUI spawnerMenuFormUI;
    private final Map<UUID, Long> playerCooldowns = new ConcurrentHashMap<UUID, Long>();

    public SpawnerClickManager(SmartSpawner plugin) {
        this.plugin = plugin;
        this.messageService = plugin.getMessageService();
        this.spawnerManager = plugin.getSpawnerManager();
        this.spawnEggHandler = plugin.getSpawnEggHandler();
        this.spawnerStackHandler = plugin.getSpawnerStackHandler();
        this.spawnerMenuUI = plugin.getSpawnerMenuUI();
        this.spawnerMenuFormUI = plugin.getSpawnerMenuFormUI();
        this.initCleanupTask();
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onSpawnerClick(PlayerInteractEvent event) {
        if (!this.isValidSpawnerInteraction(event)) {
            return;
        }
        Player player = event.getPlayer();
        Block block = event.getClickedBlock();
        SpawnerData spawner = this.spawnerManager.getSpawnerByLocation(block.getLocation());
        if (spawner == null) {
            return;
        }
        if (!this.isInteractionAllowed(player)) {
            event.setCancelled(true);
            return;
        }
        ItemStack heldItem = player.getInventory().getItemInMainHand();
        ItemStack offhandItem = player.getInventory().getItemInOffHand();
        Material itemType = heldItem.getType();
        Material offhandType = offhandItem.getType();
        if (this.shouldAllowNormalBlockPlacement(player, itemType)) {
            return;
        }
        if (this.isBedrockPlayerUsingTool(player, itemType)) {
            return;
        }
        if (this.isArmor(itemType) || this.isArmor(offhandType)) {
            return;
        }
        event.setCancelled(true);
        this.handleSpawnerInteraction(player, block, heldItem, itemType, spawner);
    }

    private boolean isValidSpawnerInteraction(PlayerInteractEvent event) {
        return event.getAction() == Action.RIGHT_CLICK_BLOCK && event.getClickedBlock() != null && event.getClickedBlock().getType() == Material.SPAWNER;
    }

    private boolean isInteractionAllowed(Player player) {
        long currentTime = System.currentTimeMillis();
        Long lastInteraction = this.playerCooldowns.get(player.getUniqueId());
        if (lastInteraction != null && currentTime - lastInteraction < 250L) {
            return false;
        }
        this.playerCooldowns.put(player.getUniqueId(), currentTime);
        return true;
    }

    private boolean shouldAllowNormalBlockPlacement(Player player, Material itemType) {
        return player.isSneaking() && itemType.isBlock() && itemType != Material.SPAWNER;
    }

    private boolean isBedrockPlayerUsingTool(Player player, Material itemType) {
        if (!this.isBedrockPlayer(player)) {
            return false;
        }
        String itemName = itemType.name();
        boolean isTool = itemName.endsWith("_PICKAXE") || itemName.endsWith("_SHOVEL") || itemName.endsWith("_HOE") || itemName.endsWith("_AXE");
        return isTool;
    }

    private boolean isArmor(Material material) {
        String name = material.name();
        return name.endsWith("_HELMET") || name.endsWith("_CHESTPLATE") || name.endsWith("_LEGGINGS") || name.endsWith("_BOOTS") || material == Material.ELYTRA || material == Material.CARVED_PUMPKIN || material == Material.SKELETON_SKULL || material == Material.WITHER_SKELETON_SKULL || material == Material.ZOMBIE_HEAD || material == Material.PLAYER_HEAD || material == Material.DRAGON_HEAD || material == Material.PIGLIN_HEAD || material == Material.CREEPER_HEAD || material == Material.TURTLE_HELMET;
    }

    private void handleSpawnerInteraction(Player player, Block block, ItemStack heldItem, Material itemType, SpawnerData spawner) {
        if (!CheckOpenMenu.CanPlayerOpenMenu(player, block.getLocation())) {
            this.messageService.sendMessage(player, "spawner_protected");
            return;
        }
        if (this.isSpawnEgg(itemType)) {
            this.spawnEggHandler.handleSpawnEggUse(player, (CreatureSpawner)block.getState(false), spawner, heldItem);
            return;
        }
        if (itemType == Material.SPAWNER) {
            this.spawnerStackHandler.handleSpawnerStacking(player, block, spawner, heldItem);
            return;
        }
        this.openSpawnerMenu(player, spawner);
    }

    private void openSpawnerMenu(Player player, SpawnerData spawner) {
        if (this.isBedrockPlayer(player)) {
            if (this.spawnerMenuFormUI != null) {
                this.spawnerMenuFormUI.openSpawnerForm(player, spawner);
            } else {
                this.spawnerMenuUI.openSpawnerMenu(player, spawner, false);
            }
        } else {
            this.spawnerMenuUI.openSpawnerMenu(player, spawner, false);
        }
    }

    private boolean isSpawnEgg(Material material) {
        return material.name().endsWith("_SPAWN_EGG");
    }

    private boolean isBedrockPlayer(Player player) {
        if (this.plugin.getIntegrationManager() == null || this.plugin.getIntegrationManager().getFloodgateHook() == null) {
            return false;
        }
        return this.plugin.getIntegrationManager().getFloodgateHook().isBedrockPlayer(player);
    }

    private void initCleanupTask() {
        Scheduler.runTaskTimer(this::cleanupCooldowns, 6000L, 6000L);
    }

    public void cleanupCooldowns() {
        long expirationThreshold = System.currentTimeMillis() - 2500L;
        this.playerCooldowns.entrySet().removeIf(entry -> (Long)entry.getValue() < expirationThreshold);
    }

    public void cleanup() {
        this.playerCooldowns.clear();
    }
}

