/*
 * Decompiled with CFR 0.152.
 */
package github.nighter.smartspawner.spawner.lootgen;

import com.google.common.collect.ImmutableList;
import github.nighter.smartspawner.Scheduler;
import github.nighter.smartspawner.SmartSpawner;
import github.nighter.smartspawner.spawner.lootgen.RangeMath;
import github.nighter.smartspawner.spawner.lootgen.SpawnerLootGenerator;
import github.nighter.smartspawner.spawner.properties.SpawnerData;
import github.nighter.smartspawner.spawner.properties.SpawnerManager;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.bukkit.Bukkit;
import org.bukkit.Location;

public class SpawnerRangeChecker {
    private static final long CHECK_INTERVAL = 20L;
    private final SmartSpawner plugin;
    private final SpawnerManager spawnerManager;
    private final SpawnerLootGenerator spawnerLootGenerator;
    private final Map<String, Scheduler.Task> spawnerTasks;
    private final ExecutorService executor;
    private final Object spawnerStateLock = new Object();

    public SpawnerRangeChecker(SmartSpawner plugin) {
        this.plugin = plugin;
        this.spawnerManager = plugin.getSpawnerManager();
        this.spawnerLootGenerator = plugin.getSpawnerLootGenerator();
        this.spawnerTasks = new ConcurrentHashMap<String, Scheduler.Task>();
        this.executor = Executors.newSingleThreadExecutor();
        this.initializeRangeCheckTask();
    }

    private void initializeRangeCheckTask() {
        Scheduler.runTaskTimer(this::scheduleRegionSpecificCheck, 20L, 20L);
    }

    private void scheduleRegionSpecificCheck() {
        List<SpawnerData> allSpawners = this.spawnerManager.getAllSpawners();
        ImmutableList onlinePlayers = ImmutableList.copyOf((Collection)Bukkit.getOnlinePlayers());
        this.executor.execute(() -> this.lambda$scheduleRegionSpecificCheck$1((List)onlinePlayers, allSpawners));
    }

    private boolean isSpawnerValid(SpawnerData spawner) {
        SpawnerData current = this.spawnerManager.getSpawnerById(spawner.getSpawnerId());
        if (current == null) {
            return false;
        }
        if (current != spawner) {
            return false;
        }
        Location loc = spawner.getSpawnerLocation();
        return loc != null && loc.getWorld() != null;
    }

    private void cleanupRemovedSpawner(String spawnerId) {
        Scheduler.Task task = this.spawnerTasks.remove(spawnerId);
        if (task != null) {
            task.cancel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleSpawnerStateChange(SpawnerData spawner, boolean shouldStop) {
        Object object = this.spawnerStateLock;
        synchronized (object) {
            if (!shouldStop) {
                this.activateSpawner(spawner);
            } else {
                this.deactivateSpawner(spawner);
            }
        }
        if (this.plugin.getSpawnerGuiViewManager().hasViewers(spawner)) {
            this.plugin.getSpawnerGuiViewManager().forceStateChangeUpdate(spawner);
        }
    }

    public void activateSpawner(SpawnerData spawner) {
        this.startSpawnerTask(spawner);
    }

    private void deactivateSpawner(SpawnerData spawner) {
        this.stopSpawnerTask(spawner);
    }

    private void startSpawnerTask(SpawnerData spawner) {
        this.stopSpawnerTask(spawner);
        long currentTime = System.currentTimeMillis();
        spawner.setLastSpawnTime(currentTime);
        Scheduler.Task task = Scheduler.runTaskTimer(() -> {
            if (!spawner.getSpawnerStop().get()) {
                this.spawnerLootGenerator.spawnLootToSpawner(spawner);
            }
        }, spawner.getSpawnDelay(), spawner.getSpawnDelay());
        this.spawnerTasks.put(spawner.getSpawnerId(), task);
        if (this.plugin.getSpawnerGuiViewManager().hasViewers(spawner)) {
            this.plugin.getSpawnerGuiViewManager().updateSpawnerMenuViewers(spawner);
        }
    }

    public void stopSpawnerTask(SpawnerData spawner) {
        Scheduler.Task task = this.spawnerTasks.remove(spawner.getSpawnerId());
        if (task != null) {
            task.cancel();
        }
    }

    public void cleanup() {
        this.spawnerTasks.values().forEach(Scheduler.Task::cancel);
        this.spawnerTasks.clear();
        this.executor.shutdown();
        try {
            if (!this.executor.awaitTermination(5L, TimeUnit.SECONDS)) {
                this.executor.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            this.executor.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }

    private /* synthetic */ void lambda$scheduleRegionSpecificCheck$1(List onlinePlayers, List allSpawners) {
        RangeMath rangeCheck = new RangeMath(onlinePlayers, allSpawners);
        rangeCheck.updateActiveSpawners();
        boolean[] spawnersPlayerFound = rangeCheck.getActiveSpawners();
        for (int i = 0; i < spawnersPlayerFound.length; ++i) {
            boolean shouldStop = !spawnersPlayerFound[i];
            SpawnerData sd = (SpawnerData)allSpawners.get(i);
            String spawnerId = sd.getSpawnerId();
            if (sd.getSpawnerStop().get() == shouldStop) continue;
            Scheduler.runLocationTask(sd.getSpawnerLocation(), () -> {
                if (!this.isSpawnerValid(sd)) {
                    this.cleanupRemovedSpawner(spawnerId);
                    return;
                }
                sd.getSpawnerStop().set(shouldStop);
                this.handleSpawnerStateChange(sd, shouldStop);
            });
        }
    }
}

