/*
 * Decompiled with CFR 0.152.
 */
package github.nighter.smartspawner.spawner.properties;

import github.nighter.smartspawner.SmartSpawner;
import github.nighter.smartspawner.commands.hologram.SpawnerHologram;
import github.nighter.smartspawner.spawner.loot.EntityLootConfig;
import github.nighter.smartspawner.spawner.loot.EntityLootRegistry;
import github.nighter.smartspawner.spawner.loot.LootItem;
import github.nighter.smartspawner.spawner.properties.VirtualInventory;
import github.nighter.smartspawner.spawner.sell.SellResult;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import lombok.Generated;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.EntityType;
import org.bukkit.inventory.ItemStack;

public class SpawnerData {
    private final SmartSpawner plugin;
    private final EntityLootRegistry lootRegistry;
    private String spawnerId;
    private final Location spawnerLocation;
    private final ReentrantLock lock = new ReentrantLock();
    private int baseMaxStoredExp;
    private int baseMaxStoragePages;
    private int baseMinMobs;
    private int baseMaxMobs;
    private Integer spawnerExp;
    private Boolean spawnerActive;
    private Integer spawnerRange;
    private AtomicBoolean spawnerStop;
    private Boolean isAtCapacity;
    private Long lastSpawnTime;
    private long spawnDelay;
    private EntityType entityType;
    private EntityLootConfig lootConfig;
    private int maxStoragePages;
    private int maxSpawnerLootSlots;
    private int maxStoredExp;
    private int minMobs;
    private int maxMobs;
    private int stackSize;
    private int maxStackSize;
    private VirtualInventory virtualInventory;
    private final Set<Material> filteredItems = new HashSet<Material>();
    private final AtomicBoolean interacted = new AtomicBoolean(false);
    private String lastInteractedPlayer;
    private SellResult lastSellResult;
    private boolean lastSellProcessed;
    private volatile double accumulatedSellValue;
    private volatile boolean sellValueDirty;
    private SpawnerHologram hologram;
    private long cachedSpawnDelay = 0L;
    private Material preferredSortItem;

    public SpawnerData(String id, Location location, EntityType type, SmartSpawner plugin) {
        this.plugin = plugin;
        this.spawnerId = id;
        this.spawnerLocation = location;
        this.entityType = type;
        this.lootRegistry = plugin.getEntityLootRegistry();
        this.initializeDefaults();
        this.loadConfigurationValues();
        this.calculateStackBasedValues();
        this.initializeComponents();
    }

    private void initializeDefaults() {
        this.spawnerExp = 0;
        this.spawnerActive = true;
        this.spawnerStop = new AtomicBoolean(true);
        this.isAtCapacity = false;
        this.stackSize = 1;
        this.lastSpawnTime = System.currentTimeMillis();
        this.preferredSortItem = null;
        this.accumulatedSellValue = 0.0;
        this.sellValueDirty = true;
    }

    public void loadConfigurationValues() {
        this.baseMaxStoredExp = this.plugin.getConfig().getInt("spawner_properties.default.max_stored_exp", 1000);
        this.baseMaxStoragePages = this.plugin.getConfig().getInt("spawner_properties.default.max_storage_pages", 1);
        this.baseMinMobs = this.plugin.getConfig().getInt("spawner_properties.default.min_mobs", 1);
        this.baseMaxMobs = this.plugin.getConfig().getInt("spawner_properties.default.max_mobs", 4);
        this.maxStackSize = this.plugin.getConfig().getInt("spawner_properties.default.max_stack_size", 1000);
        this.spawnDelay = this.plugin.getTimeFromConfig("spawner_properties.default.delay", "25s");
        this.spawnerRange = this.plugin.getConfig().getInt("spawner_properties.default.range", 16);
        this.lootConfig = this.lootRegistry.getLootConfig(this.entityType);
    }

    public void recalculateAfterConfigReload() {
        this.calculateStackBasedValues();
        if (this.virtualInventory != null && this.virtualInventory.getMaxSlots() != this.maxSpawnerLootSlots) {
            this.recreateVirtualInventory();
        }
        this.sellValueDirty = true;
        this.updateHologramData();
        if (this.plugin.getSpawnerMenuUI() != null) {
            this.plugin.getSpawnerMenuUI().invalidateSpawnerCache(this.spawnerId);
        }
        if (this.plugin.getSpawnerMenuFormUI() != null) {
            this.plugin.getSpawnerMenuFormUI().invalidateSpawnerCache(this.spawnerId);
        }
    }

    private void calculateStackBasedValues() {
        this.maxStoredExp = this.baseMaxStoredExp * this.stackSize;
        this.maxStoragePages = this.baseMaxStoragePages * this.stackSize;
        this.maxSpawnerLootSlots = this.maxStoragePages * 45;
        this.minMobs = this.baseMinMobs * this.stackSize;
        this.maxMobs = this.baseMaxMobs * this.stackSize;
        this.spawnerExp = Math.min(this.spawnerExp, this.maxStoredExp);
    }

    public void setSpawnDelay(long baseSpawnerDelay) {
        long l = this.spawnDelay = baseSpawnerDelay > 0L ? baseSpawnerDelay : 400L;
        if (baseSpawnerDelay <= 0L) {
            this.plugin.getLogger().warning("Invalid delay value. Setting to default: 400");
        }
    }

    private void initializeComponents() {
        this.virtualInventory = new VirtualInventory(this.maxSpawnerLootSlots);
        if (this.plugin.getConfig().getBoolean("hologram.enabled", false)) {
            this.createHologram();
        }
    }

    private void createHologram() {
        this.hologram = new SpawnerHologram(this.spawnerLocation);
        this.hologram.createHologram();
        this.updateHologramData();
    }

    public void setStackSize(int stackSize) {
        this.lock.lock();
        try {
            this.updateStackSize(stackSize);
        }
        finally {
            this.lock.unlock();
        }
    }

    private void updateStackSize(int newStackSize) {
        if (newStackSize <= 0) {
            this.stackSize = 1;
            this.plugin.getLogger().warning("Invalid stack size. Setting to 1");
            return;
        }
        if (newStackSize > this.maxStackSize) {
            this.stackSize = this.maxStackSize;
            this.plugin.getLogger().warning("Stack size exceeds maximum. Setting to " + this.stackSize);
            return;
        }
        this.stackSize = newStackSize;
        Map<VirtualInventory.ItemSignature, Long> currentItems = this.virtualInventory.getConsolidatedItems();
        this.calculateStackBasedValues();
        VirtualInventory newInventory = new VirtualInventory(this.maxSpawnerLootSlots);
        this.transferItemsToNewInventory(currentItems, newInventory);
        this.virtualInventory = newInventory;
        this.lastSpawnTime = System.currentTimeMillis();
        this.updateHologramData();
        if (this.plugin.getSpawnerMenuUI() != null) {
            this.plugin.getSpawnerMenuUI().invalidateSpawnerCache(this.spawnerId);
        }
        if (this.plugin.getSpawnerMenuFormUI() != null) {
            this.plugin.getSpawnerMenuFormUI().invalidateSpawnerCache(this.spawnerId);
        }
    }

    private void recreateVirtualInventory() {
        if (this.virtualInventory == null) {
            return;
        }
        Map<VirtualInventory.ItemSignature, Long> currentItems = this.virtualInventory.getConsolidatedItems();
        VirtualInventory newInventory = new VirtualInventory(this.maxSpawnerLootSlots);
        this.transferItemsToNewInventory(currentItems, newInventory);
        this.virtualInventory = newInventory;
    }

    private void transferItemsToNewInventory(Map<VirtualInventory.ItemSignature, Long> items, VirtualInventory newInventory) {
        ArrayList<ItemStack> itemsToTransfer = new ArrayList<ItemStack>();
        items.forEach((signature, amount) -> {
            ItemStack template = signature.getTemplate();
            while (amount > 0L) {
                int batchSize = (int)Math.min(amount, Integer.MAX_VALUE);
                ItemStack batch = template.clone();
                batch.setAmount(batchSize);
                itemsToTransfer.add(batch);
                amount = amount - (long)batchSize;
            }
        });
        newInventory.addItems(itemsToTransfer);
    }

    public void setSpawnerExp(int exp) {
        this.spawnerExp = Math.min(Math.max(0, exp), this.maxStoredExp);
        this.updateHologramData();
        if (this.plugin.getSpawnerMenuUI() != null) {
            this.plugin.getSpawnerMenuUI().invalidateSpawnerCache(this.spawnerId);
        }
        if (this.plugin.getSpawnerMenuFormUI() != null) {
            this.plugin.getSpawnerMenuFormUI().invalidateSpawnerCache(this.spawnerId);
        }
    }

    public void setSpawnerExpData(int exp) {
        this.spawnerExp = exp;
    }

    public void updateHologramData() {
        if (this.hologram != null) {
            this.hologram.updateData(this.stackSize, this.entityType, this.spawnerExp, this.maxStoredExp, this.virtualInventory.getUsedSlots(), this.maxSpawnerLootSlots);
        }
    }

    public void reloadHologramData() {
        if (this.hologram != null) {
            this.hologram.remove();
            this.createHologram();
        }
    }

    public void refreshHologram() {
        if (this.plugin.getConfig().getBoolean("hologram.enabled", false)) {
            if (this.hologram == null) {
                this.createHologram();
            }
        } else if (this.hologram != null) {
            this.removeHologram();
        }
    }

    public void removeHologram() {
        if (this.hologram != null) {
            this.hologram.remove();
            this.hologram = null;
        }
    }

    public boolean isCompletelyFull() {
        return this.virtualInventory.getUsedSlots() >= this.maxSpawnerLootSlots && this.spawnerExp >= this.maxStoredExp;
    }

    public boolean updateCapacityStatus() {
        boolean newStatus = this.isCompletelyFull();
        if (newStatus != this.isAtCapacity) {
            this.isAtCapacity = newStatus;
            return true;
        }
        return false;
    }

    public void setEntityType(EntityType newType) {
        this.entityType = newType;
        this.lootConfig = this.lootRegistry.getLootConfig(newType);
        this.sellValueDirty = true;
        this.updateHologramData();
    }

    public boolean toggleItemFilter(Material material) {
        boolean wasFiltered = this.filteredItems.contains(material);
        if (wasFiltered) {
            this.filteredItems.remove(material);
        } else {
            this.filteredItems.add(material);
        }
        return !wasFiltered;
    }

    public List<LootItem> getValidLootItems() {
        if (this.lootConfig == null) {
            return Collections.emptyList();
        }
        return this.lootConfig.getAllItems().stream().filter(this::isLootItemValid).collect(Collectors.toList());
    }

    private boolean isLootItemValid(LootItem item) {
        ItemStack example = item.createItemStack(new Random());
        return example != null && !this.filteredItems.contains(example.getType());
    }

    public int getEntityExperienceValue() {
        return this.lootConfig != null ? this.lootConfig.getExperience() : 0;
    }

    public void setLootConfig() {
        this.lootConfig = this.lootRegistry.getLootConfig(this.entityType);
        this.sellValueDirty = true;
    }

    public void setLastSellResult(SellResult sellResult) {
        this.lastSellResult = sellResult;
        this.lastSellProcessed = false;
    }

    public void markLastSellAsProcessed() {
        this.lastSellProcessed = true;
    }

    public boolean isInteracted() {
        return this.interacted.get();
    }

    public void markInteracted() {
        this.interacted.compareAndSet(false, true);
    }

    public void clearInteracted() {
        this.interacted.compareAndSet(true, false);
    }

    public void updateLastInteractedPlayer(String playerName) {
        this.lastInteractedPlayer = playerName;
        this.markInteracted();
    }

    public void markSellValueDirty() {
        this.sellValueDirty = true;
    }

    public void incrementSellValue(Map<VirtualInventory.ItemSignature, Long> itemsAdded, Map<String, Double> priceCache) {
        if (itemsAdded == null || itemsAdded.isEmpty()) {
            return;
        }
        double addedValue = 0.0;
        for (Map.Entry<VirtualInventory.ItemSignature, Long> entry : itemsAdded.entrySet()) {
            ItemStack template = entry.getKey().getTemplate();
            long amount = entry.getValue();
            double itemPrice = this.findItemPrice(template, priceCache);
            if (!(itemPrice > 0.0)) continue;
            addedValue += itemPrice * (double)amount;
        }
        this.accumulatedSellValue += addedValue;
        this.sellValueDirty = false;
    }

    public void decrementSellValue(List<ItemStack> itemsRemoved, Map<String, Double> priceCache) {
        if (itemsRemoved == null || itemsRemoved.isEmpty()) {
            return;
        }
        HashMap<VirtualInventory.ItemSignature, Long> consolidated = new HashMap<VirtualInventory.ItemSignature, Long>();
        for (ItemStack item : itemsRemoved) {
            if (item == null || item.getAmount() <= 0) continue;
            VirtualInventory.ItemSignature sig = new VirtualInventory.ItemSignature(item);
            consolidated.merge(sig, Long.valueOf(item.getAmount()), Long::sum);
        }
        double removedValue = 0.0;
        for (Map.Entry entry : consolidated.entrySet()) {
            ItemStack template = ((VirtualInventory.ItemSignature)entry.getKey()).getTemplate();
            long amount = (Long)entry.getValue();
            double itemPrice = this.findItemPrice(template, priceCache);
            if (!(itemPrice > 0.0)) continue;
            removedValue += itemPrice * (double)amount;
        }
        this.accumulatedSellValue = Math.max(0.0, this.accumulatedSellValue - removedValue);
    }

    public void recalculateSellValue() {
        if (this.lootConfig == null) {
            this.accumulatedSellValue = 0.0;
            this.sellValueDirty = false;
            return;
        }
        Map<String, Double> priceCache = this.createPriceCache();
        Map<VirtualInventory.ItemSignature, Long> items = this.virtualInventory.getConsolidatedItems();
        double totalValue = 0.0;
        for (Map.Entry<VirtualInventory.ItemSignature, Long> entry : items.entrySet()) {
            ItemStack template = entry.getKey().getTemplate();
            long amount = entry.getValue();
            double itemPrice = this.findItemPrice(template, priceCache);
            if (!(itemPrice > 0.0)) continue;
            totalValue += itemPrice * (double)amount;
        }
        this.accumulatedSellValue = totalValue;
        this.sellValueDirty = false;
    }

    public Map<String, Double> createPriceCache() {
        if (this.lootConfig == null) {
            return new HashMap<String, Double>();
        }
        HashMap<String, Double> cache = new HashMap<String, Double>();
        List<LootItem> allLootItems = this.lootConfig.getAllItems();
        for (LootItem lootItem : allLootItems) {
            ItemStack template;
            if (!(lootItem.getSellPrice() > 0.0) || (template = lootItem.createItemStack(new Random())) == null) continue;
            String key = this.createItemKey(template);
            cache.put(key, lootItem.getSellPrice());
        }
        return cache;
    }

    private double findItemPrice(ItemStack item, Map<String, Double> priceCache) {
        if (item == null || priceCache == null) {
            return 0.0;
        }
        String itemKey = this.createItemKey(item);
        Double price = priceCache.get(itemKey);
        return price != null ? price : 0.0;
    }

    private String createItemKey(ItemStack item) {
        if (item == null) {
            return "null";
        }
        StringBuilder key = new StringBuilder();
        key.append(item.getType().name());
        if (item.hasItemMeta() && item.getItemMeta().hasEnchants()) {
            key.append("_enchants:");
            item.getItemMeta().getEnchants().entrySet().stream().sorted(Map.Entry.comparingByKey(Comparator.comparing(enchantment -> enchantment.getKey().toString()))).forEach(entry -> key.append(((Enchantment)entry.getKey()).getKey()).append(":").append(entry.getValue()).append(","));
        }
        if (item.hasItemMeta() && item.getItemMeta().hasCustomModelData()) {
            key.append("_cmd:").append(item.getItemMeta().getCustomModelData());
        }
        if (item.hasItemMeta() && item.getItemMeta().hasDisplayName()) {
            key.append("_name:").append(item.getItemMeta().getDisplayName());
        }
        return key.toString();
    }

    public boolean isSellValueDirty() {
        return this.sellValueDirty;
    }

    public void addItemsAndUpdateSellValue(List<ItemStack> items) {
        if (items == null || items.isEmpty()) {
            return;
        }
        HashMap<VirtualInventory.ItemSignature, Long> itemsToAdd = new HashMap<VirtualInventory.ItemSignature, Long>();
        for (ItemStack item : items) {
            if (item == null || item.getAmount() <= 0) continue;
            VirtualInventory.ItemSignature sig = new VirtualInventory.ItemSignature(item);
            itemsToAdd.merge(sig, Long.valueOf(item.getAmount()), Long::sum);
        }
        this.virtualInventory.addItems(items);
        if (!this.sellValueDirty) {
            Map<String, Double> priceCache = this.createPriceCache();
            this.incrementSellValue(itemsToAdd, priceCache);
        }
    }

    public boolean removeItemsAndUpdateSellValue(List<ItemStack> items) {
        if (items == null || items.isEmpty()) {
            return true;
        }
        boolean removed = this.virtualInventory.removeItems(items);
        if (removed && !this.sellValueDirty) {
            Map<String, Double> priceCache = this.createPriceCache();
            this.decrementSellValue(items, priceCache);
        }
        return removed;
    }

    @Generated
    public SmartSpawner getPlugin() {
        return this.plugin;
    }

    @Generated
    public String getSpawnerId() {
        return this.spawnerId;
    }

    @Generated
    public void setSpawnerId(String spawnerId) {
        this.spawnerId = spawnerId;
    }

    @Generated
    public Location getSpawnerLocation() {
        return this.spawnerLocation;
    }

    @Generated
    public ReentrantLock getLock() {
        return this.lock;
    }

    @Generated
    public Integer getSpawnerExp() {
        return this.spawnerExp;
    }

    @Generated
    public Boolean getSpawnerActive() {
        return this.spawnerActive;
    }

    @Generated
    public void setSpawnerActive(Boolean spawnerActive) {
        this.spawnerActive = spawnerActive;
    }

    @Generated
    public Integer getSpawnerRange() {
        return this.spawnerRange;
    }

    @Generated
    public void setSpawnerRange(Integer spawnerRange) {
        this.spawnerRange = spawnerRange;
    }

    @Generated
    public AtomicBoolean getSpawnerStop() {
        return this.spawnerStop;
    }

    @Generated
    public Boolean getIsAtCapacity() {
        return this.isAtCapacity;
    }

    @Generated
    public void setIsAtCapacity(Boolean isAtCapacity) {
        this.isAtCapacity = isAtCapacity;
    }

    @Generated
    public Long getLastSpawnTime() {
        return this.lastSpawnTime;
    }

    @Generated
    public void setLastSpawnTime(Long lastSpawnTime) {
        this.lastSpawnTime = lastSpawnTime;
    }

    @Generated
    public long getSpawnDelay() {
        return this.spawnDelay;
    }

    @Generated
    public EntityType getEntityType() {
        return this.entityType;
    }

    @Generated
    public EntityLootConfig getLootConfig() {
        return this.lootConfig;
    }

    @Generated
    public void setLootConfig(EntityLootConfig lootConfig) {
        this.lootConfig = lootConfig;
    }

    @Generated
    public int getMaxStoragePages() {
        return this.maxStoragePages;
    }

    @Generated
    public int getMaxSpawnerLootSlots() {
        return this.maxSpawnerLootSlots;
    }

    @Generated
    public void setMaxSpawnerLootSlots(int maxSpawnerLootSlots) {
        this.maxSpawnerLootSlots = maxSpawnerLootSlots;
    }

    @Generated
    public int getMaxStoredExp() {
        return this.maxStoredExp;
    }

    @Generated
    public void setMaxStoredExp(int maxStoredExp) {
        this.maxStoredExp = maxStoredExp;
    }

    @Generated
    public int getMinMobs() {
        return this.minMobs;
    }

    @Generated
    public void setMinMobs(int minMobs) {
        this.minMobs = minMobs;
    }

    @Generated
    public int getMaxMobs() {
        return this.maxMobs;
    }

    @Generated
    public void setMaxMobs(int maxMobs) {
        this.maxMobs = maxMobs;
    }

    @Generated
    public int getStackSize() {
        return this.stackSize;
    }

    @Generated
    public int getMaxStackSize() {
        return this.maxStackSize;
    }

    @Generated
    public void setMaxStackSize(int maxStackSize) {
        this.maxStackSize = maxStackSize;
    }

    @Generated
    public VirtualInventory getVirtualInventory() {
        return this.virtualInventory;
    }

    @Generated
    public void setVirtualInventory(VirtualInventory virtualInventory) {
        this.virtualInventory = virtualInventory;
    }

    @Generated
    public Set<Material> getFilteredItems() {
        return this.filteredItems;
    }

    @Generated
    public String getLastInteractedPlayer() {
        return this.lastInteractedPlayer;
    }

    @Generated
    public void setLastInteractedPlayer(String lastInteractedPlayer) {
        this.lastInteractedPlayer = lastInteractedPlayer;
    }

    @Generated
    public SellResult getLastSellResult() {
        return this.lastSellResult;
    }

    @Generated
    public boolean isLastSellProcessed() {
        return this.lastSellProcessed;
    }

    @Generated
    public double getAccumulatedSellValue() {
        return this.accumulatedSellValue;
    }

    @Generated
    public long getCachedSpawnDelay() {
        return this.cachedSpawnDelay;
    }

    @Generated
    public void setCachedSpawnDelay(long cachedSpawnDelay) {
        this.cachedSpawnDelay = cachedSpawnDelay;
    }

    @Generated
    public Material getPreferredSortItem() {
        return this.preferredSortItem;
    }

    @Generated
    public void setPreferredSortItem(Material preferredSortItem) {
        this.preferredSortItem = preferredSortItem;
    }
}

