/*
 * Decompiled with CFR 0.152.
 */
package github.nighter.smartspawner.spawner.utils;

import github.nighter.smartspawner.SmartSpawner;
import github.nighter.smartspawner.nms.TextureWrapper;
import java.net.URL;
import java.util.EnumMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.profile.PlayerProfile;
import org.bukkit.profile.PlayerTextures;

public class SpawnerMobHeadTexture {
    private static final Map<EntityType, ItemStack> HEAD_CACHE = new EnumMap<EntityType, ItemStack>(EntityType.class);

    private static boolean isBedrockPlayer(Player player) {
        SmartSpawner plugin = SmartSpawner.getInstance();
        if (plugin == null || plugin.getIntegrationManager() == null || plugin.getIntegrationManager().getFloodgateHook() == null) {
            return false;
        }
        return plugin.getIntegrationManager().getFloodgateHook().isBedrockPlayer(player);
    }

    public static ItemStack getCustomHead(EntityType entityType, Player player) {
        if (entityType == null) {
            return SpawnerMobHeadTexture.createItemStack(Material.SPAWNER);
        }
        switch (entityType) {
            case ZOMBIE: {
                return new ItemStack(Material.ZOMBIE_HEAD);
            }
            case SKELETON: {
                return new ItemStack(Material.SKELETON_SKULL);
            }
            case WITHER_SKELETON: {
                return new ItemStack(Material.WITHER_SKELETON_SKULL);
            }
            case CREEPER: {
                return new ItemStack(Material.CREEPER_HEAD);
            }
            case PIGLIN: 
            case PIGLIN_BRUTE: {
                return new ItemStack(Material.PIGLIN_HEAD);
            }
        }
        if (SpawnerMobHeadTexture.isBedrockPlayer(player)) {
            return new ItemStack(Material.SPAWNER);
        }
        if (HEAD_CACHE.containsKey(entityType)) {
            return HEAD_CACHE.get(entityType).clone();
        }
        if (!TextureWrapper.hasTexture(entityType)) {
            return new ItemStack(Material.SPAWNER);
        }
        ItemStack head = new ItemStack(Material.PLAYER_HEAD);
        SkullMeta meta = (SkullMeta)head.getItemMeta();
        try {
            String texture = TextureWrapper.getTexture(entityType);
            PlayerProfile profile = Bukkit.createPlayerProfile((UUID)UUID.randomUUID());
            PlayerTextures textures = profile.getTextures();
            URL url = new URL("http://textures.minecraft.net/texture/" + texture);
            textures.setSkin(url);
            profile.setTextures(textures);
            meta.setOwnerProfile(profile);
            head.setItemMeta((ItemMeta)meta);
            HEAD_CACHE.put(entityType, head.clone());
            return head;
        }
        catch (Exception e) {
            e.printStackTrace();
            return SpawnerMobHeadTexture.createItemStack(Material.SPAWNER);
        }
    }

    public static ItemStack getCustomHead(EntityType entityType) {
        if (entityType == null) {
            return SpawnerMobHeadTexture.createItemStack(Material.SPAWNER);
        }
        switch (entityType) {
            case ZOMBIE: {
                return new ItemStack(Material.ZOMBIE_HEAD);
            }
            case SKELETON: {
                return new ItemStack(Material.SKELETON_SKULL);
            }
            case WITHER_SKELETON: {
                return new ItemStack(Material.WITHER_SKELETON_SKULL);
            }
            case CREEPER: {
                return new ItemStack(Material.CREEPER_HEAD);
            }
            case PIGLIN: 
            case PIGLIN_BRUTE: {
                return new ItemStack(Material.PIGLIN_HEAD);
            }
        }
        if (HEAD_CACHE.containsKey(entityType)) {
            return HEAD_CACHE.get(entityType).clone();
        }
        if (!TextureWrapper.hasTexture(entityType)) {
            return new ItemStack(Material.SPAWNER);
        }
        ItemStack head = new ItemStack(Material.PLAYER_HEAD);
        SkullMeta meta = (SkullMeta)head.getItemMeta();
        try {
            String texture = TextureWrapper.getTexture(entityType);
            PlayerProfile profile = Bukkit.createPlayerProfile((UUID)UUID.randomUUID());
            PlayerTextures textures = profile.getTextures();
            URL url = new URL("http://textures.minecraft.net/texture/" + texture);
            textures.setSkin(url);
            profile.setTextures(textures);
            meta.setOwnerProfile(profile);
            head.setItemMeta((ItemMeta)meta);
            HEAD_CACHE.put(entityType, head.clone());
            return head;
        }
        catch (Exception e) {
            e.printStackTrace();
            return new ItemStack(Material.SPAWNER);
        }
    }

    public static ItemStack createItemStack(Material material) {
        ItemStack itemStack = new ItemStack(material);
        ItemMeta meta = itemStack.getItemMeta();
        meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS, ItemFlag.HIDE_ATTRIBUTES, ItemFlag.HIDE_UNBREAKABLE, ItemFlag.HIDE_ADDITIONAL_TOOLTIP});
        itemStack.setItemMeta(meta);
        return itemStack;
    }

    public static void clearCache() {
        HEAD_CACHE.clear();
    }

    static {
        TextureWrapper.initializeCommonTextures();
    }
}

