/*
 * Decompiled with CFR 0.152.
 */
package github.nighter.smartspawner;

import github.nighter.smartspawner.api.SmartSpawnerAPI;
import github.nighter.smartspawner.api.SmartSpawnerAPIImpl;
import github.nighter.smartspawner.api.SmartSpawnerPlugin;
import github.nighter.smartspawner.bstats.Metrics;
import github.nighter.smartspawner.commands.BrigadierCommandManager;
import github.nighter.smartspawner.commands.list.ListSubCommand;
import github.nighter.smartspawner.commands.list.gui.adminstacker.AdminStackerHandler;
import github.nighter.smartspawner.commands.list.gui.list.SpawnerListGUI;
import github.nighter.smartspawner.commands.list.gui.list.UserPreferenceCache;
import github.nighter.smartspawner.commands.list.gui.management.SpawnerManagementGUI;
import github.nighter.smartspawner.commands.list.gui.management.SpawnerManagementHandler;
import github.nighter.smartspawner.commands.prices.PricesGUI;
import github.nighter.smartspawner.extras.HopperHandler;
import github.nighter.smartspawner.hooks.IntegrationManager;
import github.nighter.smartspawner.hooks.economy.ItemPriceManager;
import github.nighter.smartspawner.hooks.economy.shops.providers.shopguiplus.SpawnerProvider;
import github.nighter.smartspawner.language.LanguageManager;
import github.nighter.smartspawner.language.MessageService;
import github.nighter.smartspawner.migration.SpawnerDataMigration;
import github.nighter.smartspawner.nms.VersionInitializer;
import github.nighter.smartspawner.spawner.events.WorldEventHandler;
import github.nighter.smartspawner.spawner.gui.layout.GuiLayoutConfig;
import github.nighter.smartspawner.spawner.gui.main.SpawnerMenuAction;
import github.nighter.smartspawner.spawner.gui.main.SpawnerMenuFormUI;
import github.nighter.smartspawner.spawner.gui.main.SpawnerMenuUI;
import github.nighter.smartspawner.spawner.gui.stacker.SpawnerStackerHandler;
import github.nighter.smartspawner.spawner.gui.stacker.SpawnerStackerUI;
import github.nighter.smartspawner.spawner.gui.storage.SpawnerStorageAction;
import github.nighter.smartspawner.spawner.gui.storage.SpawnerStorageUI;
import github.nighter.smartspawner.spawner.gui.storage.filter.FilterConfigUI;
import github.nighter.smartspawner.spawner.gui.synchronization.SpawnerGuiViewManager;
import github.nighter.smartspawner.spawner.interactions.click.SpawnerClickManager;
import github.nighter.smartspawner.spawner.interactions.destroy.SpawnerBreakListener;
import github.nighter.smartspawner.spawner.interactions.destroy.SpawnerExplosionListener;
import github.nighter.smartspawner.spawner.interactions.place.SpawnerPlaceListener;
import github.nighter.smartspawner.spawner.interactions.stack.SpawnerStackHandler;
import github.nighter.smartspawner.spawner.interactions.type.SpawnEggHandler;
import github.nighter.smartspawner.spawner.item.SpawnerItemFactory;
import github.nighter.smartspawner.spawner.limits.ChunkSpawnerLimiter;
import github.nighter.smartspawner.spawner.loot.EntityLootRegistry;
import github.nighter.smartspawner.spawner.lootgen.SpawnerLootGenerator;
import github.nighter.smartspawner.spawner.lootgen.SpawnerRangeChecker;
import github.nighter.smartspawner.spawner.natural.NaturalSpawnerListener;
import github.nighter.smartspawner.spawner.properties.SpawnerManager;
import github.nighter.smartspawner.spawner.sell.SpawnerSellManager;
import github.nighter.smartspawner.spawner.utils.SpawnerFileHandler;
import github.nighter.smartspawner.spawner.utils.SpawnerMobHeadTexture;
import github.nighter.smartspawner.updates.ConfigUpdater;
import github.nighter.smartspawner.updates.LanguageUpdater;
import github.nighter.smartspawner.updates.UpdateChecker;
import github.nighter.smartspawner.utils.SpawnerTypeChecker;
import github.nighter.smartspawner.utils.TimeFormatter;
import java.util.logging.Level;
import lombok.Generated;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;

public class SmartSpawner
extends JavaPlugin
implements SmartSpawnerPlugin {
    private static SmartSpawner instance;
    public final int DATA_VERSION = 3;
    private final boolean debugMode = this.getConfig().getBoolean("debug", false);
    private IntegrationManager integrationManager;
    private TimeFormatter timeFormatter;
    private ConfigUpdater configUpdater;
    private LanguageManager languageManager;
    private LanguageUpdater languageUpdater;
    private MessageService messageService;
    private SpawnerItemFactory spawnerItemFactory;
    private GuiLayoutConfig guiLayoutConfig;
    private SpawnerMenuUI spawnerMenuUI;
    private SpawnerMenuFormUI spawnerMenuFormUI;
    private SpawnerStorageUI spawnerStorageUI;
    private FilterConfigUI filterConfigUI;
    private SpawnerStackerUI spawnerStackerUI;
    private SpawnEggHandler spawnEggHandler;
    private SpawnerClickManager spawnerClickManager;
    private SpawnerStackHandler spawnerStackHandler;
    private SpawnerMenuAction spawnerMenuAction;
    private SpawnerStackerHandler spawnerStackerHandler;
    private SpawnerStorageAction spawnerStorageAction;
    private SpawnerSellManager spawnerSellManager;
    private SpawnerFileHandler spawnerFileHandler;
    private SpawnerManager spawnerManager;
    private HopperHandler hopperHandler;
    private NaturalSpawnerListener naturalSpawnerListener;
    private SpawnerLootGenerator spawnerLootGenerator;
    private SpawnerRangeChecker rangeChecker;
    private ChunkSpawnerLimiter chunkSpawnerLimiter;
    private SpawnerGuiViewManager spawnerGuiViewManager;
    private SpawnerExplosionListener spawnerExplosionListener;
    private SpawnerBreakListener spawnerBreakListener;
    private SpawnerPlaceListener spawnerPlaceListener;
    private WorldEventHandler worldEventHandler;
    private ItemPriceManager itemPriceManager;
    private EntityLootRegistry entityLootRegistry;
    private UpdateChecker updateChecker;
    private BrigadierCommandManager brigadierCommandManager;
    private ListSubCommand listSubCommand;
    private UserPreferenceCache userPreferenceCache;
    private SpawnerListGUI spawnerListGUI;
    private SpawnerManagementHandler spawnerManagementHandler;
    private AdminStackerHandler adminStackerHandler;
    private PricesGUI pricesGUI;
    private SmartSpawnerAPIImpl apiImpl;

    public void onEnable() {
        long startTime = System.currentTimeMillis();
        instance = this;
        this.initializeVersionComponents();
        this.integrationManager = new IntegrationManager(this);
        this.integrationManager.initializeIntegrations();
        this.migrateDataIfNeeded();
        this.initializeComponents();
        this.setupCommand();
        this.setupBtatsMetrics();
        this.registerListeners();
        if (this.worldEventHandler != null) {
            this.worldEventHandler.attemptInitialSpawnerLoad();
        }
        long loadTime = System.currentTimeMillis() - startTime;
        this.getLogger().info("SmartSpawner has been enabled! (Loaded in " + loadTime + "ms)");
    }

    @Override
    public SmartSpawnerAPI getAPI() {
        return this.apiImpl;
    }

    private void initializeVersionComponents() {
        try {
            new VersionInitializer(this).initialize();
        }
        catch (Exception e) {
            this.getLogger().log(Level.SEVERE, "Failed to initialize version-specific components", e);
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
        }
    }

    private void migrateDataIfNeeded() {
        SpawnerDataMigration migration = new SpawnerDataMigration(this);
        if (migration.checkAndMigrateData()) {
            this.getLogger().info("Data migration completed. Loading with new format...");
        }
    }

    private void initializeComponents() {
        this.initializeServices();
        this.initializeEconomyComponents();
        this.initializeCoreComponents();
        this.initializeHandlers();
        this.initializeUIAndActions();
        this.setUpHopperHandler();
        this.initializeListeners();
        this.apiImpl = new SmartSpawnerAPIImpl(this);
        this.updateChecker = new UpdateChecker(this);
    }

    private void initializeServices() {
        SpawnerTypeChecker.init(this);
        this.timeFormatter = new TimeFormatter(this);
        this.configUpdater = new ConfigUpdater(this);
        this.configUpdater.checkAndUpdateConfig();
        this.languageManager = new LanguageManager(this);
        this.languageUpdater = new LanguageUpdater(this);
        this.messageService = new MessageService(this, this.languageManager);
    }

    private void initializeEconomyComponents() {
        this.itemPriceManager = new ItemPriceManager(this);
        this.itemPriceManager.init();
        this.entityLootRegistry = new EntityLootRegistry(this, this.itemPriceManager);
        this.spawnerItemFactory = new SpawnerItemFactory(this);
    }

    private void initializeCoreComponents() {
        this.spawnerFileHandler = new SpawnerFileHandler(this);
        this.spawnerManager = new SpawnerManager(this);
        this.spawnerManager.reloadAllHolograms();
        this.guiLayoutConfig = new GuiLayoutConfig(this);
        this.spawnerStorageUI = new SpawnerStorageUI(this);
        this.filterConfigUI = new FilterConfigUI(this);
        this.spawnerMenuUI = new SpawnerMenuUI(this);
        this.spawnerGuiViewManager = new SpawnerGuiViewManager(this);
        this.spawnerLootGenerator = new SpawnerLootGenerator(this);
        this.spawnerSellManager = new SpawnerSellManager(this);
        this.rangeChecker = new SpawnerRangeChecker(this);
        this.initializeFormUIComponents();
    }

    private void initializeFormUIComponents() {
        if (this.integrationManager != null && this.integrationManager.getFloodgateHook() != null && this.integrationManager.getFloodgateHook().isEnabled()) {
            try {
                this.spawnerMenuFormUI = new SpawnerMenuFormUI(this);
                this.getLogger().info("FormUI components initialized successfully for Bedrock player support");
            }
            catch (Exception | NoClassDefFoundError e) {
                this.getLogger().warning("Failed to initialize FormUI components: " + e.getMessage());
                this.spawnerMenuFormUI = null;
            }
        } else {
            this.spawnerMenuFormUI = null;
            this.debug("FormUI components not initialized - Floodgate integration not available");
        }
    }

    private void initializeHandlers() {
        this.chunkSpawnerLimiter = new ChunkSpawnerLimiter(this);
        this.spawnerStackerUI = new SpawnerStackerUI(this);
        this.spawnEggHandler = new SpawnEggHandler(this);
        this.spawnerStackHandler = new SpawnerStackHandler(this);
        this.spawnerClickManager = new SpawnerClickManager(this);
    }

    private void initializeUIAndActions() {
        this.spawnerMenuAction = new SpawnerMenuAction(this);
        this.spawnerStackerHandler = new SpawnerStackerHandler(this);
        this.spawnerStorageAction = new SpawnerStorageAction(this);
    }

    private void initializeListeners() {
        this.naturalSpawnerListener = new NaturalSpawnerListener(this);
        this.spawnerExplosionListener = new SpawnerExplosionListener(this);
        this.spawnerBreakListener = new SpawnerBreakListener(this);
        this.spawnerPlaceListener = new SpawnerPlaceListener(this);
        this.worldEventHandler = new WorldEventHandler(this);
    }

    public void setUpHopperHandler() {
        this.hopperHandler = this.getConfig().getBoolean("hopper.enabled", false) ? new HopperHandler(this) : null;
    }

    private void registerListeners() {
        PluginManager pm = this.getServer().getPluginManager();
        pm.registerEvents((Listener)this.naturalSpawnerListener, (Plugin)this);
        pm.registerEvents((Listener)this.spawnerBreakListener, (Plugin)this);
        pm.registerEvents((Listener)this.spawnerPlaceListener, (Plugin)this);
        pm.registerEvents((Listener)this.spawnerStorageAction, (Plugin)this);
        pm.registerEvents((Listener)this.spawnerExplosionListener, (Plugin)this);
        pm.registerEvents((Listener)this.spawnerGuiViewManager, (Plugin)this);
        pm.registerEvents((Listener)this.spawnerClickManager, (Plugin)this);
        pm.registerEvents((Listener)this.spawnerMenuAction, (Plugin)this);
        pm.registerEvents((Listener)this.spawnerStackerHandler, (Plugin)this);
        pm.registerEvents((Listener)this.worldEventHandler, (Plugin)this);
        pm.registerEvents((Listener)this.spawnerListGUI, (Plugin)this);
        pm.registerEvents((Listener)this.spawnerManagementHandler, (Plugin)this);
        pm.registerEvents((Listener)this.adminStackerHandler, (Plugin)this);
        pm.registerEvents((Listener)this.pricesGUI, (Plugin)this);
    }

    private void setupCommand() {
        this.brigadierCommandManager = new BrigadierCommandManager(this);
        this.brigadierCommandManager.registerCommands();
        this.userPreferenceCache = new UserPreferenceCache((Plugin)this);
        this.listSubCommand = new ListSubCommand(this);
        this.spawnerListGUI = new SpawnerListGUI(this);
        this.spawnerManagementHandler = new SpawnerManagementHandler(this, this.listSubCommand);
        this.adminStackerHandler = new AdminStackerHandler(this, new SpawnerManagementGUI(this));
        this.pricesGUI = new PricesGUI(this);
    }

    private void setupBtatsMetrics() {
        Metrics metrics = new Metrics((Plugin)this, 24822);
        metrics.addCustomChart(new Metrics.SimplePie("holograms", () -> String.valueOf(this.getConfig().getBoolean("hologram.enabled", false))));
        metrics.addCustomChart(new Metrics.SimplePie("hoppers", () -> String.valueOf(this.getConfig().getBoolean("hopper.enabled", false))));
        metrics.addCustomChart(new Metrics.SimplePie("spawners", () -> String.valueOf(this.spawnerManager.getTotalSpawners() / 1000 * 1000)));
    }

    public void reload() {
        this.guiLayoutConfig.reloadLayouts();
        this.spawnerGuiViewManager.clearSlotCache();
        if (this.spawnerMenuUI != null) {
            this.spawnerMenuUI.clearCache();
        }
        this.spawnerStorageAction.loadConfig();
        this.spawnerStorageUI.reload();
        this.filterConfigUI.reload();
        this.integrationManager.reload();
        this.spawnerMenuAction.reload();
        this.timeFormatter.clearCache();
    }

    public void onDisable() {
        this.saveAndCleanup();
        SpawnerMobHeadTexture.clearCache();
        this.getLogger().info("SmartSpawner has been disabled!");
    }

    private void saveAndCleanup() {
        if (this.spawnerManager != null) {
            try {
                if (this.spawnerFileHandler != null) {
                    this.spawnerFileHandler.shutdown();
                }
                this.spawnerManager.cleanupAllSpawners();
            }
            catch (Exception e) {
                this.getLogger().log(Level.SEVERE, "Error saving spawner data during shutdown", e);
            }
        }
        if (this.itemPriceManager != null) {
            this.itemPriceManager.cleanup();
        }
        this.cleanupResources();
    }

    private void cleanupResources() {
        if (this.rangeChecker != null) {
            this.rangeChecker.cleanup();
        }
        if (this.spawnerGuiViewManager != null) {
            this.spawnerGuiViewManager.cleanup();
        }
        if (this.hopperHandler != null) {
            this.hopperHandler.cleanup();
        }
        if (this.spawnerClickManager != null) {
            this.spawnerClickManager.cleanup();
        }
        if (this.spawnerStackerHandler != null) {
            this.spawnerStackerHandler.cleanupAll();
        }
        if (this.spawnerStorageUI != null) {
            this.spawnerStorageUI.cleanup();
        }
    }

    public SpawnerProvider getSpawnerProvider() {
        return new SpawnerProvider(this);
    }

    public boolean hasSellIntegration() {
        if (this.itemPriceManager == null) {
            return false;
        }
        return this.itemPriceManager.hasSellIntegration();
    }

    public boolean hasShopIntegration() {
        if (this.itemPriceManager == null) {
            return false;
        }
        return this.itemPriceManager.getShopIntegrationManager() != null && this.itemPriceManager.getShopIntegrationManager().hasActiveProvider();
    }

    public long getTimeFromConfig(String path, String defaultValue) {
        return this.timeFormatter.getTimeFromConfig(path, defaultValue);
    }

    public void debug(String message) {
        if (this.debugMode) {
            this.getLogger().info("[DEBUG] " + message);
        }
    }

    @Generated
    public int getDATA_VERSION() {
        return this.DATA_VERSION;
    }

    @Generated
    public boolean isDebugMode() {
        return this.debugMode;
    }

    @Generated
    public IntegrationManager getIntegrationManager() {
        return this.integrationManager;
    }

    @Generated
    public TimeFormatter getTimeFormatter() {
        return this.timeFormatter;
    }

    @Generated
    public ConfigUpdater getConfigUpdater() {
        return this.configUpdater;
    }

    @Generated
    public LanguageManager getLanguageManager() {
        return this.languageManager;
    }

    @Generated
    public LanguageUpdater getLanguageUpdater() {
        return this.languageUpdater;
    }

    @Generated
    public MessageService getMessageService() {
        return this.messageService;
    }

    @Generated
    public SpawnerItemFactory getSpawnerItemFactory() {
        return this.spawnerItemFactory;
    }

    @Generated
    public GuiLayoutConfig getGuiLayoutConfig() {
        return this.guiLayoutConfig;
    }

    @Generated
    public SpawnerMenuUI getSpawnerMenuUI() {
        return this.spawnerMenuUI;
    }

    @Generated
    public SpawnerMenuFormUI getSpawnerMenuFormUI() {
        return this.spawnerMenuFormUI;
    }

    @Generated
    public SpawnerStorageUI getSpawnerStorageUI() {
        return this.spawnerStorageUI;
    }

    @Generated
    public FilterConfigUI getFilterConfigUI() {
        return this.filterConfigUI;
    }

    @Generated
    public SpawnerStackerUI getSpawnerStackerUI() {
        return this.spawnerStackerUI;
    }

    @Generated
    public SpawnEggHandler getSpawnEggHandler() {
        return this.spawnEggHandler;
    }

    @Generated
    public SpawnerClickManager getSpawnerClickManager() {
        return this.spawnerClickManager;
    }

    @Generated
    public SpawnerStackHandler getSpawnerStackHandler() {
        return this.spawnerStackHandler;
    }

    @Generated
    public SpawnerMenuAction getSpawnerMenuAction() {
        return this.spawnerMenuAction;
    }

    @Generated
    public SpawnerStackerHandler getSpawnerStackerHandler() {
        return this.spawnerStackerHandler;
    }

    @Generated
    public SpawnerStorageAction getSpawnerStorageAction() {
        return this.spawnerStorageAction;
    }

    @Generated
    public SpawnerSellManager getSpawnerSellManager() {
        return this.spawnerSellManager;
    }

    @Generated
    public SpawnerFileHandler getSpawnerFileHandler() {
        return this.spawnerFileHandler;
    }

    @Generated
    public SpawnerManager getSpawnerManager() {
        return this.spawnerManager;
    }

    @Generated
    public HopperHandler getHopperHandler() {
        return this.hopperHandler;
    }

    @Generated
    public NaturalSpawnerListener getNaturalSpawnerListener() {
        return this.naturalSpawnerListener;
    }

    @Generated
    public SpawnerLootGenerator getSpawnerLootGenerator() {
        return this.spawnerLootGenerator;
    }

    @Generated
    public SpawnerRangeChecker getRangeChecker() {
        return this.rangeChecker;
    }

    @Generated
    public ChunkSpawnerLimiter getChunkSpawnerLimiter() {
        return this.chunkSpawnerLimiter;
    }

    @Generated
    public SpawnerGuiViewManager getSpawnerGuiViewManager() {
        return this.spawnerGuiViewManager;
    }

    @Generated
    public SpawnerExplosionListener getSpawnerExplosionListener() {
        return this.spawnerExplosionListener;
    }

    @Generated
    public SpawnerBreakListener getSpawnerBreakListener() {
        return this.spawnerBreakListener;
    }

    @Generated
    public SpawnerPlaceListener getSpawnerPlaceListener() {
        return this.spawnerPlaceListener;
    }

    @Generated
    public WorldEventHandler getWorldEventHandler() {
        return this.worldEventHandler;
    }

    @Generated
    public ItemPriceManager getItemPriceManager() {
        return this.itemPriceManager;
    }

    @Generated
    public EntityLootRegistry getEntityLootRegistry() {
        return this.entityLootRegistry;
    }

    @Generated
    public UpdateChecker getUpdateChecker() {
        return this.updateChecker;
    }

    @Generated
    public BrigadierCommandManager getBrigadierCommandManager() {
        return this.brigadierCommandManager;
    }

    @Generated
    public ListSubCommand getListSubCommand() {
        return this.listSubCommand;
    }

    @Generated
    public UserPreferenceCache getUserPreferenceCache() {
        return this.userPreferenceCache;
    }

    @Generated
    public SpawnerListGUI getSpawnerListGUI() {
        return this.spawnerListGUI;
    }

    @Generated
    public SpawnerManagementHandler getSpawnerManagementHandler() {
        return this.spawnerManagementHandler;
    }

    @Generated
    public AdminStackerHandler getAdminStackerHandler() {
        return this.adminStackerHandler;
    }

    @Generated
    public PricesGUI getPricesGUI() {
        return this.pricesGUI;
    }

    @Generated
    public SmartSpawnerAPIImpl getApiImpl() {
        return this.apiImpl;
    }

    @Generated
    public static SmartSpawner getInstance() {
        return instance;
    }
}

