/*
 * Decompiled with CFR 0.152.
 */
package github.nighter.smartspawner.commands;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import github.nighter.smartspawner.SmartSpawner;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.Commands;
import lombok.Generated;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.command.RemoteConsoleCommandSender;
import org.bukkit.entity.Player;
import org.jspecify.annotations.NullMarked;

@NullMarked
public abstract class BaseSubCommand {
    protected final SmartSpawner plugin;

    public abstract String getName();

    public abstract String getPermission();

    public abstract String getDescription();

    public abstract int execute(CommandContext<CommandSourceStack> var1);

    public LiteralArgumentBuilder<CommandSourceStack> build() {
        LiteralArgumentBuilder builder = Commands.literal((String)this.getName());
        builder.requires(source -> this.hasPermission(source.getSender()));
        builder.executes(this::execute);
        return builder;
    }

    protected boolean hasPermission(CommandSender sender) {
        if (sender instanceof ConsoleCommandSender || sender instanceof RemoteConsoleCommandSender) {
            return true;
        }
        return sender.hasPermission(this.getPermission()) || sender.isOp();
    }

    protected void sendMessage(CommandSender sender, String message) {
        sender.sendMessage("\u00a77[\u00a76SmartSpawner\u00a77] " + message);
    }

    protected void sendError(CommandSender sender, String message) {
        sender.sendMessage("\u00a77[\u00a76SmartSpawner\u00a77] \u00a7c" + message);
    }

    protected void sendSuccess(CommandSender sender, String message) {
        sender.sendMessage("\u00a77[\u00a76SmartSpawner\u00a77] \u00a7a" + message);
    }

    protected boolean isPlayer(CommandSender sender) {
        return sender instanceof Player;
    }

    protected boolean isConsoleOrRcon(CommandSender sender) {
        return sender instanceof ConsoleCommandSender || sender instanceof RemoteConsoleCommandSender;
    }

    protected Player getPlayer(CommandSender sender) {
        return sender instanceof Player ? (Player)sender : null;
    }

    protected void sendNoPermission(CommandSender sender) {
        this.sendError(sender, "You don't have permission to use this command!");
    }

    protected void sendPlayerOnly(CommandSender sender) {
        this.sendError(sender, "This command can only be used by players!");
    }

    @Generated
    public BaseSubCommand(SmartSpawner plugin) {
        this.plugin = plugin;
    }
}

