/*
 * Decompiled with CFR 0.152.
 */
package github.nighter.smartspawner.hooks.protections;

import github.nighter.smartspawner.SmartSpawner;
import github.nighter.smartspawner.hooks.IntegrationManager;
import github.nighter.smartspawner.hooks.protections.api.GriefPrevention;
import github.nighter.smartspawner.hooks.protections.api.Lands;
import github.nighter.smartspawner.hooks.protections.api.PlotSquared;
import github.nighter.smartspawner.hooks.protections.api.SimpleClaimSystem;
import github.nighter.smartspawner.hooks.protections.api.Towny;
import github.nighter.smartspawner.hooks.protections.api.WorldGuard;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class CheckBreakBlock {
    public static boolean CanPlayerBreakBlock(@NotNull Player player, @NotNull Location location) {
        if (player.isOp() || player.hasPermission("*")) {
            return true;
        }
        IntegrationManager integrationManager = SmartSpawner.getInstance().getIntegrationManager();
        if (integrationManager.isHasGriefPrevention() && !GriefPrevention.canPlayerBreakClaimBlock(player, location)) {
            return false;
        }
        if (integrationManager.isHasWorldGuard() && !WorldGuard.canPlayerBreakBlockInRegion(player, location)) {
            return false;
        }
        if (integrationManager.isHasLands() && !Lands.canPlayerBreakClaimBlock(player, location)) {
            return false;
        }
        if (integrationManager.isHasTowny() && !Towny.canPlayerInteractSpawner(player, location)) {
            return false;
        }
        if (integrationManager.isHasSimpleClaimSystem() && !SimpleClaimSystem.canPlayerBreakClaimBlock(player, location)) {
            return false;
        }
        return !integrationManager.isHasPlotSquared() || PlotSquared.canInteract(player, location);
    }
}

