/*
 * Decompiled with CFR 0.152.
 */
package github.nighter.smartspawner.spawner.events;

import github.nighter.smartspawner.Scheduler;
import github.nighter.smartspawner.SmartSpawner;
import github.nighter.smartspawner.spawner.properties.SpawnerData;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.world.WorldInitEvent;
import org.bukkit.event.world.WorldLoadEvent;
import org.bukkit.event.world.WorldSaveEvent;
import org.bukkit.event.world.WorldUnloadEvent;

public class WorldEventHandler
implements Listener {
    private final SmartSpawner plugin;
    private final Logger logger;
    private final Set<String> processedWorlds = ConcurrentHashMap.newKeySet();
    private final Map<String, PendingSpawnerData> pendingSpawners = new ConcurrentHashMap<String, PendingSpawnerData>();
    private volatile boolean initialLoadAttempted = false;

    public WorldEventHandler(SmartSpawner plugin) {
        this.plugin = plugin;
        this.logger = plugin.getLogger();
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onWorldInit(WorldInitEvent event) {
        World world = event.getWorld();
        this.plugin.debug("World initialized: " + world.getName());
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onWorldLoad(WorldLoadEvent event) {
        World world = event.getWorld();
        String worldName = world.getName();
        this.plugin.debug("World loaded: " + worldName);
        this.processedWorlds.add(worldName);
        this.loadPendingSpawnersForWorld(worldName);
        if (!this.initialLoadAttempted) {
            Scheduler.runTaskLater(() -> this.attemptInitialSpawnerLoad(), 20L);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onWorldSave(WorldSaveEvent event) {
        World world = event.getWorld();
        this.plugin.debug("World saving: " + world.getName());
        this.plugin.getSpawnerFileHandler().flushChanges();
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onWorldUnload(WorldUnloadEvent event) {
        World world = event.getWorld();
        String worldName = world.getName();
        this.plugin.debug("World unloading: " + worldName);
        this.processedWorlds.remove(worldName);
        this.unloadSpawnersFromWorld(worldName);
        this.plugin.getSpawnerFileHandler().flushChanges();
    }

    public void attemptInitialSpawnerLoad() {
        if (this.initialLoadAttempted) {
            return;
        }
        this.initialLoadAttempted = true;
        this.plugin.debug("Attempting initial spawner load...");
        Map<String, SpawnerData> allSpawnerData = this.plugin.getSpawnerFileHandler().loadAllSpawnersRaw();
        int loadedCount = 0;
        int pendingCount = 0;
        for (Map.Entry<String, SpawnerData> entry : allSpawnerData.entrySet()) {
            String spawnerId = entry.getKey();
            SpawnerData spawner = entry.getValue();
            if (spawner != null) {
                this.plugin.getSpawnerManager().addSpawnerToIndexes(spawnerId, spawner);
                ++loadedCount;
                continue;
            }
            PendingSpawnerData pending = this.loadPendingSpawnerFromFile(spawnerId);
            if (pending == null) continue;
            this.pendingSpawners.put(spawnerId, pending);
            ++pendingCount;
        }
        this.logger.info("Initial spawner load complete. Loaded: " + loadedCount + ", Pending (missing worlds): " + pendingCount);
        if (pendingCount > 0) {
            this.logger.info("Pending spawners will be loaded when their worlds become available.");
        }
    }

    private void loadPendingSpawnersForWorld(String worldName) {
        if (this.pendingSpawners.isEmpty()) {
            return;
        }
        int loadedCount = 0;
        HashSet<String> spawnerIds = new HashSet<String>(this.pendingSpawners.keySet());
        for (String spawnerId : spawnerIds) {
            SpawnerData spawner;
            PendingSpawnerData pending = this.pendingSpawners.get(spawnerId);
            if (pending == null || !worldName.equals(pending.worldName) || (spawner = this.plugin.getSpawnerFileHandler().loadSpecificSpawner(spawnerId)) == null) continue;
            this.plugin.getSpawnerManager().addSpawnerToIndexes(spawnerId, spawner);
            this.pendingSpawners.remove(spawnerId);
            ++loadedCount;
            this.plugin.debug("Loaded pending spawner " + spawnerId + " for world " + worldName);
        }
        if (loadedCount > 0) {
            this.logger.info("Loaded " + loadedCount + " pending spawners for world: " + worldName);
        }
    }

    private void unloadSpawnersFromWorld(String worldName) {
        Set<SpawnerData> worldSpawners = this.plugin.getSpawnerManager().getSpawnersInWorld(worldName);
        if (worldSpawners != null && !worldSpawners.isEmpty()) {
            int unloadedCount = 0;
            for (SpawnerData spawner : new HashSet<SpawnerData>(worldSpawners)) {
                spawner.removeHologram();
                ++unloadedCount;
            }
            this.logger.info("Unloaded " + unloadedCount + " spawners from world: " + worldName);
        }
    }

    private PendingSpawnerData loadPendingSpawnerFromFile(String spawnerId) {
        try {
            String[] locParts;
            String locationString = this.plugin.getSpawnerFileHandler().getRawLocationString(spawnerId);
            if (locationString != null && (locParts = locationString.split(",")).length >= 1) {
                return new PendingSpawnerData(spawnerId, locParts[0]);
            }
        }
        catch (Exception e) {
            this.plugin.debug("Error loading pending spawner data for " + spawnerId + ": " + e.getMessage());
        }
        return null;
    }

    public boolean isWorldLoaded(String worldName) {
        return this.processedWorlds.contains(worldName) && Bukkit.getWorld((String)worldName) != null;
    }

    public int getPendingSpawnerCount() {
        return this.pendingSpawners.size();
    }

    private static class PendingSpawnerData {
        final String spawnerId;
        final String worldName;

        PendingSpawnerData(String spawnerId, String worldName) {
            this.spawnerId = spawnerId;
            this.worldName = worldName;
        }
    }
}

