/*
 * Decompiled with CFR 0.152.
 */
package github.nighter.smartspawner.spawner.gui.storage;

import github.nighter.smartspawner.SmartSpawner;
import github.nighter.smartspawner.language.LanguageManager;
import github.nighter.smartspawner.language.MessageService;
import github.nighter.smartspawner.spawner.gui.layout.GuiLayout;
import github.nighter.smartspawner.spawner.gui.layout.GuiLayoutConfig;
import github.nighter.smartspawner.spawner.gui.main.SpawnerMenuUI;
import github.nighter.smartspawner.spawner.gui.storage.SpawnerStorageUI;
import github.nighter.smartspawner.spawner.gui.storage.StoragePageHolder;
import github.nighter.smartspawner.spawner.gui.storage.filter.FilterConfigUI;
import github.nighter.smartspawner.spawner.gui.storage.utils.ItemClickHandler;
import github.nighter.smartspawner.spawner.gui.storage.utils.ItemMoveHelper;
import github.nighter.smartspawner.spawner.gui.storage.utils.ItemMoveResult;
import github.nighter.smartspawner.spawner.gui.synchronization.SpawnerGuiViewManager;
import github.nighter.smartspawner.spawner.loot.LootItem;
import github.nighter.smartspawner.spawner.properties.SpawnerData;
import github.nighter.smartspawner.spawner.properties.SpawnerManager;
import github.nighter.smartspawner.spawner.properties.VirtualInventory;
import github.nighter.smartspawner.spawner.sell.SpawnerSellManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.util.Vector;

public class SpawnerStorageAction
implements Listener {
    private final SmartSpawner plugin;
    private final LanguageManager languageManager;
    private final SpawnerMenuUI spawnerMenuUI;
    private final SpawnerGuiViewManager spawnerGuiViewManager;
    private final MessageService messageService;
    private final FilterConfigUI filterConfigUI;
    private final SpawnerSellManager spawnerSellManager;
    private final SpawnerManager spawnerManager;
    private GuiLayoutConfig guiLayoutConfig;
    private static final int INVENTORY_SIZE = 54;
    private static final int STORAGE_SLOTS = 45;
    private final Map<ClickType, ItemClickHandler> clickHandlers;
    private final Map<UUID, Inventory> openStorageInventories = new HashMap<UUID, Inventory>();
    private final Map<UUID, Long> lastItemClickTime = new ConcurrentHashMap<UUID, Long>();
    private Random random = new Random();
    private GuiLayout layout;

    public SpawnerStorageAction(SmartSpawner plugin) {
        this.plugin = plugin;
        this.languageManager = plugin.getLanguageManager();
        this.clickHandlers = this.initializeClickHandlers();
        this.spawnerMenuUI = plugin.getSpawnerMenuUI();
        this.spawnerGuiViewManager = plugin.getSpawnerGuiViewManager();
        this.messageService = plugin.getMessageService();
        this.filterConfigUI = plugin.getFilterConfigUI();
        this.spawnerSellManager = plugin.getSpawnerSellManager();
        this.spawnerManager = plugin.getSpawnerManager();
        this.loadConfig();
    }

    public void loadConfig() {
        this.guiLayoutConfig = this.plugin.getGuiLayoutConfig();
        this.layout = this.guiLayoutConfig.getCurrentLayout();
    }

    private Map<ClickType, ItemClickHandler> initializeClickHandlers() {
        EnumMap<ClickType, ItemClickHandler> handlers = new EnumMap<ClickType, ItemClickHandler>(ClickType.class);
        handlers.put(ClickType.RIGHT, (player, inv, slot, item, spawner) -> this.takeSingleItem(player, inv, slot, item, spawner, true));
        handlers.put(ClickType.LEFT, (player, inv, slot, item, spawner) -> this.takeSingleItem(player, inv, slot, item, spawner, false));
        return Collections.unmodifiableMap(handlers);
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onInventoryClick(InventoryClickEvent event) {
        ItemStack clickedItem;
        Player player;
        HumanEntity humanEntity;
        block9: {
            block8: {
                humanEntity = event.getWhoClicked();
                if (!(humanEntity instanceof Player)) break block8;
                player = (Player)humanEntity;
                humanEntity = event.getInventory().getHolder(false);
                if (humanEntity instanceof StoragePageHolder) break block9;
            }
            return;
        }
        StoragePageHolder holder = (StoragePageHolder)humanEntity;
        SpawnerData spawner = holder.getSpawnerData();
        int slot = event.getRawSlot();
        if ((event.getAction() == InventoryAction.DROP_ONE_SLOT || event.getAction() == InventoryAction.DROP_ALL_SLOT) && slot >= 0 && slot < 45 && (clickedItem = event.getCurrentItem()) != null && clickedItem.getType() != Material.AIR) {
            event.setCancelled(true);
            boolean dropStack = event.getAction() == InventoryAction.DROP_ALL_SLOT;
            this.handleItemDrop(player, spawner, event.getInventory(), slot, clickedItem, dropStack);
            return;
        }
        event.setCancelled(true);
        if (slot < 0 || slot >= 54) {
            return;
        }
        if (this.isControlSlot(slot)) {
            this.handleControlSlotClick(player, slot, holder, spawner, event.getInventory(), this.layout);
            return;
        }
        clickedItem = event.getCurrentItem();
        if (clickedItem == null || clickedItem.getType() == Material.AIR) {
            return;
        }
        ItemClickHandler handler = this.clickHandlers.get(event.getClick());
        if (handler != null) {
            handler.handle(player, event.getInventory(), slot, clickedItem, spawner);
        }
    }

    private void handleControlSlotClick(Player player, int slot, StoragePageHolder holder, SpawnerData spawner, Inventory inventory, GuiLayout layout) {
        String buttonType;
        Optional<String> buttonTypeOpt = layout.getButtonTypeAtSlot(slot);
        if (buttonTypeOpt.isEmpty()) {
            return;
        }
        switch (buttonType = buttonTypeOpt.get()) {
            case "sort_items": {
                this.handleSortItemsClick(player, spawner, inventory);
                break;
            }
            case "item_filter": {
                this.openFilterConfig(player, spawner);
                break;
            }
            case "previous_page": {
                if (holder.getCurrentPage() <= 1) break;
                this.updatePageContent(player, spawner, holder.getCurrentPage() - 1, inventory, true);
                break;
            }
            case "take_all": {
                this.handleTakeAllItems(player, inventory);
                break;
            }
            case "next_page": {
                if (holder.getCurrentPage() >= holder.getTotalPages()) break;
                this.updatePageContent(player, spawner, holder.getCurrentPage() + 1, inventory, true);
                break;
            }
            case "drop_page": {
                this.handleDropPageItems(player, spawner, inventory);
                break;
            }
            case "sell_all": {
                if (!this.plugin.hasSellIntegration()) break;
                if (!player.hasPermission("smartspawner.sellall")) {
                    this.messageService.sendMessage(player, "no_permission");
                    return;
                }
                if (this.isClickTooFrequent(player)) {
                    return;
                }
                player.playSound(player.getLocation(), Sound.UI_BUTTON_CLICK, 1.0f, 1.0f);
                this.spawnerSellManager.sellAllItems(player, spawner);
                break;
            }
            case "return": {
                this.openMainMenu(player, spawner);
            }
        }
    }

    @EventHandler
    public void onInventoryDrag(InventoryDragEvent event) {
        if (event.getInventory().getHolder(false) instanceof StoragePageHolder) {
            event.setCancelled(true);
        }
    }

    private boolean isControlSlot(int slot) {
        return this.layout != null && this.layout.isSlotUsed(slot);
    }

    private void handleItemDrop(Player player, SpawnerData spawner, Inventory inventory, int slot, ItemStack item, boolean dropStack) {
        int amountToDrop = dropStack ? item.getAmount() : 1;
        ItemStack droppedItem = item.clone();
        droppedItem.setAmount(Math.min(amountToDrop, item.getAmount()));
        VirtualInventory virtualInv = spawner.getVirtualInventory();
        ArrayList<ItemStack> itemsToRemove = new ArrayList<ItemStack>();
        itemsToRemove.add(droppedItem);
        spawner.removeItemsAndUpdateSellValue(itemsToRemove);
        int remaining = item.getAmount() - amountToDrop;
        if (remaining <= 0) {
            inventory.setItem(slot, null);
        } else {
            ItemStack remainingItem = item.clone();
            remainingItem.setAmount(remaining);
            inventory.setItem(slot, remainingItem);
        }
        Location playerLoc = player.getLocation();
        World world = player.getWorld();
        UUID playerUUID = player.getUniqueId();
        double yaw = Math.toRadians(playerLoc.getYaw());
        double pitch = Math.toRadians(playerLoc.getPitch());
        double sinYaw = -Math.sin(yaw);
        double cosYaw = Math.cos(yaw);
        double cosPitch = Math.cos(pitch);
        double sinPitch = -Math.sin(pitch);
        Location dropLocation = playerLoc.clone();
        dropLocation.add(sinYaw * 0.3, 1.2, cosYaw * 0.3);
        Item droppedItemWorld = world.dropItem(dropLocation, droppedItem, drop -> {
            drop.setThrower(playerUUID);
            drop.setPickupDelay(40);
        });
        Vector velocity = new Vector(sinYaw * cosPitch * 0.3 + (this.random.nextDouble() - 0.5) * 0.1, sinPitch * 0.3 + 0.1 + (this.random.nextDouble() - 0.5) * 0.1, cosYaw * cosPitch * 0.3 + (this.random.nextDouble() - 0.5) * 0.1);
        droppedItemWorld.setVelocity(velocity);
        player.playSound(player.getLocation(), Sound.ENTITY_ITEM_PICKUP, 0.5f, 1.2f);
        spawner.updateHologramData();
        StoragePageHolder holder = (StoragePageHolder)inventory.getHolder(false);
        if (holder != null) {
            this.spawnerGuiViewManager.updateSpawnerMenuViewers(spawner);
            if (!spawner.isInteracted()) {
                spawner.markInteracted();
            }
            if (spawner.getMaxSpawnerLootSlots() > holder.getOldUsedSlots() && spawner.getIsAtCapacity().booleanValue()) {
                spawner.setIsAtCapacity(false);
            }
        }
    }

    private void handleDropPageItems(Player player, SpawnerData spawner, Inventory inventory) {
        if (this.isClickTooFrequent(player)) {
            return;
        }
        StoragePageHolder holder = (StoragePageHolder)inventory.getHolder(false);
        if (holder == null) {
            return;
        }
        ArrayList<ItemStack> pageItems = new ArrayList<ItemStack>();
        int itemsFound = 0;
        for (int i = 0; i < 45; ++i) {
            ItemStack item = inventory.getItem(i);
            if (item == null || item.getType() == Material.AIR) continue;
            pageItems.add(item.clone());
            itemsFound += item.getAmount();
            inventory.setItem(i, null);
        }
        if (pageItems.isEmpty()) {
            this.messageService.sendMessage(player, "no_items_to_drop");
            return;
        }
        VirtualInventory virtualInv = spawner.getVirtualInventory();
        spawner.removeItemsAndUpdateSellValue(pageItems);
        this.dropItemsInDirection(player, pageItems);
        int newTotalPages = this.calculateTotalPages(spawner);
        if (holder.getCurrentPage() > newTotalPages) {
            holder.setCurrentPage(Math.max(1, newTotalPages));
        }
        holder.setTotalPages(newTotalPages);
        holder.updateOldUsedSlots();
        spawner.updateHologramData();
        this.spawnerGuiViewManager.updateSpawnerMenuViewers(spawner);
        if (spawner.getMaxSpawnerLootSlots() > holder.getOldUsedSlots() && spawner.getIsAtCapacity().booleanValue()) {
            spawner.setIsAtCapacity(false);
        }
        if (!spawner.isInteracted()) {
            spawner.markInteracted();
        }
        this.updatePageContent(player, spawner, holder.getCurrentPage(), inventory, false);
        player.playSound(player.getLocation(), Sound.ENTITY_ITEM_PICKUP, 0.8f, 0.8f);
    }

    private void dropItemsInDirection(Player player, List<ItemStack> items) {
        if (items.isEmpty()) {
            return;
        }
        Location playerLoc = player.getLocation();
        World world = player.getWorld();
        UUID playerUUID = player.getUniqueId();
        double yaw = Math.toRadians(playerLoc.getYaw());
        double pitch = Math.toRadians(playerLoc.getPitch());
        double sinYaw = -Math.sin(yaw);
        double cosYaw = Math.cos(yaw);
        double cosPitch = Math.cos(pitch);
        double sinPitch = -Math.sin(pitch);
        Location dropLocation = playerLoc.clone();
        dropLocation.add(sinYaw * 0.3, 1.2, cosYaw * 0.3);
        for (ItemStack item : items) {
            Item droppedItem = world.dropItem(dropLocation, item, drop -> {
                drop.setThrower(playerUUID);
                drop.setPickupDelay(40);
            });
            Vector velocity = new Vector(sinYaw * cosPitch * 0.3 + (this.random.nextDouble() - 0.5) * 0.1, sinPitch * 0.3 + 0.1 + (this.random.nextDouble() - 0.5) * 0.1, cosYaw * cosPitch * 0.3 + (this.random.nextDouble() - 0.5) * 0.1);
            droppedItem.setVelocity(velocity);
        }
    }

    private void openFilterConfig(Player player, SpawnerData spawner) {
        if (this.isClickTooFrequent(player)) {
            return;
        }
        this.filterConfigUI.openFilterConfigGUI(player, spawner);
    }

    private void takeSingleItem(Player player, Inventory sourceInv, int slot, ItemStack item, SpawnerData spawner, boolean singleItem) {
        VirtualInventory virtualInv;
        PlayerInventory playerInv;
        ItemMoveResult result = ItemMoveHelper.moveItems(item, singleItem ? 1 : item.getAmount(), playerInv = player.getInventory(), virtualInv = spawner.getVirtualInventory());
        if (result.getAmountMoved() > 0) {
            SpawnerStorageAction.updateInventorySlot(sourceInv, slot, item, result.getAmountMoved());
            spawner.removeItemsAndUpdateSellValue(result.getMovedItems());
            player.updateInventory();
            spawner.updateHologramData();
            StoragePageHolder holder = (StoragePageHolder)sourceInv.getHolder(false);
            if (holder != null) {
                this.spawnerGuiViewManager.updateSpawnerMenuViewers(spawner);
                if (spawner.getMaxSpawnerLootSlots() > holder.getOldUsedSlots() && spawner.getIsAtCapacity().booleanValue()) {
                    spawner.setIsAtCapacity(false);
                }
            }
        } else {
            this.messageService.sendMessage(player, "inventory_full");
        }
    }

    private static void updateInventorySlot(Inventory sourceInv, int slot, ItemStack item, int amountMoved) {
        if (amountMoved >= item.getAmount()) {
            sourceInv.setItem(slot, null);
            return;
        }
        ItemStack remaining = item.clone();
        remaining.setAmount(item.getAmount() - amountMoved);
        sourceInv.setItem(slot, remaining);
    }

    private void updatePageContent(Player player, SpawnerData spawner, int newPage, Inventory inventory, boolean uiClickSound) {
        SpawnerStorageUI lootManager = this.plugin.getSpawnerStorageUI();
        StoragePageHolder holder = (StoragePageHolder)inventory.getHolder(false);
        int totalPages = this.calculateTotalPages(spawner);
        assert (holder != null);
        holder.setTotalPages(totalPages);
        holder.setCurrentPage(newPage);
        holder.updateOldUsedSlots();
        lootManager.updateDisplay(inventory, spawner, newPage, totalPages);
        this.updateInventoryTitle(player, inventory, spawner, newPage, totalPages);
        if (uiClickSound) {
            player.playSound(player.getLocation(), Sound.UI_BUTTON_CLICK, 1.0f, 1.0f);
        }
    }

    private int calculateTotalPages(SpawnerData spawner) {
        int usedSlots = spawner.getVirtualInventory().getUsedSlots();
        return Math.max(1, (int)Math.ceil((double)usedSlots / 45.0));
    }

    private void updateInventoryTitle(Player player, Inventory inventory, SpawnerData spawner, int page, int totalPages) {
        String baseTitle = this.languageManager.getGuiTitle("gui_title_storage");
        String newTitle = baseTitle + " - [" + page + "/" + totalPages + "]";
        try {
            player.getOpenInventory().setTitle(newTitle);
        }
        catch (Exception e) {
            this.openLootPage(player, spawner, page, false);
        }
    }

    private boolean isClickTooFrequent(Player player) {
        long now = System.currentTimeMillis();
        long last = this.lastItemClickTime.getOrDefault(player.getUniqueId(), 0L);
        this.lastItemClickTime.put(player.getUniqueId(), now);
        return now - last < 300L;
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        UUID playerId = event.getPlayer().getUniqueId();
        this.lastItemClickTime.remove(playerId);
    }

    private void openMainMenu(Player player, SpawnerData spawner) {
        player.playSound(player.getLocation(), Sound.UI_BUTTON_CLICK, 1.0f, 1.0f);
        if (spawner.isInteracted()) {
            this.spawnerManager.markSpawnerModified(spawner.getSpawnerId());
            spawner.clearInteracted();
        }
        if (this.isBedrockPlayer(player)) {
            if (this.plugin.getSpawnerMenuFormUI() != null) {
                this.plugin.getSpawnerMenuFormUI().openSpawnerForm(player, spawner);
            } else {
                this.spawnerMenuUI.openSpawnerMenu(player, spawner, true);
            }
        } else {
            this.spawnerMenuUI.openSpawnerMenu(player, spawner, true);
        }
    }

    private boolean isBedrockPlayer(Player player) {
        if (this.plugin.getIntegrationManager() == null || this.plugin.getIntegrationManager().getFloodgateHook() == null) {
            return false;
        }
        return this.plugin.getIntegrationManager().getFloodgateHook().isBedrockPlayer(player);
    }

    private void handleSortItemsClick(Player player, SpawnerData spawner, Inventory inventory) {
        Material nextSort;
        if (this.isClickTooFrequent(player)) {
            return;
        }
        if (spawner.getLootConfig() == null || spawner.getLootConfig().getAllItems() == null) {
            return;
        }
        List<LootItem> lootItems = spawner.getLootConfig().getAllItems();
        if (lootItems.isEmpty()) {
            return;
        }
        Material currentSort = spawner.getPreferredSortItem();
        List<Material> sortedLoot = lootItems.stream().map(LootItem::getMaterial).distinct().sorted(Comparator.comparing(Enum::name)).toList();
        if (sortedLoot.isEmpty()) {
            return;
        }
        if (currentSort == null) {
            nextSort = sortedLoot.getFirst();
        } else {
            int currentIndex = sortedLoot.indexOf(currentSort);
            if (currentIndex == -1) {
                nextSort = sortedLoot.getFirst();
            } else {
                int nextIndex = (currentIndex + 1) % sortedLoot.size();
                nextSort = sortedLoot.get(nextIndex);
            }
        }
        spawner.setPreferredSortItem(nextSort);
        if (!spawner.isInteracted()) {
            spawner.markInteracted();
        }
        this.spawnerManager.queueSpawnerForSaving(spawner.getSpawnerId());
        spawner.getVirtualInventory().sortItems(nextSort);
        StoragePageHolder holder = (StoragePageHolder)inventory.getHolder(false);
        if (holder != null) {
            this.updatePageContent(player, spawner, holder.getCurrentPage(), inventory, false);
        }
        player.playSound(player.getLocation(), Sound.UI_BUTTON_CLICK, 1.0f, 1.2f);
    }

    private void openLootPage(Player player, SpawnerData spawner, int page, boolean refresh) {
        List<Material> sortedLoot;
        List<LootItem> lootItems;
        SpawnerStorageUI lootManager = this.plugin.getSpawnerStorageUI();
        String title = this.languageManager.getGuiTitle("gui_title_storage");
        int totalPages = this.calculateTotalPages(spawner);
        page = Math.max(1, Math.min(page, totalPages));
        UUID playerId = player.getUniqueId();
        Inventory existingInventory = this.openStorageInventories.get(playerId);
        if (existingInventory != null && !refresh && existingInventory.getHolder(false) instanceof StoragePageHolder) {
            StoragePageHolder holder = (StoragePageHolder)existingInventory.getHolder(false);
            holder.setTotalPages(totalPages);
            holder.setCurrentPage(page);
            holder.updateOldUsedSlots();
            this.updatePageContent(player, spawner, page, existingInventory, false);
            return;
        }
        Material currentSort = spawner.getPreferredSortItem();
        if (currentSort == null && spawner.getLootConfig() != null && spawner.getLootConfig().getAllItems() != null && !(lootItems = spawner.getLootConfig().getAllItems()).isEmpty() && !(sortedLoot = lootItems.stream().map(LootItem::getMaterial).distinct().sorted(Comparator.comparing(Enum::name)).toList()).isEmpty()) {
            Material firstItem = sortedLoot.getFirst();
            spawner.setPreferredSortItem(firstItem);
            currentSort = firstItem;
            if (!spawner.isInteracted()) {
                spawner.markInteracted();
            }
            this.spawnerManager.queueSpawnerForSaving(spawner.getSpawnerId());
        }
        if (currentSort != null) {
            spawner.getVirtualInventory().sortItems(currentSort);
        }
        Inventory pageInventory = lootManager.createInventory(spawner, title, page, totalPages);
        this.openStorageInventories.put(playerId, pageInventory);
        Sound sound = refresh ? Sound.ITEM_ARMOR_EQUIP_DIAMOND : Sound.UI_BUTTON_CLICK;
        float pitch = refresh ? 1.2f : 1.0f;
        player.playSound(player.getLocation(), sound, 1.0f, pitch);
        player.openInventory(pageInventory);
    }

    public void handleTakeAllItems(Player player, Inventory sourceInventory) {
        if (this.isClickTooFrequent(player)) {
            return;
        }
        StoragePageHolder holder = (StoragePageHolder)sourceInventory.getHolder(false);
        SpawnerData spawner = holder.getSpawnerData();
        VirtualInventory virtualInv = spawner.getVirtualInventory();
        HashMap<Integer, ItemStack> sourceItems = new HashMap<Integer, ItemStack>();
        for (int i = 0; i < 45; ++i) {
            ItemStack item = sourceInventory.getItem(i);
            if (item == null || item.getType() == Material.AIR) continue;
            sourceItems.put(i, item.clone());
        }
        if (sourceItems.isEmpty()) {
            this.messageService.sendMessage(player, "no_items_to_take");
            return;
        }
        TransferResult result = this.transferItems(player, sourceInventory, sourceItems, virtualInv);
        this.sendTransferMessage(player, result);
        player.updateInventory();
        if (result.anyItemMoved) {
            int newTotalPages = this.calculateTotalPages(spawner);
            holder.setTotalPages(newTotalPages);
            this.spawnerGuiViewManager.updateSpawnerMenuViewers(spawner);
            if (spawner.getMaxSpawnerLootSlots() > holder.getOldUsedSlots() && spawner.getIsAtCapacity().booleanValue()) {
                spawner.setIsAtCapacity(false);
            }
            if (!spawner.isInteracted()) {
                spawner.markInteracted();
            }
        }
    }

    private TransferResult transferItems(Player player, Inventory sourceInventory, Map<Integer, ItemStack> sourceItems, VirtualInventory virtualInv) {
        boolean anyItemMoved = false;
        boolean inventoryFull = false;
        PlayerInventory playerInv = player.getInventory();
        int totalAmountMoved = 0;
        ArrayList<ItemStack> itemsToRemove = new ArrayList<ItemStack>();
        for (Map.Entry<Integer, ItemStack> entry : sourceItems.entrySet()) {
            int sourceSlot = entry.getKey();
            ItemStack itemToMove = entry.getValue();
            int amountToMove = itemToMove.getAmount();
            int amountMoved = 0;
            for (int i = 0; i < 36 && amountToMove > 0; ++i) {
                int spaceInStack;
                ItemStack targetItem = playerInv.getItem(i);
                if (targetItem == null || targetItem.getType() == Material.AIR) {
                    ItemStack newStack = itemToMove.clone();
                    newStack.setAmount(Math.min(amountToMove, itemToMove.getMaxStackSize()));
                    playerInv.setItem(i, newStack);
                    amountMoved += newStack.getAmount();
                    amountToMove -= newStack.getAmount();
                    anyItemMoved = true;
                    continue;
                }
                if (!targetItem.isSimilar(itemToMove) || (spaceInStack = targetItem.getMaxStackSize() - targetItem.getAmount()) <= 0) continue;
                int addAmount = Math.min(spaceInStack, amountToMove);
                targetItem.setAmount(targetItem.getAmount() + addAmount);
                amountMoved += addAmount;
                amountToMove -= addAmount;
                anyItemMoved = true;
            }
            if (amountMoved > 0) {
                totalAmountMoved += amountMoved;
                ItemStack movedItem = itemToMove.clone();
                movedItem.setAmount(amountMoved);
                itemsToRemove.add(movedItem);
                if (amountMoved == itemToMove.getAmount()) {
                    sourceInventory.setItem(sourceSlot, null);
                } else {
                    ItemStack remaining = itemToMove.clone();
                    remaining.setAmount(itemToMove.getAmount() - amountMoved);
                    sourceInventory.setItem(sourceSlot, remaining);
                    inventoryFull = true;
                }
            }
            if (!inventoryFull) continue;
            break;
        }
        if (!itemsToRemove.isEmpty()) {
            StoragePageHolder holder = (StoragePageHolder)sourceInventory.getHolder(false);
            holder.getSpawnerData().removeItemsAndUpdateSellValue(itemsToRemove);
            holder.getSpawnerData().updateHologramData();
            holder.updateOldUsedSlots();
        }
        return new TransferResult(anyItemMoved, inventoryFull, totalAmountMoved);
    }

    private void sendTransferMessage(Player player, TransferResult result) {
        if (!result.anyItemMoved) {
            this.messageService.sendMessage(player, "inventory_full");
        } else {
            HashMap<String, String> placeholders = new HashMap<String, String>();
            placeholders.put("amount", String.valueOf(result.totalMoved));
            this.messageService.sendMessage(player, "take_all_items", placeholders);
        }
    }

    @EventHandler
    public void onInventoryClose(InventoryCloseEvent event) {
        SpawnerData spawner;
        InventoryHolder inventoryHolder = event.getInventory().getHolder(false);
        if (!(inventoryHolder instanceof StoragePageHolder)) {
            return;
        }
        StoragePageHolder holder = (StoragePageHolder)inventoryHolder;
        HumanEntity humanEntity = event.getPlayer();
        if (humanEntity instanceof Player) {
            Player player = (Player)humanEntity;
            UUID playerId = player.getUniqueId();
            this.openStorageInventories.remove(playerId);
        }
        if ((spawner = holder.getSpawnerData()).isInteracted()) {
            this.spawnerManager.markSpawnerModified(spawner.getSpawnerId());
            spawner.clearInteracted();
        }
    }

    private record TransferResult(boolean anyItemMoved, boolean inventoryFull, int totalMoved) {
    }
}

