/*
 * Decompiled with CFR 0.152.
 */
package github.nighter.smartspawner.spawner.gui.synchronization;

import github.nighter.smartspawner.Scheduler;
import github.nighter.smartspawner.SmartSpawner;
import github.nighter.smartspawner.language.LanguageManager;
import github.nighter.smartspawner.spawner.gui.layout.GuiButton;
import github.nighter.smartspawner.spawner.gui.layout.GuiLayout;
import github.nighter.smartspawner.spawner.gui.main.SpawnerMenuHolder;
import github.nighter.smartspawner.spawner.gui.main.SpawnerMenuUI;
import github.nighter.smartspawner.spawner.gui.storage.SpawnerStorageUI;
import github.nighter.smartspawner.spawner.gui.storage.StoragePageHolder;
import github.nighter.smartspawner.spawner.gui.storage.filter.FilterConfigHolder;
import github.nighter.smartspawner.spawner.gui.synchronization.ItemUpdater;
import github.nighter.smartspawner.spawner.properties.SpawnerData;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class SpawnerGuiViewManager
implements Listener {
    private static final long UPDATE_INTERVAL_TICKS = 20L;
    private static final long INITIAL_DELAY_TICKS = 20L;
    private static final int ITEMS_PER_PAGE = 45;
    private static final int MAX_PLAYERS_PER_BATCH = 10;
    private volatile int cachedStorageSlot = -1;
    private volatile int cachedExpSlot = -1;
    private volatile int cachedSpawnerInfoSlot = -1;
    private static final int UPDATE_CHEST = 1;
    private static final int UPDATE_INFO = 2;
    private static final int UPDATE_EXP = 4;
    private static final int UPDATE_ALL = 7;
    private final SmartSpawner plugin;
    private final LanguageManager languageManager;
    private final SpawnerStorageUI spawnerStorageUI;
    private final SpawnerMenuUI spawnerMenuUI;
    private final Map<UUID, SpawnerViewerInfo> playerToSpawnerMap;
    private final Map<String, Set<UUID>> spawnerToPlayersMap;
    private final Set<Class<? extends InventoryHolder>> validHolderTypes;
    private final Map<String, Set<UUID>> spawnerToFilterViewersMap;
    private final Map<UUID, SpawnerViewerInfo> mainMenuViewers = new ConcurrentHashMap<UUID, SpawnerViewerInfo>();
    private final Map<String, Set<UUID>> spawnerToMainMenuViewers = new ConcurrentHashMap<String, Set<UUID>>();
    private final Set<UUID> pendingUpdates = ConcurrentHashMap.newKeySet();
    private final Map<UUID, Integer> updateFlags = new ConcurrentHashMap<UUID, Integer>();
    private final Map<UUID, Long> lastTimerUpdate = new ConcurrentHashMap<UUID, Long>();
    private final Map<UUID, String> lastTimerValue = new ConcurrentHashMap<UUID, String>();
    private Scheduler.Task updateTask;
    private volatile boolean isTaskRunning;
    private String cachedInactiveText;
    private String cachedFullText;
    private volatile Boolean hasTimerPlaceholders = null;

    public SpawnerGuiViewManager(SmartSpawner plugin) {
        this.plugin = plugin;
        this.languageManager = plugin.getLanguageManager();
        this.spawnerStorageUI = plugin.getSpawnerStorageUI();
        this.spawnerMenuUI = plugin.getSpawnerMenuUI();
        this.playerToSpawnerMap = new ConcurrentHashMap<UUID, SpawnerViewerInfo>();
        this.spawnerToPlayersMap = new ConcurrentHashMap<String, Set<UUID>>();
        this.spawnerToFilterViewersMap = new ConcurrentHashMap<String, Set<UUID>>();
        this.isTaskRunning = false;
        this.validHolderTypes = Set.of(SpawnerMenuHolder.class, StoragePageHolder.class, FilterConfigHolder.class);
        this.initCachedStrings();
        this.initializeSlotPositions();
    }

    private void initCachedStrings() {
        this.cachedInactiveText = this.languageManager.getGuiItemName("spawner_info_item.lore_inactive");
        this.cachedFullText = this.languageManager.getGuiItemName("spawner_info_item.lore_full");
        this.checkTimerPlaceholderUsage();
    }

    private void checkTimerPlaceholderUsage() {
        try {
            String[] loreLines = this.languageManager.getGuiItemLore("spawner_info_item.lore");
            String[] loreNoShopLines = this.languageManager.getGuiItemLore("spawner_info_item.lore_no_shop");
            boolean hasTimers = false;
            if (loreLines != null) {
                for (String line : loreLines) {
                    if (line == null || !line.contains("%time%")) continue;
                    hasTimers = true;
                    break;
                }
            }
            if (!hasTimers && loreNoShopLines != null) {
                for (String line : loreNoShopLines) {
                    if (line == null || !line.contains("%time%")) continue;
                    hasTimers = true;
                    break;
                }
            }
            this.hasTimerPlaceholders = hasTimers;
        }
        catch (Exception e) {
            this.hasTimerPlaceholders = true;
        }
    }

    public boolean isTimerPlaceholdersEnabled() {
        return this.hasTimerPlaceholders == null || this.hasTimerPlaceholders != false;
    }

    public void recheckTimerPlaceholders() {
        this.initCachedStrings();
        if (this.hasTimerPlaceholders != null && this.hasTimerPlaceholders.booleanValue() && !this.playerToSpawnerMap.isEmpty() && !this.isTaskRunning) {
            this.startUpdateTask();
        }
    }

    private synchronized void startUpdateTask() {
        if (this.isTaskRunning) {
            return;
        }
        if (this.playerToSpawnerMap.isEmpty()) {
            return;
        }
        this.updateTask = Scheduler.runTaskTimer(this::updateGuiForSpawnerInfo, 20L, 20L);
        this.isTaskRunning = true;
    }

    public synchronized void stopUpdateTask() {
        if (!this.isTaskRunning) {
            return;
        }
        if (this.updateTask != null) {
            this.updateTask.cancel();
            this.updateTask = null;
        }
        this.isTaskRunning = false;
    }

    private boolean isValidGuiSession(Player player) {
        return player != null && player.isOnline();
    }

    private boolean isValidHolder(InventoryHolder holder) {
        return holder != null && this.validHolderTypes.contains(holder.getClass());
    }

    public void trackViewer(UUID playerId, SpawnerData spawner, ViewerType viewerType) {
        this.playerToSpawnerMap.put(playerId, new SpawnerViewerInfo(spawner, viewerType));
        this.spawnerToPlayersMap.computeIfAbsent(spawner.getSpawnerId(), k -> ConcurrentHashMap.newKeySet()).add(playerId);
        if (viewerType == ViewerType.MAIN_MENU) {
            this.mainMenuViewers.put(playerId, new SpawnerViewerInfo(spawner, viewerType));
            this.spawnerToMainMenuViewers.computeIfAbsent(spawner.getSpawnerId(), k -> ConcurrentHashMap.newKeySet()).add(playerId);
        }
        if (viewerType == ViewerType.FILTER) {
            this.spawnerToFilterViewersMap.computeIfAbsent(spawner.getSpawnerId(), k -> ConcurrentHashMap.newKeySet()).add(playerId);
        }
        if (!this.isTaskRunning && !this.playerToSpawnerMap.isEmpty()) {
            this.startUpdateTask();
        }
    }

    public void untrackViewer(UUID playerId) {
        String spawnerId;
        Set<UUID> filterViewers;
        SpawnerData spawner;
        Set<UUID> mainMenuViewerSet;
        SpawnerViewerInfo mainMenuInfo;
        SpawnerData spawner2;
        Set<UUID> viewers;
        SpawnerViewerInfo info = this.playerToSpawnerMap.remove(playerId);
        if (info != null && (viewers = this.spawnerToPlayersMap.get((spawner2 = info.spawnerData).getSpawnerId())) != null) {
            viewers.remove(playerId);
            if (viewers.isEmpty()) {
                this.spawnerToPlayersMap.remove(spawner2.getSpawnerId());
            }
        }
        if ((mainMenuInfo = this.mainMenuViewers.remove(playerId)) != null && (mainMenuViewerSet = this.spawnerToMainMenuViewers.get((spawner = mainMenuInfo.spawnerData).getSpawnerId())) != null) {
            mainMenuViewerSet.remove(playerId);
            if (mainMenuViewerSet.isEmpty()) {
                this.spawnerToMainMenuViewers.remove(spawner.getSpawnerId());
            }
        }
        if (info != null && (filterViewers = this.spawnerToFilterViewersMap.get(spawnerId = info.spawnerData.getSpawnerId())) != null) {
            filterViewers.remove(playerId);
            if (filterViewers.isEmpty()) {
                this.spawnerToFilterViewersMap.remove(spawnerId);
            }
        }
        this.pendingUpdates.remove(playerId);
        this.updateFlags.remove(playerId);
        this.lastTimerUpdate.remove(playerId);
        this.lastTimerValue.remove(playerId);
        if (this.playerToSpawnerMap.isEmpty() && this.isTaskRunning) {
            this.stopUpdateTask();
        }
    }

    public Set<Player> getViewers(String spawnerId) {
        Set<UUID> viewerIds = this.spawnerToPlayersMap.get(spawnerId);
        if (viewerIds == null || viewerIds.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<Player> onlineViewers = new HashSet<Player>(viewerIds.size());
        for (UUID id : viewerIds) {
            Player player = Bukkit.getPlayer((UUID)id);
            if (player == null || !player.isOnline()) continue;
            onlineViewers.add(player);
        }
        return onlineViewers;
    }

    public boolean hasViewers(SpawnerData spawner) {
        Set<UUID> viewers = this.spawnerToPlayersMap.get(spawner.getSpawnerId());
        return viewers != null && !viewers.isEmpty();
    }

    public void clearAllTrackedGuis() {
        this.playerToSpawnerMap.clear();
        this.spawnerToPlayersMap.clear();
        this.mainMenuViewers.clear();
        this.spawnerToMainMenuViewers.clear();
        this.spawnerToFilterViewersMap.clear();
        this.pendingUpdates.clear();
        this.updateFlags.clear();
        this.lastTimerUpdate.clear();
        this.lastTimerValue.clear();
    }

    private void initializeSlotPositions() {
        GuiLayout layout = this.plugin.getGuiLayoutConfig().getCurrentMainLayout();
        if (layout == null) {
            this.cachedStorageSlot = -1;
            this.cachedExpSlot = -1;
            this.cachedSpawnerInfoSlot = -1;
            return;
        }
        GuiButton storageButton = layout.getButton("storage");
        this.cachedStorageSlot = storageButton != null ? storageButton.getSlot() : -1;
        GuiButton expButton = layout.getButton("exp");
        this.cachedExpSlot = expButton != null ? expButton.getSlot() : -1;
        GuiButton spawnerInfoButton = null;
        if (this.plugin.hasSellIntegration()) {
            spawnerInfoButton = layout.getButton("spawner_info_with_shop");
        }
        if (spawnerInfoButton == null) {
            spawnerInfoButton = layout.getButton("spawner_info_no_shop");
        }
        if (spawnerInfoButton == null) {
            spawnerInfoButton = layout.getButton("spawner_info");
        }
        this.cachedSpawnerInfoSlot = spawnerInfoButton != null ? spawnerInfoButton.getSlot() : -1;
    }

    private int getStorageSlot() {
        return this.cachedStorageSlot;
    }

    private int getExpSlot() {
        return this.cachedExpSlot;
    }

    private int getSpawnerInfoSlot() {
        return this.cachedSpawnerInfoSlot;
    }

    public void clearSlotCache() {
        this.initializeSlotPositions();
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onInventoryOpen(InventoryOpenEvent event) {
        HumanEntity humanEntity = event.getPlayer();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player player = (Player)humanEntity;
        InventoryHolder holder = event.getInventory().getHolder(false);
        if (!this.isValidHolder(holder)) {
            return;
        }
        UUID playerId = player.getUniqueId();
        SpawnerData spawnerData = null;
        ViewerType viewerType = null;
        if (holder instanceof SpawnerMenuHolder) {
            SpawnerMenuHolder spawnerHolder = (SpawnerMenuHolder)holder;
            spawnerData = spawnerHolder.getSpawnerData();
            viewerType = ViewerType.MAIN_MENU;
        } else if (holder instanceof StoragePageHolder) {
            StoragePageHolder storageHolder = (StoragePageHolder)holder;
            spawnerData = storageHolder.getSpawnerData();
            viewerType = ViewerType.STORAGE;
        } else if (holder instanceof FilterConfigHolder) {
            FilterConfigHolder filterHolder = (FilterConfigHolder)holder;
            spawnerData = filterHolder.getSpawnerData();
            viewerType = ViewerType.FILTER;
        }
        if (spawnerData != null && viewerType != null) {
            this.trackViewer(playerId, spawnerData, viewerType);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onInventoryClose(InventoryCloseEvent event) {
        HumanEntity humanEntity = event.getPlayer();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player player = (Player)humanEntity;
        SpawnerViewerInfo info = this.playerToSpawnerMap.get(player.getUniqueId());
        if (info != null && info.spawnerData != null) {
            info.spawnerData.updateLastInteractedPlayer(player.getName());
        }
        this.untrackViewer(player.getUniqueId());
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerQuit(PlayerQuitEvent event) {
        this.untrackViewer(event.getPlayer().getUniqueId());
    }

    private void updateGuiForSpawnerInfo() {
        this.processPendingUpdates();
        if (!this.isTimerPlaceholdersEnabled()) {
            if (this.playerToSpawnerMap.isEmpty()) {
                this.stopUpdateTask();
            }
            return;
        }
        if (this.mainMenuViewers.isEmpty()) {
            if (this.playerToSpawnerMap.isEmpty()) {
                this.stopUpdateTask();
            }
            return;
        }
        long currentTime = System.currentTimeMillis();
        HashMap<String, List> spawnerViewers = new HashMap<String, List>();
        for (Map.Entry<UUID, SpawnerViewerInfo> entry : this.mainMenuViewers.entrySet()) {
            UUID playerId = entry.getKey();
            SpawnerViewerInfo viewerInfo = entry.getValue();
            SpawnerData spawner = viewerInfo.spawnerData;
            String spawnerId = spawner.getSpawnerId();
            Player player = Bukkit.getPlayer((UUID)playerId);
            if (!this.isValidGuiSession(player)) {
                this.untrackViewer(playerId);
                continue;
            }
            Inventory openInventory = player.getOpenInventory().getTopInventory();
            if (openInventory == null || !(openInventory.getHolder(false) instanceof SpawnerMenuHolder)) {
                this.untrackViewer(playerId);
                continue;
            }
            Long lastUpdate = this.lastTimerUpdate.get(playerId);
            if (lastUpdate != null && currentTime - lastUpdate < 800L) continue;
            spawnerViewers.computeIfAbsent(spawnerId, k -> new ArrayList()).add(playerId);
        }
        int processedPlayers = 0;
        for (Map.Entry spawnerGroup : spawnerViewers.entrySet()) {
            UUID firstViewer;
            SpawnerViewerInfo viewerInfo;
            String spawnerId = (String)spawnerGroup.getKey();
            List viewers = (List)spawnerGroup.getValue();
            if (viewers.isEmpty() || (viewerInfo = this.mainMenuViewers.get(firstViewer = (UUID)viewers.get(0))) == null) continue;
            SpawnerData spawner = viewerInfo.spawnerData;
            long timeUntilNextSpawn = this.calculateTimeUntilNextSpawn(spawner);
            String newTimerValue = spawner.getIsAtCapacity() != false ? this.cachedFullText : (timeUntilNextSpawn == -1L ? this.cachedInactiveText : this.formatTime(timeUntilNextSpawn));
            for (UUID playerId : viewers) {
                if (processedPlayers >= 10) break;
                if (!this.mainMenuViewers.containsKey(playerId)) continue;
                Player player = Bukkit.getPlayer((UUID)playerId);
                if (!this.isValidGuiSession(player)) {
                    this.untrackViewer(playerId);
                    continue;
                }
                String lastValue = this.lastTimerValue.get(playerId);
                if (lastValue != null && lastValue.equals(newTimerValue)) continue;
                this.lastTimerUpdate.put(playerId, currentTime);
                this.lastTimerValue.put(playerId, newTimerValue);
                ++processedPlayers;
                Location playerLocation = player.getLocation();
                if (playerLocation == null) continue;
                String finalTimerValue = newTimerValue;
                UUID finalPlayerId = playerId;
                Scheduler.runLocationTask(playerLocation, () -> {
                    if (!player.isOnline() || !this.mainMenuViewers.containsKey(finalPlayerId)) {
                        return;
                    }
                    Inventory openInventory = player.getOpenInventory().getTopInventory();
                    if (openInventory == null) {
                        return;
                    }
                    InventoryHolder holder = openInventory.getHolder(false);
                    if (holder instanceof SpawnerMenuHolder) {
                        int spawnerInfoSlot = this.getSpawnerInfoSlot();
                        if (spawnerInfoSlot >= 0) {
                            this.updateSpawnerInfoItemTimerOptimized(openInventory, spawner, finalTimerValue, spawnerInfoSlot);
                            player.updateInventory();
                        }
                    } else {
                        this.untrackViewer(finalPlayerId);
                    }
                });
            }
            if (processedPlayers < 10) continue;
            break;
        }
    }

    private void processPendingUpdates() {
        if (this.pendingUpdates.isEmpty()) {
            return;
        }
        HashSet<UUID> currentUpdates = new HashSet<UUID>(this.pendingUpdates);
        this.pendingUpdates.clear();
        for (UUID playerId : currentUpdates) {
            Player player = Bukkit.getPlayer((UUID)playerId);
            if (!this.isValidGuiSession(player)) {
                this.untrackViewer(playerId);
                this.updateFlags.remove(playerId);
                continue;
            }
            SpawnerViewerInfo info = this.playerToSpawnerMap.get(playerId);
            if (info == null) {
                this.updateFlags.remove(playerId);
                continue;
            }
            int flags = this.updateFlags.getOrDefault(playerId, 7);
            this.updateFlags.remove(playerId);
            Location loc = player.getLocation();
            if (loc == null) continue;
            int finalFlags = flags;
            SpawnerData spawner = info.spawnerData;
            Scheduler.runLocationTask(loc, () -> {
                if (!player.isOnline()) {
                    return;
                }
                Inventory openInv = player.getOpenInventory().getTopInventory();
                if (openInv == null || !(openInv.getHolder(false) instanceof SpawnerMenuHolder)) {
                    return;
                }
                this.processInventoryUpdate(player, openInv, spawner, finalFlags);
            });
        }
    }

    private void processInventoryUpdate(Player player, Inventory inventory, SpawnerData spawner, int flags) {
        int expSlot;
        int spawnerInfoSlot;
        int storageSlot;
        boolean needsUpdate = false;
        if ((flags & 1) != 0 && (storageSlot = this.getStorageSlot()) >= 0) {
            this.updateChestItem(inventory, spawner, storageSlot);
            needsUpdate = true;
        }
        if ((flags & 2) != 0 && (spawnerInfoSlot = this.getSpawnerInfoSlot()) >= 0) {
            this.updateSpawnerInfoItem(inventory, spawner, player, spawnerInfoSlot);
            needsUpdate = true;
        }
        if ((flags & 4) != 0 && (expSlot = this.getExpSlot()) >= 0) {
            this.updateExpItem(inventory, spawner, expSlot);
            needsUpdate = true;
        }
        if (needsUpdate) {
            player.updateInventory();
        }
    }

    public void forceStateChangeUpdate(SpawnerData spawner) {
        if (!this.isTimerPlaceholdersEnabled()) {
            return;
        }
        Set<UUID> mainMenuViewerSet = this.spawnerToMainMenuViewers.get(spawner.getSpawnerId());
        if (mainMenuViewerSet == null || mainMenuViewerSet.isEmpty()) {
            return;
        }
        for (UUID viewerId : mainMenuViewerSet) {
            this.lastTimerUpdate.remove(viewerId);
            this.lastTimerValue.remove(viewerId);
        }
        this.updateMainMenuViewers(spawner);
    }

    private void updateMainMenuViewers(SpawnerData spawner) {
        if (!this.isTimerPlaceholdersEnabled()) {
            return;
        }
        Set<UUID> mainMenuViewerSet = this.spawnerToMainMenuViewers.get(spawner.getSpawnerId());
        if (mainMenuViewerSet == null || mainMenuViewerSet.isEmpty()) {
            return;
        }
        long timeUntilNextSpawn = this.calculateTimeUntilNextSpawn(spawner);
        String timerValue = spawner.getIsAtCapacity() != false ? this.cachedFullText : (timeUntilNextSpawn == -1L ? this.cachedInactiveText : this.formatTime(timeUntilNextSpawn));
        for (UUID viewerId : new HashSet<UUID>(mainMenuViewerSet)) {
            Player viewer = Bukkit.getPlayer((UUID)viewerId);
            if (!this.isValidGuiSession(viewer)) {
                this.untrackViewer(viewerId);
                continue;
            }
            Location loc = viewer.getLocation();
            if (loc == null) continue;
            String finalTimerValue = timerValue;
            UUID finalViewerId = viewerId;
            Scheduler.runLocationTask(loc, () -> {
                if (!viewer.isOnline() || !this.mainMenuViewers.containsKey(finalViewerId)) {
                    return;
                }
                Inventory openInv = viewer.getOpenInventory().getTopInventory();
                if (openInv == null || !(openInv.getHolder(false) instanceof SpawnerMenuHolder)) {
                    this.untrackViewer(finalViewerId);
                    return;
                }
                this.updateSpawnerInfoItemTimerOptimized(openInv, spawner, finalTimerValue, this.getSpawnerInfoSlot());
                viewer.updateInventory();
            });
        }
    }

    public void forceTimerUpdate(Player player, SpawnerData spawner) {
        if (this.hasTimerPlaceholders != null && !this.hasTimerPlaceholders.booleanValue()) {
            return;
        }
        if (!this.isValidGuiSession(player)) {
            return;
        }
        Location playerLocation = player.getLocation();
        if (playerLocation == null) {
            return;
        }
        Scheduler.runLocationTask(playerLocation, () -> {
            int spawnerInfoSlot;
            if (!player.isOnline()) {
                return;
            }
            Inventory openInventory = player.getOpenInventory().getTopInventory();
            if (openInventory == null) {
                return;
            }
            InventoryHolder holder = openInventory.getHolder(false);
            if (holder instanceof SpawnerMenuHolder && (spawnerInfoSlot = this.getSpawnerInfoSlot()) >= 0) {
                this.updateSpawnerInfoItemTimer(openInventory, spawner, spawnerInfoSlot);
                player.updateInventory();
            }
        });
    }

    public void updateSpawnerMenuViewers(SpawnerData spawner) {
        Player viewer;
        int viewerCount;
        Set<UUID> viewers = this.spawnerToPlayersMap.get(spawner.getSpawnerId());
        if (viewers == null || viewers.isEmpty()) {
            return;
        }
        if (this.plugin.getSpawnerMenuUI() != null) {
            this.plugin.getSpawnerMenuUI().invalidateSpawnerCache(spawner.getSpawnerId());
        }
        if (this.plugin.getSpawnerMenuFormUI() != null) {
            this.plugin.getSpawnerMenuFormUI().invalidateSpawnerCache(spawner.getSpawnerId());
        }
        if ((viewerCount = viewers.size()) > 10) {
            this.plugin.debug(viewerCount + " spawner menu viewers to update for " + spawner.getSpawnerId() + " (batch update)");
        }
        int oldTotalPages = -1;
        int newTotalPages = -1;
        for (UUID viewerId : viewers) {
            Inventory openInv;
            viewer = Bukkit.getPlayer((UUID)viewerId);
            if (!this.isValidGuiSession(viewer)) {
                this.untrackViewer(viewerId);
                continue;
            }
            this.pendingUpdates.add(viewerId);
            this.updateFlags.put(viewerId, 7);
            if (viewerCount > 5 || (openInv = viewer.getOpenInventory().getTopInventory()) == null || !(openInv.getHolder(false) instanceof StoragePageHolder)) continue;
            if (oldTotalPages == -1) {
                StoragePageHolder holder = (StoragePageHolder)openInv.getHolder(false);
                oldTotalPages = this.calculateTotalPages(holder.getOldUsedSlots());
                newTotalPages = this.calculateTotalPages(spawner.getVirtualInventory().getUsedSlots());
            }
            this.processStorageUpdate(viewer, spawner, oldTotalPages, newTotalPages);
        }
        if (viewerCount > 5) {
            for (UUID viewerId : viewers) {
                Location loc;
                viewer = Bukkit.getPlayer((UUID)viewerId);
                if (!this.isValidGuiSession(viewer) || (loc = viewer.getLocation()) == null) continue;
                Scheduler.runLocationTask(loc, () -> {
                    if (!viewer.isOnline()) {
                        return;
                    }
                    Inventory openInv = viewer.getOpenInventory().getTopInventory();
                    if (openInv != null && openInv.getHolder(false) instanceof StoragePageHolder) {
                        StoragePageHolder holder = (StoragePageHolder)openInv.getHolder(false);
                        int oldPages = this.calculateTotalPages(holder.getOldUsedSlots());
                        int newPages = this.calculateTotalPages(spawner.getVirtualInventory().getUsedSlots());
                        this.processStorageUpdateDirect(viewer, openInv, spawner, holder, oldPages, newPages);
                    }
                });
            }
        }
    }

    public void processStorageUpdate(Player viewer, SpawnerData spawner, int oldTotalPages, int newTotalPages) {
        Location loc = viewer.getLocation();
        if (loc != null) {
            Scheduler.runLocationTask(loc, () -> {
                if (!viewer.isOnline()) {
                    return;
                }
                Inventory openInv = viewer.getOpenInventory().getTopInventory();
                if (openInv == null || !(openInv.getHolder(false) instanceof StoragePageHolder)) {
                    return;
                }
                StoragePageHolder holder = (StoragePageHolder)openInv.getHolder(false);
                this.processStorageUpdateDirect(viewer, openInv, spawner, holder, oldTotalPages, newTotalPages);
            });
        }
    }

    private void processStorageUpdateDirect(Player viewer, Inventory inventory, SpawnerData spawner, StoragePageHolder holder, int oldTotalPages, int newTotalPages) {
        boolean pagesChanged = oldTotalPages != newTotalPages;
        int currentPage = holder.getCurrentPage();
        boolean needsNewInventory = false;
        int targetPage = currentPage;
        if (currentPage > newTotalPages) {
            targetPage = newTotalPages;
            holder.setCurrentPage(targetPage);
            needsNewInventory = true;
        } else if (pagesChanged) {
            needsNewInventory = true;
        }
        if (needsNewInventory) {
            try {
                String newTitle = this.languageManager.getGuiTitle("gui_title_storage") + " - [" + targetPage + "/" + newTotalPages + "]";
                viewer.getOpenInventory().setTitle(newTitle);
                this.spawnerStorageUI.updateDisplay(inventory, spawner, targetPage, newTotalPages);
            }
            catch (Exception e) {
                Inventory newInv = this.spawnerStorageUI.createInventory(spawner, this.languageManager.getGuiTitle("gui_title_storage"), targetPage, newTotalPages);
                viewer.closeInventory();
                viewer.openInventory(newInv);
            }
        } else {
            this.spawnerStorageUI.updateDisplay(inventory, spawner, targetPage, newTotalPages);
            viewer.updateInventory();
        }
    }

    private int calculateTotalPages(int totalItems) {
        return totalItems <= 0 ? 1 : (int)Math.ceil((double)totalItems / 45.0);
    }

    public void updateSpawnerMenuGui(Player player, SpawnerData spawner, boolean forceUpdate) {
        this.pendingUpdates.add(player.getUniqueId());
        this.updateFlags.put(player.getUniqueId(), 7);
    }

    private void updateSpawnerInfoItem(Inventory inventory, SpawnerData spawner, Player player, int spawnerInfoSlot) {
        if (spawnerInfoSlot < 0) {
            return;
        }
        ItemStack currentSpawnerItem = inventory.getItem(spawnerInfoSlot);
        if (currentSpawnerItem == null || !currentSpawnerItem.hasItemMeta()) {
            return;
        }
        ItemStack newSpawnerItem = this.spawnerMenuUI.createSpawnerInfoItem(player, spawner);
        if (!ItemUpdater.areItemsEqual(currentSpawnerItem, newSpawnerItem)) {
            this.preserveTimerInfo(currentSpawnerItem, newSpawnerItem);
            inventory.setItem(spawnerInfoSlot, newSpawnerItem);
        }
    }

    private void preserveTimerInfo(ItemStack currentItem, ItemStack newItem) {
        ItemMeta currentMeta = currentItem.getItemMeta();
        ItemMeta newMeta = newItem.getItemMeta();
        if (currentMeta == null || !currentMeta.hasLore() || newMeta == null || !newMeta.hasLore()) {
            return;
        }
        List currentLore = currentMeta.getLore();
        List newLore = newMeta.getLore();
        if (currentLore == null || newLore == null) {
            return;
        }
        String currentTimerValue = null;
        int currentTimerLineIndex = -1;
        int newTimerLineIndex = -1;
        for (int i = 0; i < newLore.size(); ++i) {
            if (!((String)newLore.get(i)).contains("%time%")) continue;
            newTimerLineIndex = i;
            break;
        }
        if (newTimerLineIndex == -1) {
            return;
        }
        if (newTimerLineIndex < currentLore.size()) {
            String currentLine = (String)currentLore.get(newTimerLineIndex);
            String newLine = (String)newLore.get(newTimerLineIndex);
            if (!currentLine.contains("%time%") && newLine.contains("%time%")) {
                String newLineTemplate = newLine.replace("%time%", "TIMER_PLACEHOLDER");
                String cleanNewTemplate = ChatColor.stripColor((String)newLineTemplate);
                String cleanCurrentLine = ChatColor.stripColor((String)currentLine);
                int placeholderIndex = cleanNewTemplate.indexOf("TIMER_PLACEHOLDER");
                if (placeholderIndex >= 0 && cleanCurrentLine.length() >= placeholderIndex) {
                    String beforePlaceholder = cleanNewTemplate.substring(0, placeholderIndex);
                    String afterPlaceholder = cleanNewTemplate.substring(placeholderIndex + "TIMER_PLACEHOLDER".length());
                    if (cleanCurrentLine.startsWith(beforePlaceholder) && cleanCurrentLine.endsWith(afterPlaceholder)) {
                        int startIndex = beforePlaceholder.length();
                        int endIndex = cleanCurrentLine.length() - afterPlaceholder.length();
                        if (endIndex > startIndex) {
                            currentTimerValue = cleanCurrentLine.substring(startIndex, endIndex).trim();
                        }
                    }
                }
            }
        }
        if (currentTimerValue != null && !currentTimerValue.isEmpty()) {
            Map<String, String> timerPlaceholder = Collections.singletonMap("time", currentTimerValue);
            ArrayList<String> updatedLore = new ArrayList<String>(newLore.size());
            for (String line : newLore) {
                updatedLore.add(this.languageManager.applyOnlyPlaceholders(line, timerPlaceholder));
            }
            newMeta.setLore(updatedLore);
            newItem.setItemMeta(newMeta);
        }
    }

    private void updateSpawnerInfoItemTimerOptimized(Inventory inventory, SpawnerData spawner, String timeDisplay, int spawnerInfoSlot) {
        if (!this.isTimerPlaceholdersEnabled()) {
            return;
        }
        if (spawnerInfoSlot < 0) {
            return;
        }
        ItemStack spawnerItem = inventory.getItem(spawnerInfoSlot);
        if (spawnerItem == null || !spawnerItem.hasItemMeta()) {
            return;
        }
        ItemMeta meta = spawnerItem.getItemMeta();
        if (meta == null || !meta.hasLore()) {
            return;
        }
        List lore = meta.getLore();
        if (lore == null) {
            return;
        }
        boolean needsUpdate = false;
        ArrayList<String> updatedLore = new ArrayList<String>(lore.size());
        for (String line : lore) {
            if (line.contains("%time%")) {
                String newLine = line.replace("%time%", timeDisplay);
                updatedLore.add(newLine);
                needsUpdate = true;
                continue;
            }
            String updatedLine = this.updateExistingTimerLine(line, timeDisplay);
            if (!updatedLine.equals(line)) {
                updatedLore.add(updatedLine);
                needsUpdate = true;
                continue;
            }
            updatedLore.add(line);
        }
        if (needsUpdate) {
            meta.setLore(updatedLore);
            spawnerItem.setItemMeta(meta);
            inventory.setItem(spawnerInfoSlot, spawnerItem);
        }
    }

    private void updateSpawnerInfoItemTimer(Inventory inventory, SpawnerData spawner, int spawnerInfoSlot) {
        if (!this.isTimerPlaceholdersEnabled()) {
            return;
        }
        if (spawnerInfoSlot < 0) {
            return;
        }
        ItemStack spawnerItem = inventory.getItem(spawnerInfoSlot);
        if (spawnerItem == null || !spawnerItem.hasItemMeta()) {
            return;
        }
        ItemMeta meta = spawnerItem.getItemMeta();
        if (meta == null || !meta.hasLore()) {
            return;
        }
        List lore = meta.getLore();
        if (lore == null) {
            return;
        }
        long timeUntilNextSpawn = this.calculateTimeUntilNextSpawn(spawner);
        String timeDisplay = spawner.getIsAtCapacity() != false ? this.cachedFullText : (timeUntilNextSpawn == -1L ? this.cachedInactiveText : this.formatTime(timeUntilNextSpawn));
        boolean needsUpdate = false;
        ArrayList<String> updatedLore = new ArrayList<String>(lore.size());
        for (String line : lore) {
            if (line.contains("%time%")) {
                String newLine = line.replace("%time%", timeDisplay);
                updatedLore.add(newLine);
                needsUpdate = true;
                continue;
            }
            String updatedLine = this.updateExistingTimerLine(line, timeDisplay);
            if (!updatedLine.equals(line)) {
                updatedLore.add(updatedLine);
                needsUpdate = true;
                continue;
            }
            updatedLore.add(line);
        }
        if (needsUpdate) {
            meta.setLore(updatedLore);
            spawnerItem.setItemMeta(meta);
            inventory.setItem(spawnerInfoSlot, spawnerItem);
        }
    }

    private String updateExistingTimerLine(String line, String newTimeDisplay) {
        String strippedLine = ChatColor.stripColor((String)line);
        String strippedNewDisplay = ChatColor.stripColor((String)newTimeDisplay);
        if (strippedLine.matches(".*\\d{2}:\\d{2}.*") || strippedLine.contains(ChatColor.stripColor((String)this.cachedInactiveText)) || strippedLine.contains(ChatColor.stripColor((String)this.cachedFullText))) {
            String updatedLine = line.replaceAll("\\d{2}:\\d{2}", newTimeDisplay);
            if (!updatedLine.equals(line)) {
                return updatedLine;
            }
            String strippedCachedInactive = ChatColor.stripColor((String)this.cachedInactiveText);
            String strippedCachedFull = ChatColor.stripColor((String)this.cachedFullText);
            if (strippedLine.contains(strippedCachedInactive)) {
                return line.replace(this.cachedInactiveText, newTimeDisplay);
            }
            if (strippedLine.contains(strippedCachedFull)) {
                return line.replace(this.cachedFullText, newTimeDisplay);
            }
        }
        if ((strippedNewDisplay.equals(ChatColor.stripColor((String)this.cachedInactiveText)) || strippedNewDisplay.equals(ChatColor.stripColor((String)this.cachedFullText))) && strippedLine.matches(".*\\d{2}:\\d{2}.*")) {
            return line.replaceAll("\\d{2}:\\d{2}", newTimeDisplay);
        }
        return line;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private long calculateTimeUntilNextSpawn(SpawnerData spawner) {
        boolean isSpawnerInactive;
        long cachedDelay = spawner.getCachedSpawnDelay();
        if (cachedDelay == 0L) {
            cachedDelay = spawner.getSpawnDelay() * 50L;
            spawner.setCachedSpawnDelay(cachedDelay);
        }
        long currentTime = System.currentTimeMillis();
        long lastSpawnTime = spawner.getLastSpawnTime();
        long timeElapsed = currentTime - lastSpawnTime;
        if (spawner.getSpawnerActive() == false) return -1L;
        if (spawner.getSpawnerStop().booleanValue() && timeElapsed > cachedDelay * 2L) {
            return -1L;
        }
        boolean bl = isSpawnerInactive = false;
        if (isSpawnerInactive) {
            return -1L;
        }
        long timeUntilNextSpawn = cachedDelay - timeElapsed;
        if ((timeUntilNextSpawn = Math.max(0L, Math.min(timeUntilNextSpawn, cachedDelay))) > 0L) return timeUntilNextSpawn;
        try {
            if (!spawner.getLock().tryLock(100L, TimeUnit.MILLISECONDS)) return 1000L;
            try {
                currentTime = System.currentTimeMillis();
                lastSpawnTime = spawner.getLastSpawnTime();
                timeElapsed = currentTime - lastSpawnTime;
                if (timeElapsed >= cachedDelay) {
                    spawner.setLastSpawnTime(currentTime);
                    Location spawnerLocation = spawner.getSpawnerLocation();
                    if (spawnerLocation != null) {
                        Scheduler.runLocationTask(spawnerLocation, () -> this.plugin.getRangeChecker().activateSpawner(spawner));
                    }
                    long l = cachedDelay;
                    return l;
                }
                long spawnerLocation = cachedDelay - timeElapsed;
                return spawnerLocation;
            }
            finally {
                spawner.getLock().unlock();
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return 1000L;
        }
    }

    private String formatTime(long milliseconds) {
        if (milliseconds <= 0L) {
            return "00:00";
        }
        long seconds = milliseconds / 1000L;
        long minutes = seconds / 60L;
        return String.format("%02d:%02d", minutes, seconds %= 60L);
    }

    private void updateChestItem(Inventory inventory, SpawnerData spawner, int storageSlot) {
        if (storageSlot < 0) {
            return;
        }
        ItemStack currentChestItem = inventory.getItem(storageSlot);
        if (currentChestItem == null || !currentChestItem.hasItemMeta()) {
            return;
        }
        ItemStack newChestItem = this.spawnerMenuUI.createLootStorageItem(spawner);
        if (!ItemUpdater.areItemsEqual(currentChestItem, newChestItem)) {
            inventory.setItem(storageSlot, newChestItem);
        }
    }

    private void updateExpItem(Inventory inventory, SpawnerData spawner, int expSlot) {
        if (expSlot < 0) {
            return;
        }
        ItemStack currentExpItem = inventory.getItem(expSlot);
        if (currentExpItem == null || !currentExpItem.hasItemMeta()) {
            return;
        }
        ItemStack newExpItem = this.spawnerMenuUI.createExpItem(spawner);
        if (!ItemUpdater.areItemsEqual(currentExpItem, newExpItem)) {
            inventory.setItem(expSlot, newExpItem);
        }
    }

    public void closeAllViewersInventory(SpawnerData spawner) {
        Set<UUID> filterViewers;
        String spawnerId = spawner.getSpawnerId();
        Set<Player> viewers = this.getViewers(spawnerId);
        if (!viewers.isEmpty()) {
            for (Player viewer : viewers) {
                if (viewer == null || !viewer.isOnline()) continue;
                viewer.closeInventory();
            }
        }
        if ((filterViewers = this.spawnerToFilterViewersMap.get(spawnerId)) != null && !filterViewers.isEmpty()) {
            HashSet<UUID> filterViewersCopy = new HashSet<UUID>(filterViewers);
            for (UUID viewerId : filterViewersCopy) {
                FilterConfigHolder filterHolder;
                InventoryHolder inventoryHolder;
                Inventory openInventory;
                Player viewer = Bukkit.getPlayer((UUID)viewerId);
                if (viewer == null || !viewer.isOnline() || (openInventory = viewer.getOpenInventory().getTopInventory()) == null || !((inventoryHolder = openInventory.getHolder(false)) instanceof FilterConfigHolder) || !(filterHolder = (FilterConfigHolder)inventoryHolder).getSpawnerData().getSpawnerId().equals(spawnerId)) continue;
                viewer.closeInventory();
            }
        }
        if (this.plugin.getSpawnerStackerHandler() != null) {
            this.plugin.getSpawnerStackerHandler().closeAllViewersInventory(spawnerId);
        }
    }

    public void cleanup() {
        this.stopUpdateTask();
        this.clearAllTrackedGuis();
    }

    private static class SpawnerViewerInfo {
        final SpawnerData spawnerData;
        final long lastUpdateTime;
        final ViewerType viewerType;

        SpawnerViewerInfo(SpawnerData spawnerData, ViewerType viewerType) {
            this.spawnerData = spawnerData;
            this.lastUpdateTime = System.currentTimeMillis();
            this.viewerType = viewerType;
        }
    }

    private static enum ViewerType {
        MAIN_MENU,
        STORAGE,
        FILTER;

    }
}

