/*
 * Decompiled with CFR 0.152.
 */
package github.nighter.smartspawner.spawner.lootgen;

import github.nighter.smartspawner.Scheduler;
import github.nighter.smartspawner.SmartSpawner;
import github.nighter.smartspawner.spawner.lootgen.SpawnerLootGenerator;
import github.nighter.smartspawner.spawner.properties.SpawnerData;
import github.nighter.smartspawner.spawner.properties.SpawnerManager;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Player;

public class SpawnerRangeChecker {
    private static final long CHECK_INTERVAL = 20L;
    private final SmartSpawner plugin;
    private final SpawnerManager spawnerManager;
    private final SpawnerLootGenerator spawnerLootGenerator;
    private final Map<String, Scheduler.Task> spawnerTasks;
    private final Map<String, Set<UUID>> playersInRange;
    private boolean checkGhostSpawnersOnApproach;

    public SpawnerRangeChecker(SmartSpawner plugin) {
        this.plugin = plugin;
        this.spawnerManager = plugin.getSpawnerManager();
        this.spawnerLootGenerator = plugin.getSpawnerLootGenerator();
        this.spawnerTasks = new ConcurrentHashMap<String, Scheduler.Task>();
        this.playersInRange = new ConcurrentHashMap<String, Set<UUID>>();
        this.checkGhostSpawnersOnApproach = plugin.getConfig().getBoolean("ghost_spawners.remove_on_approach", false);
        this.initializeRangeCheckTask();
    }

    public void reload() {
        this.checkGhostSpawnersOnApproach = this.plugin.getConfig().getBoolean("ghost_spawners.remove_on_approach", false);
    }

    private void initializeRangeCheckTask() {
        Scheduler.runTaskTimer(() -> this.spawnerManager.getAllSpawners().forEach(this::scheduleRegionSpecificCheck), 20L, 20L);
    }

    private void scheduleRegionSpecificCheck(SpawnerData spawner) {
        Location spawnerLoc = spawner.getSpawnerLocation();
        World world = spawnerLoc.getWorld();
        if (world == null) {
            return;
        }
        Scheduler.runLocationTask(spawnerLoc, () -> {
            boolean shouldStop;
            boolean playerFound = this.isPlayerInRange(spawner, spawnerLoc, world);
            boolean bl = shouldStop = !playerFound;
            if (spawner.getSpawnerStop() != shouldStop) {
                spawner.setSpawnerStop(shouldStop);
                this.handleSpawnerStateChange(spawner, shouldStop);
            }
        });
    }

    private void updateSpawnerStatus(SpawnerData spawner) {
        boolean shouldStop;
        Location spawnerLoc = spawner.getSpawnerLocation();
        World world = spawnerLoc.getWorld();
        if (world == null) {
            return;
        }
        boolean playerFound = this.isPlayerInRange(spawner, spawnerLoc, world);
        boolean bl = shouldStop = !playerFound;
        if (spawner.getSpawnerStop() != shouldStop) {
            spawner.setSpawnerStop(shouldStop);
            this.handleSpawnerStateChange(spawner, shouldStop);
        }
    }

    private boolean isPlayerInRange(SpawnerData spawner, Location spawnerLoc, World world) {
        int range = spawner.getSpawnerRange();
        double rangeSquared = range * range;
        Collection nearbyPlayers = world.getNearbyPlayers(spawnerLoc, (double)range, (double)range, (double)range);
        for (Player player : nearbyPlayers) {
            if (!(player.getLocation().distanceSquared(spawnerLoc) <= rangeSquared)) continue;
            return true;
        }
        return false;
    }

    private void handleSpawnerStateChange(SpawnerData spawner, boolean shouldStop) {
        boolean isGhost;
        if (this.checkGhostSpawnersOnApproach && (isGhost = this.spawnerManager.isGhostSpawner(spawner))) {
            this.plugin.debug("Ghost spawner detected during status update: " + spawner.getSpawnerId());
            this.spawnerManager.removeGhostSpawner(spawner.getSpawnerId());
            return;
        }
        if (!shouldStop) {
            this.activateSpawner(spawner);
        } else {
            this.deactivateSpawner(spawner);
        }
        if (this.plugin.getSpawnerGuiViewManager().hasViewers(spawner)) {
            this.plugin.getSpawnerGuiViewManager().forceStateChangeUpdate(spawner);
        }
    }

    public void activateSpawner(SpawnerData spawner) {
        this.startSpawnerTask(spawner);
    }

    private void deactivateSpawner(SpawnerData spawner) {
        this.stopSpawnerTask(spawner);
    }

    private void startSpawnerTask(SpawnerData spawner) {
        this.stopSpawnerTask(spawner);
        long currentTime = System.currentTimeMillis();
        spawner.setLastSpawnTime(currentTime);
        Scheduler.Task task = Scheduler.runTaskTimer(() -> {
            if (!spawner.getSpawnerStop().booleanValue()) {
                this.spawnerLootGenerator.spawnLootToSpawner(spawner);
            }
        }, spawner.getSpawnDelay(), spawner.getSpawnDelay());
        this.spawnerTasks.put(spawner.getSpawnerId(), task);
        if (this.plugin.getSpawnerGuiViewManager().hasViewers(spawner)) {
            this.plugin.getSpawnerGuiViewManager().updateSpawnerMenuViewers(spawner);
        }
    }

    public void stopSpawnerTask(SpawnerData spawner) {
        Scheduler.Task task = this.spawnerTasks.remove(spawner.getSpawnerId());
        if (task != null) {
            task.cancel();
        }
    }

    public void cleanup() {
        this.spawnerTasks.values().forEach(Scheduler.Task::cancel);
        this.spawnerTasks.clear();
        this.playersInRange.clear();
    }
}

