/*
 * Decompiled with CFR 0.152.
 */
package github.nighter.smartspawner.spawner.natural;

import github.nighter.smartspawner.SmartSpawner;
import github.nighter.smartspawner.spawner.properties.SpawnerData;
import github.nighter.smartspawner.spawner.properties.SpawnerManager;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntitySpawnEvent;
import org.bukkit.event.entity.SpawnerSpawnEvent;

public class NaturalSpawnerListener
implements Listener {
    private final SmartSpawner plugin;
    private final SpawnerManager spawnerManager;
    private static final int CHECK_RADIUS = 4;

    public NaturalSpawnerListener(SmartSpawner plugin) {
        this.plugin = plugin;
        this.spawnerManager = plugin.getSpawnerManager();
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onSpawnerSpawn(SpawnerSpawnEvent event) {
        if (event.getSpawner() == null) {
            return;
        }
        SpawnerData smartSpawner = this.spawnerManager.getSpawnerByLocation(event.getSpawner().getLocation());
        if (smartSpawner != null) {
            event.setCancelled(true);
        } else if (!this.plugin.getConfig().getBoolean("natural_spawner.spawn_mobs", true)) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onEntitySpawn(EntitySpawnEvent event) {
        Entity entity = event.getEntity();
        if (entity.getType() != EntityType.CHICKEN) {
            return;
        }
        CreatureSpawnEvent.SpawnReason spawnReason = null;
        if (event instanceof CreatureSpawnEvent) {
            spawnReason = ((CreatureSpawnEvent)event).getSpawnReason();
        }
        if (spawnReason == CreatureSpawnEvent.SpawnReason.BREEDING) {
            return;
        }
        if (spawnReason == CreatureSpawnEvent.SpawnReason.EGG) {
            return;
        }
        if (spawnReason == CreatureSpawnEvent.SpawnReason.SPAWNER_EGG) {
            return;
        }
        if (this.isNearZombieSpawner(entity.getLocation())) {
            event.setCancelled(true);
        }
    }

    private boolean isNearZombieSpawner(Location location) {
        for (int x = -4; x <= 4; ++x) {
            for (int y = -4; y <= 4; ++y) {
                for (int z = -4; z <= 4; ++z) {
                    Location checkLoc = new Location(location.getWorld(), (double)(location.getBlockX() + x), (double)(location.getBlockY() + y), (double)(location.getBlockZ() + z));
                    SpawnerData spawner = this.spawnerManager.getSpawnerByLocation(checkLoc);
                    if (spawner == null || spawner.getEntityType() != EntityType.ZOMBIE && spawner.getEntityType() != EntityType.ZOMBIFIED_PIGLIN) continue;
                    return true;
                }
            }
        }
        return false;
    }
}

