/*
 * Decompiled with CFR 0.152.
 */
package github.nighter.smartspawner.spawner.properties;

import github.nighter.smartspawner.Scheduler;
import github.nighter.smartspawner.SmartSpawner;
import github.nighter.smartspawner.spawner.properties.SpawnerData;
import github.nighter.smartspawner.spawner.utils.SpawnerFileHandler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Location;
import org.bukkit.Material;

public class SpawnerManager {
    private final SmartSpawner plugin;
    private final Map<String, SpawnerData> spawners = new HashMap<String, SpawnerData>();
    private final Map<LocationKey, SpawnerData> locationIndex = new HashMap<LocationKey, SpawnerData>();
    private final Map<String, Set<SpawnerData>> worldIndex = new HashMap<String, Set<SpawnerData>>();
    private final SpawnerFileHandler spawnerFileHandler;
    private final Set<String> confirmedGhostSpawners = ConcurrentHashMap.newKeySet();

    public SpawnerManager(SmartSpawner plugin) {
        this.plugin = plugin;
        this.spawnerFileHandler = plugin.getSpawnerFileHandler();
        this.initializeWithoutLoading();
    }

    public void reloadSpawnerDrops() {
        List<SpawnerData> allSpawners = this.getAllSpawners();
        for (SpawnerData spawner : allSpawners) {
            try {
                spawner.setLootConfig();
            }
            catch (Exception e) {
                this.plugin.getLogger().warning("Failed to reload drops config for spawner " + spawner.getSpawnerId() + ": " + e.getMessage());
            }
        }
    }

    public void reloadSpawnerDropsAndConfigs() {
        List<SpawnerData> allSpawners = this.getAllSpawners();
        for (SpawnerData spawner : allSpawners) {
            try {
                spawner.loadConfigurationValues();
                spawner.recalculateAfterConfigReload();
            }
            catch (Exception e) {
                this.plugin.getLogger().warning("Failed to reload config for spawner " + spawner.getSpawnerId() + ": " + e.getMessage());
            }
        }
    }

    public void addSpawner(String id, SpawnerData spawner) {
        this.spawners.put(id, spawner);
        this.locationIndex.put(new LocationKey(spawner.getSpawnerLocation()), spawner);
        String worldName = spawner.getSpawnerLocation().getWorld().getName();
        this.worldIndex.computeIfAbsent(worldName, k -> new HashSet()).add(spawner);
        this.spawnerFileHandler.queueSpawnerForSaving(id);
    }

    public void removeSpawner(String id) {
        SpawnerData spawner = this.spawners.get(id);
        if (spawner != null) {
            Location loc = spawner.getSpawnerLocation();
            Scheduler.runLocationTask(loc, spawner::removeHologram);
            this.locationIndex.remove(new LocationKey(spawner.getSpawnerLocation()));
            String worldName = spawner.getSpawnerLocation().getWorld().getName();
            Set<SpawnerData> worldSpawners = this.worldIndex.get(worldName);
            if (worldSpawners != null) {
                worldSpawners.remove(spawner);
                if (worldSpawners.isEmpty()) {
                    this.worldIndex.remove(worldName);
                }
            }
            this.spawners.remove(id);
        }
    }

    public int countSpawnersInWorld(String worldName) {
        Set<SpawnerData> worldSpawners = this.worldIndex.get(worldName);
        return worldSpawners != null ? worldSpawners.size() : 0;
    }

    public int countTotalSpawnersWithStacks(String worldName) {
        Set<SpawnerData> worldSpawners = this.worldIndex.get(worldName);
        if (worldSpawners == null) {
            return 0;
        }
        return worldSpawners.stream().mapToInt(SpawnerData::getStackSize).sum();
    }

    public SpawnerData getSpawnerByLocation(Location location) {
        return this.locationIndex.get(new LocationKey(location));
    }

    public SpawnerData getSpawnerById(String id) {
        return this.spawners.get(id);
    }

    public List<SpawnerData> getAllSpawners() {
        return new ArrayList<SpawnerData>(this.spawners.values());
    }

    public void addSpawnerToIndexes(String spawnerId, SpawnerData spawner) {
        this.spawners.put(spawnerId, spawner);
        this.locationIndex.put(new LocationKey(spawner.getSpawnerLocation()), spawner);
        String worldName = spawner.getSpawnerLocation().getWorld().getName();
        this.worldIndex.computeIfAbsent(worldName, k -> new HashSet()).add(spawner);
    }

    public Set<SpawnerData> getSpawnersInWorld(String worldName) {
        return this.worldIndex.get(worldName);
    }

    public void initializeWithoutLoading() {
        this.spawners.clear();
        this.locationIndex.clear();
        this.worldIndex.clear();
        this.confirmedGhostSpawners.clear();
    }

    public boolean isGhostSpawner(SpawnerData spawner) {
        if (spawner == null) {
            return false;
        }
        if (this.confirmedGhostSpawners.contains(spawner.getSpawnerId())) {
            return true;
        }
        Location loc = spawner.getSpawnerLocation();
        if (loc == null || loc.getWorld() == null) {
            return true;
        }
        if (!loc.getChunk().isLoaded()) {
            return false;
        }
        return loc.getBlock().getType() != Material.SPAWNER;
    }

    public void removeGhostSpawner(String spawnerId) {
        SpawnerData spawner = this.spawners.get(spawnerId);
        if (spawner != null) {
            Location loc = spawner.getSpawnerLocation();
            this.confirmedGhostSpawners.add(spawnerId);
            Scheduler.runLocationTask(loc, () -> {
                spawner.removeHologram();
                Scheduler.runTask(() -> {
                    this.removeSpawner(spawnerId);
                    this.spawnerFileHandler.markSpawnerDeleted(spawnerId);
                    this.plugin.debug("Removed ghost spawner " + spawnerId);
                });
            });
        }
    }

    public void markSpawnerModified(String spawnerId) {
        this.spawnerFileHandler.markSpawnerModified(spawnerId);
    }

    public void markSpawnerDeleted(String spawnerId) {
        this.spawnerFileHandler.markSpawnerDeleted(spawnerId);
    }

    public void queueSpawnerForSaving(String spawnerId) {
        this.spawnerFileHandler.queueSpawnerForSaving(spawnerId);
    }

    public void refreshAllHolograms() {
        for (SpawnerData spawner : this.spawners.values()) {
            Location loc = spawner.getSpawnerLocation();
            Scheduler.runLocationTask(loc, spawner::refreshHologram);
        }
    }

    public void reloadAllHolograms() {
        if (this.plugin.getConfig().getBoolean("hologram.enabled", false)) {
            for (SpawnerData spawner : this.spawners.values()) {
                Location loc = spawner.getSpawnerLocation();
                Scheduler.runLocationTask(loc, spawner::reloadHologramData);
            }
        }
    }

    public void cleanupAllSpawners() {
        this.spawners.clear();
        this.locationIndex.clear();
        this.worldIndex.clear();
        this.confirmedGhostSpawners.clear();
    }

    public int getTotalSpawners() {
        return this.spawners.size();
    }

    private static class LocationKey {
        private final String world;
        private final int x;
        private final int y;
        private final int z;

        public LocationKey(Location location) {
            this.world = location.getWorld().getName();
            this.x = location.getBlockX();
            this.y = location.getBlockY();
            this.z = location.getBlockZ();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof LocationKey)) {
                return false;
            }
            LocationKey that = (LocationKey)o;
            return this.x == that.x && this.y == that.y && this.z == that.z && this.world.equals(that.world);
        }

        public int hashCode() {
            return Objects.hash(this.world, this.x, this.y, this.z);
        }
    }
}

