/*
 * Decompiled with CFR 0.152.
 */
package github.nighter.smartspawner.api.events;

import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.event.Cancellable;
import org.bukkit.event.Event;
import org.bukkit.event.HandlerList;
import org.jetbrains.annotations.NotNull;

public class SpawnerStackEvent
extends Event
implements Cancellable {
    private final Player player;
    private final Location location;
    private final int oldQuantity;
    private final int newQuantity;
    private final StackSource source;
    private boolean cancelled = false;
    private static final HandlerList handlers = new HandlerList();

    public SpawnerStackEvent(Player player, Location location, int oldQuantity, int newQuantity, StackSource source) {
        this.player = player;
        this.location = location;
        this.oldQuantity = oldQuantity;
        this.newQuantity = newQuantity;
        this.source = source;
    }

    public SpawnerStackEvent(Player player, Location location, int oldQuantity, int newQuantity) {
        this(player, location, oldQuantity, newQuantity, StackSource.PLACE);
    }

    public Player getPlayer() {
        return this.player;
    }

    public Location getLocation() {
        return this.location;
    }

    public int getOldQuantity() {
        return this.oldQuantity;
    }

    public int getNewQuantity() {
        return this.newQuantity;
    }

    public StackSource getSource() {
        return this.source;
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public void setCancelled(boolean cancelled) {
        this.cancelled = cancelled;
    }

    @NotNull
    public HandlerList getHandlers() {
        return handlers;
    }

    @NotNull
    public static HandlerList getHandlerList() {
        return handlers;
    }

    public static enum StackSource {
        PLACE,
        GUI;

    }
}

