/*
 * Decompiled with CFR 0.152.
 */
package github.nighter.smartspawner.commands.give;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import github.nighter.smartspawner.SmartSpawner;
import github.nighter.smartspawner.commands.BaseSubCommand;
import github.nighter.smartspawner.spawner.item.SpawnerItemFactory;
import github.nighter.smartspawner.utils.DynamicEntityValidator;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.Commands;
import io.papermc.paper.command.brigadier.argument.ArgumentTypes;
import io.papermc.paper.command.brigadier.argument.resolvers.selector.PlayerSelectorArgumentResolver;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.jspecify.annotations.NullMarked;

@NullMarked
public class GiveSubCommand
extends BaseSubCommand {
    private final SpawnerItemFactory spawnerItemFactory;
    private final List<String> supportedMobs;
    private static final int MAX_AMOUNT = 6400;

    public GiveSubCommand(SmartSpawner plugin) {
        super(plugin);
        this.spawnerItemFactory = plugin.getSpawnerItemFactory();
        this.supportedMobs = DynamicEntityValidator.getValidEntities().stream().map(Enum::name).sorted().collect(Collectors.toList());
    }

    @Override
    public String getName() {
        return "give";
    }

    @Override
    public String getPermission() {
        return "smartspawner.command.give";
    }

    @Override
    public String getDescription() {
        return "Give spawners to players";
    }

    @Override
    public LiteralArgumentBuilder<CommandSourceStack> build() {
        LiteralArgumentBuilder builder = Commands.literal((String)this.getName());
        builder.requires(source -> this.hasPermission(source.getSender()));
        builder.then(this.buildRegularGiveCommand());
        builder.then(this.buildVanillaGiveCommand());
        builder.then(this.buildItemSpawnerGiveCommand());
        return builder;
    }

    private LiteralArgumentBuilder<CommandSourceStack> buildRegularGiveCommand() {
        return (LiteralArgumentBuilder)Commands.literal((String)"spawner").then(Commands.argument((String)"player", (ArgumentType)ArgumentTypes.player()).then(((RequiredArgumentBuilder)Commands.argument((String)"mobType", (ArgumentType)StringArgumentType.word()).suggests(this.createMobSuggestions()).executes(context -> this.executeGive((CommandContext<CommandSourceStack>)context, false, 1))).then(Commands.argument((String)"amount", (ArgumentType)IntegerArgumentType.integer((int)1, (int)6400)).executes(context -> this.executeGive((CommandContext<CommandSourceStack>)context, false, IntegerArgumentType.getInteger((CommandContext)context, (String)"amount"))))));
    }

    private LiteralArgumentBuilder<CommandSourceStack> buildVanillaGiveCommand() {
        return (LiteralArgumentBuilder)Commands.literal((String)"vanilla_spawner").then(Commands.argument((String)"player", (ArgumentType)ArgumentTypes.player()).then(((RequiredArgumentBuilder)Commands.argument((String)"mobType", (ArgumentType)StringArgumentType.word()).suggests(this.createMobSuggestions()).executes(context -> this.executeGive((CommandContext<CommandSourceStack>)context, true, 1))).then(Commands.argument((String)"amount", (ArgumentType)IntegerArgumentType.integer((int)1, (int)6400)).executes(context -> this.executeGive((CommandContext<CommandSourceStack>)context, true, IntegerArgumentType.getInteger((CommandContext)context, (String)"amount"))))));
    }

    private LiteralArgumentBuilder<CommandSourceStack> buildItemSpawnerGiveCommand() {
        return (LiteralArgumentBuilder)Commands.literal((String)"item_spawner").then(Commands.argument((String)"player", (ArgumentType)ArgumentTypes.player()).then(((RequiredArgumentBuilder)Commands.argument((String)"itemType", (ArgumentType)StringArgumentType.word()).suggests(this.createItemSuggestions()).executes(context -> this.executeGiveItemSpawner((CommandContext<CommandSourceStack>)context, 1))).then(Commands.argument((String)"amount", (ArgumentType)IntegerArgumentType.integer((int)1, (int)6400)).executes(context -> this.executeGiveItemSpawner((CommandContext<CommandSourceStack>)context, IntegerArgumentType.getInteger((CommandContext)context, (String)"amount"))))));
    }

    private SuggestionProvider<CommandSourceStack> createMobSuggestions() {
        return (context, builder) -> {
            String input = builder.getRemaining().toLowerCase();
            this.supportedMobs.stream().map(String::toLowerCase).filter(mob -> mob.startsWith(input)).forEach(arg_0 -> ((SuggestionsBuilder)builder).suggest(arg_0));
            return builder.buildFuture();
        };
    }

    private SuggestionProvider<CommandSourceStack> createItemSuggestions() {
        return (context, builder) -> {
            String input = builder.getRemaining().toLowerCase();
            this.plugin.getItemSpawnerSettingsConfig().getValidItemSpawnerMaterials().stream().map(material -> material.name().toLowerCase()).filter(item -> item.startsWith(input)).forEach(arg_0 -> ((SuggestionsBuilder)builder).suggest(arg_0));
            return builder.buildFuture();
        };
    }

    @Override
    public int execute(CommandContext<CommandSourceStack> context) {
        return 0;
    }

    private int executeGive(CommandContext<CommandSourceStack> context, boolean isVanilla, int amount) {
        CommandSender sender = ((CommandSourceStack)context.getSource()).getSender();
        this.logCommandExecution(context);
        try {
            PlayerSelectorArgumentResolver playerSelector = (PlayerSelectorArgumentResolver)context.getArgument("player", PlayerSelectorArgumentResolver.class);
            List players = (List)playerSelector.resolve((CommandSourceStack)context.getSource());
            if (players.isEmpty()) {
                this.plugin.getMessageService().sendMessage(sender, "command_give_player_not_found");
                return 0;
            }
            Player target = (Player)players.get(0);
            String mobType = StringArgumentType.getString(context, (String)"mobType");
            if (!this.supportedMobs.contains(mobType.toUpperCase())) {
                this.plugin.getMessageService().sendMessage(sender, "command_give_invalid_mob_type");
                return 0;
            }
            EntityType entityType = EntityType.valueOf((String)mobType.toUpperCase());
            ItemStack spawnerItem = isVanilla ? this.spawnerItemFactory.createVanillaSpawnerItem(entityType, amount) : this.spawnerItemFactory.createSmartSpawnerItem(entityType, amount);
            if (target.getInventory().firstEmpty() == -1) {
                target.getWorld().dropItem(target.getLocation(), spawnerItem);
                this.plugin.getMessageService().sendMessage(target, "command_give_inventory_full");
            } else {
                target.getInventory().addItem(new ItemStack[]{spawnerItem});
            }
            target.playSound(target.getLocation(), Sound.ENTITY_ITEM_PICKUP, 1.0f, 1.0f);
            String entityName = this.plugin.getLanguageManager().getFormattedMobName(entityType);
            String smallCapsEntityName = this.plugin.getLanguageManager().getSmallCaps(entityName);
            HashMap<String, String> senderPlaceholders = new HashMap<String, String>();
            senderPlaceholders.put("player", target.getName());
            senderPlaceholders.put("entity", entityName);
            senderPlaceholders.put("\u1d07\u0274\u1d1b\u026a\u1d1b\u028f", smallCapsEntityName);
            senderPlaceholders.put("amount", String.valueOf(amount));
            HashMap<String, String> targetPlaceholders = new HashMap<String, String>();
            targetPlaceholders.put("amount", String.valueOf(amount));
            targetPlaceholders.put("entity", entityName);
            targetPlaceholders.put("\u1d07\u0274\u1d1b\u026a\u1d1b\u028f", smallCapsEntityName);
            String messageKey = "command_give_spawner_";
            this.plugin.getMessageService().sendMessage(sender, messageKey + "given", senderPlaceholders);
            this.plugin.getMessageService().sendMessage(target, messageKey + "received", targetPlaceholders);
            return 1;
        }
        catch (Exception e) {
            this.plugin.getLogger().severe("Error executing give command: " + e.getMessage());
            return 0;
        }
    }

    private int executeGiveItemSpawner(CommandContext<CommandSourceStack> context, int amount) {
        CommandSender sender = ((CommandSourceStack)context.getSource()).getSender();
        this.logCommandExecution(context);
        try {
            Material itemMaterial;
            PlayerSelectorArgumentResolver playerSelector = (PlayerSelectorArgumentResolver)context.getArgument("player", PlayerSelectorArgumentResolver.class);
            List players = (List)playerSelector.resolve((CommandSourceStack)context.getSource());
            if (players.isEmpty()) {
                this.plugin.getMessageService().sendMessage(sender, "command_give_player_not_found");
                return 0;
            }
            Player target = (Player)players.get(0);
            String itemType = StringArgumentType.getString(context, (String)"itemType");
            try {
                itemMaterial = Material.valueOf((String)itemType.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                this.plugin.getMessageService().sendMessage(sender, "command_give_invalid_item_type");
                return 0;
            }
            if (!this.plugin.getItemSpawnerSettingsConfig().isValidItemSpawner(itemMaterial)) {
                this.plugin.getMessageService().sendMessage(sender, "command_give_invalid_item_spawner");
                return 0;
            }
            ItemStack spawnerItem = this.spawnerItemFactory.createItemSpawnerItem(itemMaterial, amount);
            if (target.getInventory().firstEmpty() == -1) {
                target.getWorld().dropItem(target.getLocation(), spawnerItem);
                this.plugin.getMessageService().sendMessage(target, "command_give_inventory_full");
            } else {
                target.getInventory().addItem(new ItemStack[]{spawnerItem});
            }
            target.playSound(target.getLocation(), Sound.ENTITY_ITEM_PICKUP, 1.0f, 1.0f);
            String itemName = this.plugin.getLanguageManager().getVanillaItemName(itemMaterial);
            String smallCapsItemName = this.plugin.getLanguageManager().getSmallCaps(itemName);
            HashMap<String, String> senderPlaceholders = new HashMap<String, String>();
            senderPlaceholders.put("player", target.getName());
            senderPlaceholders.put("entity", itemName);
            senderPlaceholders.put("\u1d07\u0274\u1d1b\u026a\u1d1b\u028f", smallCapsItemName);
            senderPlaceholders.put("amount", String.valueOf(amount));
            HashMap<String, String> targetPlaceholders = new HashMap<String, String>();
            targetPlaceholders.put("amount", String.valueOf(amount));
            targetPlaceholders.put("entity", itemName);
            targetPlaceholders.put("\u1d07\u0274\u1d1b\u026a\u1d1b\u028f", smallCapsItemName);
            String messageKey = "command_give_spawner_";
            this.plugin.getMessageService().sendMessage(sender, messageKey + "given", senderPlaceholders);
            this.plugin.getMessageService().sendMessage(target, messageKey + "received", targetPlaceholders);
            return 1;
        }
        catch (Exception e) {
            this.plugin.getLogger().severe("Error executing give item spawner command: " + e.getMessage());
            return 0;
        }
    }
}

