/*
 * Decompiled with CFR 0.152.
 */
package github.nighter.smartspawner.commands.list.gui.list;

import github.nighter.smartspawner.SmartSpawner;
import github.nighter.smartspawner.commands.list.ListSubCommand;
import github.nighter.smartspawner.commands.list.gui.list.SpawnerListHolder;
import github.nighter.smartspawner.commands.list.gui.list.enums.FilterOption;
import github.nighter.smartspawner.commands.list.gui.list.enums.SortOption;
import github.nighter.smartspawner.commands.list.gui.worldselection.WorldSelectionHolder;
import github.nighter.smartspawner.language.LanguageManager;
import github.nighter.smartspawner.language.MessageService;
import github.nighter.smartspawner.spawner.data.SpawnerManager;
import github.nighter.smartspawner.spawner.properties.SpawnerData;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;

public class SpawnerListGUI
implements Listener {
    private final LanguageManager languageManager;
    private final MessageService messageService;
    private final SpawnerManager spawnerManager;
    private final ListSubCommand listSubCommand;
    private static final Set<Material> SPAWNER_MATERIALS = EnumSet.of(Material.PLAYER_HEAD, new Material[]{Material.SPAWNER, Material.ZOMBIE_HEAD, Material.SKELETON_SKULL, Material.WITHER_SKELETON_SKULL, Material.CREEPER_HEAD, Material.PIGLIN_HEAD});
    private static final String patternString = "#([A-Za-z0-9]+)";

    public SpawnerListGUI(SmartSpawner plugin) {
        this.languageManager = plugin.getLanguageManager();
        this.messageService = plugin.getMessageService();
        this.spawnerManager = plugin.getSpawnerManager();
        this.listSubCommand = plugin.getListSubCommand();
    }

    @EventHandler
    public void onWorldSelectionClick(InventoryClickEvent event) {
        if (!(event.getInventory().getHolder(false) instanceof WorldSelectionHolder)) {
            return;
        }
        HumanEntity humanEntity = event.getWhoClicked();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player player = (Player)humanEntity;
        if (!player.hasPermission("smartspawner.command.list")) {
            this.messageService.sendMessage(player, "no_permission");
            return;
        }
        event.setCancelled(true);
        ItemStack clickedItem = event.getCurrentItem();
        if (clickedItem == null || !clickedItem.hasItemMeta() || !clickedItem.getItemMeta().hasDisplayName()) {
            return;
        }
        String displayName = ChatColor.stripColor((String)clickedItem.getItemMeta().getDisplayName());
        if (event.getSlot() == 11 && displayName.equals(ChatColor.stripColor((String)this.languageManager.getGuiTitle("world_buttons.overworld.name")))) {
            this.listSubCommand.openSpawnerListGUI(player, "world", 1);
            return;
        }
        if (event.getSlot() == 13 && displayName.equals(ChatColor.stripColor((String)this.languageManager.getGuiTitle("world_buttons.nether.name")))) {
            this.listSubCommand.openSpawnerListGUI(player, "world_nether", 1);
            return;
        }
        if (event.getSlot() == 15 && displayName.equals(ChatColor.stripColor((String)this.languageManager.getGuiTitle("world_buttons.end.name")))) {
            this.listSubCommand.openSpawnerListGUI(player, "world_the_end", 1);
            return;
        }
        if (displayName.equals(ChatColor.stripColor((String)this.languageManager.getGuiTitle("world_buttons.overworld.name")))) {
            this.listSubCommand.openSpawnerListGUI(player, "world", 1);
        } else if (displayName.equals(ChatColor.stripColor((String)this.languageManager.getGuiTitle("world_buttons.nether.name")))) {
            this.listSubCommand.openSpawnerListGUI(player, "world_nether", 1);
        } else if (displayName.equals(ChatColor.stripColor((String)this.languageManager.getGuiTitle("world_buttons.end.name")))) {
            this.listSubCommand.openSpawnerListGUI(player, "world_the_end", 1);
        } else {
            for (World world : Bukkit.getWorlds()) {
                String worldDisplayName = this.formatWorldName(world.getName());
                if (this.spawnerManager.countSpawnersInWorld(world.getName()) <= 0 || !displayName.contains(worldDisplayName)) continue;
                this.listSubCommand.openSpawnerListGUI(player, world.getName(), 1);
                break;
            }
        }
    }

    private String formatWorldName(String worldName) {
        return Arrays.stream(worldName.replace('_', ' ').split(" ")).map(word -> word.substring(0, 1).toUpperCase() + word.substring(1).toLowerCase()).collect(Collectors.joining(" "));
    }

    @EventHandler
    public void onSpawnerListClick(InventoryClickEvent event) {
        InventoryHolder inventoryHolder = event.getInventory().getHolder(false);
        if (!(inventoryHolder instanceof SpawnerListHolder)) {
            return;
        }
        SpawnerListHolder holder = (SpawnerListHolder)inventoryHolder;
        HumanEntity humanEntity = event.getWhoClicked();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player player = (Player)humanEntity;
        if (!player.hasPermission("smartspawner.list")) {
            this.messageService.sendMessage(player, "no_permission");
            return;
        }
        event.setCancelled(true);
        if (event.getCurrentItem() == null) {
            return;
        }
        String worldName = holder.getWorldName();
        int currentPage = holder.getCurrentPage();
        int totalPages = holder.getTotalPages();
        FilterOption currentFilter = holder.getFilterOption();
        SortOption currentSort = holder.getSortType();
        if (event.getSlot() == 48) {
            FilterOption nextFilter = currentFilter.getNextOption();
            this.listSubCommand.saveUserPreference(player, worldName, nextFilter, currentSort);
            this.listSubCommand.openSpawnerListGUI(player, worldName, 1, nextFilter, currentSort);
            return;
        }
        if (event.getSlot() == 50) {
            SortOption nextSort = currentSort.getNextOption();
            this.listSubCommand.saveUserPreference(player, worldName, currentFilter, nextSort);
            this.listSubCommand.openSpawnerListGUI(player, worldName, 1, currentFilter, nextSort);
            return;
        }
        if (event.getSlot() == 45 && currentPage > 1) {
            this.listSubCommand.openSpawnerListGUI(player, worldName, currentPage - 1, currentFilter, currentSort);
            return;
        }
        if (event.getSlot() == 49) {
            this.listSubCommand.saveUserPreference(player, worldName, currentFilter, currentSort);
            this.listSubCommand.openWorldSelectionGUI(player);
            return;
        }
        if (event.getSlot() == 53 && currentPage < totalPages) {
            this.listSubCommand.openSpawnerListGUI(player, worldName, currentPage + 1, currentFilter, currentSort);
            return;
        }
        if (this.isSpawnerItemSlot(event.getSlot()) && this.isSpawnerItem(event.getCurrentItem())) {
            this.handleSpawnerItemClick(player, event.getCurrentItem(), holder);
        }
    }

    @EventHandler
    public void onInventoryClose(InventoryCloseEvent event) {
        InventoryHolder inventoryHolder = event.getInventory().getHolder(false);
        if (!(inventoryHolder instanceof SpawnerListHolder)) {
            return;
        }
        SpawnerListHolder holder = (SpawnerListHolder)inventoryHolder;
        HumanEntity humanEntity = event.getPlayer();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player player = (Player)humanEntity;
        String worldName = holder.getWorldName();
        FilterOption currentFilter = holder.getFilterOption();
        SortOption currentSort = holder.getSortType();
        this.listSubCommand.saveUserPreference(player, worldName, currentFilter, currentSort);
    }

    private boolean isSpawnerItemSlot(int slot) {
        return slot < 45;
    }

    private boolean isSpawnerItem(ItemStack item) {
        return item != null && SPAWNER_MATERIALS.contains(item.getType()) && item.hasItemMeta() && item.getItemMeta().hasDisplayName();
    }

    private void handleSpawnerItemClick(Player player, ItemStack item, SpawnerListHolder holder) {
        String displayName = item.getItemMeta().getDisplayName();
        Pattern pattern = Pattern.compile(patternString);
        Matcher matcher = pattern.matcher(displayName);
        if (matcher.find()) {
            String spawnerId = matcher.group(1);
            SpawnerData spawner = this.spawnerManager.getSpawnerById(spawnerId);
            if (spawner != null) {
                this.listSubCommand.openSpawnerManagementGUI(player, spawnerId, holder.getWorldName(), holder.getCurrentPage());
            } else {
                this.messageService.sendMessage(player, "spawner_not_found");
            }
        }
    }
}

