/*
 * Decompiled with CFR 0.152.
 */
package github.nighter.smartspawner.extras;

import github.nighter.smartspawner.Scheduler;
import github.nighter.smartspawner.SmartSpawner;
import github.nighter.smartspawner.spawner.data.SpawnerManager;
import github.nighter.smartspawner.spawner.gui.synchronization.SpawnerGuiViewManager;
import github.nighter.smartspawner.spawner.properties.SpawnerData;
import github.nighter.smartspawner.spawner.properties.VirtualInventory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.Hopper;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.world.ChunkLoadEvent;
import org.bukkit.event.world.ChunkUnloadEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class HopperHandler
implements Listener {
    private final SmartSpawner plugin;
    private final Map<Location, Scheduler.Task> activeHoppers = new ConcurrentHashMap<Location, Scheduler.Task>();
    private final SpawnerManager spawnerManager;
    private final SpawnerGuiViewManager spawnerGuiViewManager;

    public HopperHandler(SmartSpawner plugin) {
        this.plugin = plugin;
        this.spawnerManager = plugin.getSpawnerManager();
        this.spawnerGuiViewManager = plugin.getSpawnerGuiViewManager();
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
        Scheduler.runTaskLater(() -> {
            if (plugin.getConfig().getBoolean("hopper.enabled", false)) {
                this.restartAllHoppers();
            }
        }, 40L);
    }

    public void restartAllHoppers() {
        if (!this.plugin.getConfig().getBoolean("hopper.enabled", false)) {
            return;
        }
        for (World world : this.plugin.getServer().getWorlds()) {
            try {
                Location worldLocation = world.getSpawnLocation();
                Scheduler.runLocationTask(worldLocation, () -> {
                    try {
                        for (Chunk chunk : world.getLoadedChunks()) {
                            this.processChunkHoppers(chunk);
                        }
                    }
                    catch (Exception e) {
                        this.plugin.getLogger().log(Level.SEVERE, "Error processing hoppers in world " + world.getName(), e);
                    }
                });
            }
            catch (Exception e) {
                this.plugin.getLogger().log(Level.SEVERE, "Error scheduling hopper task for world " + world.getName(), e);
            }
        }
    }

    private void processChunkHoppers(Chunk chunk) {
        if (chunk == null || !chunk.isLoaded()) {
            return;
        }
        Location chunkLoc = new Location(chunk.getWorld(), (double)(chunk.getX() * 16 + 8), 64.0, (double)(chunk.getZ() * 16 + 8));
        Scheduler.runLocationTask(chunkLoc, () -> {
            try {
                Collection hopperStates = chunk.getTileEntities(block -> block.getType() == Material.HOPPER, false);
                if (hopperStates == null || hopperStates.isEmpty()) {
                    return;
                }
                for (BlockState state : hopperStates) {
                    Block aboveBlock;
                    Block hopperBlock;
                    if (state == null || (hopperBlock = state.getBlock()).getType() != Material.HOPPER || (aboveBlock = hopperBlock.getRelative(BlockFace.UP)).getType() != Material.SPAWNER) continue;
                    this.startHopperTask(hopperBlock.getLocation(), aboveBlock.getLocation());
                }
            }
            catch (Exception e) {
                this.plugin.getLogger().log(Level.WARNING, "Error processing hoppers in chunk at " + chunk.getX() + "," + chunk.getZ(), e);
            }
        });
    }

    @EventHandler
    public void onChunkLoad(ChunkLoadEvent event) {
        if (!this.plugin.getConfig().getBoolean("hopper.enabled", false)) {
            return;
        }
        Chunk chunk = event.getChunk();
        this.processChunkHoppers(chunk);
    }

    @EventHandler
    public void onChunkUnload(ChunkUnloadEvent event) {
        if (!this.plugin.getConfig().getBoolean("hopper.enabled", false)) {
            return;
        }
        Chunk chunk = event.getChunk();
        if (chunk == null) {
            return;
        }
        try {
            Collection hopperStates = chunk.getTileEntities(block -> block.getType() == Material.HOPPER, false);
            if (hopperStates == null || hopperStates.isEmpty()) {
                return;
            }
            for (BlockState state : hopperStates) {
                if (state == null) continue;
                this.stopHopperTask(state.getLocation());
            }
        }
        catch (Exception e) {
            this.plugin.getLogger().log(Level.WARNING, "Error stopping hoppers in unloading chunk at " + chunk.getX() + "," + chunk.getZ(), e);
        }
    }

    public void cleanup() {
        try {
            ArrayList<Scheduler.Task> tasks = new ArrayList<Scheduler.Task>(this.activeHoppers.values());
            this.activeHoppers.clear();
            for (Scheduler.Task task : tasks) {
                if (task == null) continue;
                try {
                    task.cancel();
                }
                catch (Exception e) {
                    this.plugin.getLogger().log(Level.WARNING, "Error cancelling hopper task during cleanup", e);
                }
            }
        }
        catch (Exception e) {
            this.plugin.getLogger().log(Level.SEVERE, "Error during hopper handler cleanup", e);
        }
    }

    @EventHandler
    public void onHopperPlace(BlockPlaceEvent event) {
        if (!this.plugin.getConfig().getBoolean("hopper.enabled", false)) {
            return;
        }
        if (event.getBlockPlaced().getType() != Material.HOPPER) {
            return;
        }
        Block above = event.getBlockPlaced().getRelative(BlockFace.UP);
        if (above.getType() == Material.SPAWNER) {
            this.startHopperTask(event.getBlockPlaced().getLocation(), above.getLocation());
        }
    }

    @EventHandler
    public void onHopperBreak(BlockBreakEvent event) {
        if (event.getBlock().getType() == Material.HOPPER) {
            this.stopHopperTask(event.getBlock().getLocation());
        }
    }

    public void startHopperTask(Location hopperLoc, Location spawnerLoc) {
        if (!this.plugin.getConfig().getBoolean("hopper.enabled", false)) {
            return;
        }
        if (hopperLoc == null || spawnerLoc == null) {
            return;
        }
        this.stopHopperTask(hopperLoc);
        Runnable hopperRunnable = () -> {
            try {
                if (!this.isValidSetup(hopperLoc, spawnerLoc)) {
                    this.stopHopperTask(hopperLoc);
                    return;
                }
                this.transferItems(hopperLoc, spawnerLoc);
            }
            catch (Exception e) {
                this.plugin.getLogger().log(Level.WARNING, "Error in hopper task at " + String.valueOf(hopperLoc), e);
            }
        };
        try {
            Scheduler.Task task = Scheduler.runLocationTaskTimer(hopperLoc, hopperRunnable, 0L, this.plugin.getTimeFromConfig("hopper.check_delay", "3s"));
            if (task != null && !task.isCancelled()) {
                this.activeHoppers.put(hopperLoc, task);
            }
        }
        catch (Exception e) {
            this.plugin.getLogger().log(Level.SEVERE, "Failed to start hopper task at " + String.valueOf(hopperLoc), e);
        }
    }

    private boolean isValidSetup(Location hopperLoc, Location spawnerLoc) {
        Block hopper = hopperLoc.getBlock();
        Block spawner = spawnerLoc.getBlock();
        return hopper.getType() == Material.HOPPER && spawner.getType() == Material.SPAWNER && hopper.getRelative(BlockFace.UP).equals((Object)spawner);
    }

    public void stopHopperTask(Location hopperLoc) {
        if (hopperLoc == null) {
            return;
        }
        Scheduler.Task task = this.activeHoppers.remove(hopperLoc);
        if (task != null) {
            try {
                task.cancel();
            }
            catch (Exception e) {
                this.plugin.getLogger().log(Level.WARNING, "Error cancelling hopper task at " + String.valueOf(hopperLoc), e);
            }
        }
    }

    public void restartHopperForSpawner(Location spawnerLoc) {
        if (!this.plugin.getConfig().getBoolean("hopper.enabled", false)) {
            return;
        }
        if (spawnerLoc == null) {
            return;
        }
        Scheduler.runLocationTask(spawnerLoc, () -> {
            try {
                Block spawnerBlock = spawnerLoc.getBlock();
                if (spawnerBlock.getType() != Material.SPAWNER) {
                    return;
                }
                Block hopperBlock = spawnerBlock.getRelative(BlockFace.DOWN);
                if (hopperBlock.getType() != Material.HOPPER) {
                    return;
                }
                Location hopperLoc = hopperBlock.getLocation();
                this.startHopperTask(hopperLoc, spawnerLoc);
            }
            catch (Exception e) {
                this.plugin.getLogger().log(Level.WARNING, "Error restarting hopper for spawner at " + String.valueOf(spawnerLoc), e);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void transferItems(Location hopperLoc, Location spawnerLoc) {
        if (hopperLoc == null || spawnerLoc == null) {
            return;
        }
        SpawnerData spawner = this.spawnerManager.getSpawnerByLocation(spawnerLoc);
        if (spawner == null) {
            return;
        }
        ReentrantLock lock = spawner.getInventoryLock();
        if (!lock.tryLock()) {
            return;
        }
        try {
            Block hopperBlock = hopperLoc.getBlock();
            if (hopperBlock.getType() != Material.HOPPER) {
                this.stopHopperTask(hopperLoc);
                return;
            }
            VirtualInventory virtualInv = spawner.getVirtualInventory();
            if (virtualInv == null) {
                return;
            }
            Hopper hopper = (Hopper)hopperBlock.getState(false);
            if (hopper == null) {
                return;
            }
            Map<Integer, ItemStack> displayItems = virtualInv.getDisplayInventory();
            if (displayItems == null || displayItems.isEmpty()) {
                return;
            }
            int itemsPerTransfer = this.plugin.getConfig().getInt("hopper.stack_per_transfer", 5);
            Inventory hopperInv = hopper.getInventory();
            ArrayList<ItemStack> itemsToRemove = new ArrayList<ItemStack>(itemsPerTransfer);
            int transferred = 0;
            boolean inventoryChanged = false;
            for (Map.Entry<Integer, ItemStack> entry : displayItems.entrySet()) {
                if (transferred >= itemsPerTransfer) break;
                ItemStack item = entry.getValue();
                if (item == null || item.getType() == Material.AIR) continue;
                ItemStack[] hopperContents = hopperInv.getContents();
                boolean itemTransferred = false;
                for (int i = 0; i < hopperContents.length && !itemTransferred; ++i) {
                    int maxStackSize;
                    int currentAmount;
                    ItemStack hopperItem = hopperContents[i];
                    if (hopperItem == null || hopperItem.getType() == Material.AIR) {
                        hopperInv.setItem(i, item.clone());
                        itemsToRemove.add(item);
                        ++transferred;
                        inventoryChanged = true;
                        itemTransferred = true;
                        continue;
                    }
                    if (!hopperItem.isSimilar(item) || (currentAmount = hopperItem.getAmount()) >= (maxStackSize = hopperItem.getMaxStackSize())) continue;
                    int space = maxStackSize - currentAmount;
                    int toTransfer = Math.min(space, item.getAmount());
                    hopperItem.setAmount(currentAmount + toTransfer);
                    ItemStack toRemove = item.clone();
                    toRemove.setAmount(toTransfer);
                    itemsToRemove.add(toRemove);
                    ++transferred;
                    inventoryChanged = true;
                    itemTransferred = true;
                }
            }
            if (!itemsToRemove.isEmpty()) {
                spawner.removeItemsAndUpdateSellValue(itemsToRemove);
            }
            if (inventoryChanged) {
                this.updateOpenGuis(spawner);
            }
        }
        catch (Exception e) {
            this.plugin.getLogger().log(Level.WARNING, "Error transferring items from spawner to hopper at " + String.valueOf(hopperLoc), e);
        }
        finally {
            lock.unlock();
        }
    }

    private void updateOpenGuis(SpawnerData spawner) {
        try {
            Scheduler.runLocationTaskLater(spawner.getSpawnerLocation(), () -> {
                try {
                    this.spawnerGuiViewManager.updateSpawnerMenuViewers(spawner);
                }
                catch (Exception e) {
                    this.plugin.getLogger().log(Level.WARNING, "Error updating GUIs for spawner", e);
                }
            }, 2L);
        }
        catch (Exception e) {
            this.plugin.getLogger().log(Level.WARNING, "Error scheduling GUI update task", e);
        }
    }
}

