/*
 * Decompiled with CFR 0.152.
 */
package github.nighter.smartspawner.hooks.economy.shops;

import github.nighter.smartspawner.SmartSpawner;
import github.nighter.smartspawner.hooks.economy.shops.providers.ShopProvider;
import github.nighter.smartspawner.hooks.economy.shops.providers.economyshopgui.ESGUICompatibilityHandler;
import github.nighter.smartspawner.hooks.economy.shops.providers.economyshopgui.EconomyShopGUIProvider;
import github.nighter.smartspawner.hooks.economy.shops.providers.excellentshop.ExcellentShopProvider;
import github.nighter.smartspawner.hooks.economy.shops.providers.shopguiplus.ShopGuiPlusProvider;
import github.nighter.smartspawner.hooks.economy.shops.providers.shopguiplus.SpawnerHook;
import github.nighter.smartspawner.hooks.economy.shops.providers.zshop.ZShopProvider;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import lombok.Generated;
import org.bukkit.Material;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

public class ShopIntegrationManager {
    private final SmartSpawner plugin;
    private ShopProvider activeProvider;
    private final List<ShopProvider> availableProviders = new ArrayList<ShopProvider>();
    private SpawnerHook spawnerHook = null;
    private ESGUICompatibilityHandler esguiCompatibilityHandler = null;

    public void initialize() {
        this.availableProviders.clear();
        this.activeProvider = null;
        this.detectAndRegisterActiveProviders();
        this.selectActiveProvider();
    }

    private void detectAndRegisterActiveProviders() {
        String configuredShop = this.plugin.getConfig().getString("custom_economy.shop_integration.preferred_plugin", "auto");
        boolean autoDetect = "auto".equalsIgnoreCase(configuredShop);
        if (!autoDetect) {
            if (this.tryRegisterSpecificProvider(configuredShop)) {
                return;
            }
            this.plugin.getLogger().warning("Configured shop plugin '" + configuredShop + "' could not be loaded. Falling back to auto-detection.");
        }
        this.registerProviderIfAvailable("EconomyShopGUI", () -> {
            EconomyShopGUIProvider provider = new EconomyShopGUIProvider(this.plugin);
            if (provider.isAvailable() && this.esguiCompatibilityHandler == null) {
                try {
                    this.esguiCompatibilityHandler = new ESGUICompatibilityHandler(this.plugin);
                    this.plugin.getServer().getPluginManager().registerEvents((Listener)this.esguiCompatibilityHandler, (Plugin)this.plugin);
                }
                catch (Exception e) {
                    this.plugin.getLogger().warning("Failed to register ESGUICompatibilityHandler: " + e.getMessage());
                }
            }
            return provider;
        });
        if (this.isPluginAvailable("ShopGUIPlus")) {
            this.registerProviderIfAvailable("ShopGUIPlus", () -> {
                if (this.spawnerHook == null) {
                    try {
                        this.spawnerHook = new SpawnerHook(this.plugin);
                        this.plugin.getServer().getPluginManager().registerEvents((Listener)this.spawnerHook, (Plugin)this.plugin);
                    }
                    catch (Exception e) {
                        this.plugin.debug("Failed to register SpawnerHook: " + e.getMessage());
                        throw e;
                    }
                }
                return new ShopGuiPlusProvider(this.plugin);
            });
        }
        this.registerProviderIfAvailable("ZShop", () -> new ZShopProvider(this.plugin));
        this.registerProviderIfAvailable("ExcellentShop", () -> new ExcellentShopProvider(this.plugin));
    }

    private boolean tryRegisterSpecificProvider(String providerName) {
        try {
            switch (providerName.toLowerCase()) {
                case "economyshopgui": {
                    if (!this.isPluginAvailable("EconomyShopGUI")) break;
                    this.registerProviderIfAvailable("EconomyShopGUI", () -> {
                        EconomyShopGUIProvider provider = new EconomyShopGUIProvider(this.plugin);
                        if (provider.isAvailable() && this.esguiCompatibilityHandler == null) {
                            try {
                                this.esguiCompatibilityHandler = new ESGUICompatibilityHandler(this.plugin);
                                this.plugin.getServer().getPluginManager().registerEvents((Listener)this.esguiCompatibilityHandler, (Plugin)this.plugin);
                            }
                            catch (Exception e) {
                                this.plugin.getLogger().warning("Failed to register ESGUICompatibilityHandler: " + e.getMessage());
                            }
                        }
                        return provider;
                    });
                    return !this.availableProviders.isEmpty();
                }
                case "shopguiplus": {
                    if (!this.isPluginAvailable("ShopGUIPlus")) break;
                    this.registerProviderIfAvailable("ShopGUIPlus", () -> {
                        if (this.spawnerHook == null) {
                            this.spawnerHook = new SpawnerHook(this.plugin);
                            this.plugin.getServer().getPluginManager().registerEvents((Listener)this.spawnerHook, (Plugin)this.plugin);
                            this.plugin.debug("Registered SpawnerHook event listener for ShopGUIPlus");
                        }
                        return new ShopGuiPlusProvider(this.plugin);
                    });
                    return !this.availableProviders.isEmpty();
                }
                case "zshop": {
                    if (!this.isPluginAvailable("ZShop")) break;
                    this.registerProviderIfAvailable("ZShop", () -> new ZShopProvider(this.plugin));
                    return !this.availableProviders.isEmpty();
                }
                case "excellentshop": {
                    if (!this.isPluginAvailable("ExcellentShop")) break;
                    this.registerProviderIfAvailable("ExcellentShop", () -> new ExcellentShopProvider(this.plugin));
                    return !this.availableProviders.isEmpty();
                }
            }
        }
        catch (Exception e) {
            this.plugin.debug("Failed to load specific provider " + providerName + ": " + e.getMessage());
        }
        return false;
    }

    private boolean isPluginAvailable(String pluginName) {
        Plugin targetPlugin = this.plugin.getServer().getPluginManager().getPlugin(pluginName);
        return targetPlugin != null && targetPlugin.isEnabled();
    }

    private void registerProviderIfAvailable(String providerName, Supplier<ShopProvider> providerSupplier) {
        if (!this.availableProviders.isEmpty()) {
            this.plugin.debug("Skipping " + providerName + " registration - already have active provider: " + this.availableProviders.getFirst().getPluginName());
            return;
        }
        try {
            ShopProvider provider = providerSupplier.get();
            if (provider.isAvailable()) {
                this.availableProviders.add(provider);
            }
        }
        catch (NoClassDefFoundError e) {
            this.plugin.debug("Shop provider " + providerName + " classes not found (plugin not installed): " + e.getMessage());
        }
        catch (Exception e) {
            this.plugin.debug("Failed to initialize shop provider " + providerName + ": " + e.getMessage());
        }
    }

    private void selectActiveProvider() {
        if (this.availableProviders.isEmpty()) {
            this.plugin.getLogger().info("No compatible shop plugins found. Shop integration is disabled.");
            return;
        }
        this.activeProvider = this.availableProviders.getFirst();
        this.plugin.getLogger().info("Auto-detected & successfully hook into shop plugin: " + this.activeProvider.getPluginName());
    }

    public double getPrice(Material material) {
        if (this.activeProvider == null || material == null) {
            return 0.0;
        }
        try {
            return this.activeProvider.getSellPrice(material);
        }
        catch (Exception e) {
            this.plugin.debug("Error getting price for " + String.valueOf(material) + " from " + this.activeProvider.getPluginName() + ": " + e.getMessage());
            return 0.0;
        }
    }

    public String getActiveShopPlugin() {
        return this.activeProvider != null ? this.activeProvider.getPluginName() : "None";
    }

    public boolean hasActiveProvider() {
        return this.activeProvider != null;
    }

    public void cleanup() {
        this.availableProviders.clear();
        this.activeProvider = null;
        if (this.spawnerHook != null) {
            this.spawnerHook.unregister();
            this.spawnerHook = null;
        }
        if (this.esguiCompatibilityHandler != null) {
            this.esguiCompatibilityHandler = null;
        }
    }

    @Generated
    public ShopIntegrationManager(SmartSpawner plugin) {
        this.plugin = plugin;
    }
}

