/*
 * Decompiled with CFR 0.152.
 */
package github.nighter.smartspawner.spawner.gui.layout;

import github.nighter.smartspawner.spawner.gui.layout.GuiButton;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public class GuiLayout {
    private final Map<String, GuiButton> buttons = new HashMap<String, GuiButton>();
    private final Map<Integer, String> slotToButtonType = new HashMap<Integer, String>();

    public void addButton(String buttonType, GuiButton button) {
        GuiButton oldButton = this.buttons.get(buttonType);
        if (oldButton != null) {
            this.slotToButtonType.remove(oldButton.getSlot());
        }
        this.buttons.put(buttonType, button);
        this.slotToButtonType.put(button.getSlot(), buttonType);
    }

    public GuiButton getButton(String buttonType) {
        return this.buttons.get(buttonType);
    }

    public Optional<String> getButtonTypeAtSlot(int slot) {
        return Optional.ofNullable(this.slotToButtonType.get(slot));
    }

    public Optional<GuiButton> getButtonAtSlot(int slot) {
        String buttonType = this.slotToButtonType.get(slot);
        return buttonType != null ? Optional.ofNullable(this.buttons.get(buttonType)) : Optional.empty();
    }

    public boolean hasButton(String buttonType) {
        return this.buttons.containsKey(buttonType) && this.buttons.get(buttonType).isEnabled();
    }

    public Set<String> getButtonTypes() {
        return this.buttons.keySet();
    }

    public Map<String, GuiButton> getAllButtons() {
        return new HashMap<String, GuiButton>(this.buttons);
    }

    public Set<Integer> getUsedSlots() {
        return this.slotToButtonType.keySet();
    }

    public boolean isSlotUsed(int slot) {
        return this.slotToButtonType.containsKey(slot);
    }
}

