/*
 * Decompiled with CFR 0.152.
 */
package github.nighter.smartspawner.spawner.gui.stacker;

import github.nighter.smartspawner.Scheduler;
import github.nighter.smartspawner.SmartSpawner;
import github.nighter.smartspawner.api.events.SpawnerRemoveEvent;
import github.nighter.smartspawner.api.events.SpawnerStackEvent;
import github.nighter.smartspawner.language.LanguageManager;
import github.nighter.smartspawner.language.MessageService;
import github.nighter.smartspawner.logging.SpawnerEventType;
import github.nighter.smartspawner.spawner.data.SpawnerManager;
import github.nighter.smartspawner.spawner.gui.main.SpawnerMenuUI;
import github.nighter.smartspawner.spawner.gui.stacker.InventoryScanResult;
import github.nighter.smartspawner.spawner.gui.stacker.SpawnerSlot;
import github.nighter.smartspawner.spawner.gui.stacker.SpawnerStackerHolder;
import github.nighter.smartspawner.spawner.item.SpawnerItemFactory;
import github.nighter.smartspawner.spawner.limits.ChunkSpawnerLimiter;
import github.nighter.smartspawner.spawner.properties.SpawnerData;
import github.nighter.smartspawner.spawner.utils.SpawnerTypeChecker;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.block.BlockState;
import org.bukkit.block.CreatureSpawner;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.inventory.meta.BlockStateMeta;
import org.bukkit.inventory.meta.ItemMeta;

public class SpawnerStackerHandler
implements Listener {
    private final SmartSpawner plugin;
    private final MessageService messageService;
    private final SpawnerMenuUI spawnerMenuUI;
    private final LanguageManager languageManager;
    private final SpawnerItemFactory spawnerItemFactory;
    private ChunkSpawnerLimiter chunkSpawnerLimiter;
    private static final Sound STACK_SOUND = Sound.ENTITY_EXPERIENCE_ORB_PICKUP;
    private static final Sound CLICK_SOUND = Sound.UI_BUTTON_CLICK;
    private static final float SOUND_VOLUME = 1.0f;
    private static final float SOUND_PITCH = 1.0f;
    private static final int[] DECREASE_SLOTS = new int[]{9, 10, 11};
    private static final int[] INCREASE_SLOTS = new int[]{17, 16, 15};
    private static final int SPAWNER_INFO_SLOT = 13;
    private static final int[] STACK_AMOUNTS = new int[]{64, 10, 1};
    private final Map<UUID, Long> lastClickTime = new ConcurrentHashMap<UUID, Long>(16, 0.75f, 2);
    private final Map<UUID, Scheduler.Task> pendingUpdates = new ConcurrentHashMap<UUID, Scheduler.Task>(16, 0.75f, 2);
    private final Map<String, Set<UUID>> activeViewers = new ConcurrentHashMap<String, Set<UUID>>(16, 0.75f, 2);
    private final Map<UUID, AtomicBoolean> updateLocks = new ConcurrentHashMap<UUID, AtomicBoolean>(16, 0.75f, 2);
    private final Map<ItemStack, Optional<EntityType>> entityTypeCache = new WeakHashMap<ItemStack, Optional<EntityType>>();
    private static final long CLICK_COOLDOWN = 200L;
    private static final long UPDATE_DELAY = 2L;

    public SpawnerStackerHandler(SmartSpawner plugin) {
        this.plugin = plugin;
        this.languageManager = plugin.getLanguageManager();
        this.messageService = plugin.getMessageService();
        this.spawnerItemFactory = plugin.getSpawnerItemFactory();
        this.spawnerMenuUI = plugin.getSpawnerMenuUI();
        this.chunkSpawnerLimiter = plugin.getChunkSpawnerLimiter();
        this.startCleanupTask();
    }

    private void startCleanupTask() {
        Scheduler.runTaskTimer(() -> {
            long now = System.currentTimeMillis();
            this.lastClickTime.entrySet().removeIf(entry -> now - (Long)entry.getValue() > 5000L);
            this.updateLocks.entrySet().removeIf(entry -> !this.lastClickTime.containsKey(entry.getKey()));
            if (this.entityTypeCache.size() > 100) {
                this.entityTypeCache.clear();
            }
        }, 200L, 200L);
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onInventoryClick(InventoryClickEvent event) {
        HumanEntity humanEntity = event.getWhoClicked();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player player = (Player)humanEntity;
        InventoryHolder inventoryHolder = event.getInventory().getHolder(false);
        if (!(inventoryHolder instanceof SpawnerStackerHolder)) {
            return;
        }
        SpawnerStackerHolder holder = (SpawnerStackerHolder)inventoryHolder;
        event.setCancelled(true);
        SpawnerData spawner = holder.getSpawnerData();
        if (!this.isSpawnerValid(spawner)) {
            player.closeInventory();
            return;
        }
        UUID playerId = player.getUniqueId();
        Long lastClick = this.lastClickTime.get(playerId);
        if (lastClick != null && System.currentTimeMillis() - lastClick < 200L) {
            return;
        }
        ItemStack clickedItem = event.getCurrentItem();
        if (clickedItem == null || !clickedItem.hasItemMeta()) {
            return;
        }
        if (clickedItem.getType() == Material.SPAWNER) {
            if (this.isBedrockPlayer(player)) {
                if (this.plugin.getSpawnerMenuFormUI() != null) {
                    this.plugin.getSpawnerMenuFormUI().openSpawnerForm(player, spawner);
                } else {
                    this.spawnerMenuUI.openSpawnerMenu(player, spawner, true);
                }
            } else {
                this.spawnerMenuUI.openSpawnerMenu(player, spawner, true);
            }
            player.playSound(player.getLocation(), CLICK_SOUND, 1.0f, 1.0f);
            return;
        }
        int slotIndex = event.getRawSlot();
        int changeAmount = this.determineChangeAmount(slotIndex);
        if (changeAmount != 0) {
            this.lastClickTime.put(playerId, System.currentTimeMillis());
            this.processStackModification(player, spawner, changeAmount);
            String spawnerId = spawner.getSpawnerId();
            Set<UUID> viewers = this.activeViewers.get(spawnerId);
            if (viewers != null && !viewers.isEmpty()) {
                this.scheduleViewersUpdate(spawner);
            }
        }
    }

    @EventHandler
    public void onInventoryDrag(InventoryDragEvent event) {
        InventoryHolder inventoryHolder = event.getInventory().getHolder(false);
        if (!(inventoryHolder instanceof SpawnerStackerHolder)) {
            return;
        }
        SpawnerStackerHolder holder = (SpawnerStackerHolder)inventoryHolder;
        if (!this.isSpawnerValid(holder.getSpawnerData())) {
            event.setCancelled(true);
            HumanEntity humanEntity = event.getWhoClicked();
            if (humanEntity instanceof Player) {
                Player player = (Player)humanEntity;
                player.closeInventory();
            }
            return;
        }
        event.setCancelled(true);
    }

    private boolean isSpawnerValid(SpawnerData spawner) {
        if (spawner == null) {
            return false;
        }
        SpawnerManager spawnerManager = this.plugin.getSpawnerManager();
        SpawnerData current = spawnerManager.getSpawnerById(spawner.getSpawnerId());
        return current != null && current == spawner;
    }

    @EventHandler
    public void onInventoryOpen(InventoryOpenEvent event) {
        HumanEntity humanEntity = event.getPlayer();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player player = (Player)humanEntity;
        InventoryHolder inventoryHolder = event.getInventory().getHolder(false);
        if (!(inventoryHolder instanceof SpawnerStackerHolder)) {
            return;
        }
        SpawnerStackerHolder holder = (SpawnerStackerHolder)inventoryHolder;
        UUID playerId = player.getUniqueId();
        String spawnerId = holder.getSpawnerData().getSpawnerId();
        Set viewers = this.activeViewers.computeIfAbsent(spawnerId, k -> ConcurrentHashMap.newKeySet());
        viewers.add(playerId);
        this.updateLocks.putIfAbsent(playerId, new AtomicBoolean(false));
    }

    @EventHandler
    public void onInventoryClose(InventoryCloseEvent event) {
        HumanEntity humanEntity = event.getPlayer();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player player = (Player)humanEntity;
        InventoryHolder inventoryHolder = event.getInventory().getHolder(false);
        if (!(inventoryHolder instanceof SpawnerStackerHolder)) {
            return;
        }
        SpawnerStackerHolder holder = (SpawnerStackerHolder)inventoryHolder;
        String spawnerId = holder.getSpawnerData().getSpawnerId();
        UUID playerId = player.getUniqueId();
        Scheduler.runTaskLater(() -> {
            Inventory topInventory = player.getOpenInventory().getTopInventory();
            if (!(topInventory.getHolder(false) instanceof SpawnerStackerHolder)) {
                this.removeViewer(spawnerId, playerId);
            }
        }, 1L);
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        UUID playerId = event.getPlayer().getUniqueId();
        this.cleanupPlayer(playerId);
    }

    private void cleanupPlayer(UUID playerId) {
        Scheduler.Task task = this.pendingUpdates.remove(playerId);
        if (task != null && !task.isCancelled()) {
            task.cancel();
        }
        this.lastClickTime.remove(playerId);
        this.updateLocks.remove(playerId);
        for (Map.Entry<String, Set<UUID>> entry : this.activeViewers.entrySet()) {
            entry.getValue().remove(playerId);
            if (!entry.getValue().isEmpty()) continue;
            this.activeViewers.remove(entry.getKey());
        }
    }

    public void cleanupAll() {
        this.pendingUpdates.values().forEach(task -> {
            if (task != null && !task.isCancelled()) {
                task.cancel();
            }
        });
        this.pendingUpdates.clear();
        this.lastClickTime.clear();
        this.updateLocks.clear();
        this.activeViewers.clear();
        this.entityTypeCache.clear();
    }

    private void removeViewer(String spawnerId, UUID playerId) {
        Scheduler.Task task;
        Set<UUID> viewers = this.activeViewers.get(spawnerId);
        if (viewers != null) {
            viewers.remove(playerId);
            if (viewers.isEmpty()) {
                this.activeViewers.remove(spawnerId);
            }
        }
        if ((task = this.pendingUpdates.remove(playerId)) != null && !task.isCancelled()) {
            task.cancel();
        }
    }

    private int determineChangeAmount(int slotIndex) {
        if (slotIndex >= 9 && slotIndex <= 11) {
            return -STACK_AMOUNTS[slotIndex - 9];
        }
        if (slotIndex >= 15 && slotIndex <= 17) {
            return STACK_AMOUNTS[17 - slotIndex];
        }
        return 0;
    }

    private void processStackModification(Player player, SpawnerData spawner, int changeAmount) {
        if (changeAmount < 0) {
            this.handleStackDecrease(player, spawner, Math.abs(changeAmount));
        } else {
            this.handleStackIncrease(player, spawner, changeAmount);
        }
    }

    private void handleStackDecrease(Player player, SpawnerData spawner, int removeAmount) {
        int currentSize = spawner.getStackSize();
        if (currentSize == 1) {
            this.messageService.sendMessage(player, "spawner_cannot_remove_last");
            return;
        }
        int targetSize = Math.max(1, currentSize - removeAmount);
        int actualChange = currentSize - targetSize;
        if (actualChange <= 0) {
            HashMap<String, String> placeholders = new HashMap<String, String>(2);
            placeholders.put("amount", String.valueOf(currentSize));
            this.messageService.sendMessage(player, "spawner_stacker_minimum_reached", placeholders);
            return;
        }
        if (SpawnerRemoveEvent.getHandlerList().getRegisteredListeners().length != 0) {
            SpawnerRemoveEvent e = new SpawnerRemoveEvent(player, spawner.getSpawnerLocation(), targetSize, actualChange);
            Bukkit.getPluginManager().callEvent((Event)e);
            if (e.isCancelled()) {
                return;
            }
        }
        this.chunkSpawnerLimiter.unregisterSpawner(spawner.getSpawnerLocation(), actualChange);
        spawner.setStackSize(targetSize);
        this.giveSpawnersToPlayer(player, actualChange, spawner.getEntityType());
        if (this.plugin.getSpawnerActionLogger() != null) {
            this.plugin.getSpawnerActionLogger().log(SpawnerEventType.SPAWNER_DESTACK_GUI, builder -> builder.player(player.getName(), player.getUniqueId()).location(spawner.getSpawnerLocation()).entityType(spawner.getEntityType()).metadata("amount_removed", actualChange).metadata("old_stack_size", currentSize).metadata("new_stack_size", targetSize));
        }
        player.playSound(player.getLocation(), STACK_SOUND, 1.0f, 1.0f);
    }

    private void handleStackIncrease(Player player, SpawnerData spawner, int changeAmount) {
        int currentSize = spawner.getStackSize();
        int maxStackSize = spawner.getMaxStackSize();
        int spaceLeft = maxStackSize - currentSize;
        if (spaceLeft <= 0) {
            HashMap<String, String> placeholders = new HashMap<String, String>(2);
            placeholders.put("max", String.valueOf(maxStackSize));
            this.messageService.sendMessage(player, "spawner_stack_full", placeholders);
            return;
        }
        int actualChange = Math.min(changeAmount, spaceLeft);
        if (!this.chunkSpawnerLimiter.canStackSpawner(player, spawner.getSpawnerLocation(), actualChange)) {
            HashMap<String, String> placeholders = new HashMap<String, String>(2);
            placeholders.put("limit", String.valueOf(this.chunkSpawnerLimiter.getMaxSpawnersPerChunk()));
            this.messageService.sendMessage(player, "spawner_chunk_limit_reached", placeholders);
            return;
        }
        EntityType requiredType = spawner.getEntityType();
        InventoryScanResult scanResult = this.scanPlayerInventory(player, requiredType);
        if (scanResult.availableSpawners == 0 && scanResult.hasDifferentType) {
            this.messageService.sendMessage(player, "spawner_different");
            return;
        }
        if (scanResult.availableSpawners < actualChange) {
            HashMap<String, String> placeholders = new HashMap<String, String>(4);
            placeholders.put("amountChange", String.valueOf(actualChange));
            placeholders.put("amountAvailable", String.valueOf(scanResult.availableSpawners));
            this.messageService.sendMessage(player, "spawner_insufficient_quantity", placeholders);
            return;
        }
        if (SpawnerStackEvent.getHandlerList().getRegisteredListeners().length != 0) {
            SpawnerStackEvent e = new SpawnerStackEvent(player, spawner.getSpawnerLocation(), spawner.getStackSize(), spawner.getStackSize() + actualChange, SpawnerStackEvent.StackSource.GUI);
            Bukkit.getPluginManager().callEvent((Event)e);
            if (e.isCancelled()) {
                return;
            }
        }
        this.chunkSpawnerLimiter.registerSpawnerStack(spawner.getSpawnerLocation(), actualChange);
        this.removeValidSpawnersFromInventory(player, requiredType, actualChange, scanResult.spawnerSlots);
        spawner.setStackSize(currentSize + actualChange);
        if (actualChange < changeAmount) {
            HashMap<String, String> placeholders = new HashMap<String, String>(2);
            placeholders.put("amount", String.valueOf(actualChange));
            this.messageService.sendMessage(player, "spawner_stacker_minimum_reached", placeholders);
        }
        player.playSound(player.getLocation(), STACK_SOUND, 1.0f, 1.0f);
    }

    private void scheduleViewersUpdate(SpawnerData spawner) {
        String spawnerId = spawner.getSpawnerId();
        Set<UUID> viewers = this.activeViewers.get(spawnerId);
        if (viewers == null || viewers.isEmpty()) {
            return;
        }
        Scheduler.Task task = Scheduler.runTaskLater(() -> this.updateAllViewers(spawner, viewers), 2L);
        for (UUID viewerId : viewers) {
            this.pendingUpdates.put(viewerId, task);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateAllViewers(SpawnerData spawner, Set<UUID> viewers) {
        for (UUID viewerId : viewers) {
            AtomicBoolean lock;
            Player viewer = this.plugin.getServer().getPlayer(viewerId);
            if (viewer == null || !viewer.isOnline() || (lock = this.updateLocks.get(viewerId)) == null || !lock.compareAndSet(false, true)) continue;
            try {
                this.updateGui(viewer, spawner);
            }
            finally {
                lock.set(false);
            }
        }
    }

    private void updateGui(Player player, SpawnerData spawner) {
        int i;
        Inventory inv = player.getOpenInventory().getTopInventory();
        if (!(inv.getHolder(false) instanceof SpawnerStackerHolder)) {
            return;
        }
        Map<String, String> basePlaceholders = this.createBasePlaceholders(spawner);
        this.updateInfoItem(inv, basePlaceholders);
        for (i = 0; i < DECREASE_SLOTS.length; ++i) {
            this.updateActionButton(inv, "remove", STACK_AMOUNTS[i], DECREASE_SLOTS[i], basePlaceholders);
        }
        for (i = 0; i < INCREASE_SLOTS.length; ++i) {
            this.updateActionButton(inv, "add", STACK_AMOUNTS[i], INCREASE_SLOTS[i], basePlaceholders);
        }
        player.updateInventory();
    }

    private Map<String, String> createBasePlaceholders(SpawnerData spawner) {
        HashMap<String, String> placeholders = new HashMap<String, String>(8);
        placeholders.put("stack_size", String.valueOf(spawner.getStackSize()));
        placeholders.put("max_stack_size", String.valueOf(spawner.getMaxStackSize()));
        String entityName = this.languageManager.getFormattedMobName(spawner.getEntityType());
        placeholders.put("entity", entityName);
        placeholders.put("\u1d07\u0274\u1d1b\u026a\u1d1b\u028f", this.languageManager.getSmallCaps(entityName));
        return placeholders;
    }

    private void updateInfoItem(Inventory inventory, Map<String, String> basePlaceholders) {
        ItemStack infoItem = inventory.getItem(13);
        if (infoItem == null || !infoItem.hasItemMeta()) {
            return;
        }
        ItemMeta meta = infoItem.getItemMeta();
        HashMap<String, String> placeholders = new HashMap<String, String>(basePlaceholders);
        String name = this.languageManager.getGuiItemName("button_spawner.name", placeholders);
        String[] lore = this.languageManager.getGuiItemLore("button_spawner.lore", placeholders);
        meta.setDisplayName(name);
        meta.setLore(Arrays.asList(lore));
        infoItem.setItemMeta(meta);
    }

    private void updateActionButton(Inventory inventory, String action, int amount, int slot, Map<String, String> basePlaceholders) {
        ItemStack button = inventory.getItem(slot);
        if (button == null || !button.hasItemMeta()) {
            return;
        }
        ItemMeta meta = button.getItemMeta();
        HashMap<String, String> placeholders = new HashMap<String, String>(basePlaceholders);
        placeholders.put("amount", String.valueOf(amount));
        placeholders.put("plural", amount > 1 ? "s" : "");
        String name = this.languageManager.getGuiItemName("button_" + action + ".name", placeholders);
        String[] lore = this.languageManager.getGuiItemLore("button_" + action + ".lore", placeholders);
        meta.setDisplayName(name);
        meta.setLore(Arrays.asList(lore));
        button.setItemMeta(meta);
    }

    private InventoryScanResult scanPlayerInventory(Player player, EntityType requiredType) {
        int count = 0;
        boolean hasDifferentType = false;
        ArrayList<SpawnerSlot> spawnerSlots = new ArrayList<SpawnerSlot>();
        ItemStack[] contents = player.getInventory().getContents();
        for (int i = 0; i < contents.length; ++i) {
            Optional<EntityType> itemType;
            ItemStack item = contents[i];
            if (item == null || item.getType() != Material.SPAWNER || SpawnerTypeChecker.isVanillaSpawner(item) || !(itemType = this.getSpawnerEntityTypeCached(item)).isPresent()) continue;
            if (itemType.get() == requiredType) {
                count += item.getAmount();
                spawnerSlots.add(new SpawnerSlot(i, item.getAmount()));
                continue;
            }
            hasDifferentType = true;
        }
        return new InventoryScanResult(count, hasDifferentType, spawnerSlots);
    }

    private Optional<EntityType> getSpawnerEntityTypeCached(ItemStack item) {
        if (item == null || item.getType() != Material.SPAWNER) {
            return Optional.empty();
        }
        Optional<EntityType> cachedType = this.entityTypeCache.get(item);
        if (cachedType != null) {
            return cachedType;
        }
        Optional<EntityType> result = this.getEntityTypeFromItem(item);
        this.entityTypeCache.put(item, result);
        return result;
    }

    public Optional<EntityType> getEntityTypeFromItem(ItemStack item) {
        CreatureSpawner handSpawner;
        EntityType entityType;
        BlockState blockState;
        BlockStateMeta blockMeta;
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return Optional.empty();
        }
        if (meta instanceof BlockStateMeta && (blockMeta = (BlockStateMeta)meta).hasBlockState() && (blockState = blockMeta.getBlockState()) instanceof CreatureSpawner && (entityType = (handSpawner = (CreatureSpawner)blockState).getSpawnedType()) != null) {
            return Optional.of(entityType);
        }
        return Optional.empty();
    }

    private void removeValidSpawnersFromInventory(Player player, EntityType requiredType, int amountToRemove, List<SpawnerSlot> spawnerSlots) {
        int remainingToRemove = amountToRemove;
        for (SpawnerSlot slot : spawnerSlots) {
            Optional<EntityType> spawnerType;
            if (remainingToRemove <= 0) break;
            ItemStack item = player.getInventory().getItem(slot.slotIndex);
            if (item == null || item.getType() != Material.SPAWNER || !(spawnerType = this.getSpawnerEntityTypeCached(item)).isPresent() || spawnerType.get() != requiredType) continue;
            int itemAmount = item.getAmount();
            if (itemAmount <= remainingToRemove) {
                player.getInventory().setItem(slot.slotIndex, null);
                remainingToRemove -= itemAmount;
                continue;
            }
            item.setAmount(itemAmount - remainingToRemove);
            remainingToRemove = 0;
        }
        player.updateInventory();
    }

    public void giveSpawnersToPlayer(Player player, int amount, EntityType entityType) {
        int MAX_STACK_SIZE = 64;
        int remainingAmount = amount;
        ItemStack[] contents = player.getInventory().getContents();
        for (int i = 0; i < contents.length && remainingAmount > 0; ++i) {
            int currentAmount;
            Optional<EntityType> itemEntityType;
            ItemStack item = contents[i];
            if (item == null || item.getType() != Material.SPAWNER || SpawnerTypeChecker.isVanillaSpawner(item) || (itemEntityType = this.getSpawnerEntityTypeCached(item)).isEmpty() || itemEntityType.get() != entityType || (currentAmount = item.getAmount()) >= 64) continue;
            int canAdd = Math.min(64 - currentAmount, remainingAmount);
            item.setAmount(currentAmount + canAdd);
            remainingAmount -= canAdd;
        }
        if (remainingAmount > 0) {
            ArrayList<ItemStack> newStacks = new ArrayList<ItemStack>();
            while (remainingAmount > 0) {
                int stackSize = Math.min(64, remainingAmount);
                ItemStack spawnerItem = this.spawnerItemFactory.createSmartSpawnerItem(entityType, stackSize);
                newStacks.add(spawnerItem);
                remainingAmount -= stackSize;
            }
            boolean allFit = true;
            for (ItemStack stack : newStacks) {
                boolean addedSuccessfully = this.addItemAvoidingVanillaSpawners(player, stack);
                if (addedSuccessfully) continue;
                player.getWorld().dropItemNaturally(player.getLocation(), stack);
                allFit = false;
            }
            if (!allFit) {
                this.messageService.sendMessage(player, "inventory_full_items_dropped");
            }
        }
        player.updateInventory();
    }

    private boolean addItemAvoidingVanillaSpawners(Player player, ItemStack item) {
        if (item.getType() != Material.SPAWNER) {
            HashMap failed = player.getInventory().addItem(new ItemStack[]{item});
            return failed.isEmpty();
        }
        PlayerInventory inv = player.getInventory();
        for (int i = 0; i < 36; ++i) {
            ItemStack currentItem = inv.getItem(i);
            if (currentItem != null) continue;
            inv.setItem(i, item.clone());
            return true;
        }
        return false;
    }

    public void closeAllViewersInventory(String spawnerId) {
        Set<UUID> viewers = this.activeViewers.get(spawnerId);
        if (viewers == null || viewers.isEmpty()) {
            return;
        }
        HashSet<UUID> viewersCopy = new HashSet<UUID>(viewers);
        for (UUID viewerId : viewersCopy) {
            Player viewer = this.plugin.getServer().getPlayer(viewerId);
            if (viewer == null || !viewer.isOnline()) continue;
            viewer.closeInventory();
        }
    }

    private boolean isBedrockPlayer(Player player) {
        if (this.plugin.getIntegrationManager() == null || this.plugin.getIntegrationManager().getFloodgateHook() == null) {
            return false;
        }
        return this.plugin.getIntegrationManager().getFloodgateHook().isBedrockPlayer(player);
    }
}

