/*
 * Decompiled with CFR 0.152.
 */
package github.nighter.smartspawner.spawner.gui.storage;

import github.nighter.smartspawner.Scheduler;
import github.nighter.smartspawner.SmartSpawner;
import github.nighter.smartspawner.language.LanguageManager;
import github.nighter.smartspawner.language.MessageService;
import github.nighter.smartspawner.logging.SpawnerEventType;
import github.nighter.smartspawner.spawner.data.SpawnerManager;
import github.nighter.smartspawner.spawner.gui.layout.GuiLayout;
import github.nighter.smartspawner.spawner.gui.layout.GuiLayoutConfig;
import github.nighter.smartspawner.spawner.gui.main.SpawnerMenuUI;
import github.nighter.smartspawner.spawner.gui.storage.SpawnerStorageUI;
import github.nighter.smartspawner.spawner.gui.storage.StoragePageHolder;
import github.nighter.smartspawner.spawner.gui.storage.filter.FilterConfigUI;
import github.nighter.smartspawner.spawner.gui.storage.utils.ItemClickHandler;
import github.nighter.smartspawner.spawner.gui.storage.utils.ItemMoveHelper;
import github.nighter.smartspawner.spawner.gui.storage.utils.ItemMoveResult;
import github.nighter.smartspawner.spawner.gui.synchronization.SpawnerGuiViewManager;
import github.nighter.smartspawner.spawner.loot.LootItem;
import github.nighter.smartspawner.spawner.properties.SpawnerData;
import github.nighter.smartspawner.spawner.properties.VirtualInventory;
import github.nighter.smartspawner.spawner.sell.SpawnerSellManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.util.Vector;

public class SpawnerStorageAction
implements Listener {
    private final SmartSpawner plugin;
    private final LanguageManager languageManager;
    private final SpawnerMenuUI spawnerMenuUI;
    private final SpawnerGuiViewManager spawnerGuiViewManager;
    private final MessageService messageService;
    private final FilterConfigUI filterConfigUI;
    private final SpawnerSellManager spawnerSellManager;
    private final SpawnerManager spawnerManager;
    private GuiLayoutConfig guiLayoutConfig;
    private static final int INVENTORY_SIZE = 54;
    private static final int STORAGE_SLOTS = 45;
    private final Map<ClickType, ItemClickHandler> clickHandlers;
    private final Map<UUID, Inventory> openStorageInventories = new ConcurrentHashMap<UUID, Inventory>();
    private final Map<UUID, Long> lastItemClickTime = new ConcurrentHashMap<UUID, Long>();
    private final Set<UUID> activeDropTransactions = ConcurrentHashMap.newKeySet();
    private final Map<UUID, Long> transactionStartTimes = new ConcurrentHashMap<UUID, Long>();
    private final Map<UUID, Long> storageAccessCooldowns = new ConcurrentHashMap<UUID, Long>();
    private static final long TRANSACTION_TIMEOUT_MS = 5000L;
    private static final long DROP_COOLDOWN_MS = 150L;
    private static final long STORAGE_ACCESS_COOLDOWN_MS = 500L;
    private Random random = new Random();
    private GuiLayout layout;

    public SpawnerStorageAction(SmartSpawner plugin) {
        this.plugin = plugin;
        this.languageManager = plugin.getLanguageManager();
        this.clickHandlers = this.initializeClickHandlers();
        this.spawnerMenuUI = plugin.getSpawnerMenuUI();
        this.spawnerGuiViewManager = plugin.getSpawnerGuiViewManager();
        this.messageService = plugin.getMessageService();
        this.filterConfigUI = plugin.getFilterConfigUI();
        this.spawnerSellManager = plugin.getSpawnerSellManager();
        this.spawnerManager = plugin.getSpawnerManager();
        this.loadConfig();
    }

    public void loadConfig() {
        this.guiLayoutConfig = this.plugin.getGuiLayoutConfig();
        this.layout = this.guiLayoutConfig.getCurrentLayout();
    }

    private Map<ClickType, ItemClickHandler> initializeClickHandlers() {
        EnumMap<ClickType, ItemClickHandler> handlers = new EnumMap<ClickType, ItemClickHandler>(ClickType.class);
        handlers.put(ClickType.RIGHT, (player, inv, slot, item, spawner) -> this.takeSingleItem(player, inv, slot, item, spawner, true));
        handlers.put(ClickType.LEFT, (player, inv, slot, item, spawner) -> this.takeSingleItem(player, inv, slot, item, spawner, false));
        return Collections.unmodifiableMap(handlers);
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onInventoryClick(InventoryClickEvent event) {
        ItemStack clickedItem;
        Player player;
        HumanEntity humanEntity;
        block9: {
            block8: {
                humanEntity = event.getWhoClicked();
                if (!(humanEntity instanceof Player)) break block8;
                player = (Player)humanEntity;
                humanEntity = event.getInventory().getHolder(false);
                if (humanEntity instanceof StoragePageHolder) break block9;
            }
            return;
        }
        StoragePageHolder holder = (StoragePageHolder)humanEntity;
        SpawnerData spawner = holder.getSpawnerData();
        int slot = event.getRawSlot();
        if ((event.getAction() == InventoryAction.DROP_ONE_SLOT || event.getAction() == InventoryAction.DROP_ALL_SLOT) && slot >= 0 && slot < 45 && (clickedItem = event.getCurrentItem()) != null && clickedItem.getType() != Material.AIR) {
            event.setCancelled(true);
            boolean dropStack = event.getAction() == InventoryAction.DROP_ALL_SLOT;
            this.handleItemDrop(player, spawner, event.getInventory(), slot, clickedItem, dropStack);
            return;
        }
        event.setCancelled(true);
        if (slot < 0 || slot >= 54) {
            return;
        }
        if (this.isControlSlot(slot)) {
            this.handleControlSlotClick(player, slot, holder, spawner, event.getInventory(), this.layout);
            return;
        }
        clickedItem = event.getCurrentItem();
        if (clickedItem == null || clickedItem.getType() == Material.AIR) {
            return;
        }
        ItemClickHandler handler = this.clickHandlers.get(event.getClick());
        if (handler != null) {
            handler.handle(player, event.getInventory(), slot, clickedItem, spawner);
        }
    }

    private void handleControlSlotClick(Player player, int slot, StoragePageHolder holder, SpawnerData spawner, Inventory inventory, GuiLayout layout) {
        String buttonType;
        Optional<String> buttonTypeOpt = layout.getButtonTypeAtSlot(slot);
        if (buttonTypeOpt.isEmpty()) {
            return;
        }
        switch (buttonType = buttonTypeOpt.get()) {
            case "sort_items": {
                this.handleSortItemsClick(player, spawner, inventory);
                break;
            }
            case "item_filter": {
                this.openFilterConfig(player, spawner);
                break;
            }
            case "previous_page": {
                if (holder.getCurrentPage() <= 1) break;
                this.updatePageContent(player, spawner, holder.getCurrentPage() - 1, inventory, true);
                break;
            }
            case "take_all": {
                this.handleTakeAllItems(player, inventory);
                break;
            }
            case "next_page": {
                if (holder.getCurrentPage() >= holder.getTotalPages()) break;
                this.updatePageContent(player, spawner, holder.getCurrentPage() + 1, inventory, true);
                break;
            }
            case "drop_page": {
                this.handleDropPageItems(player, spawner, inventory);
                break;
            }
            case "sell_all": {
                if (!this.plugin.hasSellIntegration()) break;
                if (!player.hasPermission("smartspawner.sellall")) {
                    this.messageService.sendMessage(player, "no_permission");
                    return;
                }
                if (this.isClickTooFrequent(player)) {
                    return;
                }
                player.playSound(player.getLocation(), Sound.UI_BUTTON_CLICK, 1.0f, 1.0f);
                this.spawnerSellManager.sellAllItems(player, spawner);
                break;
            }
            case "return": {
                this.openMainMenu(player, spawner);
            }
        }
    }

    @EventHandler
    public void onInventoryDrag(InventoryDragEvent event) {
        InventoryHolder inventoryHolder = event.getInventory().getHolder(false);
        if (!(inventoryHolder instanceof StoragePageHolder)) {
            return;
        }
        StoragePageHolder holder = (StoragePageHolder)inventoryHolder;
        event.setCancelled(true);
    }

    private boolean isControlSlot(int slot) {
        return this.layout != null && this.layout.isSlotUsed(slot);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleItemDrop(Player player, SpawnerData spawner, Inventory inventory, int slot, ItemStack item, boolean dropStack) {
        UUID playerId = player.getUniqueId();
        if (this.isDropOperationTooFrequent(playerId)) {
            return;
        }
        if (!this.acquireDropTransaction(playerId)) {
            this.messageService.sendMessage(player, "action_in_progress");
            return;
        }
        try {
            if (!this.isPlayerInventoryOpen(player, inventory)) {
                return;
            }
            ItemStack currentItem = inventory.getItem(slot);
            if (currentItem == null || currentItem.getType() == Material.AIR || !currentItem.isSimilar(item)) {
                return;
            }
            int amountToDrop = dropStack ? item.getAmount() : 1;
            ItemStack droppedItem = item.clone();
            droppedItem.setAmount(Math.min(amountToDrop, item.getAmount()));
            VirtualInventory virtualInv = spawner.getVirtualInventory();
            ArrayList<ItemStack> itemsToRemove = new ArrayList<ItemStack>();
            itemsToRemove.add(droppedItem);
            if (!this.validateItemsExistInVirtualInventory(itemsToRemove, virtualInv)) {
                this.messageService.sendMessage(player, "items_not_available");
                StoragePageHolder holder = (StoragePageHolder)inventory.getHolder(false);
                if (holder != null) {
                    this.updatePageContent(player, spawner, holder.getCurrentPage(), inventory, false);
                }
                return;
            }
            boolean removalSuccess = spawner.removeItemsAndUpdateSellValue(itemsToRemove);
            if (!removalSuccess) {
                this.messageService.sendMessage(player, "drop_failed");
                StoragePageHolder holder = (StoragePageHolder)inventory.getHolder(false);
                if (holder != null) {
                    this.updatePageContent(player, spawner, holder.getCurrentPage(), inventory, false);
                }
                return;
            }
            int remaining = item.getAmount() - amountToDrop;
            if (remaining <= 0) {
                inventory.setItem(slot, null);
            } else {
                ItemStack remainingItem = item.clone();
                remainingItem.setAmount(remaining);
                inventory.setItem(slot, remainingItem);
            }
            Location playerLoc = player.getLocation();
            World world = player.getWorld();
            UUID playerUUID = player.getUniqueId();
            double yaw = Math.toRadians(playerLoc.getYaw());
            double pitch = Math.toRadians(playerLoc.getPitch());
            double sinYaw = -Math.sin(yaw);
            double cosYaw = Math.cos(yaw);
            double cosPitch = Math.cos(pitch);
            double sinPitch = -Math.sin(pitch);
            Location dropLocation = playerLoc.clone();
            dropLocation.add(sinYaw * 0.3, 1.2, cosYaw * 0.3);
            Item droppedItemWorld = world.dropItem(dropLocation, droppedItem, drop -> {
                drop.setThrower(playerUUID);
                drop.setPickupDelay(40);
            });
            Vector velocity = new Vector(sinYaw * cosPitch * 0.3 + (this.random.nextDouble() - 0.5) * 0.1, sinPitch * 0.3 + 0.1 + (this.random.nextDouble() - 0.5) * 0.1, cosYaw * cosPitch * 0.3 + (this.random.nextDouble() - 0.5) * 0.1);
            droppedItemWorld.setVelocity(velocity);
            if (this.plugin.getSpawnerActionLogger() != null) {
                this.plugin.getSpawnerActionLogger().log(SpawnerEventType.SPAWNER_ITEM_DROP, builder -> builder.player(player.getName(), player.getUniqueId()).location(spawner.getSpawnerLocation()).entityType(spawner.getEntityType()).metadata("item_type", droppedItem.getType().name()).metadata("amount_dropped", droppedItem.getAmount()).metadata("drop_stack", dropStack));
            }
            player.playSound(player.getLocation(), Sound.ENTITY_ITEM_PICKUP, 0.5f, 1.2f);
            spawner.updateHologramData();
            StoragePageHolder holder = (StoragePageHolder)inventory.getHolder(false);
            if (holder != null) {
                int newTotalPages;
                int oldTotalPages = holder.getTotalPages();
                if (oldTotalPages != (newTotalPages = this.calculateTotalPages(spawner))) {
                    int currentPage = holder.getCurrentPage();
                    int adjustedPage = Math.max(1, Math.min(currentPage, newTotalPages));
                    holder.setTotalPages(newTotalPages);
                    if (adjustedPage != currentPage) {
                        holder.setCurrentPage(adjustedPage);
                    }
                    this.updateInventoryTitle(player, inventory, spawner, adjustedPage, newTotalPages);
                }
                holder.updateOldUsedSlots();
                this.spawnerGuiViewManager.updateSpawnerMenuViewers(spawner);
                if (!spawner.isInteracted()) {
                    spawner.markInteracted();
                }
                if (spawner.getMaxSpawnerLootSlots() > holder.getOldUsedSlots() && spawner.getIsAtCapacity().booleanValue()) {
                    spawner.setIsAtCapacity(false);
                }
            }
        }
        finally {
            this.releaseDropTransaction(playerId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleDropPageItems(Player player, SpawnerData spawner, Inventory inventory) {
        UUID playerId = player.getUniqueId();
        if (this.isDropOperationTooFrequent(playerId)) {
            return;
        }
        if (!this.acquireDropTransaction(playerId)) {
            this.messageService.sendMessage(player, "action_in_progress");
            return;
        }
        try {
            StoragePageHolder holder = (StoragePageHolder)inventory.getHolder(false);
            if (holder == null) {
                return;
            }
            if (!this.isPlayerInventoryOpen(player, inventory)) {
                return;
            }
            ArrayList<ItemStack> pageItems = new ArrayList<ItemStack>();
            int itemsFoundCount = 0;
            for (int i = 0; i < 45; ++i) {
                ItemStack item = inventory.getItem(i);
                if (item == null || item.getType() == Material.AIR) continue;
                pageItems.add(item.clone());
                itemsFoundCount += item.getAmount();
            }
            if (pageItems.isEmpty()) {
                this.messageService.sendMessage(player, "no_items_to_drop");
                return;
            }
            int itemsFound = itemsFoundCount;
            VirtualInventory virtualInv = spawner.getVirtualInventory();
            if (!this.validateItemsExistInVirtualInventory(pageItems, virtualInv)) {
                this.messageService.sendMessage(player, "items_not_available");
                this.updatePageContent(player, spawner, holder.getCurrentPage(), inventory, false);
                return;
            }
            boolean removalSuccess = spawner.removeItemsAndUpdateSellValue(pageItems);
            if (!removalSuccess) {
                this.messageService.sendMessage(player, "drop_failed");
                this.updatePageContent(player, spawner, holder.getCurrentPage(), inventory, false);
                return;
            }
            for (int i = 0; i < 45; ++i) {
                ItemStack item = inventory.getItem(i);
                if (item == null || item.getType() == Material.AIR) continue;
                inventory.setItem(i, null);
            }
            this.dropItemsInDirection(player, pageItems);
            int newTotalPages = this.calculateTotalPages(spawner);
            int adjustedPage = holder.getCurrentPage();
            if (adjustedPage > newTotalPages) {
                adjustedPage = Math.max(1, newTotalPages);
                holder.setCurrentPage(adjustedPage);
            }
            holder.setTotalPages(newTotalPages);
            holder.updateOldUsedSlots();
            int finalPage = adjustedPage;
            SpawnerStorageUI lootManager = this.plugin.getSpawnerStorageUI();
            lootManager.updateDisplay(inventory, spawner, finalPage, newTotalPages);
            this.updateInventoryTitle(player, inventory, spawner, finalPage, newTotalPages);
            spawner.updateHologramData();
            this.spawnerGuiViewManager.updateSpawnerMenuViewers(spawner);
            if (spawner.getMaxSpawnerLootSlots() > holder.getOldUsedSlots() && spawner.getIsAtCapacity().booleanValue()) {
                spawner.setIsAtCapacity(false);
            }
            if (!spawner.isInteracted()) {
                spawner.markInteracted();
            }
            if (this.plugin.getSpawnerActionLogger() != null) {
                this.plugin.getSpawnerActionLogger().log(SpawnerEventType.SPAWNER_DROP_PAGE_ITEMS, builder -> builder.player(player.getName(), player.getUniqueId()).location(spawner.getSpawnerLocation()).entityType(spawner.getEntityType()).metadata("items_dropped", itemsFound).metadata("page_number", finalPage));
            }
            player.playSound(player.getLocation(), Sound.ENTITY_ITEM_PICKUP, 0.8f, 0.8f);
        }
        finally {
            this.releaseDropTransaction(playerId);
        }
    }

    private void dropItemsInDirection(Player player, List<ItemStack> items) {
        if (items.isEmpty()) {
            return;
        }
        Location playerLoc = player.getLocation();
        World world = player.getWorld();
        UUID playerUUID = player.getUniqueId();
        double yaw = Math.toRadians(playerLoc.getYaw());
        double pitch = Math.toRadians(playerLoc.getPitch());
        double sinYaw = -Math.sin(yaw);
        double cosYaw = Math.cos(yaw);
        double cosPitch = Math.cos(pitch);
        double sinPitch = -Math.sin(pitch);
        Location dropLocation = playerLoc.clone();
        dropLocation.add(sinYaw * 0.3, 1.2, cosYaw * 0.3);
        for (ItemStack item : items) {
            Item droppedItem = world.dropItem(dropLocation, item, drop -> {
                drop.setThrower(playerUUID);
                drop.setPickupDelay(40);
            });
            Vector velocity = new Vector(sinYaw * cosPitch * 0.3 + (this.random.nextDouble() - 0.5) * 0.1, sinPitch * 0.3 + 0.1 + (this.random.nextDouble() - 0.5) * 0.1, cosYaw * cosPitch * 0.3 + (this.random.nextDouble() - 0.5) * 0.1);
            droppedItem.setVelocity(velocity);
        }
    }

    private void openFilterConfig(Player player, SpawnerData spawner) {
        if (this.isClickTooFrequent(player)) {
            return;
        }
        this.filterConfigUI.openFilterConfigGUI(player, spawner);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void takeSingleItem(Player player, Inventory sourceInv, int slot, ItemStack item, SpawnerData spawner, boolean singleItem) {
        UUID playerId = player.getUniqueId();
        if (this.isDropOperationTooFrequent(playerId)) {
            return;
        }
        if (!this.acquireDropTransaction(playerId)) {
            this.messageService.sendMessage(player, "action_in_progress");
            return;
        }
        try {
            int amountNotMoved;
            if (!this.isPlayerInventoryOpen(player, sourceInv)) {
                return;
            }
            ItemStack currentItem = sourceInv.getItem(slot);
            if (currentItem == null || currentItem.getType() == Material.AIR || !currentItem.isSimilar(item)) {
                return;
            }
            PlayerInventory playerInv = player.getInventory();
            VirtualInventory virtualInv = spawner.getVirtualInventory();
            int amountToTake = singleItem ? 1 : item.getAmount();
            ArrayList<ItemStack> itemsToRemove = new ArrayList<ItemStack>();
            ItemStack itemToRemove = item.clone();
            itemToRemove.setAmount(amountToTake);
            itemsToRemove.add(itemToRemove);
            if (!this.validateItemsExistInVirtualInventory(itemsToRemove, virtualInv)) {
                this.messageService.sendMessage(player, "items_not_available");
                StoragePageHolder holder = (StoragePageHolder)sourceInv.getHolder(false);
                if (holder != null) {
                    this.updatePageContent(player, spawner, holder.getCurrentPage(), sourceInv, false);
                }
                return;
            }
            boolean removalSuccess = spawner.removeItemsAndUpdateSellValue(itemsToRemove);
            if (!removalSuccess) {
                this.messageService.sendMessage(player, "take_failed");
                StoragePageHolder holder = (StoragePageHolder)sourceInv.getHolder(false);
                if (holder != null) {
                    this.updatePageContent(player, spawner, holder.getCurrentPage(), sourceInv, false);
                }
                return;
            }
            ItemMoveResult result = ItemMoveHelper.moveItems(item, amountToTake, playerInv, virtualInv);
            if (result.getAmountMoved() < amountToTake && (amountNotMoved = amountToTake - result.getAmountMoved()) > 0) {
                ItemStack itemToReturn = item.clone();
                itemToReturn.setAmount(amountNotMoved);
                ArrayList<ItemStack> itemsToReturn = new ArrayList<ItemStack>();
                itemsToReturn.add(itemToReturn);
                virtualInv.addItems(itemsToReturn);
                itemsToRemove.clear();
                if (result.getAmountMoved() > 0) {
                    ItemStack actuallyMoved = item.clone();
                    actuallyMoved.setAmount(result.getAmountMoved());
                    itemsToRemove.add(actuallyMoved);
                }
            }
            if (result.getAmountMoved() > 0) {
                SpawnerStorageAction.updateInventorySlot(sourceInv, slot, item, result.getAmountMoved());
                player.updateInventory();
                spawner.updateHologramData();
                StoragePageHolder holder = (StoragePageHolder)sourceInv.getHolder(false);
                if (holder != null) {
                    int newTotalPages;
                    int oldTotalPages = holder.getTotalPages();
                    if (oldTotalPages != (newTotalPages = this.calculateTotalPages(spawner))) {
                        int currentPage = holder.getCurrentPage();
                        int adjustedPage = Math.max(1, Math.min(currentPage, newTotalPages));
                        holder.setTotalPages(newTotalPages);
                        if (adjustedPage != currentPage) {
                            holder.setCurrentPage(adjustedPage);
                        }
                        this.updateInventoryTitle(player, sourceInv, spawner, adjustedPage, newTotalPages);
                    }
                    holder.updateOldUsedSlots();
                    this.spawnerGuiViewManager.updateSpawnerMenuViewers(spawner);
                    if (spawner.getMaxSpawnerLootSlots() > holder.getOldUsedSlots() && spawner.getIsAtCapacity().booleanValue()) {
                        spawner.setIsAtCapacity(false);
                    }
                }
            } else {
                this.messageService.sendMessage(player, "inventory_full");
            }
        }
        finally {
            this.releaseDropTransaction(playerId);
        }
    }

    private static void updateInventorySlot(Inventory sourceInv, int slot, ItemStack item, int amountMoved) {
        if (amountMoved >= item.getAmount()) {
            sourceInv.setItem(slot, null);
            return;
        }
        ItemStack remaining = item.clone();
        remaining.setAmount(item.getAmount() - amountMoved);
        sourceInv.setItem(slot, remaining);
    }

    private void updatePageContent(Player player, SpawnerData spawner, int newPage, Inventory inventory, boolean uiClickSound) {
        SpawnerStorageUI lootManager = this.plugin.getSpawnerStorageUI();
        StoragePageHolder holder = (StoragePageHolder)inventory.getHolder(false);
        int totalPages = this.calculateTotalPages(spawner);
        assert (holder != null);
        holder.setTotalPages(totalPages);
        holder.setCurrentPage(newPage);
        holder.updateOldUsedSlots();
        lootManager.updateDisplay(inventory, spawner, newPage, totalPages);
        this.updateInventoryTitle(player, inventory, spawner, newPage, totalPages);
        if (uiClickSound) {
            player.playSound(player.getLocation(), Sound.UI_BUTTON_CLICK, 1.0f, 1.0f);
        }
    }

    private int calculateTotalPages(SpawnerData spawner) {
        int usedSlots = spawner.getVirtualInventory().getUsedSlots();
        return Math.max(1, (int)Math.ceil((double)usedSlots / 45.0));
    }

    private void updateInventoryTitle(Player player, Inventory inventory, SpawnerData spawner, int page, int totalPages) {
        String newTitle = this.languageManager.getGuiTitle("gui_title_storage", Map.of("current_page", String.valueOf(page), "total_pages", String.valueOf(totalPages)));
        try {
            player.getOpenInventory().setTitle(newTitle);
        }
        catch (Exception e) {
            this.openLootPage(player, spawner, page, false);
        }
    }

    private boolean isClickTooFrequent(Player player) {
        long now = System.currentTimeMillis();
        long last = this.lastItemClickTime.getOrDefault(player.getUniqueId(), 0L);
        this.lastItemClickTime.put(player.getUniqueId(), now);
        return now - last < 300L;
    }

    private boolean isDropOperationTooFrequent(UUID playerId) {
        long now = System.currentTimeMillis();
        long last = this.lastItemClickTime.getOrDefault(playerId, 0L);
        this.lastItemClickTime.put(playerId, now);
        return now - last < 150L;
    }

    public boolean canAccessStorageGUI(UUID playerId) {
        long now = System.currentTimeMillis();
        Long lastClose = this.storageAccessCooldowns.get(playerId);
        if (lastClose == null) {
            return true;
        }
        return now - lastClose >= 500L;
    }

    private boolean acquireDropTransaction(UUID playerId) {
        this.cleanupExpiredTransactions();
        if (this.activeDropTransactions.add(playerId)) {
            this.transactionStartTimes.put(playerId, System.currentTimeMillis());
            return true;
        }
        return false;
    }

    private void releaseDropTransaction(UUID playerId) {
        this.activeDropTransactions.remove(playerId);
        this.transactionStartTimes.remove(playerId);
    }

    private void cleanupExpiredTransactions() {
        long now = System.currentTimeMillis();
        ArrayList<UUID> expiredTransactions = new ArrayList<UUID>();
        for (Map.Entry<UUID, Long> entry : this.transactionStartTimes.entrySet()) {
            if (now - entry.getValue() <= 5000L) continue;
            expiredTransactions.add(entry.getKey());
        }
        for (UUID playerId : expiredTransactions) {
            this.activeDropTransactions.remove(playerId);
            this.transactionStartTimes.remove(playerId);
        }
    }

    private boolean validateItemsExistInVirtualInventory(List<ItemStack> items, VirtualInventory virtualInv) {
        if (items == null || items.isEmpty()) {
            return true;
        }
        HashMap<VirtualInventory.ItemSignature, Long> requiredItems = new HashMap<VirtualInventory.ItemSignature, Long>();
        for (ItemStack item : items) {
            if (item == null || item.getAmount() <= 0) continue;
            VirtualInventory.ItemSignature sig = VirtualInventory.getSignature(item);
            requiredItems.merge(sig, Long.valueOf(item.getAmount()), Long::sum);
        }
        Map<VirtualInventory.ItemSignature, Long> consolidatedItems = virtualInv.getConsolidatedItems();
        for (Map.Entry entry : requiredItems.entrySet()) {
            Long available = consolidatedItems.get(entry.getKey());
            if (available != null && available >= (Long)entry.getValue()) continue;
            return false;
        }
        return true;
    }

    private boolean isPlayerInventoryOpen(Player player, Inventory expectedInventory) {
        if (player == null || !player.isOnline()) {
            return false;
        }
        Inventory openInv = player.getOpenInventory().getTopInventory();
        return openInv != null && openInv.equals((Object)expectedInventory);
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        UUID playerId = event.getPlayer().getUniqueId();
        this.lastItemClickTime.remove(playerId);
        this.activeDropTransactions.remove(playerId);
        this.transactionStartTimes.remove(playerId);
        this.storageAccessCooldowns.remove(playerId);
    }

    private void openMainMenu(Player player, SpawnerData spawner) {
        player.playSound(player.getLocation(), Sound.UI_BUTTON_CLICK, 1.0f, 1.0f);
        if (spawner.isInteracted()) {
            this.spawnerManager.markSpawnerModified(spawner.getSpawnerId());
            spawner.clearInteracted();
        }
        if (this.isBedrockPlayer(player)) {
            if (this.plugin.getSpawnerMenuFormUI() != null) {
                this.plugin.getSpawnerMenuFormUI().openSpawnerForm(player, spawner);
            } else {
                this.spawnerMenuUI.openSpawnerMenu(player, spawner, true);
            }
        } else {
            this.spawnerMenuUI.openSpawnerMenu(player, spawner, true);
        }
    }

    private boolean isBedrockPlayer(Player player) {
        if (this.plugin.getIntegrationManager() == null || this.plugin.getIntegrationManager().getFloodgateHook() == null) {
            return false;
        }
        return this.plugin.getIntegrationManager().getFloodgateHook().isBedrockPlayer(player);
    }

    private void handleSortItemsClick(Player player, SpawnerData spawner, Inventory inventory) {
        Material nextSort;
        if (this.isClickTooFrequent(player)) {
            return;
        }
        if (spawner.getLootConfig() == null || spawner.getLootConfig().getAllItems() == null) {
            return;
        }
        List<LootItem> lootItems = spawner.getLootConfig().getAllItems();
        if (lootItems.isEmpty()) {
            return;
        }
        Material currentSort = spawner.getPreferredSortItem();
        List<Material> sortedLoot = lootItems.stream().map(LootItem::getMaterial).distinct().sorted(Comparator.comparing(Enum::name)).toList();
        if (sortedLoot.isEmpty()) {
            return;
        }
        if (currentSort == null) {
            nextSort = sortedLoot.getFirst();
        } else {
            int currentIndex = sortedLoot.indexOf(currentSort);
            if (currentIndex == -1) {
                nextSort = sortedLoot.getFirst();
            } else {
                int nextIndex = (currentIndex + 1) % sortedLoot.size();
                nextSort = sortedLoot.get(nextIndex);
            }
        }
        spawner.setPreferredSortItem(nextSort);
        if (!spawner.isInteracted()) {
            spawner.markInteracted();
        }
        this.spawnerManager.queueSpawnerForSaving(spawner.getSpawnerId());
        spawner.getVirtualInventory().sortItems(nextSort);
        StoragePageHolder holder = (StoragePageHolder)inventory.getHolder(false);
        if (holder != null) {
            this.updatePageContent(player, spawner, holder.getCurrentPage(), inventory, false);
        }
        player.playSound(player.getLocation(), Sound.UI_BUTTON_CLICK, 1.0f, 1.2f);
        if (this.plugin.getSpawnerActionLogger() != null) {
            this.plugin.getSpawnerActionLogger().log(SpawnerEventType.SPAWNER_ITEMS_SORT, builder -> builder.player(player.getName(), player.getUniqueId()).location(spawner.getSpawnerLocation()).entityType(spawner.getEntityType()).metadata("sort_item", nextSort.name()).metadata("previous_sort", currentSort != null ? currentSort.name() : "none"));
        }
    }

    private void openLootPage(Player player, SpawnerData spawner, int page, boolean refresh) {
        List<Material> sortedLoot;
        List<LootItem> lootItems;
        SpawnerStorageUI lootManager = this.plugin.getSpawnerStorageUI();
        String title = this.languageManager.getGuiTitle("gui_title_storage");
        int totalPages = this.calculateTotalPages(spawner);
        int finalPage = Math.max(1, Math.min(page, totalPages));
        UUID playerId = player.getUniqueId();
        Inventory existingInventory = this.openStorageInventories.get(playerId);
        if (existingInventory != null && !refresh && existingInventory.getHolder(false) instanceof StoragePageHolder) {
            StoragePageHolder holder = (StoragePageHolder)existingInventory.getHolder(false);
            holder.setTotalPages(totalPages);
            holder.setCurrentPage(finalPage);
            holder.updateOldUsedSlots();
            this.updatePageContent(player, spawner, finalPage, existingInventory, false);
            return;
        }
        Material currentSort = spawner.getPreferredSortItem();
        if (currentSort == null && spawner.getLootConfig() != null && spawner.getLootConfig().getAllItems() != null && !(lootItems = spawner.getLootConfig().getAllItems()).isEmpty() && !(sortedLoot = lootItems.stream().map(LootItem::getMaterial).distinct().sorted(Comparator.comparing(Enum::name)).toList()).isEmpty()) {
            Material firstItem = sortedLoot.getFirst();
            spawner.setPreferredSortItem(firstItem);
            currentSort = firstItem;
            if (!spawner.isInteracted()) {
                spawner.markInteracted();
            }
            this.spawnerManager.queueSpawnerForSaving(spawner.getSpawnerId());
        }
        if (currentSort != null) {
            spawner.getVirtualInventory().sortItems(currentSort);
        }
        Inventory pageInventory = lootManager.createInventory(spawner, title, finalPage, totalPages);
        this.openStorageInventories.put(playerId, pageInventory);
        if (this.plugin.getSpawnerActionLogger() != null) {
            this.plugin.getSpawnerActionLogger().log(SpawnerEventType.SPAWNER_STORAGE_OPEN, builder -> builder.player(player.getName(), player.getUniqueId()).location(spawner.getSpawnerLocation()).entityType(spawner.getEntityType()).metadata("page", finalPage).metadata("total_pages", totalPages));
        }
        Sound sound = refresh ? Sound.ITEM_ARMOR_EQUIP_DIAMOND : Sound.UI_BUTTON_CLICK;
        float pitch = refresh ? 1.2f : 1.0f;
        player.playSound(player.getLocation(), sound, 1.0f, pitch);
        player.openInventory(pageInventory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleTakeAllItems(Player player, Inventory sourceInventory) {
        UUID playerId = player.getUniqueId();
        if (this.isClickTooFrequent(player)) {
            return;
        }
        if (!this.acquireDropTransaction(playerId)) {
            this.messageService.sendMessage(player, "action_in_progress");
            return;
        }
        try {
            StoragePageHolder holder = (StoragePageHolder)sourceInventory.getHolder(false);
            if (holder == null) {
                return;
            }
            SpawnerData spawner = holder.getSpawnerData();
            if (!this.isPlayerInventoryOpen(player, sourceInventory)) {
                return;
            }
            VirtualInventory virtualInv = spawner.getVirtualInventory();
            HashMap<Integer, ItemStack> sourceItems = new HashMap<Integer, ItemStack>();
            ArrayList<ItemStack> itemsToTransfer = new ArrayList<ItemStack>();
            int totalItemCount = 0;
            for (int i = 0; i < 45; ++i) {
                ItemStack item = sourceInventory.getItem(i);
                if (item == null || item.getType() == Material.AIR) continue;
                sourceItems.put(i, item.clone());
                itemsToTransfer.add(item.clone());
                totalItemCount += item.getAmount();
            }
            if (sourceItems.isEmpty()) {
                this.messageService.sendMessage(player, "no_items_to_take");
                return;
            }
            if (!this.validateItemsExistInVirtualInventory(itemsToTransfer, virtualInv)) {
                this.messageService.sendMessage(player, "items_not_available");
                this.updatePageContent(player, spawner, holder.getCurrentPage(), sourceInventory, false);
                return;
            }
            boolean removalSuccess = spawner.removeItemsAndUpdateSellValue(itemsToTransfer);
            if (!removalSuccess) {
                this.messageService.sendMessage(player, "take_failed");
                this.updatePageContent(player, spawner, holder.getCurrentPage(), sourceInventory, false);
                return;
            }
            Location spawnerLoc = spawner.getSpawnerLocation();
            int itemsBeforeTransfer = totalItemCount;
            Scheduler.runLocationTask(spawnerLoc, () -> {
                TransferResult result = this.transferItemsSecure(player, sourceInventory, sourceItems, virtualInv);
                this.sendTransferMessage(player, result);
                player.updateInventory();
                if (result.anyItemMoved) {
                    int newTotalPages = this.calculateTotalPages(spawner);
                    int currentPage = holder.getCurrentPage();
                    int adjustedPage = Math.max(1, Math.min(currentPage, newTotalPages));
                    holder.setTotalPages(newTotalPages);
                    if (adjustedPage != currentPage) {
                        holder.setCurrentPage(adjustedPage);
                        SpawnerStorageUI lootManager = this.plugin.getSpawnerStorageUI();
                        lootManager.updateDisplay(sourceInventory, spawner, adjustedPage, newTotalPages);
                    }
                    this.updateInventoryTitle(player, sourceInventory, spawner, adjustedPage, newTotalPages);
                    holder.updateOldUsedSlots();
                    this.spawnerGuiViewManager.updateSpawnerMenuViewers(spawner);
                    if (spawner.getMaxSpawnerLootSlots() > holder.getOldUsedSlots() && spawner.getIsAtCapacity().booleanValue()) {
                        spawner.setIsAtCapacity(false);
                    }
                    if (!spawner.isInteracted()) {
                        spawner.markInteracted();
                    }
                    if (this.plugin.getSpawnerActionLogger() != null) {
                        int itemsLeft = spawner.getVirtualInventory().getUsedSlots();
                        this.plugin.getSpawnerActionLogger().log(SpawnerEventType.SPAWNER_ITEM_TAKE_ALL, builder -> builder.player(player.getName(), player.getUniqueId()).location(spawner.getSpawnerLocation()).entityType(spawner.getEntityType()).metadata("items_taken", result.totalMoved).metadata("items_left", itemsLeft));
                    }
                }
            });
        }
        finally {
            this.releaseDropTransaction(playerId);
        }
    }

    private TransferResult transferItemsSecure(Player player, Inventory sourceInventory, Map<Integer, ItemStack> sourceItems, VirtualInventory virtualInv) {
        StoragePageHolder holder;
        boolean anyItemMoved = false;
        boolean inventoryFull = false;
        PlayerInventory playerInv = player.getInventory();
        int totalAmountMoved = 0;
        for (Map.Entry<Integer, ItemStack> entry : sourceItems.entrySet()) {
            int sourceSlot = entry.getKey();
            ItemStack itemToMove = entry.getValue();
            int amountToMove = itemToMove.getAmount();
            int amountMoved = 0;
            for (int i = 0; i < 36 && amountToMove > 0; ++i) {
                int spaceInStack;
                ItemStack targetItem = playerInv.getItem(i);
                if (targetItem == null || targetItem.getType() == Material.AIR) {
                    ItemStack newStack = itemToMove.clone();
                    newStack.setAmount(Math.min(amountToMove, itemToMove.getMaxStackSize()));
                    playerInv.setItem(i, newStack);
                    amountMoved += newStack.getAmount();
                    amountToMove -= newStack.getAmount();
                    anyItemMoved = true;
                    continue;
                }
                if (!targetItem.isSimilar(itemToMove) || (spaceInStack = targetItem.getMaxStackSize() - targetItem.getAmount()) <= 0) continue;
                int addAmount = Math.min(spaceInStack, amountToMove);
                targetItem.setAmount(targetItem.getAmount() + addAmount);
                amountMoved += addAmount;
                amountToMove -= addAmount;
                anyItemMoved = true;
            }
            if (amountMoved > 0) {
                totalAmountMoved += amountMoved;
                if (amountMoved == itemToMove.getAmount()) {
                    sourceInventory.setItem(sourceSlot, null);
                } else {
                    ItemStack remaining = itemToMove.clone();
                    remaining.setAmount(itemToMove.getAmount() - amountMoved);
                    sourceInventory.setItem(sourceSlot, remaining);
                    inventoryFull = true;
                }
            }
            if (!inventoryFull) continue;
            break;
        }
        if (anyItemMoved && (holder = (StoragePageHolder)sourceInventory.getHolder(false)) != null) {
            holder.getSpawnerData().updateHologramData();
            holder.updateOldUsedSlots();
        }
        return new TransferResult(anyItemMoved, inventoryFull, totalAmountMoved);
    }

    private TransferResult transferItems(Player player, Inventory sourceInventory, Map<Integer, ItemStack> sourceItems, VirtualInventory virtualInv) {
        boolean anyItemMoved = false;
        boolean inventoryFull = false;
        PlayerInventory playerInv = player.getInventory();
        int totalAmountMoved = 0;
        ArrayList<ItemStack> itemsToRemove = new ArrayList<ItemStack>();
        for (Map.Entry<Integer, ItemStack> entry : sourceItems.entrySet()) {
            int sourceSlot = entry.getKey();
            ItemStack itemToMove = entry.getValue();
            int amountToMove = itemToMove.getAmount();
            int amountMoved = 0;
            for (int i = 0; i < 36 && amountToMove > 0; ++i) {
                int spaceInStack;
                ItemStack targetItem = playerInv.getItem(i);
                if (targetItem == null || targetItem.getType() == Material.AIR) {
                    ItemStack newStack = itemToMove.clone();
                    newStack.setAmount(Math.min(amountToMove, itemToMove.getMaxStackSize()));
                    playerInv.setItem(i, newStack);
                    amountMoved += newStack.getAmount();
                    amountToMove -= newStack.getAmount();
                    anyItemMoved = true;
                    continue;
                }
                if (!targetItem.isSimilar(itemToMove) || (spaceInStack = targetItem.getMaxStackSize() - targetItem.getAmount()) <= 0) continue;
                int addAmount = Math.min(spaceInStack, amountToMove);
                targetItem.setAmount(targetItem.getAmount() + addAmount);
                amountMoved += addAmount;
                amountToMove -= addAmount;
                anyItemMoved = true;
            }
            if (amountMoved > 0) {
                totalAmountMoved += amountMoved;
                ItemStack movedItem = itemToMove.clone();
                movedItem.setAmount(amountMoved);
                itemsToRemove.add(movedItem);
                if (amountMoved == itemToMove.getAmount()) {
                    sourceInventory.setItem(sourceSlot, null);
                } else {
                    ItemStack remaining = itemToMove.clone();
                    remaining.setAmount(itemToMove.getAmount() - amountMoved);
                    sourceInventory.setItem(sourceSlot, remaining);
                    inventoryFull = true;
                }
            }
            if (!inventoryFull) continue;
            break;
        }
        if (!itemsToRemove.isEmpty()) {
            StoragePageHolder holder = (StoragePageHolder)sourceInventory.getHolder(false);
            holder.getSpawnerData().removeItemsAndUpdateSellValue(itemsToRemove);
            holder.getSpawnerData().updateHologramData();
            holder.updateOldUsedSlots();
        }
        return new TransferResult(anyItemMoved, inventoryFull, totalAmountMoved);
    }

    private void sendTransferMessage(Player player, TransferResult result) {
        if (!result.anyItemMoved) {
            this.messageService.sendMessage(player, "inventory_full");
        } else {
            HashMap<String, String> placeholders = new HashMap<String, String>();
            placeholders.put("amount", String.valueOf(result.totalMoved));
            this.messageService.sendMessage(player, "take_all_items", placeholders);
        }
    }

    @EventHandler
    public void onInventoryClose(InventoryCloseEvent event) {
        SpawnerData spawner;
        InventoryHolder inventoryHolder = event.getInventory().getHolder(false);
        if (!(inventoryHolder instanceof StoragePageHolder)) {
            return;
        }
        StoragePageHolder holder = (StoragePageHolder)inventoryHolder;
        HumanEntity humanEntity = event.getPlayer();
        if (humanEntity instanceof Player) {
            Player player = (Player)humanEntity;
            UUID playerId = player.getUniqueId();
            this.openStorageInventories.remove(playerId);
            this.storageAccessCooldowns.put(playerId, System.currentTimeMillis());
        }
        if ((spawner = holder.getSpawnerData()).isInteracted()) {
            this.spawnerManager.markSpawnerModified(spawner.getSpawnerId());
            spawner.clearInteracted();
        }
    }

    private record TransferResult(boolean anyItemMoved, boolean inventoryFull, int totalMoved) {
    }
}

