/*
 * Decompiled with CFR 0.152.
 */
package github.nighter.smartspawner.spawner.limits;

import github.nighter.smartspawner.SmartSpawner;
import github.nighter.smartspawner.spawner.data.SpawnerManager;
import github.nighter.smartspawner.spawner.properties.SpawnerData;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.entity.Player;

public class ChunkSpawnerLimiter {
    private final SmartSpawner plugin;
    private final SpawnerManager spawnerManager;
    private final Map<String, Integer> chunkSpawnerCount;
    private int maxSpawnersPerChunk;
    private boolean limitsEnabled;

    public ChunkSpawnerLimiter(SmartSpawner plugin) {
        this.plugin = plugin;
        this.spawnerManager = plugin.getSpawnerManager();
        this.chunkSpawnerCount = new ConcurrentHashMap<String, Integer>();
        this.maxSpawnersPerChunk = plugin.getConfig().getInt("spawner_limits.max_per_chunk", -1);
        boolean bl = this.limitsEnabled = this.maxSpawnersPerChunk > 0;
        if (this.limitsEnabled) {
            this.initializeChunkCounts();
        }
    }

    private void initializeChunkCounts() {
        this.chunkSpawnerCount.clear();
        for (SpawnerData spawner : this.spawnerManager.getAllSpawners()) {
            Location location = spawner.getSpawnerLocation();
            if (location == null || location.getWorld() == null) continue;
            String chunkKey = this.getChunkKey(location);
            int stackSize = spawner.getStackSize();
            this.chunkSpawnerCount.merge(chunkKey, stackSize, Integer::sum);
        }
        this.plugin.debug("Initialized chunk spawner counts for " + this.chunkSpawnerCount.size() + " chunks");
    }

    public boolean canPlaceSpawner(Player player, Location location) {
        if (!this.limitsEnabled) {
            return true;
        }
        if (player.hasPermission("smartspawner.limits.bypass")) {
            return true;
        }
        String chunkKey = this.getChunkKey(location);
        int currentCount = this.chunkSpawnerCount.getOrDefault(chunkKey, 0);
        return currentCount < this.maxSpawnersPerChunk;
    }

    public boolean canStackSpawner(Player player, Location location, int stackAmount) {
        if (!this.limitsEnabled) {
            return true;
        }
        if (player.hasPermission("smartspawner.limits.bypass")) {
            return true;
        }
        String chunkKey = this.getChunkKey(location);
        int currentCount = this.chunkSpawnerCount.getOrDefault(chunkKey, 0);
        return currentCount + stackAmount <= this.maxSpawnersPerChunk;
    }

    public void registerSpawnerPlacement(Location location, int stackSize) {
        if (!this.limitsEnabled) {
            return;
        }
        String chunkKey = this.getChunkKey(location);
        this.chunkSpawnerCount.merge(chunkKey, stackSize, Integer::sum);
    }

    public void registerSpawnerStack(Location location, int stackIncrease) {
        if (!this.limitsEnabled) {
            return;
        }
        String chunkKey = this.getChunkKey(location);
        this.chunkSpawnerCount.merge(chunkKey, stackIncrease, Integer::sum);
    }

    public void unregisterSpawner(Location location, int stackSize) {
        if (!this.limitsEnabled) {
            return;
        }
        String chunkKey = this.getChunkKey(location);
        int currentCount = this.chunkSpawnerCount.getOrDefault(chunkKey, 0);
        int newCount = Math.max(0, currentCount - stackSize);
        if (newCount == 0) {
            this.chunkSpawnerCount.remove(chunkKey);
        } else {
            this.chunkSpawnerCount.put(chunkKey, newCount);
        }
    }

    public int getChunkSpawnerCount(Location location) {
        if (!this.limitsEnabled) {
            return 0;
        }
        String chunkKey = this.getChunkKey(location);
        return this.chunkSpawnerCount.getOrDefault(chunkKey, 0);
    }

    private String getChunkKey(Location location) {
        if (location.getWorld() == null) {
            throw new IllegalArgumentException("Location world cannot be null");
        }
        Chunk chunk = location.getChunk();
        return location.getWorld().getName() + ":" + chunk.getX() + ":" + chunk.getZ();
    }

    public void reloadConfig() {
        this.maxSpawnersPerChunk = this.plugin.getConfig().getInt("spawner_limits.max_per_chunk", -1);
        boolean bl = this.limitsEnabled = this.maxSpawnersPerChunk > 0;
        if (this.limitsEnabled) {
            this.initializeChunkCounts();
        }
    }

    public String getDebugInfo(Location location) {
        if (!this.limitsEnabled) {
            return "Chunk limits disabled";
        }
        String chunkKey = this.getChunkKey(location);
        int currentCount = this.chunkSpawnerCount.getOrDefault(chunkKey, 0);
        return String.format("Chunk %s: %d/%d spawners", chunkKey, currentCount, this.maxSpawnersPerChunk);
    }

    @Generated
    public int getMaxSpawnersPerChunk() {
        return this.maxSpawnersPerChunk;
    }

    @Generated
    public boolean isLimitsEnabled() {
        return this.limitsEnabled;
    }
}

