/*
 * Decompiled with CFR 0.152.
 */
package github.nighter.smartspawner.spawner.loot;

import github.nighter.smartspawner.SmartSpawner;
import github.nighter.smartspawner.hooks.economy.ItemPriceManager;
import github.nighter.smartspawner.spawner.loot.EntityLootConfig;
import github.nighter.smartspawner.spawner.loot.LootItem;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.EntityType;
import org.bukkit.potion.PotionType;

public class EntityLootRegistry {
    private final SmartSpawner plugin;
    private FileConfiguration lootConfig;
    private final Map<String, EntityLootConfig> entityLootConfigs;
    private ItemPriceManager priceManager;
    private final Map<Material, Double> cachedPrices;
    private final Set<Material> loadedMaterials;

    public EntityLootRegistry(SmartSpawner plugin, ItemPriceManager priceManager) {
        this.plugin = plugin;
        this.entityLootConfigs = new ConcurrentHashMap<String, EntityLootConfig>();
        this.priceManager = priceManager;
        this.cachedPrices = new ConcurrentHashMap<Material, Double>();
        this.loadedMaterials = new HashSet<Material>();
        this.setupLootConfigFile();
        this.loadConfigurations();
    }

    protected void setupLootConfigFile() {
        File lootConfigFile = new File(this.plugin.getDataFolder(), "mob_drops.yml");
        if (!lootConfigFile.exists()) {
            this.plugin.saveResource("mob_drops.yml", false);
        }
        this.lootConfig = YamlConfiguration.loadConfiguration((File)lootConfigFile);
    }

    public void loadConfigurations() {
        this.entityLootConfigs.clear();
        this.cachedPrices.clear();
        this.loadedMaterials.clear();
        for (String entityName : this.lootConfig.getKeys(false)) {
            if (entityName.startsWith("#")) continue;
            try {
                EntityType entityType = EntityType.valueOf((String)entityName.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                this.plugin.getLogger().warning("Skip entity type '" + entityName + "' is invalid in mob_heads.yml or not available in server version " + this.plugin.getServer().getBukkitVersion());
                continue;
            }
            ConfigurationSection entitySection = this.lootConfig.getConfigurationSection(entityName);
            if (entitySection == null) continue;
            int experience = entitySection.getInt("experience", 0);
            ArrayList<LootItem> items = new ArrayList<LootItem>();
            ConfigurationSection lootSection = entitySection.getConfigurationSection("loot");
            if (lootSection != null) {
                for (String itemKey : lootSection.getKeys(false)) {
                    ConfigurationSection itemSection = lootSection.getConfigurationSection(itemKey);
                    if (itemSection == null) continue;
                    try {
                        String potionTypeName;
                        Material material;
                        try {
                            material = Material.valueOf((String)itemKey.toUpperCase());
                        }
                        catch (IllegalArgumentException e) {
                            material = null;
                        }
                        if (material == null) {
                            this.plugin.getLogger().warning("Material '" + itemKey + "' is not available in server version " + this.plugin.getServer().getBukkitVersion() + " - skipping for entity " + entityName);
                            continue;
                        }
                        this.loadedMaterials.add(material);
                        String[] amounts = itemSection.getString("amount", "1-1").split("-");
                        int minAmount = Integer.parseInt(amounts[0]);
                        int maxAmount = Integer.parseInt(amounts.length > 1 ? amounts[1] : amounts[0]);
                        double chance = itemSection.getDouble("chance", 0.0);
                        double sellPrice = this.getSellPrice(material);
                        Integer minDurability = null;
                        Integer maxDurability = null;
                        if (itemSection.contains("durability")) {
                            String[] durabilities = itemSection.getString("durability").split("-");
                            minDurability = Integer.parseInt(durabilities[0]);
                            maxDurability = Integer.parseInt(durabilities.length > 1 ? durabilities[1] : durabilities[0]);
                        }
                        PotionType potionType = null;
                        if (material == Material.TIPPED_ARROW && itemSection.contains("potion_type") && (potionTypeName = itemSection.getString("potion_type")) != null) {
                            try {
                                potionType = PotionType.valueOf((String)potionTypeName.toUpperCase());
                            }
                            catch (IllegalArgumentException e) {
                                this.plugin.getLogger().warning("Invalid potion type '" + potionTypeName + "' for entity " + entityName + ". Available types: " + Arrays.toString(PotionType.values()));
                                continue;
                            }
                        }
                        items.add(new LootItem(material, minAmount, maxAmount, chance, minDurability, maxDurability, potionType, sellPrice));
                    }
                    catch (Exception e) {
                        this.plugin.getLogger().warning("Error processing material '" + itemKey + "' for entity " + entityName + ": " + e.getMessage());
                    }
                }
            }
            this.entityLootConfigs.put(entityName.toLowerCase(), new EntityLootConfig(experience, items));
        }
        this.priceManager.debugPricesForMaterials(this.loadedMaterials);
    }

    private double getSellPrice(Material material) {
        return this.cachedPrices.computeIfAbsent(material, this.priceManager::getPrice);
    }

    public EntityLootConfig getLootConfig(EntityType entityType) {
        if (entityType == null || entityType == EntityType.UNKNOWN) {
            return null;
        }
        return this.entityLootConfigs.get(entityType.name().toLowerCase());
    }

    public Set<Material> getLoadedMaterials() {
        return new HashSet<Material>(this.loadedMaterials);
    }

    public void reload() {
        this.priceManager = this.plugin.getItemPriceManager();
        this.setupLootConfigFile();
        this.loadConfigurations();
    }
}

